/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.util.cache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.ASSERT;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.ejs.util.cache.Cache;
import com.ibm.ejs.util.cache.CacheElementEnumerator;
import com.ibm.ejs.util.cache.Element;
import com.ibm.ejs.util.cache.EvictionStrategy;
import com.ibm.ejs.util.cache.SimpleLimitStrategy;
import com.ibm.websphere.csi.InsufficientCacheSpaceException;
import com.ibm.ws.ffdc.FFDCFilter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public final class BackgroundLruEvictionStrategy
extends Thread
implements EvictionStrategy,
AlarmListener {
    private static final TraceComponent tc = Tr.register((Class)BackgroundLruEvictionStrategy.class, (String)"EJBCache", (String)"com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.util.cache.BackgroundLruEvictionStrategy";
    private final Cache ivCache;
    private long ivSweepInterval;
    private long ivDiscardThreshold = 60L;
    private long ivMaxDiscardThreshold;
    private long ivMinDiscardThreshold;
    private long ivUpperLimit;
    private long ivNumBelowSoftLimit = 0L;
    private int ivSoftLimitBuffer;
    private CacheElementEnumerator ivElements;
    private Enumeration ivVictims;
    private final long MINIMUM_SWEEP_INTERVAL = 1000L;
    private final long MAX_THRESHOLD_MULTIPLIER = 120000L;
    private final long MIN_THRESHOLD_MULTIPLIER = 9000L;

    public BackgroundLruEvictionStrategy(Cache cache, long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("<init> : " + cache.getName() + " size = " + cache.getConfigSize() + ", sweep = " + l));
        }
        this.ivCache = cache;
        this.ivSweepInterval = l < 1000L ? 1000L : l;
        this.ivUpperLimit = (long)((double)this.ivCache.numBuckets * 1.1);
        if (this.ivSweepInterval * this.ivDiscardThreshold > 120000L) {
            this.ivDiscardThreshold = 120000L / this.ivSweepInterval;
            if (this.ivDiscardThreshold < 2L) {
                this.ivDiscardThreshold = 2L;
            }
        }
        this.ivMaxDiscardThreshold = this.ivDiscardThreshold;
        this.ivMinDiscardThreshold = 9000L / this.ivSweepInterval;
        if (this.ivMinDiscardThreshold < 2L) {
            this.ivMinDiscardThreshold = 2L;
        }
        this.ivSoftLimitBuffer = this.ivCache.numBuckets / 100;
        if (this.ivSoftLimitBuffer > 50) {
            this.ivSoftLimitBuffer = 50;
        }
        this.ivElements = (CacheElementEnumerator)this.ivCache.enumerateElements();
        this.ivVictims = null;
        this.setDaemon(true);
        this.setName("BackgroundLruEvictionStrategy");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("<init> : " + this.ivCache.getName() + " size = " + cache.getConfigSize() + ", sweep = " + this.ivSweepInterval + ", threshold = " + this.ivDiscardThreshold + ", buffer = " + this.ivSoftLimitBuffer));
        }
    }

    public void run() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"run");
        }
        if (this.ivSweepInterval >= 1000L) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"BackgroundLruEvictionStrategy using Alarms");
            }
            AlarmManager.create((long)this.ivSweepInterval, (AlarmListener)this, null);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"run");
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"BackgroundLruEvictionStrategy running as background thread");
        }
        while (true) {
            try {
                while (true) {
                    BackgroundLruEvictionStrategy.sleep(this.ivSweepInterval);
                    this.alarm(null);
                }
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ejs.util.cache.BackgroundLruEvictionStrategy.run", (String)"328", (Object)this);
                Tr.warning((TraceComponent)tc, (String)"LRU_THREAD_INTERRUPTED_CNTR0052W", (Object)new Object[]{interruptedException});
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ejs.util.cache.BackgroundLruEvictionStrategy.run", (String)"337", (Object)this);
                Tr.warning((TraceComponent)tc, (String)"LRU_THREAD_CAUGHT_EXCEPTION_CNTR0053W", (Object)new Object[]{this, exception});
                continue;
            }
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"run");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void alarm(Object object) {
        try {
            block9: {
                try {
                    if (this.ivDiscardThreshold < this.ivMaxDiscardThreshold && this.ivNumBelowSoftLimit > this.ivMaxDiscardThreshold) {
                        ++this.ivDiscardThreshold;
                        this.ivNumBelowSoftLimit = 0L;
                    }
                    this.ivCache.numSweeps = this.ivCache.numSweeps == Long.MAX_VALUE ? 1L : ++this.ivCache.numSweeps;
                    if (this.ivCache.limitStrategy.softLimitReached(this.ivCache)) {
                        this.sweep();
                        if (this.ivCache.limitStrategy.softLimitReached(this.ivCache)) {
                            this.ivNumBelowSoftLimit = 0L;
                            if ((long)this.ivCache.numObjects > this.ivUpperLimit && this.ivDiscardThreshold > this.ivMinDiscardThreshold) {
                                --this.ivDiscardThreshold;
                                this.sweep();
                            }
                            break block9;
                        }
                        ++this.ivNumBelowSoftLimit;
                        break block9;
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(this.ivCache.getName() + ": Sweep (" + this.ivCache.numSweeps + "," + this.ivDiscardThreshold + ")" + " - Cache limit not reached : " + this.ivCache.getSize() + "/" + this.ivCache.getConfigSize()));
                    }
                    ++this.ivNumBelowSoftLimit;
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ejs.util.cache.BackgroundLruEvictionStrategy.alarm", (String)"446", (Object)this);
                    Tr.warning((TraceComponent)tc, (String)"LRU_THREAD_CAUGHT_EXCEPTION_CNTR0053W", (Object)new Object[]{this, exception});
                    Object var4_3 = null;
                    if (this.ivSweepInterval < 1000L) return;
                    AlarmManager.create((long)this.ivSweepInterval, (AlarmListener)this, null);
                    return;
                }
            }
            Object var4_2 = null;
            if (this.ivSweepInterval < 1000L) return;
            AlarmManager.create((long)this.ivSweepInterval, (AlarmListener)this, null);
            return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.ivSweepInterval < 1000L) throw throwable;
            AlarmManager.create((long)this.ivSweepInterval, (AlarmListener)this, null);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sweep() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(this.ivCache.getName() + ": Sweep (" + this.ivCache.numSweeps + "," + this.ivDiscardThreshold + ")" + " - Cache limit exceeded : " + this.ivCache.getSize() + "/" + this.ivCache.getConfigSize()));
        }
        int n = 0;
        int n2 = 0;
        long l = 0L;
        this.ivElements.reset();
        try {
            while (this.ivElements.hasMoreElements() && (n2 < this.ivSoftLimitBuffer || this.ivCache.limitStrategy.softLimitReached(this.ivCache))) {
                Element element = (Element)this.ivElements.nextElement();
                l = element.accessedSweep <= this.ivCache.numSweeps ? this.ivCache.numSweeps - element.accessedSweep : Long.MAX_VALUE - element.accessedSweep + this.ivCache.numSweeps;
                if (element.pinned != 0 || l <= this.ivDiscardThreshold) continue;
                boolean bl = false;
                if (this.ivCache.ivEvictionLocks != null) {
                    Object object = this.ivCache.ivEvictionLocks.getLock(element.key);
                    synchronized (object) {
                        bl = this.ivCache.evictObject(element.key);
                    }
                } else {
                    bl = this.ivCache.evictObject(element.key);
                }
                if (!bl) continue;
                ++n;
                if (this.ivCache.limitStrategy.softLimitReached(this.ivCache)) {
                    n2 = 0;
                    continue;
                }
                ++n2;
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            FFDCFilter.processException((Throwable)noSuchElementException, (String)"com.ibm.ejs.util.cache.BackgroundLruEvictionStrategy.sweep", (String)"526", (Object)this);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)(this.ivCache.getName() + ": Sweep (" + this.ivCache.numSweeps + "," + this.ivDiscardThreshold + ")" + " - Evicted = " + n + " : " + this.ivCache.getSize() + " : NoSuchElementException"));
            }
            return;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(this.ivCache.getName() + ": Sweep (" + this.ivCache.numSweeps + "," + this.ivDiscardThreshold + ")" + " - Evicted = " + n + " : " + this.ivCache.getSize() + "/" + this.ivCache.getConfigSize()));
        }
    }

    public synchronized Object getVictim(Cache cache) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getVictim");
        }
        Element element = null;
        Element element2 = null;
        boolean bl = false;
        while (element == null) {
            if (this.ivVictims == null || !this.ivVictims.hasMoreElements()) {
                if (bl) break;
                this.ivVictims = this.ivCache.enumerateElements();
                bl = true;
            }
            try {
                element2 = (Element)this.ivVictims.nextElement();
            }
            catch (NoSuchElementException noSuchElementException) {
                FFDCFilter.processException((Throwable)noSuchElementException, (String)"com.ibm.ejs.util.cache.BackgroundLruEvictionStrategy.getVictim", (String)"600", (Object)this);
                continue;
            }
            if (!this.canBeDiscarded(element2)) continue;
            element = element2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getVictim : " + element));
        }
        return element;
    }

    public boolean canBeDiscarded(Element element) {
        long l = 0L;
        l = element.accessedSweep <= this.ivCache.numSweeps ? this.ivCache.numSweeps - element.accessedSweep : Long.MAX_VALUE - element.accessedSweep + this.ivCache.numSweeps;
        return l > this.ivDiscardThreshold && element.pinned == 0;
    }

    public static void main(String[] stringArray) {
        try {
            String string;
            String string2;
            int n;
            Cache cache = new Cache("TestCache", 9, false);
            cache.setLimitStrategy(new SimpleLimitStrategy(15, 20));
            BackgroundLruEvictionStrategy backgroundLruEvictionStrategy = new BackgroundLruEvictionStrategy(cache, 1000L);
            cache.setEvictionStrategy(backgroundLruEvictionStrategy);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss.SSSS");
            for (n = 0; n < 15; ++n) {
                string2 = Integer.toString(n);
                string = simpleDateFormat.format(new Date());
                System.out.println("Inserting (" + string2 + ", " + string + ")");
                cache.insert(string2, string);
                cache.unpin(string2);
            }
            System.out.println("---- There are " + cache.getSize() + " elements in the cache");
            ASSERT.isTrue((cache.getSize() == 15 ? 1 : 0) != 0, (String)"testCache.getSize() == 15");
            for (n = 14; n >= 0; --n) {
                string2 = Integer.toString(n);
                string = (String)cache.find(string2);
                System.out.println("Found (" + string2 + ", " + string + ")");
                cache.unpin(string2);
            }
            System.out.println("---- There are still " + cache.getSize() + " elements in the cache");
            ASSERT.isTrue((cache.getSize() == 15 ? 1 : 0) != 0, (String)"testCache.getSize() == 15");
            for (n = 29; n >= 15; --n) {
                string2 = Integer.toString(n);
                string = (String)cache.find(string2);
                System.out.println("Found (" + string2 + ", " + string + ")");
                ASSERT.isTrue((string == null ? 1 : 0) != 0, (String)"object == null");
            }
            System.out.println("---- There are still " + cache.getSize() + " elements in the cache");
            ASSERT.isTrue((cache.getSize() == 15 ? 1 : 0) != 0, (String)"testCache.getSize() == 15");
            for (n = 15; n < 30; ++n) {
                string2 = Integer.toString(n);
                string = simpleDateFormat.format(new Date());
                try {
                    System.out.println("Inserting (" + string2 + ", " + string + ")");
                    cache.insert(string2, string);
                    cache.unpin(string2);
                    continue;
                }
                catch (InsufficientCacheSpaceException insufficientCacheSpaceException) {
                    FFDCFilter.processException((Throwable)insufficientCacheSpaceException, (String)"com.ibm.ejs.util.cache.BackgroundLruEvictionStrategy.main", (String)"718");
                    System.out.println("!!!! Cache is full");
                    ASSERT.isTrue((cache.getSize() == 20 ? 1 : 0) != 0, (String)"testCache.getSize() == 20");
                    break;
                }
            }
            System.out.println("---- There are now " + cache.getSize() + " elements in the cache");
            backgroundLruEvictionStrategy.start();
            try {
                do {
                    System.out.println("Sleeping...");
                    BackgroundLruEvictionStrategy.sleep(1000L);
                    System.out.println(">>>> There are now " + cache.getSize() + " elements in the cache");
                } while (cache.getSize() > 15);
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ejs.util.cache.BackgroundLruEvictionStrategy.main", (String)"748");
                System.out.println(interruptedException);
            }
            for (int i = 0; i < 30; ++i) {
                string2 = Integer.toString(i);
                string = (String)cache.find(string2);
                System.out.println("Found (" + string2 + ", " + string + ")");
            }
            System.out.println("---- There are " + cache.getSize() + " elements in the cache");
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ejs.util.cache.BackgroundLruEvictionStrategy.main", (String)"767");
            System.out.println(exception);
        }
    }
}

