/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.csi;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.StatefulBeanReaper;
import com.ibm.ejs.container.activator.StatefulSessionActivationStrategy;
import com.ibm.ejs.container.util.EJSPlatformHelper;
import com.ibm.ejs.csi.WSGZIPOutputStream;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.EJBKey;
import com.ibm.websphere.csi.SessionBeanStore;
import com.ibm.websphere.csi.StreamUnavailableException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class FileBeanStore
implements SessionBeanStore {
    private static final TraceComponent tc = Tr.register((Class)FileBeanStore.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.csi.FileBeanStore";
    private String passivationDir;
    private String serverName;
    private String clusterName;
    private static char[] hexChars = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public FileBeanStore(String string) {
        this(string, null, null);
    }

    public FileBeanStore(String string, String string2, String string3) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{string, string2, string3});
        }
        if (string != null && new File(string).isDirectory()) {
            this.passivationDir = string;
        } else {
            this.passivationDir = null;
            if (string != null) {
                Tr.warning((TraceComponent)tc, (String)"PASSIVATION_DIRECTORY_DOES_NOT_EXIST_CNTR0023W", (Object)string);
            }
        }
        this.serverName = string2;
        this.clusterName = string3;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    public GZIPInputStream getGZIPInputStream(EJBKey eJBKey) throws CSIException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGZIPInputStream", (Object)eJBKey);
        }
        final String string = this.getPortableFilename(eJBKey.toString());
        final String string2 = this.passivationDir;
        GZIPInputStream gZIPInputStream = null;
        try {
            gZIPInputStream = (GZIPInputStream)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws FileNotFoundException, IOException {
                    File file = null;
                    if (EJSPlatformHelper.isZOS()) {
                        if (FileBeanStore.this.clusterName != null) {
                            file = new File(FileBeanStore.this.passivationDir, string + FileBeanStore.this.clusterName);
                            if (!file.exists()) {
                                file = new File(FileBeanStore.this.passivationDir, string + FileBeanStore.this.serverName);
                            }
                        } else {
                            file = new File(FileBeanStore.this.passivationDir, string + FileBeanStore.this.serverName);
                        }
                        if (!file.exists()) {
                            file = new File(FileBeanStore.this.passivationDir, string);
                        }
                    } else {
                        file = new File(string2, string);
                    }
                    FileInputStream fileInputStream = new FileInputStream(file);
                    return new GZIPInputStream(fileInputStream);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof FileNotFoundException) {
                FFDCFilter.processException((Throwable)((FileNotFoundException)exception), (String)"com.ibm.ejs.csi.FileBeanStore.getGZIPInputStream", (String)"91", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"No file found while trying to activate passivated stateful session bean", (Object)string);
                }
                throw new StreamUnavailableException("");
            }
            if (exception instanceof IOException) {
                FFDCFilter.processException((Throwable)((IOException)exception), (String)"com.ibm.ejs.csi.FileBeanStore.getGZIPInputStream", (String)"98", (Object)this);
                Tr.warning((TraceComponent)tc, (String)"IOEXCEPTION_READING_FILE_FOR_STATEFUL_SESSION_BEAN_CNTR0024W", (Object)new Object[]{string, this, (IOException)exception});
                throw new CSIException("IOException reading input stream for stateful session bean", (Throwable)((IOException)exception));
            }
            throw new CSIException("Unexpected exception reading input stream for stateful session bean", (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGZIPInputStream");
        }
        return gZIPInputStream;
    }

    public GZIPOutputStream getGZIPOutputStream(EJBKey eJBKey) throws CSIException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getOutputStream ", (Object)eJBKey);
        }
        final String string = this.getPortableFilename(eJBKey.toString());
        GZIPOutputStream gZIPOutputStream = null;
        StatefulBeanReaper statefulBeanReaper = null;
        if (EJSPlatformHelper.isZOS()) {
            statefulBeanReaper = ((StatefulSessionActivationStrategy)((BeanId)eJBKey).getActivationStrategy()).getReaper();
        }
        final long l = EJSPlatformHelper.isZOS() ? statefulBeanReaper.getBeanTimeoutTime((BeanId)eJBKey) : 0L;
        try {
            gZIPOutputStream = (GZIPOutputStream)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    FileOutputStream fileOutputStream = null;
                    if (EJSPlatformHelper.isZOS()) {
                        File file = null;
                        file = FileBeanStore.this.clusterName != null ? new File(FileBeanStore.this.passivationDir, string + FileBeanStore.this.clusterName) : new File(FileBeanStore.this.passivationDir, string + FileBeanStore.this.serverName);
                        fileOutputStream = new FileOutputStream(file);
                        return new WSGZIPOutputStream((OutputStream)fileOutputStream, file, l);
                    }
                    fileOutputStream = new FileOutputStream(new File(FileBeanStore.this.passivationDir, string));
                    return new GZIPOutputStream(fileOutputStream);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            IOException iOException = (IOException)privilegedActionException.getException();
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ejs.csi.FileBeanStore.getOutputStream", (String)"127", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"IOEXCEPTION_WRITING_FILE_FOR_STATEFUL_SESSION_BEAN_CNTR0025W", (Object)new Object[]{string, this, iOException});
            throw new CSIException("Unable to open output stream", (Throwable)iOException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getOutputStream");
        }
        return gZIPOutputStream;
    }

    public void remove(EJBKey eJBKey) {
        String string;
        block4: {
            final String string2 = this.passivationDir;
            string = this.getPortableFilename(eJBKey.toString());
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("remove file: " + string));
            }
            final EJBKey eJBKey2 = eJBKey;
            try {
                AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        File file = null;
                        if (EJSPlatformHelper.isZOS()) {
                            if (FileBeanStore.this.clusterName != null) {
                                file = new File(string2, string + FileBeanStore.this.clusterName);
                                if (!file.exists()) {
                                    file = new File(string2, string + FileBeanStore.this.serverName);
                                }
                            } else {
                                file = new File(string2, string + FileBeanStore.this.serverName);
                            }
                            if (!file.exists()) {
                                file = new File(string2, string);
                            }
                        } else {
                            file = new File(string2, string);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("deleting file: " + file.getName() + ", path: " + file.getPath()));
                        }
                        boolean bl = file.delete();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("File.delete returned: " + bl));
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Bean " + eJBKey2 + " removed from the passivation store"));
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                FFDCFilter.processException((Throwable)privilegedActionException.getException(), (String)"com.ibm.ejs.csi.FileBeanStore.remove", (String)"150", (Object)this);
                if (!tc.isEventEnabled()) break block4;
                Tr.event((TraceComponent)tc, (String)"Failed to remove session bean state", (Object)new Object[]{eJBKey, privilegedActionException});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("remove file: " + string));
        }
    }

    private static String byteArrayToHexString(byte[] byArray) {
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(hexChars[byArray[i] >> 4 & 0xF]);
            stringBuffer.append(hexChars[byArray[i] & 0xF]);
        }
        return stringBuffer.toString();
    }

    private String getPortableFilename(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '-' || c == '.') {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append('_');
        }
        return stringBuffer.toString();
    }

    public OutputStream getOutputStream(EJBKey eJBKey) throws CSIException {
        final String string = this.getPortableFilename(eJBKey.toString());
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getOutputStream: file name = ", (Object)string);
        }
        FileOutputStream fileOutputStream = null;
        StatefulBeanReaper statefulBeanReaper = null;
        if (EJSPlatformHelper.isZOS()) {
            statefulBeanReaper = ((StatefulSessionActivationStrategy)((BeanId)eJBKey).getActivationStrategy()).getReaper();
        }
        final long l = EJSPlatformHelper.isZOS() ? statefulBeanReaper.getBeanTimeoutTime((BeanId)eJBKey) : 0L;
        try {
            fileOutputStream = (FileOutputStream)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    File file = new File(FileBeanStore.this.passivationDir, string);
                    if (EJSPlatformHelper.isZOS()) {
                        return new WSFileOutputStream(file, l);
                    }
                    return new FileOutputStream(file);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            IOException iOException = (IOException)privilegedActionException.getException();
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ejs.csi.FileBeanStore.getUnCompressedOutputStream", (String)"460", (Object)this);
            Tr.warning((TraceComponent)tc, (String)"IOEXCEPTION_WRITING_FILE_FOR_STATEFUL_SESSION_BEAN_CNTR0025W", (Object)new Object[]{string, this, iOException});
            throw new CSIException("Unable to open output stream", (Throwable)iOException);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getOutputStream");
        }
        return fileOutputStream;
    }

    public InputStream getInputStream(EJBKey eJBKey) throws CSIException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getInputStream ", (Object)eJBKey);
        }
        final String string = this.getPortableFilename(eJBKey.toString());
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = (FileInputStream)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return new FileInputStream(new File(FileBeanStore.this.passivationDir, string));
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof FileNotFoundException) {
                FFDCFilter.processException((Throwable)((FileNotFoundException)exception), (String)"com.ibm.ejs.csi.FileBeanStore.getInputStream", (String)"524", (Object)this);
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"No file found while trying to activate passivated stateful session bean", (Object)string);
                }
                throw new StreamUnavailableException("");
            }
            if (exception instanceof IOException) {
                FFDCFilter.processException((Throwable)((IOException)exception), (String)"com.ibm.ejs.csi.FileBeanStore.getInputStream", (String)"531", (Object)this);
                Tr.warning((TraceComponent)tc, (String)"IOEXCEPTION_READING_FILE_FOR_STATEFUL_SESSION_BEAN_CNTR0024W", (Object)new Object[]{string, this, (IOException)exception});
                throw new CSIException("IOException reading input stream for stateful session bean", (Throwable)((IOException)exception));
            }
            throw new CSIException("Unexpected exception reading input stream for stateful session bean", (Throwable)exception);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getInputStream");
        }
        return fileInputStream;
    }

    class WSFileOutputStream
    extends FileOutputStream {
        long beanTimeoutTime;
        File beanFileObj;

        public WSFileOutputStream(File file, long l) throws IOException {
            super(file);
            this.beanFileObj = file;
            this.beanTimeoutTime = l;
        }

        public void close() throws IOException {
            this.beanFileObj.setLastModified(this.beanTimeoutTime);
            super.close();
        }
    }
}

