/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.passivator;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.StatefulBeanO;
import com.ibm.ejs.container.drs.SfDRSCache;
import com.ibm.ejs.container.passivator.NewInputStream;
import com.ibm.ejs.container.passivator.NewOutputStream;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.CSIException;
import com.ibm.websphere.csi.EJBKey;
import com.ibm.websphere.csi.RemoveCollaborator;
import com.ibm.websphere.csi.SessionBeanStore;
import com.ibm.websphere.csi.StreamUnavailableException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.j2c.WSLoginLocalOSExtensionFactory;
import com.ibm.ws.security.util.ServerIdentityHelper;
import com.ibm.ws.util.PlatformHelperFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.ejb.SessionBean;

public class StatefulPassivator {
    private static final TraceComponent tc = Tr.register((Class)StatefulPassivator.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.passivator.StatefulPassivator";
    private static final boolean isZOS = PlatformHelperFactory.getPlatformHelper().isZOS();
    private SessionBeanStore beanStore;
    private RemoveCollaborator[] removeCollaborators;
    private EJSContainer container;
    private boolean terminating = false;
    private boolean syncToThread = false;
    private SfDRSCache ivStatefulDRSCache;

    public StatefulPassivator(SessionBeanStore sessionBeanStore, RemoveCollaborator[] removeCollaboratorArray, EJSContainer eJSContainer, SfDRSCache sfDRSCache) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"StatefulPassivator");
        }
        this.beanStore = sessionBeanStore;
        this.removeCollaborators = removeCollaboratorArray;
        this.container = eJSContainer;
        this.ivStatefulDRSCache = sfDRSCache;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"StatefulPassivator");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void passivate(Object object) throws RemoteException {
        ObjectOutputStream objectOutputStream;
        boolean bl;
        BeanId beanId;
        block22: {
            Object object2;
            StatefulBeanO statefulBeanO;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"passivate", (Object)object);
            }
            if ((statefulBeanO = (StatefulBeanO)object).isRemoved() || this.terminating) {
                if (!tc.isEventEnabled()) return;
                Tr.event((TraceComponent)tc, (String)"Bean removed!");
                return;
            }
            beanId = statefulBeanO.getId();
            SessionBean sessionBean = statefulBeanO.sessionBean;
            bl = false;
            objectOutputStream = null;
            if (isZOS) {
                object2 = WSLoginLocalOSExtensionFactory.getInstance();
                this.syncToThread = object2.isApplicationSyncToOSThreadEnabled();
            }
            if (this.removeCollaborators != null) {
                for (int i = 0; i < this.removeCollaborators.length; ++i) {
                    this.removeCollaborators[i].passivate((EJBKey)beanId);
                }
            }
            object2 = null;
            if (isZOS && this.syncToThread) {
                object2 = ServerIdentityHelper.getServerIdentityHelper().push();
            }
            try {
                try {
                    if (statefulBeanO.sfsbFailoverEnabled()) {
                        long l = statefulBeanO.getLastAccessTime();
                        byte[] byArray = this.getCompressedBytes(sessionBean, l);
                        OutputStream outputStream = this.beanStore.getOutputStream((EJBKey)beanId);
                        objectOutputStream = new NewOutputStream(outputStream, this.container);
                        objectOutputStream.writeInt(byArray.length);
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("length of compressed bytes is: " + byArray.length));
                        }
                        objectOutputStream.write(byArray);
                        objectOutputStream.close();
                        statefulBeanO.updateDRSEntry(byArray, l);
                    } else {
                        GZIPOutputStream gZIPOutputStream = this.beanStore.getGZIPOutputStream((EJBKey)beanId);
                        objectOutputStream = new NewOutputStream(gZIPOutputStream, this.container);
                        long l = statefulBeanO.getLastAccessTime();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("writing passivation file with last access time set to: " + l));
                        }
                        objectOutputStream.writeLong(l);
                        objectOutputStream.writeObject(sessionBean);
                        objectOutputStream.close();
                    }
                }
                catch (CSIException cSIException) {
                    bl = true;
                    FFDCFilter.processException((Throwable)cSIException, (String)"com.ibm.ejs.container.passivator.StatefulPassivator.passivate", (String)"113", (Object)this);
                    throw new RemoteException("passivation failed", cSIException);
                }
                catch (Exception exception) {
                    bl = true;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ejs.container.passivator.StatefulPassivator.passivate", (String)"107", (Object)this);
                    Tr.warning((TraceComponent)tc, (String)"CANNOT_PASSIVATE_STATEFUL_BEAN_CNTR0001W", (Object)new Object[]{object.toString(), this, exception});
                    throw new RemoteException("passivation failed", exception);
                }
                Object var13_16 = null;
                if (!isZOS || !this.syncToThread) break block22;
            }
            catch (Throwable throwable) {
                Object var13_17 = null;
                if (isZOS && this.syncToThread) {
                    ServerIdentityHelper.getServerIdentityHelper().pop(object2);
                }
                if (!bl) throw throwable;
                try {
                    if (objectOutputStream == null) throw throwable;
                    objectOutputStream.close();
                    this.beanStore.remove((EJBKey)beanId);
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            ServerIdentityHelper.getServerIdentityHelper().pop(object2);
        }
        if (bl) {
            try {}
            catch (Exception exception) {}
            if (objectOutputStream != null) {
                objectOutputStream.close();
                this.beanStore.remove((EJBKey)beanId);
            }
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit((TraceComponent)tc, (String)"passivate");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void activate(Object object, ClassLoader classLoader) throws RemoteException {
        block23: {
            Object object2;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"activate", (Object)object);
            }
            SessionBean sessionBean = null;
            StatefulBeanO statefulBeanO = (StatefulBeanO)object;
            BeanId beanId = statefulBeanO.getId();
            Object object3 = null;
            if (isZOS) {
                object2 = WSLoginLocalOSExtensionFactory.getInstance();
                this.syncToThread = object2.isApplicationSyncToOSThreadEnabled();
                if (this.syncToThread) {
                    object3 = ServerIdentityHelper.getServerIdentityHelper().push();
                }
            }
            try {
                try {
                    if (!statefulBeanO.sfsbFailoverEnabled()) {
                        object2 = this.beanStore.getGZIPInputStream((EJBKey)beanId);
                        NewInputStream newInputStream = new NewInputStream((InputStream)object2, statefulBeanO, classLoader, this.container);
                        long l = newInputStream.readLong();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("read from passivation file last access time: " + l));
                        }
                        statefulBeanO.setLastAccessTime(l);
                        sessionBean = (SessionBean)newInputStream.readObject();
                        ((GZIPInputStream)object2).close();
                        statefulBeanO.setEnterpriseBean(sessionBean);
                    } else {
                        InputStream inputStream;
                        object2 = null;
                        if (this.ivStatefulDRSCache.beanExists(beanId)) {
                            boolean bl = this.ivStatefulDRSCache.inStickyUOW(beanId);
                            object2 = this.ivStatefulDRSCache.getAndRemoveData(beanId, statefulBeanO.ivSfDRSClient);
                            if (bl) {
                                throw new NoSuchObjectException("Bean Managed Transaction is active, SFSB failover not supported");
                            }
                            if (object2 == null) {
                                throw new NoSuchObjectException("SFSB replication failed.");
                            }
                        } else {
                            InputStream inputStream2 = this.beanStore.getInputStream((EJBKey)beanId);
                            inputStream = new NewInputStream(inputStream2, statefulBeanO, classLoader, this.container);
                            int n = ((ObjectInputStream)inputStream).readInt();
                            object2 = new byte[n];
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("length of compressed bytes is: " + n));
                            }
                            int n2 = 0;
                            for (int i = 0; i < n; i += n2) {
                                n2 = ((ObjectInputStream)inputStream).read((byte[])object2, i, n - i);
                                if (tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)("bytes read from input stream is: " + n2));
                                }
                                if (n2 != -1) continue;
                                throw new IOException("end of input stream while reading compressed bytes");
                            }
                            ((ObjectInputStream)inputStream).close();
                        }
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object2);
                        inputStream = new GZIPInputStream(byteArrayInputStream);
                        NewInputStream newInputStream = new NewInputStream(inputStream, statefulBeanO, classLoader, this.container);
                        long l = newInputStream.readLong();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("read from DRS data last access time: " + l));
                        }
                        statefulBeanO.setLastAccessTime(l);
                        sessionBean = (SessionBean)newInputStream.readObject();
                        ((GZIPInputStream)inputStream).close();
                        statefulBeanO.setEnterpriseBean(sessionBean);
                    }
                    this.beanStore.remove((EJBKey)beanId);
                }
                catch (StreamUnavailableException streamUnavailableException) {
                    FFDCFilter.processException((Throwable)streamUnavailableException, (String)"com.ibm.ejs.container.passivator.StatefulPassivator.activate", (String)"146", (Object)this);
                    throw new NoSuchObjectException("");
                }
                catch (CSIException cSIException) {
                    FFDCFilter.processException((Throwable)cSIException, (String)"com.ibm.ejs.container.passivator.StatefulPassivator.activate", (String)"149", (Object)this);
                    throw new RemoteException("passivation failed", cSIException);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    FFDCFilter.processException((Throwable)classNotFoundException, (String)"com.ibm.ejs.container.passivator.StatefulPassivator.activate", (String)"152", (Object)this);
                    Tr.warning((TraceComponent)tc, (String)"CANNOT_ACTIVATE_STATEFUL_BEAN_CNTR0003W", (Object)new Object[]{object.toString(), this, classNotFoundException});
                    throw new RemoteException("", classNotFoundException);
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ejs.container.passivator.StatefulPassivator.activate", (String)"157", (Object)this);
                    Tr.warning((TraceComponent)tc, (String)"CANNOT_ACTIVATE_STATEFUL_BEAN_CNTR0003W", (Object)new Object[]{object.toString(), this, iOException});
                    throw new RemoteException("", iOException);
                }
                Object var14_23 = null;
                if (!isZOS || !this.syncToThread) break block23;
            }
            catch (Throwable throwable) {
                Object var14_24 = null;
                if (isZOS && this.syncToThread) {
                    ServerIdentityHelper.getServerIdentityHelper().pop(object3);
                }
                throw throwable;
            }
            ServerIdentityHelper.getServerIdentityHelper().pop(object3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"activate");
        }
    }

    public synchronized void remove(BeanId beanId, boolean bl) throws RemoteException {
        if (this.ivStatefulDRSCache == null || !this.ivStatefulDRSCache.beanExists(beanId)) {
            this.beanStore.remove((EJBKey)beanId);
        } else if (bl) {
            this.ivStatefulDRSCache.removeCacheEntry(beanId);
        }
    }

    public synchronized void terminate() {
        this.terminating = true;
    }

    private byte[] getCompressedBytes(SessionBean sessionBean, long l) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getCompressedBytes", (Object)sessionBean);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);
        GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        NewOutputStream newOutputStream = new NewOutputStream(gZIPOutputStream, this.container);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("writing DRS data with last access time set to: " + l));
        }
        newOutputStream.writeLong(l);
        newOutputStream.writeObject(sessionBean);
        gZIPOutputStream.finish();
        gZIPOutputStream.close();
        newOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getCompressedBytes");
        }
        return byArray;
    }
}

