/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.drs.ws390;

import com.ibm.CORBA.iiop.ORB;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.ws.util.PlatformHelperFactory;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class SfPlatformHelper {
    private static boolean initialized = false;
    private static Integer lock = new Integer(0);
    private static boolean _is_zOS = false;
    private static boolean _is_zOS_servant = false;
    private static boolean _is_zOS_controller = false;
    private static String processType = null;
    private static TraceComponent tc = Tr.register((Class)SfPlatformHelper.class, (String)"EJBDRSCache", (String)"com.ibm.ejs.container.container");
    public static final String EJBCONTAINER_ENABLE_BASE_REPLICATION = "EJBContainerEnableUnmanagedServerReplication";
    private static boolean isBaseServerReplicationEnabled = false;
    private static boolean isBaseServer = false;
    private static boolean _loggedVersion = false;

    private SfPlatformHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SfPlatformHelper.init: Entry.");
        }
        Integer n = lock;
        synchronized (n) {
            if (tc.isDebugEnabled() && !_loggedVersion) {
                Tr.debug((TraceComponent)tc, (String)"SfPlatformHelper.init: Version 1.2 12/2/04 15:55:11");
                _loggedVersion = true;
            }
            if (!initialized) {
                String string;
                processType = AdminServiceFactory.getAdminService().getProcessType();
                if (processType != null) {
                    isBaseServer = processType.equals("UnManagedProcess");
                }
                if ((string = System.getProperty(EJBCONTAINER_ENABLE_BASE_REPLICATION)) != null && string.equals("true")) {
                    isBaseServerReplicationEnabled = true;
                }
                if (_is_zOS = PlatformHelperFactory.getPlatformHelper().isZOS()) {
                    _is_zOS_controller = PlatformHelperFactory.getPlatformHelper().isControlJvm();
                    _is_zOS_servant = PlatformHelperFactory.getPlatformHelper().isServantJvm();
                } else {
                    _is_zOS_controller = false;
                    _is_zOS_servant = false;
                }
                initialized = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("SfPlatformHelper.init: _is_zOS = " + _is_zOS));
                    Tr.debug((TraceComponent)tc, (String)("SfPlatformHelper.init: _is_zOS_controller = " + _is_zOS_controller));
                    Tr.debug((TraceComponent)tc, (String)("SfPlatformHelper.init: _is_zOS_servant = " + _is_zOS_servant));
                    Tr.debug((TraceComponent)tc, (String)("SfPlatformHelper.init:  Process Type = " + processType));
                    Tr.debug((TraceComponent)tc, (String)("SfPlatformHelper.init:  enableBaseReplication = " + (string == null ? "null" : string)));
                    Tr.debug((TraceComponent)tc, (String)("SfPlatformHelper.init:  isBaseServerReplicationEnabled = " + isBaseServerReplicationEnabled));
                    Tr.debug((TraceComponent)tc, (String)("SfPlatformHelper.init:  isBaseServer = " + isBaseServer));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SfPlatformHelper.init: Exit.");
        }
    }

    public static boolean isZOS() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SfPlatformHelper.isZOS: Entry.");
        }
        if (!initialized) {
            SfPlatformHelper.init();
        }
        boolean bl = _is_zOS;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SfPlatformHelper.isZOS: Exit - " + bl));
        }
        return bl;
    }

    public static boolean isZOS_Controller() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SfPlatformHelper.isZOS_Controller: Entry.");
        }
        if (!initialized) {
            SfPlatformHelper.init();
        }
        boolean bl2 = bl = _is_zOS && _is_zOS_controller;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SfPlatformHelper.isZOS_Controller: Exit - " + bl));
        }
        return bl;
    }

    public static boolean isZOS_Servant() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SfPlatformHelper.isZOS_Servant: Entry.");
        }
        if (!initialized) {
            SfPlatformHelper.init();
        }
        boolean bl2 = bl = _is_zOS && _is_zOS_servant;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SfPlatformHelper.isZOS_Servant: Exit - " + bl));
        }
        return bl;
    }

    public static String getZOSUniqueId() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SfPlatformHelper.getZOSUniqueId: Entry.");
        }
        String string = null;
        if (!initialized) {
            SfPlatformHelper.init();
        }
        if (_is_zOS) {
            string = PlatformHelperFactory.getPlatformHelper().getUniqueId();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SfPlatformHelper.getZOSUniqueId: Exit - unique id " + string));
        }
        return string;
    }

    public static boolean isBaseServer() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SfPlatformHelper.isBaseServer: Entry.");
        }
        if (!initialized) {
            SfPlatformHelper.init();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SfPlatformHelper.isBaseServer: Exit - isBaseServer = " + isBaseServer));
        }
        return isBaseServer;
    }

    public static boolean isZOSBaseServer() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SfPlatformHelper.isZOSBaseServer: Entry.");
        }
        boolean bl = false;
        if (!initialized) {
            SfPlatformHelper.init();
        }
        boolean bl2 = bl = _is_zOS && isBaseServer;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SfPlatformHelper.isZOSBaseServer: Exit - isZOSBaseServer = " + bl));
        }
        return bl;
    }

    public static boolean isBaseServerReplicationEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SfPlatformHelper.isBaseServerReplicationEnabled: Entry.");
        }
        if (!initialized) {
            SfPlatformHelper.init();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SfPlatformHelper.isBaseServerReplicationEnabled: Exit - isBaseServerReplicationEnabled = " + isBaseServerReplicationEnabled));
        }
        return isBaseServerReplicationEnabled;
    }

    public static boolean isZOSBaseServerReplicationEnabled() {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SfPlatformHelper.isZOSBaseServerReplicationEnabled: Entry.");
        }
        if (!initialized) {
            SfPlatformHelper.init();
        }
        boolean bl2 = bl = _is_zOS && isBaseServer && isBaseServerReplicationEnabled;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SfPlatformHelper.isZOSBaseServerReplicationEnabled: Exit - isZOSBaseServerReplicationEnabled = " + bl));
        }
        return bl;
    }

    public static String getZOSStoken() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SfPlatformHelper.getZOSServantToken: Entry.");
        }
        String string = null;
        if (!initialized) {
            SfPlatformHelper.init();
        }
        if (_is_zOS) {
            string = PlatformHelperFactory.getPlatformHelper().getServantToken();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SfPlatformHelper.getZOSServantToken: Exit - stoken = " + string));
        }
        return string;
    }

    public static String getZOSServantToken() {
        return SfPlatformHelper.getZOSStoken();
    }

    public static ORB getZOSORB() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SfPlatformHelper.init: Entry.");
        }
        ORB oRB = null;
        if (!initialized) {
            SfPlatformHelper.init();
        }
        if (_is_zOS) {
            oRB = PlatformHelperFactory.getPlatformHelper().getGlobalORB();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SfPlatformHelper.init: Exit.");
        }
        return oRB;
    }

    public static byte[] getByteArray(Object object) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SfPlatformHelper.init: Entry.");
        }
        byte[] byArray = new byte[]{};
        if (object != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            byArray = byteArrayOutputStream.toByteArray();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SfPlatformHelper.init: Exit.");
        }
        return byArray;
    }

    public static Object getObject(byte[] byArray) throws IOException, ClassNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SfPlatformHelper.getObject: Entry.");
        }
        Object object = null;
        if (byArray != null && byArray.length > 0) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SfPlatformHelper.getObject: Exit.");
        }
        return object;
    }
}

