/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.drs.ws390;

import com.ibm.ejs.container.drs.ws390.SfDRSControllerBootstrapImpl;
import com.ibm.ejs.container.drs.ws390.SfDRSControllerCacheMsgListenerImpl;
import com.ibm.ejs.container.drs.ws390.SfDRSControllerDataXferImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.applicationserver.webcontainer.DRSSettings;
import com.ibm.wsspi.drs.DRSControllerDataXfer;
import com.ibm.wsspi.drs.DRSControllerInstance;
import com.ibm.wsspi.drs.DRSControllerInstanceFactoryConfig;
import com.ibm.wsspi.drs.DRSDataXfer;
import com.ibm.wsspi.drs.DRSEventObject;
import com.ibm.wsspi.drs.DRSInstanceToken;
import com.ibm.wsspi.drs.DRSInstanceTokenTable;
import com.ibm.wsspi.drs.DRSServantProxyFactory;
import java.util.Map;

public class SfDRSControllerInstanceImpl
implements DRSControllerInstance {
    DRSInstanceTokenTable registerendServants;
    DRSInstanceTokenTable unRegisterendServants;
    DRSServantProxyFactory drsServantProxyFactory;
    SfDRSControllerDataXferImpl ddx;
    DRSDataXfer baseDDX;
    DRSSettings drss;
    String ddxKey;
    Map miscParms;
    SfDRSControllerCacheMsgListenerImpl dcml;
    SfDRSControllerBootstrapImpl db;
    boolean usingHAManager;
    long uniqueInstanceId;
    long instanceId;
    String instanceName;
    String instanceUniqueName;
    private DRSEventObject isUpEvent;
    private DRSEventObject isNotCongestedEvent;
    boolean eventStateReplicationUp;
    boolean eventStateIsCongested;
    private Integer drsStateLock;
    private int unAvailableCount;
    private static final int MAX_UNAVAILABLE_ATTEMPTS = 500;
    private static TraceComponent tc = Tr.register((Class)SfDRSControllerInstanceImpl.class, (String)"EJBDRSCache", (String)"com.ibm.ejs.container.container");
    private static boolean _loggedVersion = false;

    public SfDRSControllerInstanceImpl(String string, DRSSettings dRSSettings, Map map, boolean bl, long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SfDRSControllerInstanceImpl.constructor:  Entry - ddxKey = " + string));
        }
        if (tc.isDebugEnabled() && !_loggedVersion) {
            Tr.debug((TraceComponent)tc, (String)"SfDRSControllerInstanceImpl.constructor: Version 1.5 2/26/05 20:32:00");
            _loggedVersion = true;
        }
        this.ddxKey = string;
        this.drss = dRSSettings;
        this.miscParms = map;
        this.usingHAManager = bl;
        this.uniqueInstanceId = l;
        this.instanceUniqueName = this.ddxKey + ":" + this.uniqueInstanceId;
        this.drsStateLock = new Integer(9472);
        this.unAvailableCount = 0;
        this.isUpEvent = new DRSEventObject(1, (Object)this);
        this.isNotCongestedEvent = new DRSEventObject(4, (Object)this);
        this.eventStateReplicationUp = true;
        this.eventStateIsCongested = false;
        this.ddx = null;
        this.baseDDX = null;
        this.dcml = null;
        this.drsServantProxyFactory = null;
        this.instanceId = 0L;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SfDRSControllerInstanceImpl.constructor:  ddxKey = " + this.ddxKey));
            Tr.debug((TraceComponent)tc, (String)("SfDRSControllerInstanceImpl.constructor:  DRS Settings = " + this.drss));
            Tr.debug((TraceComponent)tc, (String)("SfDRSControllerInstanceImpl.constructor:  Misc Parms = " + this.miscParms));
            Tr.debug((TraceComponent)tc, (String)("SfDRSControllerInstanceImpl.constructor:  Using HAManager = " + this.usingHAManager));
            Tr.debug((TraceComponent)tc, (String)("SfDRSControllerInstanceImpl.constructor:  Unique Instance Id = " + this.uniqueInstanceId));
        }
        this.registerendServants = DRSControllerInstanceFactoryConfig.createDRSInstanceTokenTable((String)("SfDRSControllerInstance" + this.instanceUniqueName), (String)"registerendServants");
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SfDRSControllerInstanceImpl.constructor:  ddxKey = " + this.ddxKey));
        }
    }

    public void init() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SfDRSControllerInstanceImpl.init:  Entry - ddxKey = " + this.ddxKey));
        }
        if (this.usingHAManager) {
            this.instanceId = this.ddx.getInstanceId();
            this.instanceName = this.ddx.getInstanceName();
        } else {
            this.instanceId = this.uniqueInstanceId;
            this.instanceName = this.ddxKey;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SfDRSControllerInstanceImpl.init:  instanceId = " + this.instanceId));
            Tr.debug((TraceComponent)tc, (String)("SfDRSControllerInstanceImpl.init:  instanceName = " + this.instanceName));
            Tr.debug((TraceComponent)tc, (String)("SfDRSControllerInstanceImpl.init:  instanceUniqueName = " + this.instanceUniqueName));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SfDRSControllerInstanceImpl.init:  Exit - ddxKey = " + this.ddxKey + " instanceUniqueName = " + this.instanceUniqueName));
        }
    }

    public DRSControllerDataXfer getDRSControllerDataXfer() {
        String string = "SfDRSControllerInstanceImpl.getDRSControllerDataXfer/" + this.instanceUniqueName + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string + " Entry"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(string + " Exit"));
        }
        return this.ddx;
    }

    public DRSInstanceTokenTable getDRSInstanceTokenTable() {
        String string = "SfDRSControllerInstanceImpl.getDRSInstanceTokenTable/" + this.instanceUniqueName + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string + " Entry"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(string + " Exit"));
        }
        return this.registerendServants;
    }

    public void addServant(DRSInstanceToken dRSInstanceToken, DRSEventObject dRSEventObject) {
        String string = "SfDRSControllerInstanceImpl.addServant/" + this.instanceUniqueName + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string + " token = " + dRSInstanceToken + " event = " + dRSEventObject));
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(string + " token = " + dRSInstanceToken + " event = " + dRSEventObject));
        }
        this.dcml.sendEvent(dRSInstanceToken, this.isUpEvent);
        this.dcml.sendEvent(dRSInstanceToken, this.isNotCongestedEvent);
        this.registerendServants.addServant(dRSInstanceToken);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(string + " Exit"));
        }
    }

    public void deleteServant(DRSInstanceToken dRSInstanceToken) {
        String string = "SfDRSControllerInstanceImpl.deleteServant/" + this.instanceUniqueName + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string + " Token = " + dRSInstanceToken));
        }
        this.registerendServants.deleteServant(dRSInstanceToken);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(string + " Exit"));
        }
    }

    public void deleteServant(String string) {
        String string2 = "SfDRSControllerInstanceImpl.deleteServant/" + this.instanceUniqueName + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string2 + " Stoken = " + string));
        }
        this.registerendServants.deleteServant(string);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(string2 + " Exit"));
        }
    }

    public long getInstanceId() {
        String string = "SfDRSControllerInstanceImpl.getInstanceId/" + this.instanceUniqueName + "/";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string + "Entry"));
        }
        long l = this.instanceId;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(string + " Exit - instanceId = " + l));
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDRSReplicationUp() {
        boolean bl;
        String string = "SfDRSControllerInstanceImpl.setDRSReplicationUp/" + this.instanceUniqueName + "/ ";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string + "Entry  - eventStateReplicationUp = " + this.eventStateReplicationUp));
        }
        Integer n = this.drsStateLock;
        synchronized (n) {
            bl = this.eventStateReplicationUp;
            this.eventStateReplicationUp = true;
            this.eventStateIsCongested = false;
        }
        if (!bl) {
            Tr.info((TraceComponent)tc, (String)"SFB_CONTROLLER_DRSEVENT_REPLICATION_UP_CNTR0113I", (Object)this.instanceUniqueName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(string + "Exit - eventStateReplicationUp = " + this.eventStateReplicationUp));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDRSReplicationDown() {
        boolean bl;
        String string = "SfDRSControllerInstanceImpl.setDRSReplicationDown/" + this.instanceUniqueName + "/ ";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string + "Entry  - eventStateReplicationUp = " + this.eventStateReplicationUp));
        }
        Integer n = this.drsStateLock;
        synchronized (n) {
            bl = this.eventStateReplicationUp;
            this.eventStateReplicationUp = false;
            this.eventStateIsCongested = false;
        }
        if (bl) {
            Tr.info((TraceComponent)tc, (String)"SFB_CONTROLLER_DRSEVENT_REPLICATION_DOWN_CNTR0114I", (Object)this.instanceUniqueName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(string + "Exit - eventStateReplicationUp = " + this.eventStateReplicationUp));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDRSCongested() {
        boolean bl;
        String string = "SfDRSControllerInstanceImpl.setDRSCongested/" + this.instanceUniqueName + "/ ";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string + "Entry  - eventStateIsCongested = " + this.eventStateIsCongested));
        }
        Integer n = this.drsStateLock;
        synchronized (n) {
            bl = this.eventStateIsCongested;
            this.eventStateIsCongested = true;
        }
        if (!bl) {
            Tr.info((TraceComponent)tc, (String)"SFB_CONTROLLER_DRSEVENT_IS_CONGESTED_CNTR0115I", (Object)this.instanceUniqueName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(string + "Exit - eventStateIsCongested = " + this.eventStateIsCongested));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDRSNotCongested() {
        boolean bl;
        String string = "SfDRSControllerInstanceImpl.setDRSNotCongested/" + this.instanceUniqueName + "/ ";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string + "Entry  - eventStateIsCongested = " + this.eventStateIsCongested));
        }
        Integer n = this.drsStateLock;
        synchronized (n) {
            bl = this.eventStateIsCongested;
            this.eventStateIsCongested = false;
        }
        if (bl) {
            Tr.info((TraceComponent)tc, (String)"SFB_CONTROLLER_DRSEVENT_NOT_CONGESTED_CNTR0116I", (Object)this.instanceUniqueName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(string + "Exit - eventStateIsCongested = " + this.eventStateIsCongested));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDRSAvailable() {
        String string = "SfDRSControllerInstanceImpl.isDRSAvailable/" + this.instanceUniqueName + "/ ";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string + "Entry."));
        }
        boolean bl = false;
        Integer n = this.drsStateLock;
        synchronized (n) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)(string + "DRS state - eventStateReplicationUp = " + this.eventStateReplicationUp + " - eventStateIsCongested = " + this.eventStateIsCongested));
            }
            boolean bl2 = bl = this.eventStateReplicationUp && !this.eventStateIsCongested;
            if (!bl && this.usingHAManager) {
                try {
                    ++this.unAvailableCount;
                    if (this.unAvailableCount > 500) {
                        boolean bl3;
                        this.unAvailableCount = 0;
                        if (!this.eventStateReplicationUp) {
                            bl3 = this.baseDDX.isReplicationUp();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)(string + "replicationUp = " + bl3));
                            }
                            if (bl3) {
                                this.setDRSReplicationUp();
                            }
                        }
                        if (this.eventStateReplicationUp && this.eventStateIsCongested) {
                            bl3 = this.baseDDX.isCongested();
                            if (tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)(string + "isCongested = " + bl3));
                            }
                            if (!bl3) {
                                this.setDRSNotCongested();
                            }
                        }
                        bl = this.eventStateReplicationUp && !this.eventStateIsCongested;
                    }
                }
                catch (Throwable throwable) {
                    Tr.error((TraceComponent)tc, (String)"ControllerSession.CaughtException", (Object)new Object[]{string, throwable});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(string + "Exit - isDRSAvailable = " + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDRSUp() {
        String string = "SfDRSControllerInstanceImpl.isDRSUp/" + this.instanceUniqueName + "/ ";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string + "Entry."));
        }
        boolean bl = false;
        Integer n = this.drsStateLock;
        synchronized (n) {
            bl = this.eventStateReplicationUp;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(string + "Exit - isDRSUp = " + bl));
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDRSCongested() {
        String string = "SfDRSControllerInstanceImpl.isDRSCongested/" + this.instanceUniqueName + "/ ";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(string + "Entry."));
        }
        boolean bl = false;
        Integer n = this.drsStateLock;
        synchronized (n) {
            bl = this.eventStateIsCongested;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)(string + "Exit - isDRSUp = " + bl));
        }
        return bl;
    }
}

