/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.drs;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.drs.SfDRSCacheEntry;
import com.ibm.ejs.container.drs.SfDRSKey;
import com.ibm.ejs.container.util.ByteArray;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.FastHashtable;
import com.ibm.wsspi.cluster.Identity;
import com.ibm.wsspi.drs.DRSDataXfer;
import com.ibm.wsspi.drs.DRSEventObject;
import java.util.Enumeration;

public final class SfDRSClient {
    private static final TraceComponent tc = Tr.register((Class)SfDRSClient.class, (String)"EJBDRSCache", (String)"com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.drs.SfDRSClient";
    private DRSDataXfer ivBaseDataXfer = null;
    private String ivInstanceId;
    private FastHashtable ivCache = new FastHashtable(97);

    public SfDRSClient(DRSDataXfer dRSDataXfer, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("SfDRSClient CTOR for ID = " + string));
        }
        this.ivInstanceId = string;
        this.ivBaseDataXfer = dRSDataXfer;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("SfDRSClient CTOR for ID = " + string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activated(BeanId beanId, long l) {
        SfDRSCacheEntry sfDRSCacheEntry;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("activated, beanId is: " + beanId));
        }
        if ((sfDRSCacheEntry = (SfDRSCacheEntry)this.ivCache.get((Object)beanId)) != null) {
            ByteArray byteArray = beanId.getByteArray();
            SfDRSCacheEntry sfDRSCacheEntry2 = sfDRSCacheEntry;
            synchronized (sfDRSCacheEntry2) {
                ++sfDRSCacheEntry.ivSequenceNumber;
                sfDRSCacheEntry.ivPassivated = false;
                sfDRSCacheEntry.ivLastAccessTime = l;
                sfDRSCacheEntry.replicate(this.ivBaseDataXfer);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("activated, beanId is: " + beanId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void passivated(BeanId beanId, byte[] byArray, long l) {
        SfDRSCacheEntry sfDRSCacheEntry;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("passivated, beanId is: " + beanId));
        }
        if ((sfDRSCacheEntry = (SfDRSCacheEntry)this.ivCache.get((Object)beanId)) != null) {
            ByteArray byteArray = beanId.getByteArray();
            SfDRSCacheEntry sfDRSCacheEntry2 = sfDRSCacheEntry;
            synchronized (sfDRSCacheEntry2) {
                ++sfDRSCacheEntry.ivSequenceNumber;
                sfDRSCacheEntry.ivPassivated = true;
                sfDRSCacheEntry.ivLastAccessTime = l;
                sfDRSCacheEntry.ivData = byArray;
                sfDRSCacheEntry.replicate(this.ivBaseDataXfer);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("passivated, beanId is: " + beanId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createEntry(BeanId beanId, long l) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createEntry beanId is: " + beanId));
        }
        SfDRSCacheEntry sfDRSCacheEntry = new SfDRSCacheEntry(beanId, l);
        Object object = this.ivCache;
        synchronized (object) {
            this.ivCache.put((Object)beanId, (Object)sfDRSCacheEntry);
        }
        object = sfDRSCacheEntry;
        synchronized (object) {
            ++sfDRSCacheEntry.ivSequenceNumber;
            sfDRSCacheEntry.replicate(this.ivBaseDataXfer);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createEntry ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createEntry(BeanId beanId, SfDRSCacheEntry sfDRSCacheEntry) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("createEntry bean ID is: " + beanId));
        }
        Object object = this.ivCache;
        synchronized (object) {
            this.ivCache.put((Object)beanId, (Object)sfDRSCacheEntry);
        }
        object = sfDRSCacheEntry;
        synchronized (object) {
            sfDRSCacheEntry.replicate(this.ivBaseDataXfer);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createEntry ");
        }
    }

    public void event(DRSEventObject dRSEventObject) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("eventObject = " + dRSEventObject));
        }
        int n = dRSEventObject.getEvent();
        switch (n) {
            case 1: {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"received event REPLICATION_UP.");
                }
                this.retryReplication();
                break;
            }
            case 2: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)"received event REPLICATION_DOWN.");
                break;
            }
            case 3: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug((TraceComponent)tc, (String)"received event IS_CONGESTED.");
                break;
            }
            case 4: {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"received event NOT_CONGESTED.");
                }
                this.retryReplication();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("eventObject = " + dRSEventObject));
        }
    }

    public SfDRSCacheEntry getEntry(BeanId beanId) {
        SfDRSCacheEntry sfDRSCacheEntry;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("getEntry beanId is: " + beanId));
            }
            sfDRSCacheEntry = null;
            try {
                SfDRSKey sfDRSKey = new SfDRSKey(beanId);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("getEntry key: " + sfDRSKey));
                }
                sfDRSCacheEntry = (SfDRSCacheEntry)this.ivBaseDataXfer.getEntry((Object)sfDRSKey);
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)("getEntry failed for entryKey = " + beanId));
                Tr.debug((TraceComponent)tc, (String)"caught Throwable: ", (Object)throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getEntry ");
        }
        return sfDRSCacheEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(BeanId beanId) {
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("removeEntry beanId is: " + beanId));
            }
            SfDRSCacheEntry sfDRSCacheEntry = null;
            FastHashtable fastHashtable = this.ivCache;
            synchronized (fastHashtable) {
                sfDRSCacheEntry = (SfDRSCacheEntry)this.ivCache.remove((Object)beanId);
            }
            try {
                if (sfDRSCacheEntry != null && !sfDRSCacheEntry.ivCreateEntry) {
                    ++sfDRSCacheEntry.ivSequenceNumber;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("removing DRS entry, " + sfDRSCacheEntry));
                    }
                    this.ivBaseDataXfer.removeEntry((Object)sfDRSCacheEntry.ivKey);
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug((TraceComponent)tc, (String)("remoteEntry failed for entryKey = " + beanId));
                Tr.debug((TraceComponent)tc, (String)"caught Throwable: ", (Object)throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeEntry ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retryReplication() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"retryReplication", (Object)this);
        }
        FastHashtable fastHashtable = this.ivCache;
        synchronized (fastHashtable) {
            Enumeration enumeration = this.ivCache.elements();
            while (enumeration.hasMoreElements()) {
                SfDRSCacheEntry sfDRSCacheEntry = (SfDRSCacheEntry)enumeration.nextElement();
                if (sfDRSCacheEntry == null) continue;
                SfDRSCacheEntry sfDRSCacheEntry2 = sfDRSCacheEntry;
                synchronized (sfDRSCacheEntry2) {
                    if (sfDRSCacheEntry.ivDRSState != 0L) {
                        sfDRSCacheEntry.replicate(this.ivBaseDataXfer);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"retryReplication");
        }
    }

    public boolean entryIDExists(BeanId beanId) {
        boolean bl;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("entryIDExists beanId is: " + beanId));
            }
            bl = false;
            try {
                SfDRSKey sfDRSKey = new SfDRSKey(beanId);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("entryIDExists key: " + sfDRSKey));
                }
                bl = this.ivBaseDataXfer.entryIDExists((Object)sfDRSKey);
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)tc, (String)("entryIDExists failed for entryKey = " + beanId));
                Tr.debug((TraceComponent)tc, (String)"caught Throwable: ", (Object)throwable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("entryIDExists returning " + bl));
        }
        return bl;
    }

    public Identity getWLMIdentity(BeanId beanId) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getWLMIdentity, beanId is: " + beanId));
        }
        SfDRSKey sfDRSKey = new SfDRSKey(beanId);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getWLMIdentity key: " + sfDRSKey));
        }
        Identity identity = this.ivBaseDataXfer.getWLMIdentity((Object)sfDRSKey, true);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getWLMIdentity returning WLM Identity: " + identity));
        }
        return identity;
    }

    public String toString() {
        return "SfDRSClient for ID: " + this.ivInstanceId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stickyUOW(BeanId beanId, boolean bl) {
        SfDRSCacheEntry sfDRSCacheEntry;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("stickyUOW, state is " + bl));
        }
        if ((sfDRSCacheEntry = (SfDRSCacheEntry)this.ivCache.get((Object)beanId)) != null) {
            ByteArray byteArray = beanId.getByteArray();
            SfDRSCacheEntry sfDRSCacheEntry2 = sfDRSCacheEntry;
            synchronized (sfDRSCacheEntry2) {
                ++sfDRSCacheEntry.ivSequenceNumber;
                sfDRSCacheEntry.ivStickyUOW = bl;
                sfDRSCacheEntry.replicate(this.ivBaseDataXfer);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"stickyUOW");
        }
    }
}

