/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.drs;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.activator.Activator;
import com.ibm.ejs.container.drs.SfDRSCacheEntry;
import com.ibm.ejs.container.drs.SfDRSCacheMsgListener;
import com.ibm.ejs.container.drs.SfDRSClient;
import com.ibm.ejs.container.drs.SfDRSKey;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.FastHashtable;
import com.ibm.websphere.models.config.applicationserver.webcontainer.DRSSettings;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.MultibrokerDomain;
import com.ibm.wsspi.drs.DRSCacheMsgListener;
import com.ibm.wsspi.drs.DRSDataXfer;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;

public class SfDRSCache {
    private static final TraceComponent tc = Tr.register((Class)SfDRSCache.class, (String)"EJBDRSCache", (String)"com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.drs.SfDRSCache";
    private final FastHashtable ivCache;
    private final FastHashtable ivSfDRSClientCache;
    private Activator ivActivator;
    private final MultibrokerDomain ivMultibrokerDomain;
    private String ivContainerId;
    private SfDRSClient ivContainerSfDRSClient;
    private EJSContainer ivContainer;

    public SfDRSCache(MultibrokerDomain multibrokerDomain) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"SfDRSCache CTOR");
        }
        this.ivCache = new FastHashtable(97);
        this.ivSfDRSClientCache = new FastHashtable(17);
        this.ivMultibrokerDomain = multibrokerDomain;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"SfDRSCache created");
        }
    }

    public final SfDRSClient getContainerSfDRSClient() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"getContainerSfDRSClient", (Object)this.ivContainerSfDRSClient);
        }
        return this.ivContainerSfDRSClient;
    }

    public SfDRSClient getSfDRSClient(String string, DRSSettings dRSSettings) {
        SfDRSClient sfDRSClient;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getSfDRSClient for DRS instance ID = " + string));
        }
        if ((sfDRSClient = (SfDRSClient)this.ivSfDRSClientCache.get((Object)string)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("creating DRS instance for ID = " + string));
            }
            try {
                SfDRSCacheMsgListener sfDRSCacheMsgListener = new SfDRSCacheMsgListener(this);
                String string2 = dRSSettings.getMessageBrokerDomainName();
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("DRS replication domain: " + string2));
                }
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("Configure DRS Controller Instance", "EJB Container DRS Controller Instance");
                DRSDataXfer dRSDataXfer = this.ivMultibrokerDomain.createInstance(string, (DRSCacheMsgListener)sfDRSCacheMsgListener, null, dRSSettings, null, hashMap);
                sfDRSClient = new SfDRSClient(dRSDataXfer, string);
                sfDRSCacheMsgListener.setSfDRSClient(sfDRSClient);
                this.ivSfDRSClientCache.put((Object)string, (Object)sfDRSClient);
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ejs.container.drs.SfDRSCache.getSfDRSClient", (String)"216", (Object)this);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("creating DRS instance failed: " + throwable));
                }
                sfDRSClient = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getSfDRSClient returning " + sfDRSClient));
        }
        return sfDRSClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beanDoesNotExistOrHasTimedOut(BeanId beanId) {
        SfDRSKey sfDRSKey;
        CacheEntry cacheEntry;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("beanDoesNotExistOrHasTimedOut for BeanId = " + beanId));
        }
        if ((cacheEntry = (CacheEntry)this.ivCache.get((Object)(sfDRSKey = new SfDRSKey(beanId)))) == null) {
            cacheEntry = this.faultDataIntoCache(beanId);
        }
        boolean bl = true;
        if (cacheEntry != null) {
            CacheEntry cacheEntry2 = cacheEntry;
            synchronized (cacheEntry2) {
                bl = this.beanTimedOut(cacheEntry);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("beanDoesNotExistOrHasTimedOut returning " + bl + " for BeanId = " + beanId));
        }
        return bl;
    }

    public void addCacheEntry(SfDRSKey sfDRSKey, SfDRSCacheEntry sfDRSCacheEntry) {
        CacheEntry cacheEntry;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("addCacheEntry for key = " + sfDRSKey));
        }
        if ((cacheEntry = (CacheEntry)this.ivCache.get((Object)sfDRSKey)) != null) {
            this.updateCacheEntry(sfDRSKey, sfDRSCacheEntry);
        } else {
            cacheEntry = new CacheEntry();
            cacheEntry.ivData = sfDRSCacheEntry.ivData;
            cacheEntry.ivSequenceNumber = sfDRSCacheEntry.ivSequenceNumber;
            cacheEntry.ivPassivated = sfDRSCacheEntry.ivPassivated;
            cacheEntry.ivStickyUOW = sfDRSCacheEntry.ivStickyUOW;
            cacheEntry.ivTimeoutValue = sfDRSCacheEntry.ivTimeoutValue;
            cacheEntry.ivLastAccessTime = sfDRSCacheEntry.ivLastAccessTime;
            cacheEntry.ivKey = sfDRSKey;
            this.ivCache.put((Object)sfDRSKey, (Object)cacheEntry);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("added: " + cacheEntry));
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"addCacheEntry");
        }
    }

    public final boolean beanExists(BeanId beanId) {
        SfDRSKey sfDRSKey = new SfDRSKey(beanId);
        return this.beanExists(sfDRSKey);
    }

    final boolean beanExists(SfDRSKey sfDRSKey) {
        CacheEntry cacheEntry = (CacheEntry)this.ivCache.get((Object)sfDRSKey);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(cacheEntry != null ? "Session bean is in DRS cache" : "Session bean is not DRS cache"));
        }
        return cacheEntry != null;
    }

    private boolean beanTimedOut(CacheEntry cacheEntry) {
        long l;
        long l2;
        if (cacheEntry.ivTimeoutValue > 0L && (l2 = (l = System.currentTimeMillis()) - cacheEntry.ivLastAccessTime) >= cacheEntry.ivTimeoutValue) {
            if (tc.isEventEnabled()) {
                Date date = new Date(l);
                Date date2 = new Date(cacheEntry.ivLastAccessTime);
                Tr.event((TraceComponent)tc, (String)"SFSB DRS cache entry timed out ", (Object)("DRS Key: " + cacheEntry.ivKey + ", Current Time: " + date.toString() + ", Last Access Time: " + date2.toString() + " Timeout: " + cacheEntry.ivTimeoutValue + " ms"));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beanExistsAndTimedOut(BeanId beanId) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("beanExistsAndTimedOut for BeanId = " + beanId));
        }
        boolean bl = false;
        SfDRSKey sfDRSKey = new SfDRSKey(beanId);
        CacheEntry cacheEntry = (CacheEntry)this.ivCache.get((Object)sfDRSKey);
        if (cacheEntry != null) {
            CacheEntry cacheEntry2 = cacheEntry;
            synchronized (cacheEntry2) {
                bl = this.beanTimedOut(cacheEntry);
            }
        }
        cacheEntry = this.faultDataIntoCache(beanId);
        if (cacheEntry != null) {
            CacheEntry cacheEntry3 = cacheEntry;
            synchronized (cacheEntry3) {
                bl = this.beanTimedOut(cacheEntry);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("beanExistsAndTimedOut returning " + bl + " for BeanId = " + beanId));
        }
        return bl;
    }

    private CacheEntry faultDataIntoCache(BeanId beanId) {
        SfDRSCacheEntry sfDRSCacheEntry;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("faultDataIntoCache for BeanId: " + beanId));
        }
        CacheEntry cacheEntry = null;
        SfDRSClient sfDRSClient = beanId.getBeanMetaData().getSfDRSClient();
        if (sfDRSClient != null && (sfDRSCacheEntry = sfDRSClient.getEntry(beanId)) != null) {
            SfDRSKey sfDRSKey = new SfDRSKey(beanId);
            this.addCacheEntry(sfDRSKey, sfDRSCacheEntry);
            cacheEntry = (CacheEntry)this.ivCache.get((Object)sfDRSKey);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("faultDataIntoCache returning: " + cacheEntry + "for BeanId = " + beanId));
        }
        return cacheEntry;
    }

    public byte[] getAndRemoveData(BeanId beanId, SfDRSClient sfDRSClient) {
        SfDRSKey sfDRSKey = new SfDRSKey(beanId);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getAndRemoveData, key = " + sfDRSKey));
        }
        byte[] byArray = null;
        CacheEntry cacheEntry = (CacheEntry)this.ivCache.remove((Object)sfDRSKey);
        if (cacheEntry != null) {
            byArray = cacheEntry.ivData;
            SfDRSCacheEntry sfDRSCacheEntry = new SfDRSCacheEntry(cacheEntry.ivKey, cacheEntry.ivTimeoutValue);
            sfDRSCacheEntry.ivData = byArray;
            sfDRSCacheEntry.ivLastAccessTime = cacheEntry.ivLastAccessTime;
            sfDRSCacheEntry.ivPassivated = cacheEntry.ivPassivated;
            sfDRSCacheEntry.ivSequenceNumber = cacheEntry.ivSequenceNumber;
            sfDRSCacheEntry.ivStickyUOW = cacheEntry.ivStickyUOW;
            sfDRSClient.createEntry(beanId, sfDRSCacheEntry);
        }
        if (tc.isEntryEnabled()) {
            int n = byArray != null ? byArray.length : 0;
            Tr.exit((TraceComponent)tc, (String)("getAndRemoveData returning data of length: " + n));
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SfDRSCacheEntry getCacheEntry(SfDRSKey sfDRSKey) {
        SfDRSCacheEntry sfDRSCacheEntry = null;
        CacheEntry cacheEntry = (CacheEntry)this.ivCache.get((Object)sfDRSKey);
        if (cacheEntry != null) {
            sfDRSCacheEntry = new SfDRSCacheEntry(sfDRSKey, cacheEntry.ivTimeoutValue);
            CacheEntry cacheEntry2 = cacheEntry;
            synchronized (cacheEntry2) {
                sfDRSCacheEntry.ivSequenceNumber = cacheEntry.ivSequenceNumber;
                sfDRSCacheEntry.ivData = cacheEntry.ivData;
                sfDRSCacheEntry.ivPassivated = cacheEntry.ivPassivated;
                sfDRSCacheEntry.ivStickyUOW = cacheEntry.ivStickyUOW;
                sfDRSCacheEntry.ivLastAccessTime = cacheEntry.ivLastAccessTime;
            }
        }
        return sfDRSCacheEntry;
    }

    public void initialize(EJSContainer eJSContainer, DRSSettings dRSSettings) {
        String string;
        String string2 = string = dRSSettings != null ? dRSSettings.getMessageBrokerDomainName() : "*unknown";
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("initialize for MultiBrokerDomain: " + string));
        }
        this.ivContainer = eJSContainer;
        this.ivContainerId = eJSContainer.getHomeOfHomes().getJ2EEName().getApplication();
        if (dRSSettings != null) {
            this.ivContainerSfDRSClient = this.getSfDRSClient(this.ivContainerId, dRSSettings);
        }
        this.ivActivator = eJSContainer.getActivator();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("initialize completed for MultiBrokerDomain: " + string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inStickyUOW(BeanId beanId) {
        boolean bl = false;
        SfDRSKey sfDRSKey = new SfDRSKey(beanId);
        CacheEntry cacheEntry = (CacheEntry)this.ivCache.get((Object)sfDRSKey);
        if (cacheEntry != null) {
            CacheEntry cacheEntry2 = cacheEntry;
            synchronized (cacheEntry2) {
                bl = cacheEntry.ivStickyUOW;
            }
        }
        return bl;
    }

    public final void removeCacheEntry(SfDRSKey sfDRSKey) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("removeCacheEntry, key = " + sfDRSKey));
        }
        CacheEntry cacheEntry = (CacheEntry)this.ivCache.remove((Object)sfDRSKey);
        if (tc.isDebugEnabled()) {
            if (cacheEntry != null) {
                Tr.debug((TraceComponent)tc, (String)("removed cache entry: " + cacheEntry));
            } else {
                Tr.debug((TraceComponent)tc, (String)"cache entry not removed since it was not found");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"removeCacheEntry");
        }
    }

    public final void removeCacheEntry(BeanId beanId) {
        SfDRSKey sfDRSKey = new SfDRSKey(beanId);
        this.removeCacheEntry(sfDRSKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sweep() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("sweep : DRS Cache size = " + this.ivCache.size()));
        }
        Enumeration enumeration = this.ivCache.elements();
        while (enumeration.hasMoreElements()) {
            CacheEntry cacheEntry;
            boolean bl = false;
            CacheEntry cacheEntry2 = cacheEntry = (CacheEntry)enumeration.nextElement();
            synchronized (cacheEntry2) {
                if (this.beanTimedOut(cacheEntry)) {
                    bl = true;
                }
            }
            if (!bl) continue;
            this.ivCache.remove((Object)cacheEntry.ivKey);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("sweep : DRS Cache size = " + this.ivCache.size()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCacheEntry(SfDRSKey sfDRSKey, SfDRSCacheEntry sfDRSCacheEntry) {
        CacheEntry cacheEntry;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("updateCacheEntry for key = " + sfDRSKey));
        }
        if ((cacheEntry = (CacheEntry)this.ivCache.get((Object)sfDRSKey)) == null) {
            this.addCacheEntry(sfDRSKey, sfDRSCacheEntry);
        } else if (sfDRSCacheEntry.ivSequenceNumber > cacheEntry.ivSequenceNumber) {
            long l = System.currentTimeMillis();
            CacheEntry cacheEntry2 = cacheEntry;
            synchronized (cacheEntry2) {
                cacheEntry.ivSequenceNumber = sfDRSCacheEntry.ivSequenceNumber;
                cacheEntry.ivStickyUOW = sfDRSCacheEntry.ivStickyUOW;
                cacheEntry.ivPassivated = sfDRSCacheEntry.ivPassivated;
                cacheEntry.ivLastAccessTime = sfDRSCacheEntry.ivLastAccessTime;
                if (sfDRSCacheEntry.ivData != null) {
                    cacheEntry.ivData = sfDRSCacheEntry.ivData;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("cached updated: " + cacheEntry));
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("stale data cache entry: " + sfDRSCacheEntry));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"updateCacheEntry");
        }
    }

    private class CacheEntry {
        SfDRSKey ivKey;
        byte[] ivData;
        long ivSequenceNumber;
        long ivTimeoutValue;
        long ivLastAccessTime;
        boolean ivPassivated;
        boolean ivStickyUOW;

        private CacheEntry() {
        }

        public String toString() {
            return "key = " + this.ivKey + ", sequence = " + this.ivSequenceNumber + ", passivated = " + this.ivPassivated + ", sticky UOW = " + this.ivStickyUOW;
        }
    }
}

