/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container.activator;

import com.ibm.ejs.container.BeanId;
import java.util.GregorianCalendar;

public final class TimeoutKey {
    private static final int CURRENT_TIME = 0;
    private static final int TIMEOUT_TIME = 1;
    private int ivTimeoutType;
    private final BeanId ivBeanId;
    private long ivTimeout;
    private boolean ivDiscarded;
    private boolean ivExpired;
    private boolean ivInUse;
    private final int ivHashValue;

    TimeoutKey(BeanId beanId) {
        this.ivBeanId = beanId;
        this.ivTimeoutType = 0;
        this.ivTimeout = System.currentTimeMillis();
        this.ivDiscarded = false;
        this.ivExpired = false;
        this.ivInUse = false;
        this.ivHashValue = beanId.hashCode();
    }

    TimeoutKey(BeanId beanId, long l) {
        this.ivBeanId = beanId;
        this.ivTimeoutType = 1;
        this.ivTimeout = l;
        this.ivDiscarded = false;
        this.ivExpired = false;
        this.ivInUse = true;
        this.ivHashValue = beanId.hashCode();
    }

    public void setTimeoutByInterval(int n, long l) {
        if (this.ivTimeoutType != 0) {
            if (this.ivExpired && !this.ivDiscarded && !this.ivInUse) {
                this.ivExpired = false;
                this.ivTimeout = System.currentTimeMillis();
            } else {
                throw new IllegalStateException("timeout already set");
            }
        }
        long l2 = this.ivTimeout;
        this.ivTimeoutType = 1;
        this.ivInUse = true;
        switch (n) {
            case 1: {
                if (l > 0L) {
                    long l3 = l2 % l;
                    long l4 = (long)(this.ivBeanId.hashCode() & Integer.MAX_VALUE) % l;
                    this.ivTimeout = l2 + (l4 - l3);
                    if (this.ivTimeout > l2) break;
                    this.ivTimeout += l;
                    break;
                }
                this.ivTimeout = Long.MAX_VALUE;
                break;
            }
            case 2: {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.set(11, 0);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(14, 0);
                long l5 = gregorianCalendar.getTime().getTime();
                this.ivTimeout = l5 + l;
                if (this.ivTimeout > l2) break;
                this.ivTimeout += 86400000L;
                break;
            }
            case 3: {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.set(7, 1);
                gregorianCalendar.set(11, 0);
                gregorianCalendar.set(12, 0);
                gregorianCalendar.set(13, 0);
                gregorianCalendar.set(14, 0);
                long l6 = gregorianCalendar.getTime().getTime();
                this.ivTimeout = l6 + l;
                if (this.ivTimeout > l2) break;
                this.ivTimeout += 604800000L;
                break;
            }
            default: {
                throw new IllegalArgumentException("Interval LoadPolicy not specified");
            }
        }
    }

    public void setDiscarded() {
        this.ivDiscarded = true;
        this.ivExpired = true;
    }

    public void setInUse(boolean bl) {
        this.ivInUse = bl;
    }

    public boolean expirationDetected() {
        return this.ivExpired;
    }

    public final int hashCode() {
        return this.ivHashValue;
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof TimeoutKey) {
            TimeoutKey timeoutKey = (TimeoutKey)object;
            if (this.ivBeanId.equals(timeoutKey.ivBeanId)) {
                if (this.ivTimeoutType == 1 && timeoutKey.ivTimeoutType == 1) {
                    if (this.ivTimeout == timeoutKey.ivTimeout) {
                        return true;
                    }
                } else if (timeoutKey.ivTimeoutType == 0 && this.ivTimeoutType == 1) {
                    if (!this.ivExpired) {
                        if (this.ivTimeout > timeoutKey.ivTimeout) {
                            return true;
                        }
                        this.ivExpired = true;
                        if (!this.ivInUse && !this.ivDiscarded) {
                            return true;
                        }
                    }
                } else if (this.ivTimeoutType == 0 && timeoutKey.ivTimeoutType == 1 && !timeoutKey.ivExpired) {
                    if (timeoutKey.ivTimeout > this.ivTimeout) {
                        return true;
                    }
                    timeoutKey.ivExpired = true;
                    if (!timeoutKey.ivInUse && !timeoutKey.ivDiscarded) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public final boolean equals(TimeoutKey timeoutKey) {
        if (this == timeoutKey) {
            return true;
        }
        if (timeoutKey == null) {
            return false;
        }
        if (this.ivBeanId.equals(timeoutKey.ivBeanId)) {
            if (this.ivTimeoutType == 1 && timeoutKey.ivTimeoutType == 1) {
                if (this.ivTimeout == timeoutKey.ivTimeout) {
                    return true;
                }
            } else if (timeoutKey.ivTimeoutType == 0 && this.ivTimeoutType == 1) {
                if (!this.ivExpired) {
                    if (this.ivTimeout > timeoutKey.ivTimeout) {
                        return true;
                    }
                    this.ivExpired = true;
                    if (!this.ivInUse && !this.ivDiscarded) {
                        return true;
                    }
                }
            } else if (this.ivTimeoutType == 0 && timeoutKey.ivTimeoutType == 1 && !timeoutKey.ivExpired) {
                if (timeoutKey.ivTimeout > this.ivTimeout) {
                    return true;
                }
                timeoutKey.ivExpired = true;
                if (!timeoutKey.ivInUse && !timeoutKey.ivDiscarded) {
                    return true;
                }
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("TimeoutKey(");
        stringBuffer.append(this.ivBeanId);
        if (this.ivTimeoutType == 1) {
            stringBuffer.append(", Timeout: ");
        } else {
            stringBuffer.append(", Current: ");
        }
        stringBuffer.append(this.ivTimeout);
        if (this.ivDiscarded) {
            stringBuffer.append(", discarded");
        }
        if (this.ivExpired) {
            stringBuffer.append(", expired");
        }
        if (this.ivInUse) {
            stringBuffer.append(", inUse");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }
}

