/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanO;
import com.ibm.ejs.container.ContainerTx;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.TimerHandleImpl;
import com.ibm.ejs.container.TimerServiceException;
import com.ibm.ejs.container.TimerTaskInfoImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.csi.TransactionAttribute;
import com.ibm.websphere.scheduler.Scheduler;
import com.ibm.websphere.scheduler.TaskInfo;
import com.ibm.websphere.scheduler.TaskInvalid;
import com.ibm.websphere.scheduler.TaskStatus;
import com.ibm.ws.csi.TimerTaskInfo;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import javax.ejb.EJBException;
import javax.ejb.NoSuchObjectLocalException;
import javax.ejb.Timer;
import javax.ejb.TimerHandle;

public final class TimerImpl
implements Timer {
    private static final TraceComponent tc = Tr.register((Class)TimerImpl.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final String CLASS_NAME = "com.ibm.ejs.container.TimerImpl";
    private String ivTaskId;
    private BeanId ivBeanId;
    private EJSHome ivHome;
    private Scheduler ivScheduler;
    private int ivHashCode;

    TimerImpl(BeanId beanId, Date date, long l, Serializable serializable) {
        if (tc.isEntryEnabled()) {
            String string = serializable == null ? null : serializable.getClass().getName();
            Tr.entry((TraceComponent)tc, (String)("TimerImpl: " + beanId + ", " + date + ", " + l + ", " + string));
        }
        try {
            this.ivBeanId = beanId;
            this.ivHome = (EJSHome)beanId.home;
            this.ivScheduler = this.ivHome.container.ivScheduler;
            boolean bl = false;
            if (this.ivHome.beanMetaData.timedMethodInfos[0].getTransactionAttribute() == TransactionAttribute.TX_REQUIRED) {
                bl = true;
            }
            TimerTaskInfoImpl timerTaskInfoImpl = new TimerTaskInfoImpl(beanId, date, l, serializable, TimerImpl.getTaskName(beanId), bl);
            TaskStatus taskStatus = this.ivScheduler.create((TaskInfo)timerTaskInfoImpl);
            this.ivTaskId = taskStatus.getTaskId();
            this.ivHashCode = taskStatus.hashCode();
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ejs.container.TimerImpl.<init>", (String)"128", (Object)this);
            TimerServiceException timerServiceException = new TimerServiceException(this.toString(), throwable);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("TimerImpl: " + timerServiceException));
            }
            throw timerServiceException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)this.toString());
        }
    }

    TimerImpl(BeanId beanId, String string, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("TimerImpl : " + beanId + ", " + string));
        }
        this.ivTaskId = string;
        this.ivBeanId = beanId;
        this.ivHome = (EJSHome)this.ivBeanId.home;
        this.ivScheduler = this.ivHome.container.ivScheduler;
        this.ivHashCode = n;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)this.toString());
        }
    }

    public void cancel() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("cancel: " + this));
        }
        this.checkTimerAccess();
        try {
            this.ivScheduler.cancel(this.ivTaskId, true);
        }
        catch (TaskInvalid taskInvalid) {
            FFDCFilter.processException((Throwable)taskInvalid, (String)"com.ibm.ejs.container.TimerImpl.cancel", (String)"203", (Object)this);
            NoSuchObjectLocalException noSuchObjectLocalException = new NoSuchObjectLocalException(this.toString(), (Exception)((Object)taskInvalid));
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("cancel: " + noSuchObjectLocalException));
            }
            throw noSuchObjectLocalException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ejs.container.TimerImpl.cancel", (String)"215", (Object)this);
            TimerServiceException timerServiceException = new TimerServiceException(this.toString(), throwable);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("cancel: " + timerServiceException));
            }
            throw timerServiceException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"cancel: successful");
        }
    }

    public long getTimeRemaining() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        Date date = this.getNextTimeout();
        long l = System.currentTimeMillis();
        long l2 = date.getTime() - l;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getTimeRemaining: " + l2));
        }
        return l2;
    }

    public Date getNextTimeout() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getNextTimeout: " + this));
        }
        this.checkTimerAccess();
        Date date = null;
        TaskStatus taskStatus = null;
        try {
            taskStatus = this.ivScheduler.getStatus(this.ivTaskId);
            date = taskStatus.getNextFireTime();
        }
        catch (TaskInvalid taskInvalid) {
            FFDCFilter.processException((Throwable)taskInvalid, (String)"com.ibm.ejs.container.TimerImpl.getNextTimeout", (String)"288", (Object)this);
            NoSuchObjectLocalException noSuchObjectLocalException = new NoSuchObjectLocalException(this.toString(), (Exception)((Object)taskInvalid));
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getNextTimeout: " + noSuchObjectLocalException));
            }
            throw noSuchObjectLocalException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ejs.container.TimerImpl.getNextTimeout", (String)"300", (Object)this);
            TimerServiceException timerServiceException = new TimerServiceException(this.toString(), throwable);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getNextTimeout: " + timerServiceException));
            }
            throw timerServiceException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getNextTimeout: " + date));
        }
        return date;
    }

    public Serializable getInfo() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getInfo: " + this));
        }
        this.checkTimerAccess();
        Serializable serializable = null;
        TimerTaskInfo timerTaskInfo = null;
        try {
            timerTaskInfo = (TimerTaskInfo)this.ivScheduler.getTask(this.ivTaskId);
            serializable = timerTaskInfo.getInfo();
        }
        catch (TaskInvalid taskInvalid) {
            FFDCFilter.processException((Throwable)taskInvalid, (String)"com.ibm.ejs.container.TimerImpl.getInfo", (String)"351", (Object)this);
            NoSuchObjectLocalException noSuchObjectLocalException = new NoSuchObjectLocalException(this.toString(), (Exception)((Object)taskInvalid));
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getInfo: " + noSuchObjectLocalException));
            }
            throw noSuchObjectLocalException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ejs.container.TimerImpl.getInfo", (String)"363", (Object)this);
            TimerServiceException timerServiceException = new TimerServiceException(this.toString(), throwable);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getInfo: " + timerServiceException));
            }
            throw timerServiceException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getInfo: " + serializable));
        }
        return serializable;
    }

    public TimerHandle getHandle() throws IllegalStateException, NoSuchObjectLocalException, EJBException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("getHandle: " + this));
        }
        this.checkTimerAccess();
        TimerHandleImpl timerHandleImpl = null;
        TaskStatus taskStatus = null;
        try {
            taskStatus = this.ivScheduler.getStatus(this.ivTaskId);
            timerHandleImpl = new TimerHandleImpl(this.ivBeanId, this.ivTaskId, this.ivHashCode, false);
        }
        catch (TaskInvalid taskInvalid) {
            FFDCFilter.processException((Throwable)taskInvalid, (String)"com.ibm.ejs.container.TimerImpl.getHandle", (String)"415", (Object)this);
            NoSuchObjectLocalException noSuchObjectLocalException = new NoSuchObjectLocalException(this.toString(), (Exception)((Object)taskInvalid));
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getHandle: " + noSuchObjectLocalException));
            }
            throw noSuchObjectLocalException;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ejs.container.TimerImpl.getHandle", (String)"427", (Object)this);
            TimerServiceException timerServiceException = new TimerServiceException(this.toString(), throwable);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("getHandle: " + timerServiceException));
            }
            throw timerServiceException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("getHandle: " + timerHandleImpl));
        }
        return timerHandleImpl;
    }

    static Collection findTimersByBeanId(BeanId beanId) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("findTimersByBeanId: " + beanId));
        }
        ArrayList<TimerImpl> arrayList = new ArrayList<TimerImpl>();
        String string = TimerImpl.getTaskName(beanId);
        EJSHome eJSHome = (EJSHome)beanId.home;
        Scheduler scheduler = eJSHome.container.ivScheduler;
        long l = 0L;
        Iterator iterator = null;
        try {
            iterator = scheduler.findTasksByName(string);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ejs.container.TimerImpl.findTimersByBeanId", (String)"487");
            TimerServiceException timerServiceException = new TimerServiceException(beanId.toString(), throwable);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("findTimersByBeanId: " + timerServiceException));
            }
            throw timerServiceException;
        }
        while (iterator.hasNext()) {
            TimerTaskInfo timerTaskInfo = (TimerTaskInfo)iterator.next();
            BeanId beanId2 = (BeanId)timerTaskInfo.getTimedObjectId();
            if (beanId.equals(beanId2)) {
                TimerImpl timerImpl = new TimerImpl(beanId2, timerTaskInfo.getTaskId(), timerTaskInfo.hashCode());
                arrayList.add(timerImpl);
            }
            ++l;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("findTimersByBeanId: " + arrayList.size() + "(of " + l + " found)"));
        }
        return arrayList;
    }

    static void removeTimersByBeanId(BeanId beanId) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("removeTimersByBeanId: " + beanId));
        }
        String string = TimerImpl.getTaskName(beanId);
        EJSHome eJSHome = (EJSHome)beanId.home;
        Scheduler scheduler = eJSHome.container.ivScheduler;
        long l = 0L;
        long l2 = 0L;
        Iterator iterator = null;
        try {
            iterator = scheduler.findTasksByName(string);
        }
        catch (Throwable throwable) {
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ejs.container.TimerImpl.removeTimersByBeanId", (String)"559");
            TimerServiceException timerServiceException = new TimerServiceException(beanId.toString(), throwable);
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("removeTimersByBeanId: " + timerServiceException));
            }
            throw timerServiceException;
        }
        while (iterator.hasNext()) {
            TimerTaskInfo timerTaskInfo = (TimerTaskInfo)iterator.next();
            BeanId beanId2 = (BeanId)timerTaskInfo.getTimedObjectId();
            if (beanId.equals(beanId2)) {
                try {
                    scheduler.cancel(timerTaskInfo.getTaskId(), true);
                    ++l2;
                }
                catch (TaskInvalid taskInvalid) {
                    FFDCFilter.processException((Throwable)taskInvalid, (String)"com.ibm.ejs.container.TimerImpl.removeTimersByBeanId", (String)"591");
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("TaskInvalid ignored : " + timerTaskInfo.getTaskId()));
                    }
                }
                catch (Throwable throwable) {
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ejs.container.TimerImpl.removeTimersByBeanId", (String)"601");
                    TimerServiceException timerServiceException = new TimerServiceException(timerTaskInfo.toString(), throwable);
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)("removeTimersByBeanId: " + timerServiceException));
                    }
                    throw timerServiceException;
                }
            }
            ++l;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("removeTimersByBeanId: " + l2 + "(of " + l + " found)"));
        }
    }

    private static String getTaskName(BeanId beanId) {
        J2EEName j2EEName = beanId.getJ2EEName();
        StringBuffer stringBuffer = new StringBuffer(j2EEName.getComponent());
        if (stringBuffer.length() > 240) {
            stringBuffer.setLength(240);
        }
        stringBuffer.append("_").append(beanId.hashCode());
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("taskName = " + stringBuffer));
        }
        return stringBuffer.toString();
    }

    protected void checkTimerAccess() throws IllegalStateException {
        IllegalStateException illegalStateException;
        BeanO beanO;
        block6: {
            beanO = null;
            ContainerTx containerTx = null;
            Object var3_3 = null;
            illegalStateException = null;
            try {
                containerTx = this.ivHome.container.getCurrentTx(false);
                if (containerTx != null) {
                    beanO = containerTx.ivCallbackBeanO;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("checkTimerAccess: checking callback  beanO from current tx: " + beanO));
                    }
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ejs.container.TimerImpl.checkTimerAccess", (String)"703", (Object)this);
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug((TraceComponent)tc, (String)("Exception ignored : " + throwable));
            }
        }
        if (beanO == null) {
            illegalStateException = new IllegalStateException("Timer: Timer methods not allowed - no active EJB");
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("checkTimerAccess: " + illegalStateException));
            }
            throw illegalStateException;
        }
        beanO.checkTimerServiceAccess();
    }

    public TimerHandleImpl getSerializableObject() {
        TimerHandleImpl timerHandleImpl = new TimerHandleImpl(this.ivBeanId, this.ivTaskId, this.ivHashCode, true);
        return timerHandleImpl;
    }

    public boolean equals(Object object) {
        if (object instanceof TimerImpl) {
            TimerImpl timerImpl = (TimerImpl)object;
            if (this.ivHashCode == timerImpl.ivHashCode && this.ivTaskId.equals(timerImpl.ivTaskId)) {
                return true;
            }
        }
        return false;
    }

    public boolean equals(TimerImpl timerImpl) {
        return timerImpl != null && this.ivHashCode == timerImpl.ivHashCode && this.ivTaskId.equals(timerImpl.ivTaskId);
    }

    public int hashCode() {
        return this.ivHashCode;
    }

    public String toString() {
        return "TimerImpl(" + this.ivTaskId + ", " + this.ivBeanId + ")";
    }
}

