/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BeanId;
import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.EJSContainer;
import com.ibm.ejs.container.EJSHome;
import com.ibm.ejs.container.MDBInternalHome;
import com.ibm.ejs.container.MessageEndpointHandler;
import com.ibm.ejs.container.util.MethodAttribUtils;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.EJBConfigData;
import com.ibm.websphere.csi.EJBMethodInfo;
import com.ibm.websphere.csi.MethodInterface;
import com.ibm.websphere.csi.Pool;
import com.ibm.websphere.csi.TransactionAttribute;
import com.ibm.ws.Transaction.RecoverableXAResource;
import com.ibm.ws.j2c.MessageEndpointFactory;
import com.ibm.ws.j2c.RALifeCycleManager;
import com.ibm.ws.j2c.RALifeCycleManagerFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import javax.resource.ResourceException;
import javax.resource.spi.ApplicationServerInternalException;
import javax.resource.spi.UnavailableException;
import javax.resource.spi.endpoint.MessageEndpoint;
import javax.transaction.xa.XAResource;

public class MessageEndpointFactoryImpl
extends EJSHome
implements MessageEndpointFactory,
MDBInternalHome {
    private static final long serialVersionUID = 6055819285757596987L;
    private static final String CLASS_NAME = "com.ibm.ejs.container.MessageEndpointFactoryImpl";
    protected static TraceComponent tc = Tr.register((Class)MessageEndpointFactoryImpl.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private final byte INACTIVE_STATE = 0;
    private final byte ACTIVATING_STATE = 1;
    private final byte ACTIVE_STATE = (byte)2;
    private final byte DEACTIVATING_STATE = (byte)3;
    private byte ivState = 0;
    private Thread ivActivatingThread = null;
    private int ivRecoveryId;
    private boolean ivRecoveryIdKnown = false;
    private boolean ivEnlistNotNeeded = false;
    private int ivEnlistNotNeededReason;
    private boolean ivEnlistNotNeededMessageLogged = false;
    private Constructor ivProxyCTOR = null;
    private Pool ivInvocationHandlerPool = null;
    private int ivNumberOfMessageEndpointsCreated;
    private int ivMaxCreation;
    private EJBMethodInfo[] ivMdbMethods;
    private String ivDeactivationKey = null;
    private String ivRAKey = null;
    private boolean ivJMS = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activateEndpoint(EJBConfigData eJBConfigData) throws ResourceException {
        ResourceException resourceException;
        block22: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("MEF.activateEndpoint for enterprise class " + this.beanMetaData.enterpriseBeanName));
            }
            resourceException = null;
            RALifeCycleManager rALifeCycleManager = RALifeCycleManagerFactory.getInstance();
            String string = null;
            Thread thread = Thread.currentThread();
            try {
                Constructor constructor = this.ivProxyCTOR;
                synchronized (constructor) {
                    if (this.ivState == 0) {
                        this.ivState = 1;
                        this.ivActivatingThread = thread;
                    } else if (this.ivState == 2) {
                        rALifeCycleManager = null;
                    } else {
                        rALifeCycleManager = null;
                        resourceException = new ResourceException("can not activate until deactivate completes");
                    }
                }
                if (rALifeCycleManager == null) break block22;
                rALifeCycleManager = RALifeCycleManagerFactory.getInstance();
                string = rALifeCycleManager.activateEndpoint(this.beanMetaData.ivActivationSpecJndiName, (MessageEndpointFactory)this, this.beanMetaData.ivActivationConfig, this.beanMetaData.j2eeName, this.beanMetaData.ivActivationSpecAuthAlias, this.beanMetaData.ivMessageDestinationJndiName);
                constructor = this.ivProxyCTOR;
                synchronized (constructor) {
                    this.ivState = (byte)2;
                    this.ivDeactivationKey = string;
                    this.ivProxyCTOR.notifyAll();
                }
            }
            catch (ResourceException resourceException2) {
                Constructor constructor = this.ivProxyCTOR;
                synchronized (constructor) {
                    this.ivState = 0;
                    this.ivProxyCTOR.notifyAll();
                }
                resourceException = resourceException2;
            }
            catch (Throwable throwable) {
                Constructor constructor = this.ivProxyCTOR;
                synchronized (constructor) {
                    this.ivState = 0;
                    this.ivProxyCTOR.notifyAll();
                }
                resourceException = new ResourceException(throwable);
            }
        }
        this.beanMetaData.ivActivationConfig = null;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("MEF.activateEndpoint for enterprise class " + this.beanMetaData.enterpriseBeanName));
        }
        if (resourceException != null) {
            throw resourceException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivateEndpoint() throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("MEF.deactivateEndpoint for enterprise class " + this.beanMetaData.enterpriseBeanName));
        }
        RALifeCycleManager rALifeCycleManager = RALifeCycleManagerFactory.getInstance();
        String string = null;
        Constructor constructor = this.ivProxyCTOR;
        synchronized (constructor) {
            if (this.ivState == 2) {
                this.ivState = (byte)3;
                string = this.ivDeactivationKey;
            } else if (this.ivState != 0) {
                throw new ResourceException("illegal state for deactivate");
            }
        }
        if (string != null) {
            Constructor constructor2;
            try {
                rALifeCycleManager.deactivateEndPoint(string);
                Object var6_5 = null;
                constructor2 = this.ivProxyCTOR;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                Constructor constructor3 = this.ivProxyCTOR;
                synchronized (constructor3) {
                    this.ivState = 0;
                    this.ivDeactivationKey = null;
                }
                throw throwable;
            }
            synchronized (constructor2) {
                this.ivState = 0;
                this.ivDeactivationKey = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("MEF.deactivateEndpoint for enterprise class " + this.beanMetaData.enterpriseBeanName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageEndpoint createEndpoint(XAResource xAResource) throws UnavailableException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("MEF.createEndpoint for enterprise class " + this.beanMetaData.enterpriseBeanName));
        }
        boolean bl = false;
        if (!(xAResource == null || this.ivRecoveryIdKnown && this.ivRecoveryId != 0 || this.ivEnlistNotNeeded)) {
            if (xAResource instanceof RecoverableXAResource) {
                bl = true;
            } else {
                Tr.error((TraceComponent)tc, (String)"ENDPOINT_RECOVERY_ID_UNKNOWN_CNTR0082E", (Object)new Object[]{this.ivRAKey, this.beanMetaData.j2eeName});
                throw new UnavailableException("setRecoveryId must be called prior to createEndpoint");
            }
        }
        MessageEndpointHandler messageEndpointHandler = null;
        Proxy proxy = null;
        boolean bl2 = false;
        Constructor constructor = this.ivProxyCTOR;
        synchronized (constructor) {
            if (this.ivState == 2) {
                messageEndpointHandler = (MessageEndpointHandler)this.ivInvocationHandlerPool.get();
                if (messageEndpointHandler == null) {
                    if (this.ivNumberOfMessageEndpointsCreated >= this.ivMaxCreation) {
                        throw new UnavailableException("limit for number of MessageEndpoint proxies created reached.");
                    }
                    ++this.ivNumberOfMessageEndpointsCreated;
                    bl2 = true;
                }
            } else if (this.ivState == 1) {
                if (this.ivActivatingThread == Thread.currentThread()) {
                    throw new UnavailableException("activating thread not allowed to create endpoint during activation.");
                }
                try {
                    this.ivProxyCTOR.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.ivState != 2) {
                    throw new UnavailableException("endpoint needs to be activated.");
                }
            } else {
                if (this.ivState == 3) {
                    throw new UnavailableException("deactivate of endpoint is in progress.");
                }
                throw new UnavailableException("endpoint needs to be activated.");
            }
        }
        constructor = null;
        try {
            if (messageEndpointHandler != null) {
                proxy = (Proxy)messageEndpointHandler.ivProxy;
            } else {
                messageEndpointHandler = new MessageEndpointHandler(this, this.ivRecoveryId, this.container, this.beanMetaData, this.pmiBean, this.wrapperManager, this.ivJMS);
                proxy = (Proxy)this.ivProxyCTOR.newInstance(messageEndpointHandler);
                messageEndpointHandler.ivProxy = proxy;
            }
            if (this.ivEnlistNotNeeded) {
                if (xAResource == null) {
                    messageEndpointHandler.initialize(null, false);
                } else {
                    constructor = this.mapAndLogTranEnlistmentNotNeeded();
                }
            } else {
                messageEndpointHandler.initialize(xAResource, bl);
            }
        }
        catch (Throwable throwable) {
            Tr.error((TraceComponent)tc, (String)"CREATE_ENDPOINT_FAILED_CNTR0083E", (Object)throwable);
            constructor = new UnavailableException("Creation of MessageEndpoint Proxy failed", throwable);
        }
        if (constructor != null) {
            Object object;
            if (messageEndpointHandler != null && proxy != null) {
                this.ivInvocationHandlerPool.put((Object)messageEndpointHandler);
            } else if (bl2) {
                object = this.ivProxyCTOR;
                synchronized (object) {
                    --this.ivNumberOfMessageEndpointsCreated;
                }
            }
            if (tc.isEntryEnabled()) {
                object = this.beanMetaData;
                Tr.exit((TraceComponent)tc, (String)("createEndpoint for enterprise class " + ((BeanMetaData)((Object)object)).enterpriseBeanName + " failed."));
            }
            throw constructor;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("MEF.createEndpoint for enterprise class " + this.beanMetaData.enterpriseBeanName));
        }
        return (MessageEndpoint)proxy;
    }

    public boolean isDeliveryTransacted(Method method) throws NoSuchMethodException {
        boolean bl;
        EJBMethodInfo eJBMethodInfo;
        BeanMetaData beanMetaData = this.beanMetaData;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("MEF.isDeliveryTransacted called for " + beanMetaData.enterpriseBeanName + "." + method.getName()));
        }
        if ((eJBMethodInfo = this.getEJBMethodInfo(method)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("MEF.isDeliveryTransacted failed to find method " + beanMetaData.enterpriseBeanName + "." + method.getName()));
            }
            Tr.error((TraceComponent)tc, (String)"NO_SUCH_MDB_METHOD_CNTR0085E", (Object)new Object[]{beanMetaData.j2eeName, method.getName(), beanMetaData.localInterfaceClass});
            throw new NoSuchMethodException(beanMetaData.enterpriseBeanName + "." + method.getName() + " not found");
        }
        TransactionAttribute transactionAttribute = eJBMethodInfo.getTransactionAttribute();
        if (transactionAttribute == TransactionAttribute.TX_REQUIRED) {
            bl = true;
        } else if (transactionAttribute == TransactionAttribute.TX_NOT_SUPPORTED) {
            bl = false;
        } else if (transactionAttribute == TransactionAttribute.TX_BEAN_MANAGED) {
            bl = false;
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("MEF.isDeliveryTransacted detected invalid TX attribute for " + beanMetaData.enterpriseBeanName + "." + method.getName() + ", TX attribute is " + transactionAttribute));
            }
            Tr.error((TraceComponent)tc, (String)"INVALID_MDB_TX_ATTR_CNTR0084E", (Object)new Object[]{method.getName(), beanMetaData.j2eeName});
            ApplicationServerInternalException applicationServerInternalException = new ApplicationServerInternalException("Method exists, but TX attribute is neither REQUIRED, NOT_SUPPORTED, nor BEAN_MANAGED: " + transactionAttribute);
            NoSuchMethodException noSuchMethodException = new NoSuchMethodException("see chained exception");
            noSuchMethodException.initCause((Throwable)applicationServerInternalException);
            throw noSuchMethodException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("MEF.isDeliveryTransacted returning " + bl + " for " + beanMetaData.enterpriseBeanName + "." + method.getName()));
        }
        return bl;
    }

    private EJBMethodInfo getEJBMethodInfo(Method method) {
        String string = MethodAttribUtils.methodSignature(method);
        EJBMethodInfo eJBMethodInfo = null;
        int n = this.ivMdbMethods.length;
        for (int i = 0; i < n; ++i) {
            eJBMethodInfo = this.ivMdbMethods[i];
            if (!string.equals(eJBMethodInfo.getMethodSignature())) continue;
            return eJBMethodInfo;
        }
        return null;
    }

    public void initialize(EJSContainer eJSContainer, BeanId beanId, BeanMetaData beanMetaData) throws RemoteException {
        super.initialize(eJSContainer, beanId, beanMetaData);
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("MEF Initializing MessageEndpointFactory for enterprise class " + beanMetaData.enterpriseBeanName + ", with message listener interface of " + beanMetaData.localInterfaceClass.getName()));
        }
        this.ivMdbMethods = this.beanMetaData.getEJBMethodMetaData(MethodInterface.MESSAGE_LISTENER);
        this.ivJMS = beanMetaData.localInterfaceClass.getName().equals("javax.jms.MessageListener");
        Class[] classArray = new Class[]{MessageEndpoint.class, beanMetaData.localInterfaceClass};
        Class<?> clazz = Proxy.getProxyClass(beanMetaData.classLoader, classArray);
        try {
            this.ivProxyCTOR = clazz.getConstructor(InvocationHandler.class);
        }
        catch (Throwable throwable) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("MEF initialization for enterprise class " + beanMetaData.enterpriseBeanName + " with messaging listener interface of " + beanMetaData.localInterfaceClass.getName() + " failed."));
            }
            throw new RemoteException("Unable to get Proxy Constructor Method object", throwable);
        }
        this.ivMaxCreation = beanMetaData.maxPoolSize;
        this.ivInvocationHandlerPool = eJSContainer.poolManager.createThreadSafePool(beanMetaData.minPoolSize, beanMetaData.maxPoolSize);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("MessageEndpointFactory initialized for enterprise class " + beanMetaData.enterpriseBeanName + " with messaging listener interface of " + beanMetaData.localInterfaceClass.getName()));
        }
    }

    public void setRecoveryID(int n) throws ResourceException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("MEF.setRecoveryID for enterprise class " + this.beanMetaData.enterpriseBeanName));
        }
        if (this.ivRecoveryIdKnown) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("MEF.setRecoveryID for enterprise class " + this.beanMetaData.enterpriseBeanName));
            }
            throw new ApplicationServerInternalException("setRecoveryId can only be called once per factory");
        }
        this.ivRecoveryId = n;
        this.ivRecoveryIdKnown = true;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("MEF.setRecoveryID for enterprise class " + this.beanMetaData.enterpriseBeanName));
        }
    }

    public void setTranEnlistmentNotNeeded(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("MEF.setTranEnlistmentNotNeeded for enterprise class " + this.beanMetaData.enterpriseBeanName + ", reason =  " + n));
        }
        this.ivEnlistNotNeeded = true;
        this.ivEnlistNotNeededReason = n;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("MEF.setTranEnlistmentNotNeeded for enterprise class " + this.beanMetaData.enterpriseBeanName));
        }
    }

    private UnavailableException mapAndLogTranEnlistmentNotNeeded() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("MEF.mapAndLogTranEnlistmentNotNeeded for enterprise class " + this.beanMetaData.enterpriseBeanName));
        }
        UnavailableException unavailableException = null;
        switch (this.ivEnlistNotNeededReason) {
            case 0: {
                if (!this.ivEnlistNotNeededMessageLogged) {
                    Tr.error((TraceComponent)tc, (String)"RA_DOES_NOT_SUPPORT_XATRANSACTIONS_CNTR0087E", (Object)new Object[]{this.ivRAKey, this.beanMetaData.j2eeName});
                }
                unavailableException = new UnavailableException("Transaction recovery not setup for this RA since RA does not support XA transactions");
                break;
            }
            case 1: {
                if (!this.ivEnlistNotNeededMessageLogged) {
                    Tr.error((TraceComponent)tc, (String)"ERROR_DURING_TRAN_RECOVERY_SETUP_CNTR0086E", (Object)new Object[]{this.ivRAKey, this.beanMetaData.j2eeName});
                }
                unavailableException = new UnavailableException("Error occured during transaction recovery setup for this Resource Adapter");
                break;
            }
            default: {
                if (!this.ivEnlistNotNeededMessageLogged) {
                    Tr.error((TraceComponent)tc, (String)"REASON_CODE_NOT_RECOGNIZED_CNTR0081E", (Object)new Integer(this.ivEnlistNotNeededReason));
                }
                unavailableException = new UnavailableException("Error occured during transaction recovery setup for this Resource Adapter");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("MEF.mapAndLogTranEnlistmentNotNeeded for enterprise class " + this.beanMetaData.enterpriseBeanName));
        }
        this.ivEnlistNotNeededMessageLogged = true;
        return unavailableException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnInvocationHandler(MessageEndpointHandler messageEndpointHandler, boolean bl) {
        if (bl) {
            this.ivInvocationHandlerPool.put((Object)messageEndpointHandler);
        } else {
            Constructor constructor = this.ivProxyCTOR;
            synchronized (constructor) {
                --this.ivNumberOfMessageEndpointsCreated;
            }
        }
    }

    public void setRAKey(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("MEF.setRAKey for enterprise class " + this.beanMetaData.enterpriseBeanName));
        }
        this.ivRAKey = string;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("MEF.setRAKey for enterprise class " + this.beanMetaData.enterpriseBeanName));
        }
    }

    public void messageEndpointForcefullyDeactivated() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("MEF.messageEndpointForcefullyDeactivated called for enterprise class " + this.beanMetaData.enterpriseBeanName));
        }
        this.ivDeactivationKey = null;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("MEF.messageEndpointForcefullyDeactivated exit for enterprise class " + this.beanMetaData.enterpriseBeanName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void discard() {
        Constructor constructor = this.ivProxyCTOR;
        synchronized (constructor) {
            --this.ivNumberOfMessageEndpointsCreated;
        }
    }
}

