/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.security.AccessController;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import sun.security.action.GetPropertyAction;
import sun.security.provider.PolicyParser;
import sun.security.tools.CancelButtonListener;
import sun.security.tools.FileMenuListener;
import sun.security.tools.FocusTextField;
import sun.security.tools.LegacyList;
import sun.security.tools.MainWindowListener;
import sun.security.tools.OKButtonListener;
import sun.security.tools.PolicyEntry;
import sun.security.tools.PolicyListListener;
import sun.security.tools.PolicyTool;
import sun.security.tools.ToolDialog;
import sun.security.tools.ToolWindowListener;

class ToolWindow
extends JFrame {
    private static final long serialVersionUID = 5682568601210376777L;
    public static final Insets TOP_PADDING = new Insets(25, 0, 0, 0);
    public static final Insets BOTTOM_PADDING = new Insets(0, 0, 25, 0);
    public static final Insets LITE_BOTTOM_PADDING = new Insets(0, 0, 10, 0);
    public static final Insets LR_PADDING = new Insets(0, 10, 0, 10);
    public static final String NEW_POLICY_FILE = PolicyTool.rb.getString("New");
    public static final String OPEN_POLICY_FILE = PolicyTool.rb.getString("Open");
    public static final String SAVE_POLICY_FILE = PolicyTool.rb.getString("Save");
    public static final String SAVE_AS_POLICY_FILE = PolicyTool.rb.getString("Save As");
    public static final String VIEW_WARNINGS = PolicyTool.rb.getString("View Warning Log");
    public static final String QUIT = PolicyTool.rb.getString("Exit");
    public static final String ADD_POLICY_ENTRY = PolicyTool.rb.getString("Add Policy Entry");
    public static final String EDIT_POLICY_ENTRY = PolicyTool.rb.getString("Edit Policy Entry");
    public static final String REMOVE_POLICY_ENTRY = PolicyTool.rb.getString("Remove Policy Entry");
    public static final String CHANGE_KEYSTORE = PolicyTool.rb.getString("Change KeyStore");
    public static final String ADD_PUBKEY_ALIAS = PolicyTool.rb.getString("Add Public Key Alias");
    public static final String REMOVE_PUBKEY_ALIAS = PolicyTool.rb.getString("Remove Public Key Alias");
    public static final int FILE_MENU_MNEMONIC = ToolWindow.getMnemonic("File Menu Mnemonic");
    public static final int OPEN_MNEMONIC = ToolWindow.getMnemonic("Open Mnemonic");
    public static final int NEW_MNEMONIC = ToolWindow.getMnemonic("New Mnemonic");
    public static final int SAVE_MNEMONIC = ToolWindow.getMnemonic("Save Mnemonic");
    public static final int SAVE_AS_MNEMONIC = ToolWindow.getMnemonic("Save As Mnemonic");
    public static final int VIEW_MNEMONIC = ToolWindow.getMnemonic("View Mnemonic");
    public static final int EXIT_MNEMONIC = ToolWindow.getMnemonic("Exit Mnemonic");
    public static final int EDIT_MENU_MNEMONIC = ToolWindow.getMnemonic("Edit Menu Mnemonic");
    public static final int CHANGE_KEYSTORE_MNEMONIC = ToolWindow.getMnemonic("Change Keystore Mnemonic");
    public static final int ADD_POLICY_ENTRY_MNEMONIC = ToolWindow.getMnemonic("Add Policy Entry Mnemonic");
    public static final int EDIT_POLICY_ENTRY_MNEMONIC = ToolWindow.getMnemonic("Edit Policy Entry Mnemonic");
    public static final int REMOVE_POLICY_ENTRY_MNEMONIC = ToolWindow.getMnemonic("Remove Policy Entry Mnemonic");
    public static final int MW_FILENAME_LABEL = 0;
    public static final int MW_FILENAME_TEXTFIELD = 1;
    public static final int MW_KEYSTORE_LABEL = 2;
    public static final int MW_KEYSTORE_TEXTFIELD = 3;
    public static final int MW_PANEL = 4;
    public static final int MW_ADD_BUTTON = 0;
    public static final int MW_EDIT_BUTTON = 1;
    public static final int MW_REMOVE_BUTTON = 2;
    public static final int MW_POLICY_LIST = 5;
    private PolicyTool tool;

    private static int getMnemonic(String string) {
        return (Integer)PolicyTool.rb.getObject(string);
    }

    ToolWindow(PolicyTool policyTool) {
        this.tool = policyTool;
    }

    private void initWindow() {
        Object object;
        class FontChangeListener
        implements PropertyChangeListener {
            private JFrame frame;

            public FontChangeListener(JFrame jFrame) {
                this.frame = jFrame;
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("UIDefaults")) {
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ FontChangeListener this$1;
                        {
                            this.this$1 = fontChangeListener;
                        }

                        void packOwnedWindows(Window window) {
                            window.pack();
                            Window[] windowArray = window.getOwnedWindows();
                            for (int i = 0; i < windowArray.length; ++i) {
                                this.packOwnedWindows(windowArray[i]);
                            }
                        }

                        public void run() {
                            this.packOwnedWindows(FontChangeListener.access$000(this.this$1));
                        }
                    });
                }
            }

            static /* synthetic */ JFrame access$000(FontChangeListener fontChangeListener) {
                return fontChangeListener.frame;
            }
        }
        UIManager.getDefaults().addPropertyChangeListener(new FontChangeListener(this));
        ((JComponent)this.getContentPane()).setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu(PolicyTool.rb.getString("File"));
        jMenu.setMnemonic(FILE_MENU_MNEMONIC);
        FileMenuListener fileMenuListener = new FileMenuListener(this.tool, this);
        JMenuItem jMenuItem = jMenu.add(NEW_POLICY_FILE);
        jMenuItem.setMnemonic(NEW_MNEMONIC);
        jMenuItem.addActionListener(fileMenuListener);
        jMenuItem = jMenu.add(OPEN_POLICY_FILE);
        jMenuItem.setMnemonic(OPEN_MNEMONIC);
        jMenuItem.addActionListener(fileMenuListener);
        jMenuItem = jMenu.add(SAVE_POLICY_FILE);
        jMenuItem.setMnemonic(SAVE_MNEMONIC);
        jMenuItem.addActionListener(fileMenuListener);
        jMenuItem = jMenu.add(SAVE_AS_POLICY_FILE);
        jMenuItem.setMnemonic(SAVE_AS_MNEMONIC);
        jMenuItem.addActionListener(fileMenuListener);
        jMenuItem = jMenu.add(VIEW_WARNINGS);
        jMenuItem.setMnemonic(VIEW_MNEMONIC);
        jMenuItem.addActionListener(fileMenuListener);
        jMenuItem = jMenu.add(QUIT);
        jMenuItem.setMnemonic(EXIT_MNEMONIC);
        jMenuItem.addActionListener(fileMenuListener);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        jMenu = new JMenu(PolicyTool.rb.getString("Edit"));
        jMenu.setMnemonic(EDIT_MENU_MNEMONIC);
        MainWindowListener mainWindowListener = new MainWindowListener(this.tool, this);
        jMenuItem = jMenu.add(ADD_POLICY_ENTRY);
        jMenuItem.setMnemonic(ADD_POLICY_ENTRY_MNEMONIC);
        jMenuItem.addActionListener(mainWindowListener);
        jMenuItem = jMenu.add(EDIT_POLICY_ENTRY);
        jMenuItem.setMnemonic(EDIT_POLICY_ENTRY_MNEMONIC);
        jMenuItem.addActionListener(mainWindowListener);
        jMenuItem = jMenu.add(REMOVE_POLICY_ENTRY);
        jMenuItem.setMnemonic(REMOVE_POLICY_ENTRY_MNEMONIC);
        jMenuItem.addActionListener(mainWindowListener);
        jMenuItem = jMenu.add(CHANGE_KEYSTORE);
        jMenuItem.setMnemonic(CHANGE_KEYSTORE_MNEMONIC);
        jMenuItem.addActionListener(mainWindowListener);
        jMenuBar.add(jMenu);
        this.setJMenuBar(jMenuBar);
        JLabel jLabel = new JLabel(PolicyTool.rb.getString("Policy File:"));
        this.addNewComponent(this.getContentPane(), jLabel, 0, 0, 0, 1, 1, 0.0, 0.0, 1, TOP_PADDING);
        FocusTextField focusTextField = new FocusTextField(40);
        focusTextField.setEditable(false);
        this.addNewComponent(this.getContentPane(), focusTextField, 1, 1, 0, 1, 1, 0.0, 0.0, 1, TOP_PADDING);
        jLabel.setLabelFor(focusTextField);
        jLabel = new JLabel(PolicyTool.rb.getString("Keystore:"));
        this.addNewComponent(this.getContentPane(), jLabel, 2, 0, 1, 1, 1, 0.0, 0.0, 1, BOTTOM_PADDING);
        focusTextField = new FocusTextField(40);
        focusTextField.setEditable(false);
        this.addNewComponent(this.getContentPane(), focusTextField, 3, 1, 1, 1, 1, 0.0, 0.0, 1, BOTTOM_PADDING);
        jLabel.setLabelFor(focusTextField);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        final JButton jButton = new JButton(ADD_POLICY_ENTRY);
        jButton.setMnemonic(ADD_POLICY_ENTRY_MNEMONIC);
        jButton.addActionListener(new MainWindowListener(this.tool, this));
        this.addNewComponent(jPanel, jButton, 0, 0, 0, 1, 1, 0.5, 0.0, 1, LR_PADDING);
        jButton.getAccessibleContext().setAccessibleDescription("To read the Policy File and Keystore text fields use shift tab to tab backwards to them.");
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                jButton.requestFocusInWindow();
            }
        });
        JButton jButton2 = new JButton(EDIT_POLICY_ENTRY);
        jButton2.setMnemonic(EDIT_POLICY_ENTRY_MNEMONIC);
        jButton2.addActionListener(new MainWindowListener(this.tool, this));
        jButton2.getAccessibleContext().setAccessibleDescription("To edit the Policy entry and Keystore text fields use shift tab to tab backwards to them.");
        this.addNewComponent(jPanel, jButton2, 1, 1, 0, 1, 1, 0.5, 0.0, 1, LR_PADDING);
        jButton2 = new JButton(REMOVE_POLICY_ENTRY);
        jButton2.setMnemonic(REMOVE_POLICY_ENTRY_MNEMONIC);
        jButton2.addActionListener(new MainWindowListener(this.tool, this));
        jButton2.getAccessibleContext().setAccessibleDescription("To remove the Policy entry and Keystore text fields use shift tab to tab backwards to them.");
        this.addNewComponent(jPanel, jButton2, 2, 2, 0, 1, 1, 0.5, 0.0, 1, LR_PADDING);
        this.addNewComponent(this.getContentPane(), jPanel, 4, 0, 2, 2, 1, 0.0, 0.0, 1, BOTTOM_PADDING);
        String string = this.tool.getPolicyFileName();
        if (string == null) {
            object = AccessController.doPrivileged(new GetPropertyAction("user.home"));
            string = (String)object + File.separatorChar + ".java.policy";
        }
        try {
            this.tool.openPolicy(this, string);
            object = new LegacyList();
            ((LegacyList)object).addActionListener(new PolicyListListener(this.tool, this));
            PolicyEntry[] policyEntryArray = this.tool.getEntry();
            if (policyEntryArray != null) {
                for (int i = 0; i < policyEntryArray.length; ++i) {
                    ((LegacyList)object).add(policyEntryArray[i].headerToString());
                }
            }
            FocusTextField focusTextField2 = (FocusTextField)this.getContentPane().getComponent(1);
            focusTextField2.setText(string);
            FocusTextField focusTextField3 = (FocusTextField)this.getContentPane().getComponent(3);
            if (this.tool.getKeyStoreType() != null && this.tool.getKeyStoreType().length() > 0) {
                focusTextField3.setText(this.tool.getKeyStoreName() + ", " + this.tool.getKeyStoreType());
            } else {
                focusTextField3.setText(this.tool.getKeyStoreName());
            }
            this.initPolicyList((LegacyList)object);
        }
        catch (PolicyParser.ParsingException parsingException) {
            LegacyList legacyList = new LegacyList();
            this.initPolicyList(legacyList);
            this.pack();
            this.setVisible(true);
            MessageFormat messageFormat = new MessageFormat(PolicyTool.rb.getString("Error parsing policy file policyFile. View Warning Log for details."));
            Object[] objectArray = new Object[]{string};
            this.displayErrorDialog(this, messageFormat.format(objectArray));
            messageFormat = new MessageFormat(PolicyTool.rb.getString("Error: Could not open policy file, filename, because of parsing error: pppe.getMessage()"));
            Object[] objectArray2 = new Object[]{string, parsingException.getMessage()};
            this.tool.warnings.addElement(messageFormat.format(objectArray2));
            System.exit(1);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LegacyList legacyList = new LegacyList();
            legacyList.addActionListener(new PolicyListListener(this.tool, this));
            this.initPolicyList(legacyList);
            this.tool.modified = false;
            this.pack();
            this.setVisible(true);
            this.displayErrorDialog(this, PolicyTool.rb.getString("Could not find Policy File: ") + string);
        }
        catch (Exception exception) {
            LegacyList legacyList = new LegacyList();
            legacyList.addActionListener(new PolicyListListener(this.tool, this));
            this.initPolicyList(legacyList);
            this.tool.modified = false;
        }
    }

    void addNewComponent(Container container, Component component, int n, int n2, int n3, int n4, int n5, double d, double d2, int n6, Insets insets) {
        container.add(component, n);
        GridBagLayout gridBagLayout = (GridBagLayout)container.getLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n3;
        gridBagConstraints.gridwidth = n4;
        gridBagConstraints.gridheight = n5;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagConstraints.fill = n6;
        if (insets != null) {
            gridBagConstraints.insets = insets;
        }
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    void addNewComponent(Container container, Component component, int n, int n2, int n3, int n4, int n5, double d, double d2, int n6) {
        this.addNewComponent(container, component, n, n2, n3, n4, n5, d, d2, n6, null);
    }

    void initPolicyList(LegacyList legacyList) {
        this.addNewComponent(this.getContentPane(), legacyList, 5, 0, 3, 2, 1, 1.0, 1.0, 1);
        legacyList.getViewport().getView().getAccessibleContext().setAccessibleName("Policy list");
    }

    void replacePolicyList(LegacyList legacyList) {
        LegacyList legacyList2 = (LegacyList)this.getContentPane().getComponent(5);
        legacyList2.removeAll();
        String[] stringArray = legacyList.getItems();
        for (int i = 0; i < stringArray.length; ++i) {
            legacyList2.add(stringArray[i]);
        }
    }

    void displayToolWindow() {
        this.setTitle(PolicyTool.rb.getString("Policy Tool"));
        this.setDefaultCloseOperation(0);
        this.setResizable(true);
        this.addWindowListener(new ToolWindowListener(this.tool, this));
        this.setLocation(135, 80);
        this.getContentPane().setLayout(new GridBagLayout());
        this.initWindow();
        this.pack();
        this.setVisible(true);
        if (this.tool.newWarning) {
            this.displayStatusDialog(this, PolicyTool.rb.getString("Errors have occurred while opening the policy configuration.  View the Warning Log for more information."));
        }
    }

    void displayErrorDialog(Component component, String string) {
        this.displayDialog("Error", component, string);
    }

    void displayWarningDialog(Component component, String string) {
        this.displayDialog("Warning", component, string);
    }

    void displayStatusDialog(Component component, String string) {
        this.displayDialog("Status", component, string);
    }

    private void displayDialog(String string, Component component, String string2) {
        ToolDialog toolDialog = component instanceof JFrame ? new ToolDialog(PolicyTool.rb.getString(string), this.tool, this, (JFrame)component, true) : new ToolDialog(PolicyTool.rb.getString(string), this.tool, this, (JDialog)component, true);
        Point point = component == null ? this.getLocationOnScreen() : component.getLocationOnScreen();
        toolDialog.setLocation(point.x + 50, point.y + 50);
        toolDialog.getContentPane().setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel(string2);
        this.addNewComponent(toolDialog.getContentPane(), jLabel, 0, 0, 0, 1, 1, 0.0, 0.0, 1, LR_PADDING);
        JButton jButton = new JButton(PolicyTool.rb.getString("OK"));
        jButton.setMnemonic((Integer)PolicyTool.rb.getObject("OK Mnemonic"));
        jButton.addActionListener(new OKButtonListener(toolDialog));
        this.addNewComponent(toolDialog.getContentPane(), jButton, 1, 0, 1, 1, 1, 0.0, 0.0, 3, TOP_PADDING);
        jButton.getAccessibleContext().setAccessibleName(jLabel.getText() + ". " + jButton.getText());
        toolDialog.getRootPane().setDefaultButton(jButton);
        toolDialog.pack();
        toolDialog.setVisible(true);
    }

    void displayWarningLog(Component component) {
        ToolDialog toolDialog = component instanceof JFrame ? new ToolDialog(PolicyTool.rb.getString("Warning"), this.tool, this, (JFrame)component, true) : new ToolDialog(PolicyTool.rb.getString("Warning"), this.tool, this, (JDialog)component, true);
        Point point = component == null ? this.getLocationOnScreen() : component.getLocationOnScreen();
        toolDialog.setLocation(point.x + 50, point.y + 50);
        toolDialog.getContentPane().setLayout(new GridBagLayout());
        JTextArea jTextArea = new JTextArea();
        jTextArea.setEditable(false);
        for (int i = 0; i < this.tool.warnings.size(); ++i) {
            jTextArea.append((String)this.tool.warnings.elementAt(i));
            jTextArea.append(PolicyTool.rb.getString("\n"));
        }
        jTextArea.setCaretPosition(0);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.getViewport().setPreferredSize(new Dimension(450, 200));
        this.addNewComponent(toolDialog.getContentPane(), jScrollPane, 0, 0, 0, 1, 1, 1.0, 1.0, 1, BOTTOM_PADDING);
        jTextArea.getAccessibleContext().setAccessibleName("Warning log text area");
        jTextArea.getAccessibleContext().setAccessibleDescription("Use the up and down arrows to read the warning log. Use Ctrl tab to exit the text area and get to the OK button");
        final JButton jButton = new JButton(PolicyTool.rb.getString("OK"));
        jButton.setMnemonic((Integer)PolicyTool.rb.getObject("OK Mnemonic"));
        jButton.addActionListener(new CancelButtonListener(toolDialog));
        this.addNewComponent(toolDialog.getContentPane(), jButton, 1, 0, 1, 1, 1, 0.0, 0.0, 3, LR_PADDING);
        jButton.getAccessibleContext().setAccessibleDescription("To read the warning log tab to text area. Use Ctrl tab to exit the text area and return to this OK button");
        toolDialog.getRootPane().setDefaultButton(jButton);
        toolDialog.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                jButton.requestFocusInWindow();
            }
        });
        toolDialog.pack();
        toolDialog.setVisible(true);
    }
}

