/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import com.ibm.jvm.io.LocalizedInputStream;
import com.ibm.security.auth.PrincipalComparator;
import com.ibm.security.util.PropertyExpander;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.SocketPermission;
import java.net.URI;
import java.net.URL;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Identity;
import java.security.IdentityScope;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.security.UnresolvedPermission;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.PropertyPermission;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.Subject;
import sun.net.www.ParseUtil;
import sun.security.provider.IdentityDatabase;
import sun.security.provider.PolicyInfo;
import sun.security.provider.PolicyParser;
import sun.security.provider.SelfPermission;
import sun.security.provider.SystemIdentity;
import sun.security.provider.SystemSigner;
import sun.security.util.Debug;
import sun.security.util.ResourcesMgr;

public class PolicyFile
extends Policy {
    private static final Debug debug = Debug.getInstance("policy");
    private static int instanceCount = 0;
    private static final String SELF = "${{self}}";
    private static final String X500PRINCIPAL = "javax.security.auth.x500.X500Principal";
    private static final String POLICY = "java.security.policy";
    private static final String SECURITY_MANAGER = "java.security.manager";
    private static final String POLICY_URL = "policy.url.";
    private static final String AUTH_POLICY = "java.security.auth.policy";
    private static final String AUTH_POLICY_URL = "auth.policy.url.";
    private static IdentityScope scope = null;
    private PolicyInfo policyInfo;
    private boolean constructed = false;
    private boolean expandProperties = true;
    private boolean ignoreIdentityScope = false;
    private static final Class[] PARAMS0 = new Class[0];
    private static final Class[] PARAMS1 = new Class[]{String.class};
    private static final Class[] PARAMS2 = new Class[]{String.class, String.class};

    public PolicyFile() {
        this.init();
    }

    private void init() {
        PolicyInfo policyInfo = new PolicyInfo();
        ++instanceCount;
        this.initPolicyFile(policyInfo);
        --instanceCount;
        this.policyInfo = policyInfo;
    }

    private void initPolicyFile(PolicyInfo policyInfo) {
        boolean bl = false;
        if (!(bl |= this.initPolicyFile(POLICY, POLICY_URL, policyInfo))) {
            this.initStaticPolicy(policyInfo);
        }
        bl |= this.initPolicyFile(AUTH_POLICY, AUTH_POLICY_URL, policyInfo);
    }

    private boolean initPolicyFile(final String string, final String string2, final PolicyInfo policyInfo) {
        Boolean bl = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string3;
                URL uRL;
                Object object;
                String string22;
                boolean bl = false;
                PolicyFile.this.expandProperties = "true".equalsIgnoreCase(Security.getProperty("policy.expandProperties"));
                PolicyFile.this.ignoreIdentityScope = "true".equalsIgnoreCase(Security.getProperty("policy.ignoreIdentityScope"));
                if ("true".equalsIgnoreCase(Security.getProperty("policy.allowSystemProperty")) && (string22 = System.getProperty(string)) != null) {
                    boolean bl2;
                    block15: {
                        bl2 = false;
                        if (string22.startsWith("=")) {
                            bl2 = true;
                            string22 = string22.substring(1);
                        }
                        try {
                            string22 = PropertyExpander.expand(string22);
                            object = new File(string22);
                            uRL = ((File)object).exists() ? ParseUtil.fileToEncodedURL(new File(((File)object).getCanonicalPath())) : new URL(string22);
                            if (debug != null) {
                                debug.println("reading " + uRL);
                            }
                            if (PolicyFile.this.init(uRL, policyInfo)) {
                                bl = true;
                            }
                        }
                        catch (Exception exception) {
                            if (debug == null) break block15;
                            debug.println("caught exception: " + exception);
                        }
                    }
                    if (bl2) {
                        if (debug != null) {
                            debug.println("overriding other policies!");
                        }
                        return bl;
                    }
                }
                int n = 1;
                while ((string3 = Security.getProperty(string2 + n)) != null) {
                    block16: {
                        try {
                            uRL = null;
                            if (string3.startsWith("file:${java.home}/") || string3.startsWith("file:${user.home}/")) {
                                object = PropertyExpander.expand(string3).replace(File.separatorChar, '/');
                                uRL = new File(((String)object).substring(5)).toURI().toURL();
                            } else {
                                object = PropertyExpander.expand(string3, true).replace(File.separatorChar, '/');
                                uRL = new URI((String)object).toURL();
                            }
                            if (debug != null) {
                                debug.println("reading " + uRL);
                            }
                            if (PolicyFile.this.init(uRL, policyInfo)) {
                                bl = true;
                            }
                        }
                        catch (Exception exception) {
                            if (debug == null) break block16;
                            debug.println("error reading policy " + exception);
                            exception.printStackTrace();
                        }
                    }
                    ++n;
                }
                return bl;
            }
        });
        return bl;
    }

    private boolean init(URL uRL, PolicyInfo policyInfo) {
        boolean bl;
        block6: {
            bl = false;
            PolicyParser policyParser = new PolicyParser(this.expandProperties);
            try {
                InputStream inputStream = this.getInputStream(uRL);
                if (inputStream == null) {
                    return false;
                }
                InputStream inputStream2 = LocalizedInputStream.localize((InputStream)inputStream);
                LocalizedInputStream.dontUnwrap((InputStream)inputStream2);
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream2, "UTF-8");
                policyParser.read(inputStreamReader);
                inputStreamReader.close();
                KeyStore keyStore = this.initKeyStore(uRL, policyParser.getKeyStoreUrl(), policyParser.getKeyStoreType());
                Enumeration enumeration = policyParser.grantElements();
                while (enumeration.hasMoreElements()) {
                    PolicyParser.GrantEntry grantEntry = (PolicyParser.GrantEntry)enumeration.nextElement();
                    this.addGrantEntry(grantEntry, keyStore, policyInfo);
                }
                bl = true;
            }
            catch (PolicyParser.ParsingException parsingException) {
                MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("java.security.policy: error parsing policy:\n\tmessage"));
                Object[] objectArray = new Object[]{uRL, parsingException.getLocalizedMessage()};
                System.err.println(messageFormat.format(objectArray));
                if (debug != null) {
                    parsingException.printStackTrace();
                }
            }
            catch (Exception exception) {
                if (debug == null) break block6;
                debug.println("error parsing " + uRL);
                debug.println(exception.toString());
                exception.printStackTrace();
            }
        }
        return bl;
    }

    private void initStaticPolicy(final PolicyInfo policyInfo) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                PolicyEntry policyEntry = new PolicyEntry(new CodeSource(null, null));
                policyEntry.add(new SocketPermission("localhost:1024-", "listen"));
                policyEntry.add(new PropertyPermission("java.version", "read"));
                policyEntry.add(new PropertyPermission("java.vendor", "read"));
                policyEntry.add(new PropertyPermission("java.vendor.url", "read"));
                policyEntry.add(new PropertyPermission("java.class.version", "read"));
                policyEntry.add(new PropertyPermission("os.name", "read"));
                policyEntry.add(new PropertyPermission("os.version", "read"));
                policyEntry.add(new PropertyPermission("os.arch", "read"));
                policyEntry.add(new PropertyPermission("file.separator", "read"));
                policyEntry.add(new PropertyPermission("path.separator", "read"));
                policyEntry.add(new PropertyPermission("line.separator", "read"));
                policyEntry.add(new PropertyPermission("java.specification.version", "read"));
                policyEntry.add(new PropertyPermission("java.specification.vendor", "read"));
                policyEntry.add(new PropertyPermission("java.specification.name", "read"));
                policyEntry.add(new PropertyPermission("java.vm.specification.version", "read"));
                policyEntry.add(new PropertyPermission("java.vm.specification.vendor", "read"));
                policyEntry.add(new PropertyPermission("java.vm.specification.name", "read"));
                policyEntry.add(new PropertyPermission("java.vm.version", "read"));
                policyEntry.add(new PropertyPermission("java.vm.vendor", "read"));
                policyEntry.add(new PropertyPermission("java.vm.name", "read"));
                policyInfo.policyEntries.addElement(policyEntry);
                try {
                    File file = new File(PropertyExpander.expand("${java.home}/lib/ext/*"));
                    policyEntry = new PolicyEntry(new CodeSource(ParseUtil.fileToEncodedURL(file), null));
                    policyEntry.add(new AllPermission());
                    policyInfo.policyEntries.addElement(policyEntry);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    private KeyStore initKeyStore(URL uRL, String string, String string2) {
        if (string != null && instanceCount < 2) {
            try {
                InputStream inputStream;
                URL uRL2 = null;
                try {
                    uRL2 = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    uRL2 = new URL(uRL, string);
                }
                if (debug != null) {
                    debug.println("reading keystore " + uRL2);
                }
                if ((inputStream = this.getInputStream(uRL2)) == null) {
                    return null;
                }
                if (string2 == null) {
                    string2 = KeyStore.getDefaultType();
                }
                KeyStore keyStore = KeyStore.getInstance(string2);
                keyStore.load(inputStream, null);
                inputStream.close();
                return keyStore;
            }
            catch (Exception exception) {
                if (debug != null) {
                    exception.printStackTrace();
                }
                return null;
            }
        }
        return null;
    }

    private InputStream getInputStream(URL uRL) throws IOException {
        if (uRL.getProtocol().equals("file")) {
            String string = uRL.getFile().replace('/', File.separatorChar);
            File file = new File(string = ParseUtil.decode(string));
            if (file.canRead()) {
                return new FileInputStream(file);
            }
            if (debug != null) {
                debug.println("unable to read " + uRL);
                debug.println();
            }
            return null;
        }
        return uRL.openStream();
    }

    CodeSource getCodeSource(PolicyParser.GrantEntry grantEntry, KeyStore keyStore, PolicyInfo policyInfo) throws MalformedURLException {
        Certificate[] certificateArray = null;
        if (grantEntry.signedBy != null && instanceCount < 2 && (certificateArray = this.getCertificates(keyStore, grantEntry.signedBy, policyInfo)) == null) {
            if (debug != null) {
                debug.println("  -- No certs for alias '" + grantEntry.signedBy + "' - ignoring entry");
            }
            return null;
        }
        URL uRL = grantEntry.codeBase != null ? new URL(grantEntry.codeBase) : null;
        return this.canonicalizeCodebase(new CodeSource(uRL, certificateArray), false);
    }

    private void addGrantEntry(PolicyParser.GrantEntry grantEntry, KeyStore keyStore, PolicyInfo policyInfo) {
        Object object;
        Object object2;
        if (debug != null) {
            debug.println("Adding policy entry: ");
            debug.println("  signedBy " + grantEntry.signedBy);
            debug.println("  codeBase " + grantEntry.codeBase);
            if (grantEntry.principals != null && grantEntry.principals.size() > 0) {
                object2 = grantEntry.principals.listIterator();
                while (object2.hasNext()) {
                    object = (PolicyParser.PrincipalEntry)object2.next();
                    debug.println("  " + ((PolicyParser.PrincipalEntry)object).toString());
                }
            }
        }
        try {
            object2 = this.getCodeSource(grantEntry, keyStore, policyInfo);
            if (object2 == null) {
                return;
            }
            if (!this.replacePrincipals(grantEntry.principals, keyStore)) {
                return;
            }
            object = new PolicyEntry((CodeSource)object2, grantEntry.principals);
            Enumeration enumeration = grantEntry.permissionElements();
            while (enumeration.hasMoreElements()) {
                Object[] objectArray;
                Object object3;
                PolicyParser.PermissionEntry permissionEntry = (PolicyParser.PermissionEntry)enumeration.nextElement();
                try {
                    Permission permission;
                    this.expandPermissionName(permissionEntry, keyStore);
                    if (permissionEntry.permission.equals("javax.security.auth.PrivateCredentialPermission") && permissionEntry.name.endsWith(" self")) {
                        permissionEntry.name = permissionEntry.name.substring(0, permissionEntry.name.indexOf("self")) + SELF;
                    }
                    if (permissionEntry.name != null && permissionEntry.name.indexOf(SELF) != -1) {
                        object3 = permissionEntry.signedBy != null ? this.getCertificates(keyStore, permissionEntry.signedBy, policyInfo) : null;
                        permission = new SelfPermission(permissionEntry.permission, permissionEntry.name, permissionEntry.action, (Certificate[])object3);
                    } else {
                        permission = PolicyFile.getInstance(permissionEntry.permission, permissionEntry.name, permissionEntry.action);
                    }
                    ((PolicyEntry)object).add(permission);
                    if (debug == null) continue;
                    debug.println("  " + permission);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    object3 = permissionEntry.signedBy != null ? this.getCertificates(keyStore, permissionEntry.signedBy, policyInfo) : null;
                    if (object3 == null && permissionEntry.signedBy != null) continue;
                    objectArray = new UnresolvedPermission(permissionEntry.permission, permissionEntry.name, permissionEntry.action, (Certificate[])object3);
                    ((PolicyEntry)object).add((Permission)objectArray);
                    if (debug == null) continue;
                    debug.println("  " + objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    object3 = new MessageFormat(ResourcesMgr.getString("java.security.policy: error adding Permission, perm:\n\tmessage"));
                    objectArray = new Object[]{permissionEntry.permission, invocationTargetException.getTargetException().toString()};
                    System.err.println(object3.format(objectArray));
                }
                catch (Exception exception) {
                    object3 = new MessageFormat(ResourcesMgr.getString("java.security.policy: error adding Permission, perm:\n\tmessage"));
                    objectArray = new Object[]{permissionEntry.permission, exception.toString()};
                    System.err.println(object3.format(objectArray));
                }
            }
            policyInfo.policyEntries.addElement(object);
        }
        catch (Exception exception) {
            object = new MessageFormat(ResourcesMgr.getString("java.security.policy: error adding Entry:\n\tmessage"));
            Object[] objectArray = new Object[]{exception.toString()};
            System.err.println(((Format)object).format(objectArray));
        }
        if (debug != null) {
            debug.println();
        }
    }

    private static final Permission getInstance(String string, String string2, String string3) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Class<?> clazz = Class.forName(string);
        if (string2 == null && string3 == null) {
            try {
                Constructor<?> constructor = clazz.getConstructor(PARAMS0);
                return (Permission)constructor.newInstance(new Object[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                try {
                    Constructor<?> constructor = clazz.getConstructor(PARAMS1);
                    return (Permission)constructor.newInstance(string2);
                }
                catch (NoSuchMethodException noSuchMethodException2) {
                    Constructor<?> constructor = clazz.getConstructor(PARAMS2);
                    return (Permission)constructor.newInstance(string2, string3);
                }
            }
        }
        if (string2 != null && string3 == null) {
            try {
                Constructor<?> constructor = clazz.getConstructor(PARAMS1);
                return (Permission)constructor.newInstance(string2);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                Constructor<?> constructor = clazz.getConstructor(PARAMS2);
                return (Permission)constructor.newInstance(string2, string3);
            }
        }
        Constructor<?> constructor = clazz.getConstructor(PARAMS2);
        return (Permission)constructor.newInstance(string2, string3);
    }

    Certificate[] getCertificates(KeyStore keyStore, String string, PolicyInfo policyInfo) {
        Object[] objectArray;
        Vector<Certificate> vector = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            objectArray = stringTokenizer.nextToken().trim();
            ++n;
            Certificate certificate = null;
            certificate = (Certificate)policyInfo.aliasMapping.get(objectArray);
            if (certificate == null && keyStore != null) {
                try {
                    certificate = keyStore.getCertificate((String)objectArray);
                }
                catch (KeyStoreException keyStoreException) {
                    // empty catch block
                }
                if (certificate != null) {
                    policyInfo.aliasMapping.put(objectArray, certificate);
                    policyInfo.aliasMapping.put(certificate, objectArray);
                }
            }
            if (certificate == null) continue;
            if (vector == null) {
                vector = new Vector<Certificate>();
            }
            vector.addElement(certificate);
        }
        if (vector != null && n == vector.size()) {
            objectArray = new Certificate[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        return null;
    }

    public void refresh() {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean implies(ProtectionDomain protectionDomain, Permission permission) {
        PermissionCollection permissionCollection;
        PolicyInfo policyInfo;
        PolicyInfo policyInfo2 = policyInfo = this.policyInfo;
        synchronized (policyInfo2) {
            permissionCollection = (PermissionCollection)policyInfo.pdMapping.get(protectionDomain);
        }
        if (permissionCollection != null) {
            return permissionCollection.implies(permission);
        }
        permissionCollection = this.getPermissions(protectionDomain);
        if (permissionCollection == null) {
            return false;
        }
        policyInfo2 = policyInfo;
        synchronized (policyInfo2) {
            policyInfo.pdMapping.put(protectionDomain, permissionCollection);
        }
        return permissionCollection.implies(permission);
    }

    public PermissionCollection getPermissions(ProtectionDomain protectionDomain) {
        Permissions permissions = new Permissions();
        if (protectionDomain == null) {
            return permissions;
        }
        this.getPermissions(permissions, protectionDomain);
        PermissionCollection permissionCollection = protectionDomain.getPermissions();
        if (permissionCollection != null) {
            Enumeration<Permission> enumeration = permissionCollection.elements();
            while (enumeration.hasMoreElements()) {
                permissions.add(enumeration.nextElement());
            }
        }
        return permissions;
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        return this.getPermissions(new Permissions(), codeSource);
    }

    private PermissionCollection getPermissions(Permissions permissions, ProtectionDomain protectionDomain) {
        CodeSource codeSource;
        if (debug != null) {
            debug.println("getPermissions:\n\t" + this.printPD(protectionDomain));
        }
        if ((codeSource = protectionDomain.getCodeSource()) == null) {
            return permissions;
        }
        CodeSource codeSource2 = (CodeSource)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return PolicyFile.this.canonicalizeCodebase(codeSource, true);
            }
        });
        return this.getPermissions(permissions, codeSource2, protectionDomain.getPrincipals());
    }

    private PermissionCollection getPermissions(Permissions permissions, final CodeSource codeSource) {
        CodeSource codeSource2 = (CodeSource)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return PolicyFile.this.canonicalizeCodebase(codeSource, true);
            }
        });
        return this.getPermissions(permissions, codeSource2, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Permissions getPermissions(Permissions permissions, CodeSource codeSource, Principal[] principalArray) {
        Certificate[] certificateArray;
        Object object;
        Object object2;
        int n;
        PolicyInfo policyInfo;
        boolean bl = false;
        Object var5_5 = null;
        PolicyInfo policyInfo2 = policyInfo = this.policyInfo;
        synchronized (policyInfo2) {
            n = policyInfo.policyEntries.size();
        }
        for (int i = 0; i < n; ++i) {
            Object object3;
            Boolean bl2;
            PolicyEntry policyEntry;
            bl = false;
            object2 = policyInfo;
            synchronized (object2) {
                policyEntry = (PolicyEntry)policyInfo.policyEntries.elementAt(i);
            }
            if (debug != null) {
                debug.println("evaluate codesources:\n\tPolicy CodeSource: " + policyEntry.codesource + "\n" + "\tActive CodeSource: " + codeSource);
            }
            if (!(bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedAction((PolicyEntry)(object = policyEntry), (CodeSource)(object2 = codeSource)){
                private final /* synthetic */ PolicyEntry val$entryCopy;
                private final /* synthetic */ CodeSource val$csCopy;
                {
                    this.val$entryCopy = policyEntry;
                    this.val$csCopy = codeSource;
                }

                public Object run() {
                    return new Boolean(this.val$entryCopy.codesource.implies(this.val$csCopy));
                }
            })).booleanValue()) {
                if (debug == null) continue;
                debug.println("evaluation (codesource) failed");
                continue;
            }
            final Principal[] principalArray2 = principalArray;
            LinkedList linkedList = policyEntry.getPrincipals();
            LinkedList<Object> linkedList2 = new LinkedList<Object>();
            if (principalArray2 != null && principalArray2.length != 0) {
                object3 = null;
                for (int j = 0; j < principalArray2.length; ++j) {
                    object3 = new PolicyParser.PrincipalEntry(principalArray2[j].getClass().getName(), principalArray2[j].getName());
                    linkedList2.add(object3);
                }
            }
            if (debug != null) {
                debug.println("evaluate principals:\n\tPolicy Principals: " + linkedList + "\n" + "\tActive Principals: " + linkedList2);
            }
            if (linkedList.size() == 0) {
                bl = true;
            }
            if (linkedList.size() != 0 && linkedList2.size() != 0) {
                object3 = linkedList.listIterator(0);
                while (object3.hasNext()) {
                    PolicyParser.PrincipalEntry principalEntry = (PolicyParser.PrincipalEntry)object3.next();
                    try {
                        Class<?> clazz = Class.forName(principalEntry.principalClass, true, Thread.currentThread().getContextClassLoader());
                        Constructor<?> constructor = clazz.getConstructor(PARAMS1);
                        PrincipalComparator principalComparator = (PrincipalComparator)constructor.newInstance(principalEntry.principalName);
                        if (debug != null) {
                            debug.println("found PrincipalComparator " + principalComparator.getClass().getName());
                        }
                        final Subject subject = new Subject();
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                Set set = subject.getPrincipals();
                                for (int i = 0; i < principalArray2.length; ++i) {
                                    set.add(principalArray2[i]);
                                }
                                return null;
                            }
                        });
                        bl = principalComparator.implies(subject);
                        if (bl) continue;
                    }
                    catch (Exception exception) {
                        if (debug != null) {
                            debug.println("Exception while attempting to construct PrincipalComparator");
                            exception.printStackTrace();
                        }
                        if (bl = this.subjectListImpliesPrincipalEntry(linkedList2, principalEntry)) continue;
                    }
                    break;
                }
            }
            if (!bl) {
                if (debug == null) continue;
                debug.println("evaluation failed");
                continue;
            }
            if (debug != null) {
                debug.println("evaluation (codesource/principals) passed");
            }
            for (int j = 0; j < policyEntry.permissions.size(); ++j) {
                Permission permission = (Permission)policyEntry.permissions.elementAt(j);
                if (debug != null) {
                    debug.println("  granting " + permission);
                }
                if (permission instanceof SelfPermission) {
                    this.expandSelf((SelfPermission)permission, linkedList, principalArray2, permissions);
                    continue;
                }
                permissions.add(permission);
            }
        }
        if (!this.ignoreIdentityScope && (certificateArray = codeSource.getCertificates()) != null) {
            for (int i = 0; i < certificateArray.length; ++i) {
                object = policyInfo;
                synchronized (object) {
                    object2 = policyInfo.aliasMapping.get(certificateArray[i]);
                }
                if (object2 != null || !this.checkForTrustedIdentity(certificateArray[i], policyInfo)) continue;
                permissions.add(new AllPermission());
            }
        }
        return permissions;
    }

    private boolean subjectListImpliesPrincipalEntry(LinkedList linkedList, PolicyParser.PrincipalEntry principalEntry) {
        ListIterator listIterator = linkedList.listIterator(0);
        while (listIterator.hasNext()) {
            PolicyParser.PrincipalEntry principalEntry2 = (PolicyParser.PrincipalEntry)listIterator.next();
            if (!principalEntry.principalClass.equals("WILDCARD_PRINCIPAL_CLASS") && !principalEntry.principalClass.equals(principalEntry2.principalClass) || !principalEntry.principalName.equals("WILDCARD_PRINCIPAL_NAME") && !principalEntry.principalName.equals(principalEntry2.principalName)) continue;
            return true;
        }
        return false;
    }

    private void expandSelf(SelfPermission selfPermission, LinkedList linkedList, Principal[] principalArray, Permissions permissions) {
        block18: {
            Object object;
            Object object2;
            int n;
            if (linkedList == null || linkedList.size() == 0) {
                if (debug != null) {
                    debug.println("Ignoring permission " + selfPermission.getSelfType() + " with target name (" + selfPermission.getSelfName() + ").  " + "No Principal(s) specified " + "in the grant clause.  " + "SELF-based target names are " + "only valid in the context " + "of a Principal-based grant entry.");
                }
                return;
            }
            int n2 = 0;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = selfPermission.getSelfName().indexOf(SELF, n2)) != -1) {
                stringBuffer.append(selfPermission.getSelfName().substring(n2, n));
                ListIterator listIterator = linkedList.listIterator();
                while (listIterator.hasNext()) {
                    object2 = (PolicyParser.PrincipalEntry)listIterator.next();
                    object = this.getPrincipalInfo((PolicyParser.PrincipalEntry)object2, principalArray);
                    for (int i = 0; i < ((String[][])object).length; ++i) {
                        if (i != 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(object[i][0] + " " + "\"" + object[i][1] + "\"");
                    }
                    if (!listIterator.hasNext()) continue;
                    stringBuffer.append(", ");
                }
                n2 = n + SELF.length();
            }
            stringBuffer.append(selfPermission.getSelfName().substring(n2));
            if (debug != null) {
                debug.println("  expanded:\n\t" + selfPermission.getSelfName() + "\n  into:\n\t" + stringBuffer.toString());
            }
            try {
                permissions.add(PolicyFile.getInstance(selfPermission.getSelfType(), stringBuffer.toString(), selfPermission.getSelfActions()));
            }
            catch (ClassNotFoundException classNotFoundException) {
                object2 = permissions.elements();
                object = null;
                while (object2.hasMoreElements()) {
                    Permission permission = (Permission)object2.nextElement();
                    if (!permission.getClass().getName().equals(selfPermission.getSelfType())) continue;
                    object = permission.getClass();
                    break;
                }
                if (object == null) {
                    permissions.add(new UnresolvedPermission(selfPermission.getSelfType(), stringBuffer.toString(), selfPermission.getSelfActions(), selfPermission.getCerts()));
                }
                try {
                    if (selfPermission.getSelfActions() == null) {
                        try {
                            Constructor constructor = object.getConstructor(PARAMS1);
                            permissions.add((Permission)constructor.newInstance(stringBuffer.toString()));
                        }
                        catch (NoSuchMethodException noSuchMethodException) {
                            Constructor constructor = object.getConstructor(PARAMS2);
                            permissions.add((Permission)constructor.newInstance(stringBuffer.toString(), selfPermission.getSelfActions()));
                        }
                    }
                    Constructor constructor = object.getConstructor(PARAMS2);
                    permissions.add((Permission)constructor.newInstance(stringBuffer.toString(), selfPermission.getSelfActions()));
                }
                catch (Exception exception) {
                    if (debug != null) {
                        debug.println("self entry expansion  instantiation failed: " + exception.toString());
                    }
                }
            }
            catch (Exception exception) {
                if (debug == null) break block18;
                debug.println(exception.toString());
            }
        }
    }

    private String[][] getPrincipalInfo(PolicyParser.PrincipalEntry principalEntry, Principal[] principalArray) {
        if (!principalEntry.principalClass.equals("WILDCARD_PRINCIPAL_CLASS") && !principalEntry.principalName.equals("WILDCARD_PRINCIPAL_NAME")) {
            String[][] stringArray = new String[1][2];
            stringArray[0][0] = principalEntry.principalClass;
            stringArray[0][1] = principalEntry.principalName;
            return stringArray;
        }
        if (!principalEntry.principalClass.equals("WILDCARD_PRINCIPAL_CLASS") && principalEntry.principalName.equals("WILDCARD_PRINCIPAL_NAME")) {
            LinkedList<Principal> linkedList = new LinkedList<Principal>();
            for (int i = 0; i < principalArray.length; ++i) {
                if (!principalEntry.principalClass.equals(principalArray[i].getClass().getName())) continue;
                linkedList.add(principalArray[i]);
            }
            String[][] stringArray = new String[linkedList.size()][2];
            int n = 0;
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                Principal principal = (Principal)iterator.next();
                stringArray[n][0] = principal.getClass().getName();
                stringArray[n][1] = principal.getName();
                ++n;
            }
            return stringArray;
        }
        String[][] stringArray = new String[principalArray.length][2];
        for (int i = 0; i < principalArray.length; ++i) {
            stringArray[i][0] = principalArray[i].getClass().getName();
            stringArray[i][1] = principalArray[i].getName();
        }
        return stringArray;
    }

    protected Certificate[] getSignerCertificates(CodeSource codeSource) {
        int n;
        Certificate[] certificateArray = null;
        certificateArray = codeSource.getCertificates();
        if (certificateArray == null) {
            return null;
        }
        for (n = 0; n < certificateArray.length; ++n) {
            if (certificateArray[n] instanceof X509Certificate) continue;
            return codeSource.getCertificates();
        }
        int n2 = 0;
        for (n = 0; n < certificateArray.length; ++n) {
            ++n2;
            while (n + 1 < certificateArray.length && ((Object)((X509Certificate)certificateArray[n]).getIssuerDN()).equals(((X509Certificate)certificateArray[n + 1]).getSubjectDN())) {
                ++n;
            }
        }
        if (n2 == certificateArray.length) {
            return certificateArray;
        }
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        for (n = 0; n < certificateArray.length; ++n) {
            arrayList.add(certificateArray[n]);
            while (n + 1 < certificateArray.length && ((Object)((X509Certificate)certificateArray[n]).getIssuerDN()).equals(((X509Certificate)certificateArray[n + 1]).getSubjectDN())) {
                ++n;
            }
        }
        Certificate[] certificateArray2 = new Certificate[arrayList.size()];
        arrayList.toArray(certificateArray2);
        return certificateArray2;
    }

    private CodeSource canonicalizeCodebase(CodeSource codeSource, boolean bl) {
        CodeSource codeSource2;
        block17: {
            Serializable serializable;
            String string = null;
            codeSource2 = codeSource;
            URL uRL = codeSource.getLocation();
            if (uRL != null) {
                try {
                    serializable = uRL.openConnection().getPermission();
                }
                catch (IOException iOException) {
                    serializable = null;
                }
                if (serializable instanceof FilePermission) {
                    string = serializable.getName();
                } else if (serializable == null && uRL.getProtocol().equals("file")) {
                    string = uRL.getFile().replace('/', File.separatorChar);
                    string = ParseUtil.decode(string);
                }
            }
            if (string != null) {
                try {
                    serializable = null;
                    if (string.endsWith("*")) {
                        string = string.substring(0, string.length() - 1);
                        boolean bl2 = false;
                        if (string.endsWith(File.separator)) {
                            bl2 = true;
                        }
                        if (string.equals("")) {
                            string = System.getProperty("user.dir");
                        }
                        File file = new File(string);
                        string = file.getCanonicalPath();
                        StringBuffer stringBuffer = new StringBuffer(string);
                        if (!string.endsWith(File.separator) && (bl2 || file.isDirectory())) {
                            stringBuffer.append(File.separatorChar);
                        }
                        stringBuffer.append('*');
                        string = stringBuffer.toString();
                    } else {
                        string = new File(string).getCanonicalPath();
                    }
                    serializable = ParseUtil.fileToEncodedURL(new File(string));
                    if (bl) {
                        codeSource2 = new CodeSource((URL)serializable, this.getSignerCertificates(codeSource));
                        break block17;
                    }
                    codeSource2 = new CodeSource((URL)serializable, codeSource.getCertificates());
                }
                catch (IOException iOException) {
                    if (bl) {
                        codeSource2 = new CodeSource(codeSource.getLocation(), this.getSignerCertificates(codeSource));
                    }
                    break block17;
                }
            }
            if (bl) {
                codeSource2 = new CodeSource(codeSource.getLocation(), this.getSignerCertificates(codeSource));
            }
        }
        return codeSource2;
    }

    private String printPD(ProtectionDomain protectionDomain) {
        Principal[] principalArray = protectionDomain.getPrincipals();
        String string = "<no principals>";
        if (principalArray != null && principalArray.length > 0) {
            StringBuffer stringBuffer = new StringBuffer("(principals ");
            for (int i = 0; i < principalArray.length; ++i) {
                stringBuffer.append(principalArray[i].getClass().getName() + " \"" + principalArray[i].getName() + "\"");
                if (i < principalArray.length - 1) {
                    stringBuffer.append(", ");
                    continue;
                }
                stringBuffer.append(")");
            }
            string = stringBuffer.toString();
        }
        return "PD CodeSource: " + protectionDomain.getCodeSource() + "\n\t" + "PD ClassLoader: " + protectionDomain.getClassLoader() + "\n\t" + "PD Principals: " + string;
    }

    private boolean replacePrincipals(LinkedList linkedList, KeyStore keyStore) {
        if (linkedList == null || linkedList.size() == 0 || keyStore == null) {
            return true;
        }
        ListIterator listIterator = linkedList.listIterator();
        while (listIterator.hasNext()) {
            PolicyParser.PrincipalEntry principalEntry = (PolicyParser.PrincipalEntry)listIterator.next();
            if (!principalEntry.principalClass.equals("PolicyParser.REPLACE_NAME")) continue;
            String string = this.getDN(principalEntry.principalName, keyStore);
            if (string == null) {
                return false;
            }
            if (debug != null) {
                debug.println("  Replacing \"" + principalEntry.principalName + "\" with " + X500PRINCIPAL + "/\"" + string + "\"");
            }
            principalEntry.principalClass = X500PRINCIPAL;
            principalEntry.principalName = string;
        }
        return true;
    }

    private void expandPermissionName(PolicyParser.PermissionEntry permissionEntry, KeyStore keyStore) throws Exception {
        int n;
        int n2;
        if (permissionEntry.name == null || permissionEntry.name.indexOf("${{", 0) == -1) {
            return;
        }
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n2 = permissionEntry.name.indexOf("${{", n3)) != -1 && (n = permissionEntry.name.indexOf("}}", n2)) >= 1) {
            String string;
            stringBuffer.append(permissionEntry.name.substring(n3, n2));
            String string2 = string = permissionEntry.name.substring(n2 + 3, n);
            int n4 = string.indexOf(":");
            if (n4 != -1) {
                string2 = string.substring(0, n4);
            }
            if (string2.equalsIgnoreCase("self")) {
                stringBuffer.append(permissionEntry.name.substring(n2, n + 2));
                n3 = n + 2;
                continue;
            }
            if (string2.equalsIgnoreCase("alias")) {
                if (n4 == -1) {
                    MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("alias name not provided (pe.name)"));
                    Object[] objectArray = new Object[]{permissionEntry.name};
                    throw new Exception(messageFormat.format(objectArray));
                }
                String string3 = string.substring(n4 + 1);
                if ((string3 = this.getDN(string3, keyStore)) == null) {
                    MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("unable to perform substitution on alias, suffix"));
                    Object[] objectArray = new Object[]{string.substring(n4 + 1)};
                    throw new Exception(messageFormat.format(objectArray));
                }
                stringBuffer.append("javax.security.auth.x500.X500Principal \"" + string3 + "\"");
                n3 = n + 2;
                continue;
            }
            MessageFormat messageFormat = new MessageFormat(ResourcesMgr.getString("substitution value, prefix, unsupported"));
            Object[] objectArray = new Object[]{string2};
            throw new Exception(messageFormat.format(objectArray));
        }
        stringBuffer.append(permissionEntry.name.substring(n3));
        if (debug != null) {
            debug.println("  Permission name expanded from:\n\t" + permissionEntry.name + "\nto\n\t" + stringBuffer.toString());
        }
        permissionEntry.name = stringBuffer.toString();
    }

    private String getDN(String string, KeyStore keyStore) {
        Certificate certificate = null;
        try {
            certificate = keyStore.getCertificate(string);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println("  Error retrieving certificate for '" + string + "': " + exception.toString());
            }
            return null;
        }
        if (certificate == null || !(certificate instanceof X509Certificate)) {
            if (debug != null) {
                debug.println("  -- No certificate for '" + string + "' - ignoring entry");
            }
            return null;
        }
        X509Certificate x509Certificate = (X509Certificate)certificate;
        return x509Certificate.getSubjectX500Principal().getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForTrustedIdentity(final Certificate certificate, PolicyInfo policyInfo) {
        Certificate[] certificateArray;
        if (certificate == null) {
            return false;
        }
        if (this.ignoreIdentityScope) {
            return false;
        }
        Serializable serializable = PolicyFile.class;
        synchronized (serializable) {
            if (scope == null && (certificateArray = (Certificate[])AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return IdentityScope.getSystemScope();
                }
            })) instanceof IdentityDatabase) {
                scope = certificateArray;
            }
        }
        if (scope == null) {
            this.ignoreIdentityScope = true;
            return false;
        }
        serializable = (Identity)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return scope.getIdentity(certificate.getPublicKey());
            }
        });
        if (this.isTrusted((Identity)serializable)) {
            if (debug != null) {
                debug.println("Adding policy entry for trusted Identity: ");
                AccessController.doPrivileged(new PrivilegedAction((Identity)serializable){
                    private final /* synthetic */ Identity val$id;
                    {
                        this.val$id = identity;
                    }

                    public Object run() {
                        debug.println("  identity = " + this.val$id);
                        return null;
                    }
                });
                debug.println("");
            }
            certificateArray = new Certificate[]{certificate};
            PolicyEntry policyEntry = new PolicyEntry(new CodeSource(null, certificateArray));
            policyEntry.add(new AllPermission());
            PolicyInfo policyInfo2 = policyInfo;
            synchronized (policyInfo2) {
                policyInfo.policyEntries.addElement(policyEntry);
                policyInfo.aliasMapping.put(certificate, ((Identity)serializable).getName());
            }
            return true;
        }
        return false;
    }

    private boolean isTrusted(Identity identity) {
        SystemSigner systemSigner;
        SystemIdentity systemIdentity;
        return identity instanceof SystemIdentity ? (systemIdentity = (SystemIdentity)identity).isTrusted() : identity instanceof SystemSigner && (systemSigner = (SystemSigner)identity).isTrusted();
    }

    private static class PolicyEntry {
        CodeSource codesource;
        Vector permissions;
        LinkedList principals;

        PolicyEntry(CodeSource codeSource, LinkedList linkedList) {
            this.codesource = codeSource;
            this.permissions = new Vector();
            this.principals = linkedList == null ? new LinkedList() : linkedList;
        }

        PolicyEntry(CodeSource codeSource) {
            this(codeSource, null);
        }

        LinkedList getPrincipals() {
            return this.principals;
        }

        void add(Permission permission) {
            this.permissions.addElement(permission);
        }

        CodeSource getCodeSource() {
            return this.codesource;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(ResourcesMgr.getString("("));
            stringBuffer.append(this.getCodeSource());
            stringBuffer.append("\n");
            for (int i = 0; i < this.permissions.size(); ++i) {
                Permission permission = (Permission)this.permissions.elementAt(i);
                stringBuffer.append(ResourcesMgr.getString(" "));
                stringBuffer.append(ResourcesMgr.getString(" "));
                stringBuffer.append(permission);
                stringBuffer.append(ResourcesMgr.getString("\n"));
            }
            stringBuffer.append(ResourcesMgr.getString(")"));
            stringBuffer.append(ResourcesMgr.getString("\n"));
            return stringBuffer.toString();
        }
    }
}

