/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import com.ibm.bidiTools.bdlayout.BidiConvert;
import java.security.AccessController;
import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.misc.VM;
import sun.security.action.GetPropertyAction;

public class CharToByteUTF8
extends CharToByteConverter {
    private char highHalfZoneCode;
    private String bidiParms = bidiInit;
    private boolean bidiEnabled = false;
    private static String bidiInit;

    public CharToByteUTF8() {
        if (null == this.bidiParms) {
            if (VM.isBooted()) {
                this.bidiParms = System.getSecurityManager() == null ? (String)new GetPropertyAction("JAVABIDI").run() : AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                if (null == this.bidiParms) {
                    this.bidiParms = "NO";
                }
                bidiInit = this.bidiParms;
            } else {
                this.bidiParms = "NO";
            }
        }
        this.bidiEnabled = !"NO".equals(this.bidiParms);
    }

    public int flush(byte[] byArray, int n, int n2) throws MalformedInputException {
        if (this.highHalfZoneCode != '\u0000') {
            this.reset();
            this.badInputLength = 0;
            throw new MalformedInputException();
        }
        this.charOff = 0;
        this.byteOff = 0;
        return 0;
    }

    public int convert(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws ConversionBufferFullException, MalformedInputException {
        int n5;
        int n6;
        int n7;
        int n8;
        BidiConvert bidiConvert;
        int n9;
        char c;
        int n10 = n4;
        int n11 = n2;
        int n12 = n;
        int n13 = n3;
        if (this.highHalfZoneCode != '\u0000') {
            c = this.highHalfZoneCode;
            this.highHalfZoneCode = '\u0000';
            if (cArray[n] >= '\udc00' && cArray[n] <= '\udfff') {
                if (n13 + 4 > n10) {
                    this.charOff = n12;
                    this.byteOff = n13;
                    throw new ConversionBufferFullException();
                }
                n9 = (this.highHalfZoneCode - 55296) * 1024 + (cArray[n] - 56320) + 65536;
                byArray[n13++] = (byte)(0xF0 | n9 >> 18 & 7);
                byArray[n13++] = (byte)(0x80 | n9 >> 12 & 0x3F);
                byArray[n13++] = (byte)(0x80 | n9 >> 6 & 0x3F);
                byArray[n13++] = (byte)(0x80 | n9 & 0x3F);
                ++n12;
                this.highHalfZoneCode = '\u0000';
            } else {
                this.badInputLength = 0;
                this.charOff = n12;
                this.byteOff = n13;
                throw new MalformedInputException();
            }
        }
        if (this.bidiEnabled && (bidiConvert = new BidiConvert()).isBidiData(cArray, n12, n11, this.bidiParms, this.getCharacterEncoding())) {
            n8 = n12;
            n7 = n11;
            int n14 = 0;
            int n15 = n10 - n13;
            for (n6 = n8; n6 < n7; ++n6) {
                char c2 = cArray[n6];
                if (c2 < '\u0080') {
                    n5 = 1;
                } else if (c2 < '\u0800') {
                    n5 = 2;
                } else if (c2 < '\ud800' || c2 >= '\ue000') {
                    n5 = 3;
                } else {
                    char c3;
                    if (c2 < '\udc00' ? n6 + 1 >= n7 || (c3 = cArray[n6 + 1]) < '\udc00' || c3 >= '\ue000' : n6 == n8 || (c3 = cArray[n6 - 1]) < '\ud800' || c3 >= '\udc00') break;
                    n5 = 2;
                }
                if (n14 + n5 > n15) break;
                n14 += n5;
            }
            n5 = n6 - n8;
            char[] cArray2 = new char[n5];
            cArray2 = bidiConvert.toSbcs(cArray, n12, n12 + n5, this.bidiParms, this.getCharacterEncoding());
            System.arraycopy(cArray2, 0, cArray, n12, n5);
        }
        int n16 = n8 = (n5 = n10 - n13) < (n9 = n11 - n12) ? n12 + n5 : n11;
        while (n12 < n8) {
            if ((c = cArray[n12++]) > '\u007f') {
                --n12;
                break;
            }
            byArray[n13++] = (byte)c;
        }
        if (n12 == n11) {
            this.charOff = n12;
            this.byteOff = n13;
            return n13 - n3;
        }
        while (n12 < n11) {
            c = cArray[n12];
            if (c < '\u0080') {
                if (n13 >= n10) {
                    this.charOff = n12;
                    this.byteOff = n13;
                    throw new ConversionBufferFullException();
                }
                byArray[n13++] = (byte)c;
                ++n12;
                continue;
            }
            if (c < '\u0800') {
                if (n13 + 2 > n10) {
                    this.charOff = n12;
                    this.byteOff = n13;
                    throw new ConversionBufferFullException();
                }
                byArray[n13++] = (byte)(0xC0 | c >> 6 & 0x1F);
                byArray[n13++] = (byte)(0x80 | c & 0x3F);
                ++n12;
                continue;
            }
            if (c < '\ud800' || c >= '\ue000') {
                if (n13 + 3 > n10) {
                    this.charOff = n12;
                    this.byteOff = n13;
                    throw new ConversionBufferFullException();
                }
                byArray[n13++] = (byte)(0xE0 | c >> 12 & 0xF);
                byArray[n13++] = (byte)(0x80 | c >> 6 & 0x3F);
                byArray[n13++] = (byte)(0x80 | c & 0x3F);
                ++n12;
                continue;
            }
            if (c >= '\udc00') {
                this.badInputLength = 1;
                this.charOff = n12;
                this.byteOff = n13;
                throw new MalformedInputException();
            }
            if (n12 + 1 >= n11) {
                this.highHalfZoneCode = c;
                break;
            }
            n7 = cArray[n12 + 1];
            if (n7 < 56320 || n7 > 57343) {
                this.badInputLength = 1;
                this.charOff = n12;
                this.byteOff = n13;
                throw new MalformedInputException();
            }
            if (n13 + 4 > n10) {
                this.charOff = n12;
                this.byteOff = n13;
                throw new ConversionBufferFullException();
            }
            n6 = (c - 55296) * 1024 + (n7 - 56320) + 65536;
            byArray[n13++] = (byte)(0xF0 | n6 >> 18 & 7);
            byArray[n13++] = (byte)(0x80 | n6 >> 12 & 0x3F);
            byArray[n13++] = (byte)(0x80 | n6 >> 6 & 0x3F);
            byArray[n13++] = (byte)(0x80 | n6 & 0x3F);
            n12 += 2;
        }
        this.charOff = n12;
        this.byteOff = n13;
        return n13 - n3;
    }

    public boolean canConvert(char c) {
        return true;
    }

    public int getMaxBytesPerChar() {
        return 3;
    }

    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
        this.highHalfZoneCode = '\u0000';
    }

    public String getCharacterEncoding() {
        return "UTF8";
    }
}

