/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.java.impl;

import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jem.internal.java.init.JavaInit;
import org.eclipse.jem.java.ArrayType;
import org.eclipse.jem.java.Block;
import org.eclipse.jem.java.Comment;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.Initializer;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaDataType;
import org.eclipse.jem.java.JavaHelpers;
import org.eclipse.jem.java.JavaPackage;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.JavaParameterKind;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.java.JavaRefPackage;
import org.eclipse.jem.java.JavaURL;
import org.eclipse.jem.java.JavaVisibilityKind;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.java.Statement;
import org.eclipse.jem.java.TypeKind;
import org.eclipse.jem.java.impl.ArrayTypeImpl;
import org.eclipse.jem.java.impl.BlockImpl;
import org.eclipse.jem.java.impl.CommentImpl;
import org.eclipse.jem.java.impl.FieldImpl;
import org.eclipse.jem.java.impl.InitializerImpl;
import org.eclipse.jem.java.impl.JavaClassImpl;
import org.eclipse.jem.java.impl.JavaDataTypeImpl;
import org.eclipse.jem.java.impl.JavaPackageImpl;
import org.eclipse.jem.java.impl.JavaParameterImpl;
import org.eclipse.jem.java.impl.MethodImpl;
import org.eclipse.jem.java.impl.StatementImpl;

public class JavaRefFactoryImpl
extends EFactoryImpl
implements JavaRefFactory {
    protected static Class ReflectionFactoryClass;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jem.internal.java.adapters.jdk.JavaJDKAdapterFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ReflectionFactoryClass = clazz;
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createJavaClass();
            }
            case 1: {
                return this.createInitializer();
            }
            case 2: {
                return this.createJavaParameter();
            }
            case 3: {
                return this.createMethod();
            }
            case 4: {
                return this.createField();
            }
            case 5: {
                return this.createBlock();
            }
            case 6: {
                return this.createComment();
            }
            case 7: {
                return this.createStatement();
            }
            case 8: {
                return this.createJavaPackage();
            }
            case 9: {
                return this.createJavaDataType();
            }
            case 10: {
                return this.createArrayType();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 12: {
                return TypeKind.get(initialValue);
            }
            case 13: {
                return JavaVisibilityKind.get(initialValue);
            }
            case 14: {
                return JavaParameterKind.get(initialValue);
            }
            case 15: {
                return this.createJTypeJavaHelpersFromString(eDataType, initialValue);
            }
            case 16: {
                return this.createJTypeListFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 12: {
                return instanceValue == null ? null : instanceValue.toString();
            }
            case 13: {
                return instanceValue == null ? null : instanceValue.toString();
            }
            case 14: {
                return instanceValue == null ? null : instanceValue.toString();
            }
            case 15: {
                return this.convertJTypeJavaHelpersToString(eDataType, instanceValue);
            }
            case 16: {
                return this.convertJTypeListToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public ArrayType createArrayType(JavaHelpers componentType) {
        ArrayType at = this.createArrayType();
        String computedName = String.valueOf(componentType.getQualifiedName()) + "[]";
        at.setName(computedName);
        return at;
    }

    public ArrayType createArrayType(JavaHelpers finalComponentType, int dimensions) {
        ArrayType at = this.createArrayType();
        String computedName = finalComponentType.getQualifiedName();
        int i = 0;
        while (i < dimensions) {
            computedName = String.valueOf(computedName) + "[]";
            ++i;
        }
        at.setName(computedName);
        return at;
    }

    public static ResourceSet createJavaContext() {
        JavaInit.init();
        ResourceSetImpl set = new ResourceSetImpl();
        set.getAdapterFactories().add((Object)JavaRefFactoryImpl.createJavaReflectionAdapterFactory());
        return set;
    }

    protected static AdapterFactory createJavaReflectionAdapterFactory() {
        AdapterFactory factoryInstance = null;
        try {
            if (JavaRefFactoryImpl.getReflectionAdapterFactoryClass() != null) {
                factoryInstance = (AdapterFactory)JavaRefFactoryImpl.getReflectionAdapterFactoryClass().newInstance();
            }
        }
        catch (Exception exception) {}
        return factoryInstance;
    }

    public static Class getReflectionAdapterFactoryClass() {
        return ReflectionFactoryClass;
    }

    public static void setReflectionAdapterFactoryClass(Class javaReflectionFactoryClass) {
        ReflectionFactoryClass = javaReflectionFactoryClass;
    }

    public Method createMethod() {
        MethodImpl method = new MethodImpl();
        return method;
    }

    public JavaClass createJavaClass() {
        JavaClassImpl javaClass = new JavaClassImpl();
        return javaClass;
    }

    public Field createField() {
        FieldImpl field = new FieldImpl();
        return field;
    }

    public Block createBlock() {
        BlockImpl block = new BlockImpl();
        return block;
    }

    public Comment createComment() {
        CommentImpl comment = new CommentImpl();
        return comment;
    }

    public Statement createStatement() {
        StatementImpl statement = new StatementImpl();
        return statement;
    }

    public Initializer createInitializer() {
        InitializerImpl initializer = new InitializerImpl();
        return initializer;
    }

    public JavaParameter createJavaParameter() {
        JavaParameterImpl javaParameter = new JavaParameterImpl();
        return javaParameter;
    }

    public ArrayType createArrayType() {
        ArrayTypeImpl arrayType = new ArrayTypeImpl();
        return arrayType;
    }

    public JavaHelpers createJTypeJavaHelpersFromString(EDataType eDataType, String initialValue) {
        return (JavaHelpers)super.createFromString(eDataType, initialValue);
    }

    public String convertJTypeJavaHelpersToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public List createJTypeListFromString(EDataType eDataType, String initialValue) {
        return (List)super.createFromString(eDataType, initialValue);
    }

    public String convertJTypeListToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public JavaDataType createJavaDataType() {
        JavaDataTypeImpl javaDataType = new JavaDataTypeImpl();
        return javaDataType;
    }

    public JavaPackage createJavaPackage() {
        JavaPackageImpl javaPackage = new JavaPackageImpl();
        return javaPackage;
    }

    public JavaRefPackage getJavaRefPackage() {
        return (JavaRefPackage)this.getEPackage();
    }

    public static JavaRefPackage getPackage() {
        return JavaRefPackage.eINSTANCE;
    }

    public static JavaRefFactory getActiveFactory() {
        return JavaRefFactory.eINSTANCE;
    }

    public JavaClass createClassRef(String targetName) {
        JavaClass ref = this.createJavaClass();
        JavaURL javaurl = new JavaURL(targetName);
        ((InternalEObject)ref).eSetProxyURI(URI.createURI((String)javaurl.getFullString()));
        return ref;
    }

    public JavaHelpers reflectType(String aQualifiedName, EObject relatedObject) {
        ResourceSet rs;
        Resource r = relatedObject.eResource();
        if (r != null && (rs = r.getResourceSet()) != null) {
            return this.reflectType(aQualifiedName, rs);
        }
        return null;
    }

    public JavaHelpers reflectType(String aQualifiedName, ResourceSet set) {
        if (aQualifiedName != null) {
            int index = aQualifiedName.lastIndexOf(".");
            if (index > 0) {
                return this.reflectType(aQualifiedName.substring(0, index), aQualifiedName.substring(index + 1, aQualifiedName.length()), set);
            }
            return this.reflectType("", aQualifiedName, set);
        }
        return null;
    }

    public JavaHelpers reflectType(String aPackageName, String aTypeName, ResourceSet set) {
        if (aTypeName != null && aPackageName != null) {
            JavaInit.init();
            JavaURL url = new JavaURL(aPackageName, aTypeName);
            return (JavaHelpers)set.getEObject(URI.createURI((String)url.getFullString()), true);
        }
        return null;
    }

    public JavaPackage reflectPackage(String packageName, ResourceSet set) {
        if (packageName != null) {
            JavaInit.init();
            JavaURL url = new JavaURL(packageName, "*package");
            return (JavaPackage)set.getEObject(URI.createURI((String)url.getFullString()), true);
        }
        return null;
    }
}

