/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.java.adapters;

import com.ibm.wtp.common.logger.proxy.Logger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.jem.internal.java.adapters.ReflectionAdaptor;
import org.eclipse.jem.java.Block;
import org.eclipse.jem.java.Field;
import org.eclipse.jem.java.JavaClass;
import org.eclipse.jem.java.JavaParameter;
import org.eclipse.jem.java.JavaRefFactory;
import org.eclipse.jem.java.JavaRefPackage;
import org.eclipse.jem.java.JavaURL;
import org.eclipse.jem.java.Method;
import org.eclipse.jem.java.impl.JavaRefFactoryImpl;

public abstract class JavaReflectionAdaptor
extends ReflectionAdaptor {
    private static final String C_METHOD_DEFAULT_CTOR = String.valueOf(String.valueOf('(')) + "_V";
    protected static final String LEFT_BRACKET = "[";
    public static final EAttribute FLUSH_REFLECTION_SF = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
    public static final EAttribute FLUSH_NEW_REFLECTION_SF = EcorePackage.eINSTANCE.getEcoreFactory().createEAttribute();
    protected boolean hasFlushed = false;
    protected boolean isFlushing = false;

    static {
        FLUSH_REFLECTION_SF.setName("flushReflectedValues");
        FLUSH_NEW_REFLECTION_SF.setName("flushNewReflectedValues");
    }

    public JavaReflectionAdaptor() {
    }

    public JavaReflectionAdaptor(Notifier target) {
        super(target);
    }

    public Block createBlock(String name, String sourceString) {
        Block newBlock = JavaReflectionAdaptor.getJavaFactory().createBlock();
        newBlock.setName(String.valueOf(name) + "_" + "block");
        newBlock.setSource(sourceString);
        return newBlock;
    }

    public JavaClass createJavaClassRef(String targetName) {
        JavaClass ref = JavaRefFactoryImpl.getActiveFactory().createJavaClass();
        JavaURL javaurl = new JavaURL(targetName);
        ((InternalEObject)ref).eSetProxyURI(URI.createURI((String)javaurl.getFullString()));
        return ref;
    }

    public JavaParameter createJavaParameter(Method parentMethod, String parmName, String parmTypeName) {
        JavaParameter newParm = JavaReflectionAdaptor.getJavaFactory().createJavaParameter();
        newParm.setName(parmName);
        String classRefString = parmTypeName;
        newParm.setEType((EClassifier)this.createJavaClassRef(classRefString));
        return newParm;
    }

    public List getArrayDimensions(String typeName) {
        ArrayList<Integer> dimensions = new ArrayList<Integer>();
        if (typeName != null) {
            int begin = 0;
            int index = -1;
            while (begin < typeName.length()) {
                index = typeName.indexOf(LEFT_BRACKET, begin);
                if (index > -1) {
                    dimensions.add(new Integer(1));
                    begin = index + 1;
                    continue;
                }
                begin = typeName.length();
            }
        }
        return dimensions;
    }

    protected static JavaRefFactory getJavaFactory() {
        return ((JavaRefPackage)EPackage.Registry.INSTANCE.getEPackage("java.xmi")).getJavaRefFactory();
    }

    public abstract Object getReflectionSource();

    /*
     * Unable to fully structure code
     */
    protected static String[] getTypeNamesFromMethodID(String methodID) {
        if (methodID.charAt(methodID.length() - 1) == '(' || methodID.endsWith(JavaReflectionAdaptor.C_METHOD_DEFAULT_CTOR)) {
            return ReflectionAdaptor.emptyStringArray;
        }
        numParms = 1;
        pos = -1;
        ++pos;
        pos = methodID.indexOf(46, pos);
        ++pos;
        pos = parmPos = methodID.indexOf(40, pos);
        if (true) ** GOTO lbl12
        do {
            ++numParms;
lbl12:
            // 2 sources

            ++pos;
        } while ((pos = methodID.indexOf(44, pos)) != -1);
        parmTypeNames = new String[numParms];
        pos = parmPos;
        i = 0;
        do {
            if ((end = methodID.indexOf(44, pos + 1)) == -1) {
                end = methodID.indexOf("_V", pos + 1);
            }
            if (end == -1) {
                end = methodID.length();
            }
            parmTypeNames[i++] = methodID.substring(pos + 1, end);
            ++pos;
        } while ((pos = methodID.indexOf(44, pos)) != -1);
        return parmTypeNames;
    }

    public abstract boolean hasCachedReflectionSource();

    public boolean hasReflectionSource() {
        return this.getReflectionSource() != null;
    }

    public void releaseSourceType() {
    }

    public Notification releaseSourceTypeNoNotification() {
        return null;
    }

    public static void releaseSourceType(JavaClass javaClass) {
        if (javaClass == null) {
            return;
        }
        JavaReflectionAdaptor existing = (JavaReflectionAdaptor)ReflectionAdaptor.retrieveAdaptorFrom((EObject)javaClass);
        if (existing != null) {
            existing.releaseSourceType();
        }
    }

    protected void setFieldType(Field aField, String aTypeName) {
        if (aField != null && aTypeName != null) {
            String classRefString = aTypeName;
            aField.setEType((EClassifier)this.createJavaClassRef(classRefString));
        }
    }

    public final boolean flushReflectedValuesIfNecessary() {
        return this.flushReflectedValuesIfNecessary(false);
    }

    public final boolean flushReflectedValuesIfNecessary(boolean clearCachedModelObject) {
        Notification not = this.flushReflectedValuesIfNecessaryNoNotification(clearCachedModelObject);
        if (not != null) {
            this.getTarget().eNotify(not);
        }
        return this.hasFlushed;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Notification flushReflectedValuesIfNecessaryNoNotification(boolean clearCachedModelObject) {
        block7: {
            if (this.hasFlushed || this.isFlushing) break block7;
            boolean isExisting = this.hasCachedReflectionSource();
            try {
                try {
                    this.isFlushing = true;
                    this.hasReflected = false;
                    this.hasFlushed = this.flushReflectedValues(clearCachedModelObject);
                }
                catch (Throwable e) {
                    this.hasFlushed = false;
                    Logger.getLogger().log(e);
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    if (e instanceof Error) {
                        throw (Error)e;
                    }
                    throw new RuntimeException(e.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                this.isFlushing = false;
                this.postFlushReflectedValuesIfNecessary(isExisting);
                throw throwable;
            }
            {
                Object var4_6 = null;
                this.isFlushing = false;
                this.postFlushReflectedValuesIfNecessary(isExisting);
                return this.createFlushNotification(isExisting);
            }
        }
        return null;
    }

    protected Notification createFlushNotification(boolean isExisting) {
        EAttribute feature = isExisting ? FLUSH_REFLECTION_SF : FLUSH_NEW_REFLECTION_SF;
        return new ENotificationImpl((InternalEObject)this.getTarget(), 1, (EStructuralFeature)feature, null, null);
    }

    protected void postFlushReflectedValuesIfNecessary(boolean isExisting) {
    }

    protected boolean flushReflectedValues(boolean clearCachedModelObject) {
        return true;
    }

    public boolean reflectValuesIfNecessary() {
        if (this.isFlushing) {
            return false;
        }
        return super.reflectValuesIfNecessary();
    }

    public boolean reflectValues() {
        this.hasFlushed = false;
        return true;
    }
}

