/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.xmi10;

import com.ibm.xmi.xmi10.Output;
import com.ibm.xmi.xmi10.Transform;
import com.ibm.xmi.xmi10.TransformFactory;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.util.Enumeration;

public class TransformUtility {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999,2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static TransformUtility tf;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Void;

    public static TransformUtility instance() {
        if (tf == null) {
            tf = new TransformUtility();
        }
        return tf;
    }

    public void instantiateAll() {
        TransformFactory transformFactory = TransformFactory.instance();
        Enumeration enumeration = transformFactory.transformsAvailable();
        while (enumeration.hasMoreElements()) {
            Class clazz = (Class)enumeration.nextElement();
            if (transformFactory.getTransform(clazz) != null) continue;
            transformFactory.makeTransform(clazz);
        }
    }

    public void printAll(Transform transform, boolean bl, boolean bl2) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(transform.getClass());
            BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
            if (!bl2 && beanDescriptor.isHidden()) {
                return;
            }
            if (!bl && beanDescriptor.isExpert()) {
                return;
            }
            StringBuffer stringBuffer = new StringBuffer(beanDescriptor.getName());
            if (beanDescriptor.isExpert()) {
                stringBuffer.append("*");
            }
            if (beanDescriptor.isHidden()) {
                stringBuffer.append("~");
            }
            while (stringBuffer.length() < 12) {
                stringBuffer.append(" ");
            }
            Output.out("\n" + stringBuffer + " " + beanDescriptor.getShortDescription());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = propertyDescriptorArray.length - 1; i >= 0; --i) {
                if (!bl2 && propertyDescriptorArray[i].isHidden() || !bl && propertyDescriptorArray[i].isExpert()) continue;
                stringBuffer = new StringBuffer(propertyDescriptorArray[i].getName());
                if (propertyDescriptorArray[i].isExpert()) {
                    stringBuffer.append("*");
                }
                if (propertyDescriptorArray[i].isHidden()) {
                    stringBuffer.append("~");
                }
                while (stringBuffer.length() < 14) {
                    stringBuffer.append(" ");
                }
                StringBuffer stringBuffer2 = new StringBuffer(propertyDescriptorArray[i].getShortDescription());
                while (stringBuffer2.length() < 34) {
                    stringBuffer2.append(" ");
                }
                String string = this.shortName(propertyDescriptorArray[i].getReadMethod().getReturnType().getName());
                String string2 = propertyDescriptorArray[i].getValue(Transform.range).toString();
                String string3 = propertyDescriptorArray[i].getReadMethod().invoke((Object)transform, null).toString();
                String string4 = " -" + stringBuffer + " " + stringBuffer2 + " (" + string;
                String string5 = string.equals("String") ? (string3.length() > 0 ? ", " + string3 + ")" : ")") : (string.equals("boolean") ? ", " + string3 + ")" : ", " + string3 + ", " + string2 + ")");
                Output.out(string4 + string5);
            }
        }
        catch (Exception exception) {
            Output.exc(exception);
            return;
        }
    }

    public void printAllTransforms(boolean bl, boolean bl2) {
        TransformFactory transformFactory = TransformFactory.instance();
        Enumeration enumeration = transformFactory.transformsLoaded();
        while (enumeration.hasMoreElements()) {
            this.printAll((Transform)enumeration.nextElement(), bl, bl2);
        }
    }

    public String shortName(String string) {
        if (string == null || string.length() < 2) {
            return string;
        }
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    public Object stringToObject(String string, Class clazz) {
        try {
            Class clazz2 = this.wrapType(clazz);
            Class[] classArray = new Class[]{class$java$lang$String == null ? (class$java$lang$String = TransformUtility.class$("java.lang.String")) : class$java$lang$String};
            Constructor constructor = clazz2.getConstructor(classArray);
            Object[] objectArray = new Object[]{string};
            return constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            Output.out(exception.toString());
            return null;
        }
    }

    public Class wrapType(Class clazz) {
        if (!clazz.isPrimitive()) {
            return clazz;
        }
        if (clazz == Integer.TYPE) {
            return class$java$lang$Integer == null ? (class$java$lang$Integer = TransformUtility.class$("java.lang.Integer")) : class$java$lang$Integer;
        }
        if (clazz == Boolean.TYPE) {
            return class$java$lang$Boolean == null ? (class$java$lang$Boolean = TransformUtility.class$("java.lang.Boolean")) : class$java$lang$Boolean;
        }
        if (clazz == Byte.TYPE) {
            return class$java$lang$Byte == null ? (class$java$lang$Byte = TransformUtility.class$("java.lang.Byte")) : class$java$lang$Byte;
        }
        if (clazz == Character.TYPE) {
            return class$java$lang$Character == null ? (class$java$lang$Character = TransformUtility.class$("java.lang.Character")) : class$java$lang$Character;
        }
        if (clazz == Double.TYPE) {
            return class$java$lang$Double == null ? (class$java$lang$Double = TransformUtility.class$("java.lang.Double")) : class$java$lang$Double;
        }
        if (clazz == Float.TYPE) {
            return class$java$lang$Float == null ? (class$java$lang$Float = TransformUtility.class$("java.lang.Float")) : class$java$lang$Float;
        }
        if (clazz == Long.TYPE) {
            return class$java$lang$Long == null ? (class$java$lang$Long = TransformUtility.class$("java.lang.Long")) : class$java$lang$Long;
        }
        if (clazz == Short.TYPE) {
            return class$java$lang$Short == null ? (class$java$lang$Short = TransformUtility.class$("java.lang.Short")) : class$java$lang$Short;
        }
        return class$java$lang$Void == null ? (class$java$lang$Void = TransformUtility.class$("java.lang.Void")) : class$java$lang$Void;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

