/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.xmi10;

import com.ibm.xmi.utility.Stat;
import com.ibm.xmi.xmi10.CustomLoader;
import com.ibm.xmi.xmi10.Output;
import com.ibm.xmi.xmi10.Transform;
import java.beans.Beans;
import java.util.Enumeration;
import java.util.Vector;

public class TransformFactory {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999,2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Vector transAvail;
    private static Vector transLoaded;
    private static TransformFactory tf;
    private static String prefix;
    private CustomLoader customLoader;

    public TransformFactory() {
        this.init();
    }

    public CustomLoader getCustomLoader() {
        return this.customLoader;
    }

    public Transform getTransform(int n) {
        return (Transform)transLoaded.elementAt(n);
    }

    public Transform getTransform(Class clazz) {
        for (int i = 0; i < this.numTransforms(); ++i) {
            Transform transform = this.getTransform(i);
            if (transform.getClass() != clazz) continue;
            return transform;
        }
        return null;
    }

    public Transform getTransform(String string) {
        for (int i = 0; i < this.numTransforms(); ++i) {
            Transform transform = this.getTransform(i);
            if (!string.equals(transform.getName())) continue;
            return transform;
        }
        return null;
    }

    public void init() {
        transAvail = new Vector();
        transLoaded = new Vector();
        this.customLoader = null;
        try {
            transAvail.addElement(Class.forName(prefix + "Toolkit"));
            transAvail.addElement(Class.forName(prefix + "R2X"));
            transAvail.addElement(Class.forName(prefix + "X2R"));
        }
        catch (Exception exception) {
            Output.exc(exception);
        }
    }

    public static TransformFactory instance() {
        if (tf == null) {
            tf = new TransformFactory();
        }
        return tf;
    }

    public Transform makeTransform(Class clazz) {
        Stat stat = new Stat();
        Transform transform = null;
        try {
            if (this.customLoader != null) {
                transform = this.customLoader.makeTransform(clazz);
            }
            if (transform == null) {
                transform = (Transform)Beans.instantiate(null, clazz.getName());
            }
        }
        catch (Exception exception) {
            Output.exc(exception);
            return null;
        }
        transLoaded.addElement(transform);
        Stat stat2 = new Stat(stat);
        if (Output.getDebug()) {
            stat2.print("Instantiate " + transform.toString());
        }
        transform.getBeanInfo();
        Stat stat3 = new Stat(stat);
        if (Output.getDebug()) {
            stat3.print("BeanInfo");
        }
        transform.init();
        return transform;
    }

    public Transform makeTransform(String string) {
        Class clazz = null;
        try {
            if (this.customLoader != null) {
                clazz = this.customLoader.resolveTransform(string);
            }
            if (clazz == null) {
                return this.makeTransform(Class.forName(prefix + string));
            }
            return this.makeTransform(clazz);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int numTransforms() {
        return transLoaded.size();
    }

    public void setCustomLoader(String string) {
        try {
            this.customLoader = (CustomLoader)Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            Output.exc(exception);
        }
    }

    public static void term() {
        tf = null;
    }

    public Enumeration transformsAvailable() {
        if (this.customLoader != null) {
            Vector vector = (Vector)transAvail.clone();
            Enumeration enumeration = this.customLoader.transformsAvailable();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
            return vector.elements();
        }
        return transAvail.elements();
    }

    public Enumeration transformsLoaded() {
        return transLoaded.elements();
    }

    static {
        prefix = "com.ibm.xmi.xmi10.";
    }
}

