/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.xmi10;

import com.ibm.xmi.uml.Id;
import com.ibm.xmi.uml.Property;
import com.ibm.xmi.uml.Type;
import com.ibm.xmi.uml.UML;
import com.ibm.xmi.uml.UMLException;
import java.util.Vector;

public class IDLUtil {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999,2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static IDLUtil util = null;
    private static Id IDLDataTypePackageId = null;
    private static Id anyId;
    private static Id booleanId;
    private static Id charId;
    private static Id doubleId;
    private static Id floatId;
    private static Id intId;
    private static Id longId;
    private static Id longdoubleId;
    private static Id longlongId;
    private static Id octetId;
    private static Id shortId;
    private static Id stringId;
    private static Id unsignedlongId;
    private static Id unsignedlonglongId;
    private static Id unsignedshortId;
    private static Id voidId;
    private static Id wstringId;
    private static Id wcharId;
    private static Id trueId;
    private static Id falseId;

    private IDLUtil() {
    }

    public boolean createIDLDatatype() {
        UML uML = UML.instance();
        Id id = uML.getSession();
        return this.createIDLDatatype(id);
    }

    public boolean createIDLDatatype(Id id) {
        boolean bl = true;
        if (IDLDataTypePackageId == null) {
            try {
                String string;
                Id id2;
                int n;
                Vector vector = id.get(Type.PACKAGE, false);
                if (vector != null) {
                    boolean bl2 = false;
                    for (n = 0; n < vector.size() && !bl2; ++n) {
                        id2 = (Id)vector.elementAt(n);
                        string = id2.get(Property.NAME);
                        if (string == null || !string.equals("IDL_DATATYPE")) continue;
                        IDLDataTypePackageId = id2;
                        bl2 = true;
                    }
                }
                if (IDLDataTypePackageId == null) {
                    IDLDataTypePackageId = id.add(Type.PACKAGE, "IDL_DATATYPE");
                    anyId = IDLDataTypePackageId.add(Type.PRIMITIVE, "any");
                    charId = IDLDataTypePackageId.add(Type.PRIMITIVE, "char");
                    doubleId = IDLDataTypePackageId.add(Type.PRIMITIVE, "double");
                    floatId = IDLDataTypePackageId.add(Type.PRIMITIVE, "float");
                    intId = IDLDataTypePackageId.add(Type.PRIMITIVE, "int");
                    longId = IDLDataTypePackageId.add(Type.PRIMITIVE, "long");
                    longdoubleId = IDLDataTypePackageId.add(Type.PRIMITIVE, "long double");
                    longlongId = IDLDataTypePackageId.add(Type.PRIMITIVE, "long long");
                    octetId = IDLDataTypePackageId.add(Type.PRIMITIVE, "octet");
                    shortId = IDLDataTypePackageId.add(Type.PRIMITIVE, "short");
                    stringId = IDLDataTypePackageId.add(Type.PRIMITIVE, "string");
                    unsignedlongId = IDLDataTypePackageId.add(Type.PRIMITIVE, "unsigned long");
                    unsignedlonglongId = IDLDataTypePackageId.add(Type.PRIMITIVE, "unsigned long long");
                    unsignedshortId = IDLDataTypePackageId.add(Type.PRIMITIVE, "unsigned short");
                    voidId = IDLDataTypePackageId.add(Type.PRIMITIVE, "void");
                    wcharId = IDLDataTypePackageId.add(Type.PRIMITIVE, "wchar");
                    wstringId = IDLDataTypePackageId.add(Type.PRIMITIVE, "wstring");
                    booleanId = IDLDataTypePackageId.add(Type.ENUMERATION, "boolean");
                    trueId = booleanId.add(Type.ATTRIBUTE, "true");
                    falseId = booleanId.add(Type.ATTRIBUTE, "false");
                } else {
                    Vector vector2 = IDLDataTypePackageId.get(Type.PRIMITIVE, false);
                    if (vector2 != null) {
                        for (n = 0; n < vector2.size(); ++n) {
                            id2 = (Id)vector2.elementAt(n);
                            string = id2.get(Property.NAME);
                            if (string == null) continue;
                            if (string.equals("any")) {
                                anyId = id2;
                                continue;
                            }
                            if (string.equals("boolean")) {
                                booleanId = id2;
                                continue;
                            }
                            if (string.equals("char")) {
                                charId = id2;
                                continue;
                            }
                            if (string.equals("double")) {
                                doubleId = id2;
                                continue;
                            }
                            if (string.equals("float")) {
                                floatId = id2;
                                continue;
                            }
                            if (string.equals("int")) {
                                intId = id2;
                                continue;
                            }
                            if (string.equals("long")) {
                                longId = id2;
                                continue;
                            }
                            if (string.equals("long double")) {
                                longdoubleId = id2;
                                continue;
                            }
                            if (string.equals("long long")) {
                                longlongId = id2;
                                continue;
                            }
                            if (string.equals("octet")) {
                                octetId = id2;
                                continue;
                            }
                            if (string.equals("short")) {
                                shortId = id2;
                                continue;
                            }
                            if (string.equals("string")) {
                                stringId = id2;
                                continue;
                            }
                            if (string.equals("double")) {
                                doubleId = id2;
                                continue;
                            }
                            if (string.equals("unsigned long")) {
                                unsignedlongId = id2;
                                continue;
                            }
                            if (string.equals("unsigned long long")) {
                                unsignedlonglongId = id2;
                                continue;
                            }
                            if (string.equals("unsigned short")) {
                                unsignedshortId = id2;
                                continue;
                            }
                            if (string.equals("wchar")) {
                                wcharId = id2;
                                continue;
                            }
                            if (!string.equals("wstring")) continue;
                            wstringId = id2;
                        }
                    }
                }
            }
            catch (UMLException uMLException) {
                bl = false;
                uMLException.printStackTrace();
            }
        }
        return bl;
    }

    public Id getAny() {
        return anyId;
    }

    public Id getBoolean() {
        return booleanId;
    }

    public Id getChar() {
        return charId;
    }

    public Id getDouble() {
        return doubleId;
    }

    public Id getFloat() {
        return floatId;
    }

    public Id getIdFromType(String string) {
        Id id = null;
        if (string.equals("any")) {
            id = anyId;
        } else if (string.equals("boolean")) {
            id = booleanId;
        } else if (string.equals("char")) {
            id = charId;
        } else if (string.equals("double")) {
            id = doubleId;
        } else if (string.equals("float")) {
            id = floatId;
        } else if (string.equals("int")) {
            id = intId;
        } else if (string.equals("long")) {
            id = longId;
        } else if (string.equals("long double")) {
            id = longdoubleId;
        } else if (string.equals("long long")) {
            id = longlongId;
        } else if (string.equals("octet")) {
            id = octetId;
        } else if (string.equals("short")) {
            id = shortId;
        } else if (string.equals("string")) {
            id = stringId;
        } else if (string.equals("unsigned long")) {
            id = unsignedlongId;
        } else if (string.equals("unsigned long long")) {
            id = unsignedlonglongId;
        } else if (string.equals("unsigned short")) {
            id = unsignedshortId;
        } else if (string.equals("void")) {
            id = voidId;
        } else if (string.equals("wchar")) {
            id = wcharId;
        } else if (string.equals("wstring")) {
            id = wstringId;
        }
        return id;
    }

    public Id getIDLDatatypePackage() {
        return IDLDataTypePackageId;
    }

    public Id getInt() {
        return intId;
    }

    public Id getLong() {
        return longId;
    }

    public Id getLongDouble() {
        return longdoubleId;
    }

    public Id getLongLong() {
        return longlongId;
    }

    public Id getOctet() {
        return octetId;
    }

    public Id getShort() {
        return shortId;
    }

    public Id getString() {
        return stringId;
    }

    public Id getUnsignedLong() {
        return unsignedlongId;
    }

    public Id getUnsignedLongLong() {
        return unsignedlonglongId;
    }

    public Id getUnsignedShort() {
        return unsignedshortId;
    }

    public Id getVoid() {
        return voidId;
    }

    public Id getWChar() {
        return wcharId;
    }

    public Id getWString() {
        return wstringId;
    }

    public void initIDLPackage() {
        IDLDataTypePackageId = null;
    }

    public static IDLUtil instance() {
        if (util == null) {
            util = new IDLUtil();
        }
        return util;
    }

    public boolean isPredefined(Id id) {
        boolean bl = false;
        if (id == anyId || id == booleanId || id == charId || id == doubleId || id == floatId || id == intId || id == longId || id == longdoubleId || id == longlongId || id == octetId || id == shortId || id == stringId || id == unsignedlongId || id == unsignedlonglongId || id == unsignedshortId || id == voidId || id == wstringId || id == wcharId) {
            bl = true;
        }
        return bl;
    }
}

