/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.xmi10;

import com.ibm.xmi.xmi10.Output;
import com.ibm.xmi.xmi10.Transform;
import com.ibm.xmi.xmi10.TransformUtility;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;

public class DefaultTransform
implements Transform {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999,2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);
    private boolean started;
    private boolean finished;
    private boolean closed;
    private int progress;
    private int scale;
    static /* synthetic */ Class class$java$lang$String;

    public DefaultTransform() {
        this.init();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public void fire(Method method, Object object, Object object2) {
        this.changes.firePropertyChange(this.getPropName(method), object, object2);
    }

    public void fire(String string, Object object, Object object2) {
        this.changes.firePropertyChange(string, object, object2);
    }

    public BeanInfo getBeanInfo() {
        try {
            return Introspector.getBeanInfo(this.getClass());
        }
        catch (Exception exception) {
            Output.out(exception.toString());
            return null;
        }
    }

    public String getName() {
        BeanInfo beanInfo = this.getBeanInfo();
        BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
        return beanDescriptor.getName();
    }

    public int getProgress() {
        return this.progress;
    }

    public Object getProperty(String string) {
        try {
            PropertyDescriptor propertyDescriptor = this.propertyDescriptor(string);
            Method method = propertyDescriptor.getReadMethod();
            return method.invoke((Object)this, null);
        }
        catch (Exception exception) {
            Output.out(exception.toString());
            return null;
        }
    }

    public String getPropName(Method method) {
        return this.propertyDescriptor(method).getName();
    }

    public void init() {
        this.started = false;
        this.finished = false;
        this.closed = false;
        this.progress = 0;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public boolean isConst() {
        return true;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void postStart() {
        this.setProgress(100);
        this.setFinished(true);
        this.setClosed(true);
    }

    public void preStart() {
        this.setStarted(true);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(Transform.finished)) {
            this.start();
        }
    }

    public PropertyDescriptor propertyDescriptor(Method method) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(method.getDeclaringClass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                if (!method.equals(propertyDescriptorArray[i].getReadMethod()) && !method.equals(propertyDescriptorArray[i].getWriteMethod())) continue;
                return propertyDescriptorArray[i];
            }
        }
        catch (Exception exception) {
            Output.out(exception.toString());
        }
        return null;
    }

    public PropertyDescriptor propertyDescriptor(String string) {
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(this.getClass());
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                if (!string.equals(propertyDescriptorArray[i].getName())) continue;
                return propertyDescriptorArray[i];
            }
        }
        catch (Exception exception) {
            Output.out(exception.toString());
        }
        return null;
    }

    public void ready() {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public void setClosed(boolean bl) {
        boolean bl2 = this.closed;
        this.closed = bl;
        this.fire(Transform.closed, (Object)new Boolean(bl2), (Object)new Boolean(this.closed));
    }

    public void setFinished(boolean bl) {
        boolean bl2 = this.finished;
        this.finished = bl;
        this.fire(Transform.finished, (Object)new Boolean(bl2), (Object)new Boolean(this.finished));
    }

    public void setProgress(int n) {
        if (this.progress >= n) {
            return;
        }
        int n2 = this.progress;
        if (n < 0) {
            n = 0;
        } else if (n > 100) {
            n = 100;
        }
        this.progress = n;
        this.fire(Transform.progress, (Object)new Integer(n2), (Object)new Integer(this.progress));
    }

    protected void setProgressScale(int n) {
        this.scale = n;
    }

    public boolean setProperty(String string, String string2) {
        try {
            PropertyDescriptor propertyDescriptor = this.propertyDescriptor(string);
            Method method = propertyDescriptor.getWriteMethod();
            Class<?>[] classArray = method.getParameterTypes();
            Class<?> clazz = classArray[0];
            if (clazz == (class$java$lang$String == null ? (class$java$lang$String = DefaultTransform.class$("java.lang.String")) : class$java$lang$String)) {
                Object[] objectArray = new Object[]{string2};
                method.invoke((Object)this, objectArray);
                return true;
            }
            Object object = TransformUtility.instance().stringToObject(string2, clazz);
            Object[] objectArray = new Object[]{object};
            method.invoke((Object)this, objectArray);
            return true;
        }
        catch (Exception exception) {
            Output.out(exception.toString());
            return false;
        }
    }

    protected void setScaledProgress(int n) {
        if (this.scale == 0) {
            this.scale = 1;
        }
        this.setProgress(n * 100 / this.scale);
    }

    public void setStarted(boolean bl) {
        boolean bl2 = this.started;
        this.started = bl;
        this.fire(Transform.started, (Object)new Boolean(bl2), (Object)new Boolean(this.started));
    }

    public void start() {
        this.preStart();
        this.postStart();
        this.setStarted(true);
        this.setProgress(100);
        this.setFinished(true);
        this.setClosed(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

