/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.uml;

import com.ibm.xmi.mod.Id;
import com.ibm.xmi.mod.ModelAPI;
import com.ibm.xmi.mod.ModelException;
import com.ibm.xmi.mod.ModelLink;
import com.ibm.xmi.mod.ModelProperty;
import com.ibm.xmi.mod.ModelType;
import com.ibm.xmi.mod.XMILoader;
import com.ibm.xmi.uml.Link;
import com.ibm.xmi.uml.Property;
import com.ibm.xmi.uml.Type;
import java.util.Vector;
import org.xml.sax.AttributeList;

class UMLXMILoader
extends XMILoader {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private String tag;

    public UMLXMILoader(ModelAPI modelAPI, int n, Vector vector) {
        super(modelAPI, n, vector);
    }

    protected void handleCreation(ModelType modelType, AttributeList attributeList) {
        if (modelType == Type.TAGGED_VALUE) {
            this.pushConstruct("Tagged Value");
        } else {
            super.handleCreation(modelType, attributeList);
        }
    }

    protected void setProperty(ModelProperty modelProperty, String string) {
        block11: {
            if (this.constructs.empty()) {
                return;
            }
            if (modelProperty == Property.TAG) {
                this.tag = string;
            } else {
                if (modelProperty == Property.TG_VALUE) {
                    Id id = (Id)this.constructs.peek();
                    ModelLink modelLink = (ModelLink)this.links.peek();
                    if (modelLink == null) {
                        return;
                    }
                    try {
                        if (modelLink == Link.TAGGED_VALUE) {
                            id.set("", this.tag, string);
                        } else if (modelLink == Link.REQUIRED_TAG) {
                            id.set("requiredTag", this.tag, string);
                        }
                        break block11;
                    }
                    catch (ModelException modelException) {
                        if (this.getDebug()) {
                            System.out.println("INTERNAL ERROR SETTING TAGGED-VALUE!!!!");
                        }
                        break block11;
                    }
                }
                super.setProperty(modelProperty, string);
            }
        }
    }
}

