/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.uml;

import com.ibm.xmi.mod.Metamodel;
import com.ibm.xmi.mod.ModelLink;
import com.ibm.xmi.mod.ModelType;
import com.ibm.xmi.mod.TestBuilder;
import com.ibm.xmi.mod.TestScript;
import com.ibm.xmi.uml.Link;
import com.ibm.xmi.uml.Property;
import com.ibm.xmi.uml.Type;
import java.util.Enumeration;
import java.util.Vector;

class UMLSaveTestBuilder
extends TestBuilder {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String CONTAINER = "container";
    private static final String CONSTRUCT = "construct";
    private static final String LINK = "link";
    private static final String VALUE = "value";
    int testNum = -1;

    protected UMLSaveTestBuilder(String string, Metamodel metamodel, ModelType modelType, int n, boolean bl, boolean bl2) {
        super(string, metamodel, modelType, n, bl, bl2);
    }

    public Vector build() {
        Vector vector = new Vector();
        this.testNum = this.getFirstNum();
        if (!this.buildBasicSaveTest(vector, this.testNum)) {
            return null;
        }
        ++this.testNum;
        if (!this.buildSaveLinkTest(vector, this.testNum)) {
            return null;
        }
        ++this.testNum;
        Vector vector2 = this.metamodel.getContainerTypes(this.getType());
        if (vector2 == null) {
            return vector;
        }
        if (!this.buildAddSaveTest((Type)vector2.firstElement(), vector, this.testNum, 1)) {
            return null;
        }
        ++this.testNum;
        if (this.getType() == Type.GUARD || this.getType() == Type.ACTION_SEQUENCE) {
            return vector;
        }
        if (!this.buildAddSaveTest((Type)vector2.firstElement(), vector, this.testNum, 2)) {
            return null;
        }
        ++this.testNum;
        return vector;
    }

    private boolean buildAddSaveTest(Type type, Vector vector, int n, int n2) {
        Vector<Object> vector2 = new Vector<Object>();
        vector2.addElement("3");
        vector2.addElement(type);
        vector2.addElement("" + n2);
        return this.buildTest(n, vector2, vector);
    }

    private boolean buildBasicSaveTest(Vector vector, int n) {
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement("1");
        return this.buildTest(n, vector2, vector);
    }

    private boolean buildSaveLinkTest(Vector vector, int n) {
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement("2");
        return this.buildTest(n, vector2, vector);
    }

    private Vector getContainedTypes() {
        Vector<Type> vector = new Vector<Type>();
        Enumeration enumeration = this.getMetamodel().getAllTypes();
        while (enumeration.hasMoreElements()) {
            Vector vector2;
            Type type = (Type)enumeration.nextElement();
            if (type == Type.TAGGED_VALUE || (vector2 = this.getMetamodel().getContainerTypes(type)) == null || !vector2.contains(this.getType())) continue;
            vector.addElement(type);
        }
        return vector;
    }

    protected String getTestType() {
        return "ls";
    }

    private void makeAddOneOfEach(TestScript testScript, Vector vector) {
        if (vector == null || vector.size() == 0) {
            return;
        }
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Type type = (Type)enumeration.nextElement();
            testScript.add(CONSTRUCT, "Type." + this.getName(type), null, "id");
            testScript.setLabel("contained" + ++n);
        }
    }

    protected boolean makeContent(TestScript testScript, Vector vector) {
        int n;
        Object object;
        int n2 = 0;
        if (vector.firstElement().equals("2")) {
            n2 = this.makeLinkedConstructs(testScript);
        }
        if (vector.firstElement().equals("1") || vector.firstElement().equals("2")) {
            testScript.add("s", "Type." + this.getName(this.getType()), null, "id");
            testScript.setLabel(CONSTRUCT);
        } else {
            object = (Type)vector.elementAt(1);
            testScript.add("s", "Type." + this.getName((ModelType)object), null, "id");
            testScript.setLabel(CONTAINER);
            n = 0;
            try {
                n = Integer.parseInt((String)vector.elementAt(2));
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (int i = 1; i <= n; ++i) {
                testScript.add(CONTAINER, "Type." + this.getName(this.getType()), null, "id");
                testScript.getUUID();
            }
        }
        if (vector.firstElement().equals("1")) {
            this.makeProperties(testScript);
        }
        if (vector.firstElement().equals("1")) {
            n2 = this.makeLinkedConstructs(testScript);
        }
        if (vector.firstElement().equals("1") || vector.firstElement().equals("2")) {
            this.makeSetLinks(testScript);
        }
        if (vector.firstElement().equals("1")) {
            this.makeAddOneOfEach(testScript, this.getContainedTypes());
        }
        object = new Vector();
        if (vector.firstElement().equals("1")) {
            ((Vector)object).addElement(CONSTRUCT);
            for (n = 1; n <= n2; ++n) {
                ((Vector)object).addElement(LINK + n);
            }
        } else if (vector.firstElement().equals("2")) {
            for (n = 1; n <= n2; ++n) {
                ((Vector)object).addElement(LINK + n);
            }
            ((Vector)object).addElement(CONSTRUCT);
        } else {
            ((Vector)object).addElement(CONTAINER);
        }
        testScript.save((Vector)object, this.getTestName(this.testNum) + ".xml", 1);
        return true;
    }

    protected boolean makeDescription(TestScript testScript, Vector vector) {
        if (vector.size() < 1) {
            return false;
        }
        String string = "Test if can save ";
        if (vector.firstElement().equals("1")) {
            string = string + "properties, links, tagged values, and sets of tagged values for ";
            string = string + this.getType().toString();
        } else if (vector.firstElement().equals("2")) {
            string = string + "links of ";
            string = string + this.getType().toString();
            string = string + " if linked construct added before links are set";
        } else {
            string = vector.elementAt(2).equals("1") ? string + this.getType().toString() + " added to container" : string + "2 " + this.getType().toString() + "s added to container";
        }
        string = string + this.getModeString();
        testScript.setDescription(string);
        return true;
    }

    private int makeLinkedConstructs(TestScript testScript) {
        Vector vector = this.getMetamodel().getLinks(this.getType());
        int n = 0;
        if (vector == null || vector.size() == 0) {
            return n;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Link link = (Link)vector.elementAt(i);
            Type type = link.getLegalType();
            if (link.isContainment()) continue;
            testScript.add("s", "Type." + this.getName(type), null, "id");
            testScript.setLabel(LINK + (i + 1));
            ++n;
        }
        return n;
    }

    private void makeProperties(TestScript testScript) {
        Vector vector = this.getMetamodel().getProperties(this.getType());
        if (vector == null || vector.size() == 0) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            Object object2;
            Property property = (Property)vector.elementAt(i);
            if (!property.isClass()) {
                int n;
                object2 = VALUE + (i + 1);
                if (!property.getLegalValues().equals("") && (n = ((String)(object = property.getLegalValues())).indexOf(" ")) != -1) {
                    object2 = ((String)object).substring(0, n);
                }
                testScript.set(CONSTRUCT, this.getName(property), (String)object2, "");
                continue;
            }
            object2 = property.getType();
            object = property.getLink();
            testScript.create("Type." + this.getName((ModelType)object2), "id");
            testScript.setLabel(VALUE + (i + 1));
            testScript.add(CONSTRUCT, "Link." + this.getName((ModelLink)object), VALUE + (i + 1), "");
        }
        testScript.set(CONSTRUCT, "", "t", "v", "");
        testScript.set(CONSTRUCT, "", "t1", "v1", "");
        testScript.set(CONSTRUCT, "s1", "st1", "stv1", "");
        testScript.set(CONSTRUCT, "s1", "st12", "stv12", "");
        testScript.set(CONSTRUCT, "s2", "st2", "stv2", "");
        testScript.set(CONSTRUCT, "s2", "st22", "stv22", "");
    }

    private void makeSetLinks(TestScript testScript) {
        Vector vector = this.getMetamodel().getLinks(this.getType());
        if (vector == null || vector.size() == 0) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Link link = (Link)vector.elementAt(i);
            if (link.isContainment()) continue;
            testScript.add(CONSTRUCT, "Link." + this.getName(link), LINK + (i + 1), "");
        }
    }
}

