/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.uml;

import com.ibm.xmi.mod.MetamodelManager;
import com.ibm.xmi.mod.ModelAPI;
import com.ibm.xmi.mod.ModelLink;
import com.ibm.xmi.mod.ModelProperty;
import com.ibm.xmi.mod.ModelType;
import com.ibm.xmi.uml.BadContainerException;
import com.ibm.xmi.uml.BadCriteriaException;
import com.ibm.xmi.uml.BadIdException;
import com.ibm.xmi.uml.DuplicateException;
import com.ibm.xmi.uml.Id;
import com.ibm.xmi.uml.InternalErrorException;
import com.ibm.xmi.uml.Link;
import com.ibm.xmi.uml.NoContainLinkException;
import com.ibm.xmi.uml.NoLinkException;
import com.ibm.xmi.uml.NullParameterException;
import com.ibm.xmi.uml.Property;
import com.ibm.xmi.uml.SaveMemoryException;
import com.ibm.xmi.uml.Type;
import com.ibm.xmi.uml.UML;
import com.ibm.xmi.uml.UMLException;
import java.util.Enumeration;
import java.util.Vector;

class StringAPI {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private UML api;
    private MetamodelManager mm;
    private final String NULL = "UMLAPI.null";
    private final String STRING_PREFIX = "String.";
    private Id lastId = null;

    StringAPI(UML uML, ModelAPI modelAPI) {
        this.api = uML;
        this.mm = modelAPI.getMetamodelManager();
    }

    private void assembleCriteria(Vector vector, String[] stringArray) {
        for (int i = 3; i < stringArray.length - 1; ++i) {
            Object object = null;
            if (!stringArray[i].startsWith("String.")) {
                object = this.mm.getMMConstruct(stringArray[i]);
            }
            if (object != null && object instanceof ModelProperty) {
                vector.addElement(object);
                if (i + 1 >= stringArray.length - 1) continue;
                vector.addElement(stringArray[++i]);
                continue;
            }
            Object object2 = null;
            if (!stringArray[i].startsWith("String.")) {
                object2 = this.mm.getMMConstruct(stringArray[i]);
            }
            if (object2 != null && object2 instanceof ModelLink) {
                Id id;
                vector.addElement(object2);
                if (i + 1 >= stringArray.length - 1) continue;
                if ((id = this.getId(stringArray[++i])) != null) {
                    vector.addElement(id);
                    continue;
                }
                vector.addElement(stringArray[i - 1]);
                continue;
            }
            vector.addElement(stringArray[i]);
        }
    }

    public String execute(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = this.getWords(string);
        if (stringArray[0].equals("add")) {
            return this.executeAdd(stringArray);
        }
        if (stringArray[0].equals("create")) {
            return this.executeCreate(stringArray);
        }
        if (stringArray[0].equals("delete") || stringArray[0].equals("del")) {
            return this.executeDelete(stringArray);
        }
        if (stringArray[0].equals("get")) {
            return this.executeGet(stringArray);
        }
        if (stringArray[0].equals("getFilePath")) {
            return this.executeGetFilePath(stringArray);
        }
        if (stringArray[0].equals("getHref")) {
            return this.executeGetHref(stringArray);
        }
        if (stringArray[0].equals("getLinks")) {
            return this.executeGetLinks(stringArray);
        }
        if (stringArray[0].equals("getLoadIds")) {
            return this.executeGetLoadIds(stringArray);
        }
        if (stringArray[0].equals("getProperties")) {
            return this.executeGetProperties(stringArray);
        }
        if (stringArray[0].equals("getSession")) {
            return this.executeGetSession(stringArray);
        }
        if (stringArray[0].equals("getSets")) {
            return this.executeGetSets(stringArray);
        }
        if (stringArray[0].equals("getTags")) {
            return this.executeGetTags(stringArray);
        }
        if (stringArray[0].equals("getUUID")) {
            return this.executeGetUUID(stringArray);
        }
        if (stringArray[0].equals("getUUIDREF")) {
            return this.executeGetUUIDREF(stringArray);
        }
        if (stringArray[0].equals("isLoaded")) {
            return this.executeIsLoaded(stringArray);
        }
        if (stringArray[0].equals("load")) {
            return this.executeLoad(stringArray);
        }
        if (stringArray[0].equals("save")) {
            return this.executeSave(stringArray);
        }
        if (stringArray[0].equals("set")) {
            return this.executeSet(stringArray);
        }
        if (stringArray[0].equals("setDemandLoad")) {
            return this.executeSetDemandLoad(stringArray);
        }
        if (stringArray[0].equals("setFilePath")) {
            return this.executeSetFilePath(stringArray);
        }
        if (stringArray[0].equals("setLabel")) {
            return this.executeSetLabel(stringArray);
        }
        if (stringArray[0].equals("setLog")) {
            return this.executeSetLog(stringArray);
        }
        if (stringArray[0].equals("setUUID")) {
            return this.executeSetUUID(stringArray);
        }
        if (stringArray[0].equals("setUUIDREF")) {
            return this.executeSetUUIDREF(stringArray);
        }
        if (stringArray[0].equals("setSaveMemory")) {
            return this.executeSetSaveMemory(stringArray);
        }
        return "Error:  Illegal method name";
    }

    private String executeAdd(String[] stringArray) {
        if (stringArray.length < 3) {
            return "Error:  Null parameter exception";
        }
        Id id = this.getId(stringArray[1]);
        if (id == null) {
            return "Error:  Bad Id exception -- id: '" + stringArray[1] + "'";
        }
        Object object = null;
        if (!stringArray[2].startsWith("String.")) {
            object = this.mm.getMMConstruct(stringArray[2]);
        }
        if (object == null) {
            return "Error:  Illegal metamodel construct: '" + stringArray[2] + "'";
        }
        if (object instanceof ModelLink) {
            return this.executeAddLink(id, (ModelLink)object, stringArray);
        }
        if (!(object instanceof ModelType)) {
            return "Error:  Not a type or link: '" + stringArray[2] + "'";
        }
        ModelType modelType = (ModelType)object;
        String string = null;
        boolean bl = true;
        if (stringArray.length > 3) {
            string = stringArray[3];
        }
        if (stringArray.length > 4) {
            if (stringArray[4].equals("false")) {
                bl = false;
            } else if (stringArray[4].equals("true")) {
                bl = true;
            } else {
                return "Error:  Illegal boolean value: '" + stringArray[3] + "'";
            }
        }
        Type type = modelType instanceof Type ? (Type)modelType : Type.convertCoreTypeToType(modelType);
        try {
            this.lastId = this.api.add(id, type, string, bl);
        }
        catch (UMLException uMLException) {
            return this.printException(uMLException);
        }
        return this.lastId.toString();
    }

    private String executeAddLink(Id id, ModelLink modelLink, String[] stringArray) {
        if (stringArray.length < 4) {
            return "Error:  Null Parameter exception";
        }
        if (stringArray.length != 4) {
            return "Error:  Wrong number of parameters";
        }
        Id id2 = this.getId(stringArray[3]);
        if (id2 == null) {
            return "Error:  Bad id exception -- id: '" + stringArray[3] + "'";
        }
        Link link = modelLink instanceof Link ? (Link)modelLink : Link.convertCoreLinkToLink(modelLink);
        try {
            this.api.add(id, link, id2);
        }
        catch (Exception exception) {
            return this.printException(exception);
        }
        return "";
    }

    private String executeCreate(String[] stringArray) {
        if (stringArray.length < 2) {
            return "Error:  Null parameter exception";
        }
        Object object = this.mm.getMMConstruct(stringArray[1]);
        if (object == null || !(object instanceof ModelType)) {
            return "Error:  Illegal type: " + stringArray[1];
        }
        Id id = null;
        Type type = object instanceof Type ? (Type)object : Type.convertCoreTypeToType((ModelType)object);
        try {
            id = this.api.create(type);
        }
        catch (UMLException uMLException) {
            return this.printException(uMLException);
        }
        if (id != null) {
            this.lastId = id;
        }
        Vector<Id> vector = new Vector<Id>(1);
        vector.addElement(id);
        return this.printVector(vector);
    }

    private String executeDelete(String[] stringArray) {
        if (stringArray.length < 2) {
            return "Error:  Null parameter exception";
        }
        if (stringArray.length == 2) {
            return this.executeDeleteId(stringArray);
        }
        if (stringArray.length == 4) {
            return this.executeDeleteAssoc(stringArray);
        }
        return "Error:  Wrong number of parameters";
    }

    private String executeDeleteAssoc(String[] stringArray) {
        if (stringArray.length < 4) {
            return "Error:  Null parameter exception";
        }
        Id id = this.getId(stringArray[1]);
        if (id == null) {
            return "Error:  Bad Id exception -- id: '" + stringArray[1] + "'";
        }
        Object object = null;
        if (!stringArray[2].startsWith("String.")) {
            object = this.mm.getMMConstruct(stringArray[2]);
        }
        if (object == null || !(object instanceof ModelLink)) {
            return "Error:  Illegal link name: '" + stringArray[2] + "'";
        }
        Id id2 = this.getId(stringArray[3]);
        if (id2 == null) {
            return "Error:  Bad Id exception -- id: '" + stringArray[3] + "'";
        }
        Link link = object instanceof Link ? (Link)object : Link.convertCoreLinkToLink((ModelLink)object);
        try {
            this.api.delete(id, link, id2);
        }
        catch (Exception exception) {
            return this.printException(exception);
        }
        return "";
    }

    private String executeDeleteId(String[] stringArray) {
        Id id = this.getId(stringArray[1]);
        if (id == null) {
            return "Error:  Bad Id exception -- id: '" + stringArray[1] + "'";
        }
        Vector vector = null;
        try {
            vector = this.api.delete(id);
        }
        catch (UMLException uMLException) {
            return this.printException(uMLException);
        }
        return this.printVector(vector);
    }

    private String executeGet(String[] stringArray) {
        if (stringArray.length < 3) {
            return "Error:  Null parameter exception";
        }
        Id id = this.getId(stringArray[1]);
        if (id == null) {
            return "Error:  Bad Id exception -- id: '" + stringArray[1] + "'";
        }
        Object object = null;
        if (!stringArray[2].startsWith("String.")) {
            object = this.mm.getMMConstruct(stringArray[2]);
        }
        if (object == null && (stringArray[2].startsWith("Link.") || stringArray[2].startsWith("Type.") || stringArray[2].startsWith("Property."))) {
            return "Error:  Illegal metamodel construct '" + stringArray[2] + "'";
        }
        if (object != null && object instanceof ModelLink) {
            return this.executeGetLink(id, (ModelLink)object, stringArray);
        }
        if (object != null && object instanceof ModelType) {
            return this.executeGetType(id, (ModelType)object, stringArray);
        }
        if (object != null && object instanceof ModelProperty) {
            return this.executeGetProperty(id, (ModelProperty)object);
        }
        if (stringArray.length == 3) {
            return this.executeGetTag(id, "", stringArray[2]);
        }
        if (stringArray.length == 4) {
            if (stringArray[2].startsWith("String.")) {
                return this.executeGetTag(id, stringArray[2].substring("String.".length()), stringArray[3]);
            }
            return this.executeGetTag(id, stringArray[2], stringArray[3]);
        }
        return "Error:  Wrong number of parameters";
    }

    private String executeGetFilePath(String[] stringArray) {
        if (stringArray.length > 1) {
            return "Error:  Wrong number of parameters";
        }
        return this.api.getFilePath();
    }

    private String executeGetHref(String[] stringArray) {
        if (stringArray.length > 2) {
            return "Error:  Wrong number of parameters";
        }
        if (stringArray.length == 2) {
            this.lastId = this.getId(stringArray[1]);
        }
        if (this.lastId == null) {
            return "Error:  No current id.";
        }
        return this.lastId.getHref();
    }

    private String executeGetLink(Id id, ModelLink modelLink, String[] stringArray) {
        boolean bl;
        if (stringArray.length < 4) {
            return "Error:  Null parameter exception";
        }
        if (stringArray[3].equals("false")) {
            bl = false;
        } else if (stringArray[3].equals("true")) {
            bl = true;
        } else {
            return "Error:  Illegal boolean value: '" + stringArray[3] + "'";
        }
        Vector vector = null;
        Link link = modelLink instanceof Link ? (Link)modelLink : Link.convertCoreLinkToLink(modelLink);
        try {
            vector = this.api.get(id, link, bl);
        }
        catch (Exception exception) {
            return this.printException(exception);
        }
        return this.printVector(vector);
    }

    private String executeGetLinks(String[] stringArray) {
        if (stringArray.length < 2) {
            return "Error:  Null parameter exception";
        }
        Id id = this.getId(stringArray[1]);
        if (id == null) {
            return "Error:  Bad Id exception -- id: '" + stringArray[1] + "'";
        }
        Vector vector = null;
        try {
            vector = this.api.getLinks(id);
        }
        catch (Exception exception) {
            return this.printException(exception);
        }
        return this.printVector(vector);
    }

    private String executeGetLoadIds(String[] stringArray) {
        if (stringArray.length > 1) {
            return "Error:  Too many input parameters";
        }
        Vector vector = this.api.getLoadIds();
        return this.printVector(vector);
    }

    private String executeGetProperties(String[] stringArray) {
        if (stringArray.length < 2) {
            return "Error:  Null parameter exception";
        }
        Id id = this.getId(stringArray[1]);
        if (id == null) {
            return "Error:  Bad Id exception -- id: '" + stringArray[1] + "'";
        }
        Vector vector = null;
        try {
            vector = this.api.getProperties(id);
        }
        catch (Exception exception) {
            return this.printException(exception);
        }
        return this.printVector(vector);
    }

    private String executeGetProperty(Id id, ModelProperty modelProperty) {
        String string = null;
        Property property = modelProperty instanceof Property ? (Property)modelProperty : Property.convertCorePropertyToProperty(modelProperty);
        try {
            string = this.api.get(id, property);
        }
        catch (Exception exception) {
            return this.printException(exception);
        }
        if (string == null) {
            return string;
        }
        return "'" + string + "'";
    }

    private String executeGetSession(String[] stringArray) {
        if (stringArray.length != 1) {
            return "Error:  Wrong number of parameters";
        }
        this.lastId = this.api.getSession();
        return "";
    }

    private String executeGetSets(String[] stringArray) {
        if (stringArray.length < 2) {
            return "Error:  Null parameter exception";
        }
        Id id = this.getId(stringArray[1]);
        if (id == null) {
            return "Error:  Bad Id exception -- id: '" + stringArray[1] + "'";
        }
        Vector vector = null;
        try {
            vector = this.api.getSets(id);
        }
        catch (Exception exception) {
            return this.printException(exception);
        }
        return this.printVector(vector);
    }

    private String executeGetTag(Id id, String string, String string2) {
        String string3 = null;
        try {
            string3 = this.api.get(id, string, string2);
        }
        catch (Exception exception) {
            return this.printException(exception);
        }
        if (string3 == null) {
            return string3;
        }
        return "'" + string3 + "'";
    }

    private String executeGetTags(String[] stringArray) {
        if (stringArray.length < 3) {
            return "Error:  Null parameter exception";
        }
        Id id = this.getId(stringArray[1]);
        if (id == null) {
            return "Error:  Bad Id exception -- id: '" + stringArray[1] + "'";
        }
        Vector vector = null;
        try {
            vector = this.api.getTags(id, stringArray[2]);
        }
        catch (Exception exception) {
            return this.printException(exception);
        }
        return this.printVector(vector);
    }

    private String executeGetType(Id id, ModelType modelType, String[] stringArray) {
        boolean bl;
        if (stringArray.length < 4) {
            return "Error:  Wrong number of parameters.";
        }
        Vector vector = new Vector();
        int n = stringArray.length;
        if (stringArray[n - 1].equals("true")) {
            bl = true;
        } else if (stringArray[n - 1].equals("false")) {
            bl = false;
        } else {
            return "Error:  Illegal boolean value: '" + stringArray[n - 1] + "'";
        }
        Vector vector2 = null;
        if (stringArray.length > 4) {
            this.assembleCriteria(vector, stringArray);
            Type type = modelType instanceof Type ? (Type)modelType : Type.convertCoreTypeToType(modelType);
            try {
                vector2 = this.api.get(id, type, vector, bl);
            }
            catch (Exception exception) {
                return this.printException(exception);
            }
        }
        Type type = modelType instanceof Type ? (Type)modelType : Type.convertCoreTypeToType(modelType);
        try {
            vector2 = this.api.get(id, type, bl);
        }
        catch (Exception exception) {
            return this.printException(exception);
        }
        return this.printVector(vector2);
    }

    private String executeGetUUID(String[] stringArray) {
        if (stringArray.length > 2) {
            return "Error:  Wrong number of parameters";
        }
        if (stringArray.length == 2) {
            this.lastId = this.getId(stringArray[1]);
        }
        if (this.lastId == null) {
            return "Error:  No current id.";
        }
        return this.lastId.getUUID();
    }

    private String executeGetUUIDREF(String[] stringArray) {
        if (stringArray.length > 2) {
            return "Error:  Wrong number of parameters";
        }
        if (stringArray.length == 2) {
            this.lastId = this.getId(stringArray[1]);
        }
        if (this.lastId == null) {
            return "Error:  No current id.";
        }
        return this.lastId.getUUIDREF();
    }

    private String executeIsLoaded(String[] stringArray) {
        if (stringArray.length > 2) {
            return "Error:  Wrong number of parameters";
        }
        if (stringArray.length == 2) {
            this.lastId = this.getId(stringArray[1]);
        }
        if (this.lastId == null) {
            return "Error:  No current id.";
        }
        if (this.lastId.isLoaded()) {
            return "true";
        }
        return "false";
    }

    private String executeLoad(String[] stringArray) {
        if (stringArray.length != 4) {
            return "Error:  Wrong number of parameters";
        }
        if (!stringArray[3].equals("true") && !stringArray[3].equals("false")) {
            return "Error:  Illegal boolean value.";
        }
        boolean bl = true;
        if (stringArray[3].equals("false")) {
            bl = false;
        }
        try {
            int n = Integer.parseInt(stringArray[2]);
            this.api.load(stringArray[1], null, n, bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.printException(exception);
        }
        return "";
    }

    private String executeSave(String[] stringArray) {
        Id id;
        if (stringArray.length < 4) {
            return "Error:  Null parameter exception";
        }
        Vector<Id> vector = new Vector<Id>();
        int n = 0;
        do {
            if ((id = this.getId(stringArray[++n])) == null) continue;
            vector.addElement(id);
        } while (id != null);
        if (n == 1) {
            return "Error:  Bad Id exception -- id: '" + stringArray[1] + "'";
        }
        Vector vector2 = new Vector();
        try {
            int n2 = Integer.parseInt(stringArray[n + 1]);
            this.api.save(vector, stringArray[n], n2, vector2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return this.printException(exception);
        }
        return this.printVector(vector2);
    }

    private String executeSet(String[] stringArray) {
        if (stringArray.length < 4) {
            return "Error:  Null parameter exception";
        }
        Id id = this.getId(stringArray[1]);
        if (id == null) {
            return "Error:  Bad Id exception -- id: '" + stringArray[1] + "'";
        }
        Object object = null;
        if (!stringArray[2].startsWith("String.")) {
            object = this.mm.getMMConstruct(stringArray[2]);
        }
        if (object == null && stringArray[2].startsWith("Property.")) {
            return "Error:  Unknown property: " + stringArray[2];
        }
        if (object != null && object instanceof ModelProperty) {
            return this.executeSetProperty(id, (ModelProperty)object, stringArray);
        }
        return this.executeSetTag(id, stringArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String executeSetDemandLoad(String[] stringArray) {
        boolean bl = false;
        if (stringArray.length != 2) return "Error:  Wrong number of arguments";
        if (stringArray[1].equals("true")) {
            bl = true;
        } else {
            if (!stringArray[1].equals("false")) return "Error:  Illegal boolean value: '" + stringArray[1] + "'";
            bl = false;
        }
        this.api.setDemandLoad(bl);
        if (!bl) return "false";
        return "true";
    }

    private String executeSetFilePath(String[] stringArray) {
        if (stringArray.length < 2) {
            return "Error:  Wrong number of parameters.";
        }
        this.api.setFilePath(stringArray[1]);
        return stringArray[1];
    }

    private String executeSetLabel(String[] stringArray) {
        if (stringArray.length < 2) {
            return "Error:  Wrong number of parameters";
        }
        if (this.lastId == null) {
            return "Error:  No current id";
        }
        if (stringArray[1].equals("UMLAPI.null")) {
            this.lastId.setLabel(null);
        } else {
            this.lastId.setLabel(stringArray[1]);
        }
        if (stringArray[1].equals("UMLAPI.null")) {
            return null;
        }
        return stringArray[1];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String executeSetLog(String[] stringArray) {
        boolean bl = false;
        if (stringArray.length != 2) return "Error:  Wrong number of arguments";
        if (stringArray[1].equals("true")) {
            bl = true;
        } else {
            if (!stringArray[1].equals("false")) return "Error:  Illegal boolean value: '" + stringArray[1] + "'";
            bl = false;
        }
        this.api.setLog(bl);
        if (!bl) return "false";
        return "true";
    }

    private String executeSetProperty(Id id, ModelProperty modelProperty, String[] stringArray) {
        if (stringArray.length < 4) {
            return "Error:  Null Parameter exception";
        }
        if (stringArray.length != 4) {
            return "Error:  Wrong number of parameters";
        }
        String string = null;
        if (!stringArray[3].equals("UMLAPI.null")) {
            string = stringArray[3];
        }
        Property property = modelProperty instanceof Property ? (Property)modelProperty : Property.convertCorePropertyToProperty(modelProperty);
        try {
            this.api.set(id, property, string);
        }
        catch (Exception exception) {
            return this.printException(exception);
        }
        return "";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String executeSetSaveMemory(String[] stringArray) {
        boolean bl = false;
        if (stringArray.length != 2) return "Error:  Wrong number of arguments";
        if (stringArray[1].equals("true")) {
            bl = true;
        } else {
            if (!stringArray[1].equals("false")) return "Error:  Illegal boolean value: '" + stringArray[1] + "'";
            bl = false;
        }
        try {
            this.api.setSaveMemory(bl);
        }
        catch (Exception exception) {
            return this.printException(exception);
        }
        if (!bl) return "false";
        return "true";
    }

    private String executeSetTag(Id id, String[] stringArray) {
        String string;
        String string2 = null;
        String string3 = null;
        if (stringArray.length == 4) {
            string = stringArray[2];
            if (!stringArray[3].equals("UMLAPI.null")) {
                string3 = stringArray[3];
            }
        } else if (stringArray.length == 5) {
            if (!stringArray[2].equals("UMLAPI.null")) {
                string2 = stringArray[2];
            }
            string = stringArray[3];
            if (!stringArray[4].equals("UMLAPI.null")) {
                string3 = stringArray[4];
            }
        } else {
            return "Error:  Wrong number of parameters";
        }
        try {
            if (stringArray.length == 4) {
                this.api.set(id, string, string3);
            } else {
                this.api.set(id, string2, string, string3);
            }
        }
        catch (Exception exception) {
            return this.printException(exception);
        }
        return "";
    }

    private String executeSetUUID(String[] stringArray) {
        if (stringArray.length < 2) {
            return "Error:  Wrong number of parameters.";
        }
        if (this.lastId == null) {
            return "Error:  No current id.";
        }
        try {
            if (stringArray[1].equals("UMLAPI.null")) {
                this.lastId.setUUID(null);
            } else {
                this.lastId.setUUID(stringArray[1]);
            }
        }
        catch (Exception exception) {
            return this.printException(exception);
        }
        if (stringArray[1].equals("UMLAPI.null")) {
            return null;
        }
        return stringArray[1];
    }

    private String executeSetUUIDREF(String[] stringArray) {
        if (stringArray.length < 2) {
            return "Error:  Wrong number of parameters.";
        }
        if (this.lastId == null) {
            return "Error:  No current id.";
        }
        if (stringArray[1].equals("UMLAPI.null")) {
            this.lastId.setUUIDREF(null);
        } else {
            this.lastId.setUUIDREF(stringArray[1]);
        }
        if (stringArray[1].equals("UMLAPI.null")) {
            return null;
        }
        return stringArray[1];
    }

    private Id getId(String string) {
        Id id = this.api.getId(string);
        if (id != null) {
            return id;
        }
        Vector vector = this.api.getIds(string);
        if (vector != null && vector.size() == 1) {
            id = (Id)vector.firstElement();
        }
        return id;
    }

    private String[] getWords(String string) {
        string = string.trim();
        Vector<String> vector = new Vector<String>(5);
        if (string.length() == 0) {
            return null;
        }
        String string2 = "";
        boolean bl = false;
        boolean bl2 = false;
        int n = string.length();
        block5: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': {
                    if (bl) {
                        string2 = string2 + c;
                        continue block5;
                    }
                    if (string2.length() == 0 && !bl2) continue block5;
                    vector.addElement(string2);
                    string2 = "";
                    bl2 = false;
                    continue block5;
                }
                case '\"': {
                    if (bl) {
                        bl2 = true;
                    }
                    bl = !bl;
                    continue block5;
                }
                case '\\': {
                    string2 = string2 + string.charAt(++i);
                    continue block5;
                }
                default: {
                    string2 = string2 + c;
                }
            }
        }
        if (string2.length() > 0 || bl2) {
            vector.addElement(string2);
        }
        if (vector.size() == 0) {
            return null;
        }
        String[] stringArray = new String[vector.size()];
        Enumeration enumeration = vector.elements();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            if (n2 == 1) {
                String string3 = (String)enumeration.nextElement();
                if (string3.charAt(0) == '\"') {
                    string3 = string3.substring(1);
                }
                if (string3.charAt(string3.length() - 1) == '\"') {
                    string3 = string3.substring(0, string3.length() - 1);
                }
                stringArray[n2++] = string3;
                continue;
            }
            stringArray[n2++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    private String printException(Exception exception) {
        if (exception instanceof BadIdException) {
            return "Error:  Bad Id exception -- id: '" + ((BadIdException)exception).getId() + "'";
        }
        if (exception instanceof DuplicateException) {
            return "Error:  Duplicate exception";
        }
        if (exception instanceof NoLinkException) {
            return "Error:  No link exception: assoc: " + ((NoLinkException)exception).getLink();
        }
        if (exception instanceof NullParameterException) {
            return "Error:  Null parameter exception";
        }
        if (exception instanceof SaveMemoryException) {
            return "Error:  Save memory exception";
        }
        if (exception instanceof BadCriteriaException) {
            return "Error:  Bad criteria exception";
        }
        if (exception instanceof BadContainerException) {
            return "Error:  Bad container exception";
        }
        if (exception instanceof InternalErrorException) {
            return "Error:  Internal error exception";
        }
        if (exception instanceof NoContainLinkException) {
            return "Error:  No contain link exception: " + ((NoContainLinkException)exception).getConstruct();
        }
        return "Error:  " + exception.toString();
    }

    private String printVector(Vector vector) {
        String string;
        String string2 = "";
        if (vector == null) {
            return null;
        }
        if (vector.size() == 0) {
            return string2;
        }
        string2 = vector.firstElement() instanceof String ? ((string = (String)vector.firstElement()).equals("") ? "''" : string) : vector.firstElement().toString();
        if (vector.size() > 1) {
            for (int i = 1; i < vector.size(); ++i) {
                if (vector.elementAt(i) instanceof String) {
                    String string3 = (String)vector.elementAt(i);
                    if (string3.equals("")) {
                        string2 = string2 + " ''";
                        continue;
                    }
                    string2 = string2 + " " + string3;
                    continue;
                }
                string2 = string2 + " " + vector.elementAt(i);
            }
        }
        return string2;
    }
}

