/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.uml;

import com.ibm.xmi.mod.ModelAPI;
import com.ibm.xmi.mod.ModelException;
import com.ibm.xmi.mod.ModelType;
import com.ibm.xmi.uml.ConvertException;
import com.ibm.xmi.uml.Link;
import com.ibm.xmi.uml.Property;
import com.ibm.xmi.uml.Type;
import com.ibm.xmi.uml.UML;
import com.ibm.xmi.uml.UMLException;
import java.util.EventListener;
import java.util.Vector;
import java.util.zip.ZipOutputStream;

public class Id {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private com.ibm.xmi.mod.Id coreId;
    private UML api;

    Id(com.ibm.xmi.mod.Id id, UML uML) {
        this.coreId = id;
        this.api = uML;
        uML.registerCoreId(id, this);
    }

    public void add(Link link, Id id) throws UMLException {
        this.api.add(this, link, id);
    }

    public Id add(Type type, String string) throws UMLException {
        return this.api.add(this, type, string);
    }

    public Id add(Type type, String string, boolean bl) throws UMLException {
        return this.api.add(this, type, string, bl);
    }

    public void addListener(EventListener eventListener) throws UMLException {
        this.api.addListener(this, eventListener);
    }

    public void check(boolean bl) throws UMLException {
        this.api.check(this, bl);
    }

    void clear() {
        this.coreId = null;
    }

    public static String createUUID() {
        return Id.makeUUID();
    }

    public Vector delete() throws UMLException {
        return this.api.delete(this);
    }

    public void delete(Link link, Id id) throws UMLException {
        this.api.delete(this, link, id);
    }

    public Vector get(Link link, boolean bl) throws UMLException {
        return this.api.get(this, link, bl);
    }

    public String get(Property property) throws UMLException {
        return this.api.get(this, property);
    }

    public Vector get(Type type, Vector vector, boolean bl) throws UMLException {
        return this.api.get(this, type, vector, bl);
    }

    public Vector get(Type type, boolean bl) throws UMLException {
        return this.api.get(this, type, bl);
    }

    public String get(String string) throws UMLException {
        return this.api.get(this, string);
    }

    public String get(String string, String string2) throws UMLException {
        return this.api.get(this, string, string2);
    }

    public UML getAPI() {
        return this.api;
    }

    com.ibm.xmi.mod.Id getCoreId() {
        return this.coreId;
    }

    public String getHref() {
        return this.coreId.getHref();
    }

    public static Id getId(String string) {
        com.ibm.xmi.mod.Id id = ModelAPI.instance().getIds().getId(string);
        if (id != null) {
            return UML.instance().getId(id);
        }
        return null;
    }

    public static Vector getIds(String string) {
        Vector vector = ModelAPI.instance().getIds().getIdsFromLabel(string);
        Vector<Id> vector2 = null;
        if (vector != null) {
            vector2 = new Vector<Id>(vector.size());
            for (int i = 0; i < vector.size(); ++i) {
                vector2.addElement(UML.instance().getId((com.ibm.xmi.mod.Id)vector.elementAt(i)));
            }
        }
        return vector2;
    }

    public static Vector getIdsFromUUID(String string) {
        Id id = Id.getId(string);
        if (id == null) {
            return null;
        }
        Vector<Id> vector = new Vector<Id>(1);
        vector.addElement(id);
        return vector;
    }

    public String getLabel() {
        return this.coreId.getLabel();
    }

    public Vector getLinks() throws UMLException {
        return this.api.getLinks(this);
    }

    public Vector getProperties() throws UMLException {
        return this.api.getProperties(this);
    }

    public Vector getSets() throws UMLException {
        return this.api.getSets(this);
    }

    public Vector getTags(String string) throws UMLException {
        return this.api.getTags(this, string);
    }

    public Type getType() {
        ModelType modelType = this.coreId.getType();
        if (modelType == null) {
            return null;
        }
        if (modelType instanceof Type) {
            return (Type)modelType;
        }
        return Type.convertCoreTypeToType(modelType);
    }

    public String getUUID() {
        return this.coreId.getUUID();
    }

    public String getUUIDREF() {
        return this.coreId.getUUIDREF();
    }

    public boolean isDeleted() {
        return this.coreId.isDeleted();
    }

    public boolean isLoaded() {
        return this.coreId.isLoaded();
    }

    private static String makeUUID() {
        return com.ibm.xmi.mod.Id.createUUID();
    }

    public void removeListener(EventListener eventListener) throws UMLException {
        this.api.removeListener(this, eventListener);
    }

    String retrieveUUID() {
        return this.coreId.retrieveUUID();
    }

    public void save(String string, int n) throws Exception {
        Vector<Id> vector = new Vector<Id>(1);
        vector.addElement(this);
        this.api.save(vector, string, n, new Vector());
    }

    public void save(String string, int n, Vector vector) throws Exception {
        Vector<Id> vector2 = new Vector<Id>(1);
        vector2.addElement(this);
        this.api.save(vector2, string, n, vector);
    }

    public void save(String string, int n, Vector vector, Vector vector2) throws Exception {
        Vector<Id> vector3 = new Vector<Id>(1);
        vector3.addElement(this);
        this.api.save(vector3, string, n, vector, vector2);
    }

    public void save(ZipOutputStream zipOutputStream, int n, Vector vector) throws Exception {
        Vector<Id> vector2 = new Vector<Id>(1);
        vector2.addElement(this);
        this.api.save(vector2, zipOutputStream, n, vector);
    }

    public void save(ZipOutputStream zipOutputStream, int n, Vector vector, Vector vector2) throws Exception {
        Vector<Id> vector3 = new Vector<Id>(1);
        vector3.addElement(this);
        this.api.save(vector3, zipOutputStream, n, vector, vector2);
    }

    public void set(Property property, String string) throws UMLException {
        this.api.set(this, property, string);
    }

    public void set(String string, String string2) throws UMLException {
        this.api.set(this, string, string2);
    }

    public void set(String string, String string2, String string3) throws UMLException {
        this.api.set(this, string, string2, string3);
    }

    public void setDeleted(boolean bl) {
        this.coreId.setDeleted(bl);
    }

    public void setHref(String string) {
        this.coreId.setHref(string);
    }

    public void setLabel(String string) {
        this.coreId.setLabel(string);
    }

    public void setLoaded(boolean bl) {
        this.coreId.setLoaded(bl);
    }

    public void setUUID(String string) throws UMLException {
        try {
            this.coreId.setUUID(string);
        }
        catch (ModelException modelException) {
            throw ConvertException.convert(modelException, this.api);
        }
    }

    public void setUUIDREF(String string) {
        this.coreId.setUUIDREF(string);
    }

    public String toString() {
        return this.coreId.toString();
    }
}

