/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.mod;

import com.ibm.xmi.mod.MetamodelManager;
import com.ibm.xmi.mod.ModelAPI;
import com.ibm.xmi.mod.ModelType;
import com.ibm.xmi.mod.TestGenerator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class XMITest {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private ModelAPI defaultAPI;
    private Object defaultSubclassAPI;
    private Vector apis = new Vector(5);
    private Hashtable nameToAPI = new Hashtable(5);

    public XMITest() {
        this.defaultSubclassAPI = this.getDefaultAPI();
    }

    protected void compare(String string, String string2) {
        Vector vector = this.getXMLFiles(string);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Vector<String> vector2 = new Vector<String>();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = string + System.getProperty("file.separator") + string3;
            String string5 = string2 + System.getProperty("file.separator") + string3;
            Vector vector3 = this.readFile(string4);
            Vector vector4 = this.readFile(string5);
            ++n;
            if (this.compareFiles(vector3, vector4)) {
                System.out.println(string3 + " s");
                ++n3;
                continue;
            }
            System.out.println(string3 + " f");
            ++n2;
            vector2.addElement(string3);
        }
        System.out.println("");
        System.out.println("Total files: " + n);
        System.out.println("Different:   " + n2);
        System.out.println("Same:        " + n3);
        System.out.println("");
        System.out.println("Different files:");
        enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            System.out.println("  " + enumeration.nextElement());
        }
    }

    private boolean compareFiles(Vector vector, Vector vector2) {
        Enumeration enumeration = vector.elements();
        Enumeration enumeration2 = vector2.elements();
        while (enumeration.hasMoreElements()) {
            if (!enumeration2.hasMoreElements()) {
                return false;
            }
            String string = ((String)enumeration.nextElement()).trim();
            String string2 = ((String)enumeration2.nextElement()).trim();
            if ((string = this.filter(string)).equals(string2 = this.filter(string2))) continue;
            return false;
        }
        return !enumeration2.hasMoreElements();
    }

    protected abstract void deleteSession(Object var1) throws Exception;

    protected void execute(String string, Vector vector) {
        if (string.startsWith("//")) {
            if (vector == null) {
                System.out.println(string);
            } else {
                vector.addElement(string);
            }
            return;
        }
        if (string.startsWith("--> ")) {
            if (vector == null) {
                System.out.println(string);
            } else {
                vector.addElement(string);
            }
            if (string.length() < 5) {
                return;
            }
            String string2 = string.substring(4);
            String string3 = this.processString(string2);
            this.printOutput(string3, vector);
        }
    }

    protected abstract String executeString(Object var1, String var2);

    private String filter(String string) {
        int n = string.indexOf("timestamp=\"");
        if (n == -1) {
            n = string.indexOf("xmi.uuid=\"");
        }
        if (n == -1) {
            return string;
        }
        while (string.charAt(n) != '\"') {
            ++n;
        }
        String string2 = string.substring(0, ++n);
        while (string.charAt(n) != '\"') {
            ++n;
        }
        string2 = string2 + string.substring(n);
        return string2;
    }

    public void genDocs(String string) {
        Vector vector = this.getSummaryFiles(string);
        if (vector.size() == 0) {
            System.out.println("No summary files in: " + string);
            return;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (string2.endsWith("gettests")) {
                this.generateDoc("Get", "get", string2, string);
                continue;
            }
            if (string2.endsWith("settests")) {
                this.generateDoc("Set", "set", string2, string);
                continue;
            }
            if (string2.endsWith("addtests")) {
                this.generateDoc("Add", "add", string2, string);
                continue;
            }
            System.out.println("Don't know how to handle: " + string2);
        }
    }

    private void generateDoc(String string, String string2, String string3, String string4) {
        File file = new File(string3 + ".html");
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (IOException iOException) {
            System.out.println("Exception: " + iOException);
            return;
        }
        this.writeLine(fileOutputStream, "<title>" + string + " Unit Test Cases</title>");
        this.writeLine(fileOutputStream, "<h1><center>" + string + " Unit Test Summary</center></h1>");
        this.writeLine(fileOutputStream, "<hr scale = \"20\" noshade>");
        this.writeLine(fileOutputStream, "<p>Test case documentation automatically generated on " + new Date());
        this.writeLine(fileOutputStream, "<TABLE border=1><CAPTION><B>Test Cases</B></CAPTION>");
        this.writeLine(fileOutputStream, "<TR><TH align=center>Name <TH align=center>Description");
        File file2 = new File(string3);
        FileInputStream fileInputStream = null;
        if (!file2.exists()) {
            System.out.println("File '" + string3 + "' does not exist.");
            return;
        }
        if (!file2.canRead()) {
            System.out.println("Cannot read file '" + string3 + "'");
            return;
        }
        try {
            fileInputStream = new FileInputStream(file2);
        }
        catch (IOException iOException) {
            System.out.println("Exception: " + iOException);
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        try {
            String string5;
            while ((string5 = bufferedReader.readLine()) != null) {
                if (string5.length() <= 0 || string5.charAt(0) == '\u001a') continue;
                String string6 = this.getDescription(string4 + System.getProperty("file.separator") + string5);
                this.writeTableEntry(fileOutputStream, string5, string6);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.out.println("Exception: " + indexOutOfBoundsException);
        }
        catch (IOException iOException) {
            System.out.println("Exception: " + iOException);
        }
        this.writeLine(fileOutputStream, "</TABLE>");
        try {
            bufferedReader.close();
            fileInputStream.close();
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Error closing file.");
        }
    }

    protected void genTests(MetamodelManager metamodelManager, String string, String string2, String string3, String string4, boolean bl) {
        TestGenerator testGenerator = this.makeTestGenerator(string, metamodelManager);
        int n = 0;
        try {
            n = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            System.out.println(exception);
            return;
        }
        ModelType modelType = null;
        modelType = string4.equals("all") ? this.getTypeAll() : (ModelType)metamodelManager.getMMConstruct(string4);
        testGenerator.generate(string2, n, modelType, bl);
    }

    protected abstract Object getDefaultAPI();

    private String getDescription(String string) {
        File file = new File(string);
        FileInputStream fileInputStream = null;
        if (!file.exists()) {
            System.out.println("File '" + string + "' does not exist.");
            return null;
        }
        if (!file.canRead()) {
            System.out.println("Cannot read file '" + string + "'");
            return null;
        }
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (IOException iOException) {
            System.out.println("Exception: " + iOException);
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        String string2 = "";
        try {
            String string3;
            bufferedReader.readLine();
            bufferedReader.readLine();
            bufferedReader.readLine();
            bufferedReader.readLine();
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.length() <= 0 || string3.charAt(0) == '\u001a') continue;
                if (!string3.startsWith("//////")) {
                    if (string3.startsWith("// Descr")) {
                        string2 = string3.substring(17);
                        continue;
                    }
                    string2 = string2 + " " + string3.substring(17);
                    continue;
                }
                break;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.out.println("Exception: " + indexOutOfBoundsException);
        }
        catch (IOException iOException) {
            System.out.println("Exception: " + iOException);
        }
        return string2;
    }

    private Vector getSummaryFiles(String string) {
        Vector<String> vector = new Vector<String>();
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray == null) {
            System.out.println("Illegal directory: " + string);
            return vector;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith("tests") || stringArray[i].endsWith("alltests")) continue;
            vector.addElement(string + System.getProperty("file.separator") + stringArray[i]);
        }
        return vector;
    }

    protected ModelType getTypeAll() {
        return ModelType.IXT_ALL;
    }

    private Vector getXMLFiles(String string) {
        Vector<String> vector = new Vector<String>();
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray == null) {
            System.out.println("Illegal directory: " + string);
            return vector;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(".xml")) continue;
            vector.addElement(stringArray[i]);
        }
        return vector;
    }

    public void interactive() {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            System.out.print("--> ");
            String string = null;
            try {
                string = bufferedReader.readLine();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string.length() == 0) {
                try {
                    this.deleteSession(this.defaultSubclassAPI);
                    for (int i = 0; i < this.apis.size(); ++i) {
                        this.deleteSession(this.apis.elementAt(i));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                System.exit(0);
            }
            String string2 = this.processString(string);
            this.printOutput(string2, null);
        }
    }

    protected boolean isEqual(Vector vector, Vector vector2) {
        Enumeration enumeration = vector.elements();
        Enumeration enumeration2 = vector2.elements();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            if (!enumeration2.hasMoreElements()) {
                return false;
            }
            String string = ((String)enumeration.nextElement()).trim();
            String string2 = ((String)enumeration2.nextElement()).trim();
            if ((string.startsWith("-->") || string2.startsWith("-->")) && bl) {
                if (!this.isEqualAllVector(vector3, vector4)) {
                    return false;
                }
                vector3 = new Vector();
                vector4 = new Vector();
                bl = false;
            }
            if (string.startsWith("com.ibm.xmi.mod") && string2.startsWith("com.ibm.xmi.mod")) continue;
            if (string.startsWith("--> get") && string2.startsWith("--> get") && string.indexOf("all") != -1 && string.equals(string2)) {
                bl = true;
            }
            if (!string.equals(string2) && !bl) {
                return false;
            }
            if (!bl) continue;
            vector3.addElement(string);
            vector4.addElement(string2);
        }
        if (bl && !this.isEqualAllVector(vector3, vector4)) {
            return false;
        }
        return !enumeration2.hasMoreElements();
    }

    private boolean isEqualAllVector(Vector vector, Vector vector2) {
        if (vector.size() != vector2.size()) {
            return false;
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (vector2.contains(vector.elementAt(i))) continue;
            return false;
        }
        return true;
    }

    protected void loadSave(String string, String string2) {
        File file = new File(string);
        File file2 = new File(string2);
        if (!file.exists()) {
            System.out.println("Source does not exist.");
            return;
        }
        if (file.isDirectory() && !file2.exists()) {
            System.out.println("Target does not exist.");
            return;
        }
        Object object = this.makeAPI();
        if (file.isFile()) {
            this.loadSaveAFile(object, file.getPath(), string2);
            return;
        }
        Vector vector = this.getXMLFiles(string);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            String string4 = string + System.getProperty("file.separator") + string3;
            String string5 = string2 + System.getProperty("file.separator") + string3;
            this.loadSaveAFile(object, string4, string5);
        }
    }

    protected abstract void loadSaveAFile(Object var1, String var2, String var3);

    protected Object makeAPI() {
        return new ModelAPI();
    }

    protected TestGenerator makeTestGenerator(String string, MetamodelManager metamodelManager) {
        return new TestGenerator(string, metamodelManager);
    }

    protected void printOutput(String string, Vector vector) {
        if (string == null || string.equals("")) {
            if (vector == null) {
                System.out.println(string);
            } else if (string == null) {
                vector.addElement("null");
            } else {
                vector.addElement(string);
            }
            return;
        }
        if (string.startsWith("'") && !string.startsWith("''") || string.startsWith("Error:")) {
            if (vector == null) {
                System.out.println(string);
            } else {
                vector.addElement(string);
            }
            return;
        }
        int n = string.indexOf(" ");
        if (n == -1) {
            if (vector == null) {
                System.out.println(string);
            } else {
                vector.addElement(string);
            }
            return;
        }
        String string2 = "";
        for (n = 0; n < string.length(); ++n) {
            if (string.charAt(n) != ' ') {
                string2 = string2 + string.charAt(n);
                continue;
            }
            if (string2.equals("")) continue;
            if (vector == null) {
                System.out.println(string2);
            } else {
                vector.addElement(string2);
            }
            string2 = "";
        }
        if (!string2.equals("")) {
            if (vector == null) {
                System.out.println(string2);
            } else {
                vector.addElement(string2);
            }
        }
    }

    protected void processOptions(String[] stringArray) {
        int n;
        if (stringArray.length == 0) {
            System.out.println("Valid options are: ");
            System.out.println("-interactive   -- Interactive mode.");
            System.out.println("-loadSave source target -- Loads from source; saves in target.");
            System.out.println("-compare source target -- Compares XML files in source with ones in target.");
            System.out.println("-run script    -- Runs script, prints input commands, output.");
            System.out.println("-runDir dir prefix -- Runs scripts in dir with given prefix.");
            System.out.println("-test testName -- Runs test, prints success or fail.");
            System.out.println("-tests testFile directory -- Runs all tests in file; prints report.");
            System.out.println("-genDocs dir -- Generates html documentation from test files");
            System.out.println("-genTests dir metamodel kind type boolean -- Generates kind tests for the metamodel and type in dir.");
            System.out.println("                                             If boolean is true, full names are used; otherwise, simple");
            System.out.println("                                             names are used.");
            return;
        }
        if (stringArray.length > 6) {
            System.out.println("Too many input arguments.");
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        boolean bl8 = true;
        boolean bl9 = false;
        boolean bl10 = false;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        for (n = 0; n < stringArray.length; ++n) {
            if (stringArray[n].equals("-interactive")) {
                bl = true;
                continue;
            }
            if (stringArray[n].equals("-run")) {
                bl2 = true;
                continue;
            }
            if (stringArray[n].equals("-runDir")) {
                bl3 = true;
                if (n + 1 < stringArray.length) {
                    string2 = stringArray[++n];
                }
                if (n + 1 >= stringArray.length) continue;
                string5 = stringArray[++n];
                continue;
            }
            if (stringArray[n].equals("-loadSave")) {
                bl9 = true;
                if (n + 1 < stringArray.length) {
                    string = stringArray[++n];
                }
                if (n + 1 >= stringArray.length) continue;
                string2 = stringArray[++n];
                continue;
            }
            if (stringArray[n].equals("-compare")) {
                bl10 = true;
                if (n + 1 < stringArray.length) {
                    string = stringArray[++n];
                }
                if (n + 1 >= stringArray.length) continue;
                string2 = stringArray[++n];
                continue;
            }
            if (stringArray[n].equals("-test")) {
                bl4 = true;
                continue;
            }
            if (stringArray[n].equals("-genDocs")) {
                bl7 = true;
                continue;
            }
            if (stringArray[n].equals("-genTests")) {
                bl6 = true;
                if (n + 1 < stringArray.length) {
                    string2 = stringArray[++n];
                }
                if (n + 1 < stringArray.length) {
                    string3 = stringArray[++n];
                }
                if (n + 1 < stringArray.length) {
                    string4 = stringArray[++n];
                }
                if (n + 1 < stringArray.length) {
                    string = stringArray[++n];
                }
                if (n + 1 >= stringArray.length) continue;
                if (stringArray[++n].equals("true")) {
                    bl8 = true;
                    continue;
                }
                if (stringArray[n].equals("false")) {
                    bl8 = false;
                    continue;
                }
                System.out.println("Illegal value for boolean.");
                return;
            }
            if (stringArray[n].equals("-tests")) {
                bl5 = true;
                if (n + 1 < stringArray.length) {
                    string = stringArray[++n];
                }
                if (n + 1 >= stringArray.length) continue;
                string2 = stringArray[++n];
                continue;
            }
            string = stringArray[n];
        }
        if (bl && string != null) {
            System.out.println("Too many arguments for interactive option.");
        } else if (bl) {
            this.interactive();
        } else if (bl2 && string == null) {
            System.out.println("No input file specified.");
        } else if (bl2) {
            this.run(string, null, null);
        } else if (bl3 && (string2 == null || string5 == null)) {
            System.out.println("Must specify directory and prefix.");
        } else if (bl3) {
            this.runDir(string2, string5);
        } else if (bl4 && string == null) {
            System.out.println("No test file specified.");
        } else {
            if (bl4) {
                n = this.test(string) ? 1 : 0;
                if (n == 1) {
                    System.out.println("Test succeeded.");
                } else {
                    System.out.println("Test failed.");
                }
                return;
            }
            if (bl5 && (string == null || string2 == null)) {
                System.out.println("Must specify filename and directory for tests option.");
            } else if (bl5) {
                this.tests(string, string2);
            } else if (bl6 && (string2 == null || string3 == null || string4 == null || string == null)) {
                System.out.println("Must specify directory, metamodel, kind, and type for genTests option.");
            } else if (bl6) {
                this.genTests(this.defaultAPI.getMetamodelManager(), string2, string3, string4, string, bl8);
            } else if (bl7 && string == null) {
                System.out.println("Must specify directory.");
            } else if (bl7) {
                this.genDocs(string);
            } else if (bl9 && (string == null || string2 == null)) {
                System.out.println("Must specify source and target directories.");
            } else if (bl9) {
                this.loadSave(string, string2);
            } else if (bl10 && (string == null || string2 == null)) {
                System.out.println("Must specify source and target directories.");
            } else if (bl10) {
                this.compare(string, string2);
            }
        }
    }

    private String processString(String string) {
        if (string.startsWith("Model ")) {
            Object object = this.makeAPI();
            this.apis.addElement(object);
            String string2 = string.substring(6);
            this.nameToAPI.put(string2.intern(), object);
            return string2;
        }
        Object object = this.defaultSubclassAPI;
        int n = string.indexOf(".");
        int n2 = string.indexOf(" ");
        if (n != -1 && (n2 == -1 || n < n2)) {
            String string3 = string.substring(0, n);
            object = this.nameToAPI.get(string3.intern());
            if (object == null) {
                return "No model component with name: " + string3;
            }
            string = string.substring(n + 1);
        }
        return this.executeString(object, string);
    }

    private Vector readFile(String string) {
        Vector<String> vector = new Vector<String>();
        File file = new File(string);
        FileInputStream fileInputStream = null;
        if (!file.exists()) {
            return vector;
        }
        if (!file.canRead()) {
            return vector;
        }
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (IOException iOException) {
            return vector;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.length() <= 0 || string2.charAt(0) == '\u001a') continue;
                vector.addElement(string2);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.out.println("Exception: " + indexOutOfBoundsException);
        }
        catch (IOException iOException) {
            System.out.println("Exception: " + iOException);
        }
        try {
            bufferedReader.close();
            fileInputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Error closing file.");
        }
        return vector;
    }

    public void run(String string, Vector vector, Vector vector2) {
        block15: {
            if (string == null) {
                return;
            }
            File file = new File(string);
            FileInputStream fileInputStream = null;
            if (!file.exists()) {
                System.out.println("File '" + string + "' does not exist.");
                return;
            }
            if (!file.canRead()) {
                System.out.println("Cannot read file '" + string + "'");
                return;
            }
            try {
                fileInputStream = new FileInputStream(file);
            }
            catch (IOException iOException) {
                System.out.println("Exception: " + iOException);
                return;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
            try {
                String string2;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.length() > 0 && string2.charAt(0) != '\u001a') {
                        this.execute(string2, vector2);
                    }
                    if (vector == null) continue;
                    vector.addElement(string2);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                System.out.println("Exception: " + indexOutOfBoundsException);
            }
            catch (IOException iOException) {
                System.out.println("Exception: " + iOException);
            }
            try {
                bufferedReader.close();
                fileInputStream.close();
            }
            catch (IOException iOException) {
                System.out.println("Error closing file.");
            }
            try {
                this.deleteSession(this.defaultSubclassAPI);
                for (int i = 0; i < this.apis.size(); ++i) {
                    this.deleteSession(this.apis.elementAt(i));
                }
                this.apis = new Vector(5);
                this.nameToAPI.clear();
            }
            catch (Exception exception) {
                if (vector2 == null) break block15;
                vector2.addElement(exception.toString());
            }
        }
    }

    public void runDir(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray == null) {
            System.out.println("Illegal directory: " + string);
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(string2)) continue;
            vector.addElement(string + System.getProperty("file.separator") + stringArray[i]);
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            String string3 = (String)enumeration.nextElement();
            this.run(string3, null, null);
        }
    }

    protected void setAPI(ModelAPI modelAPI) {
        this.defaultAPI = modelAPI;
    }

    protected boolean test(String string) {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        this.run(string, vector, vector2);
        if (vector.size() == 0) {
            return false;
        }
        return this.isEqual(vector, vector2);
    }

    public void tests(String string, String string2) {
        Object object;
        File file = new File(string);
        FileInputStream fileInputStream = null;
        Vector<String> vector = new Vector<String>();
        if (!file.exists()) {
            System.out.println("File '" + string + "' does not exist.");
            return;
        }
        if (!file.canRead()) {
            System.out.println("Cannot read file '" + string + "'");
            return;
        }
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (IOException iOException) {
            System.out.println("Exception: " + iOException);
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        System.out.println("Test case  Status");
        System.out.println("---------  ------");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        Date date = new Date();
        try {
            String string3;
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.length() <= 0 || string3.charAt(0) == '\u001a') continue;
                string3 = string3.trim();
                object = string2 + "\\" + string3;
                while (string3.length() < 9) {
                    string3 = string3 + " ";
                }
                System.out.print(string3 + "    ");
                if (this.test((String)object)) {
                    System.out.println("S");
                    ++n3;
                } else {
                    System.out.println("F");
                    ++n2;
                    vector.addElement(string3);
                }
                ++n;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.out.println("Exception: " + indexOutOfBoundsException);
        }
        catch (IOException iOException) {
            System.out.println("Exception: " + iOException);
        }
        try {
            bufferedReader.close();
            fileInputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Error closing file.");
        }
        object = new Date();
        System.out.println("");
        System.out.println("Start time: " + date);
        System.out.println("End time:   " + object);
        System.out.println("");
        System.out.println("Ran:       " + n);
        System.out.println("Succeeded: " + n3);
        System.out.println("Failed:    " + n2);
        if (n2 > 0) {
            System.out.println("");
            System.out.println("Failed tests:");
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                System.out.println((String)enumeration.nextElement());
            }
        }
    }

    private boolean writeLine(FileOutputStream fileOutputStream, String string) {
        try {
            fileOutputStream.write(string.getBytes());
            String string2 = "\n";
            fileOutputStream.write(string2.getBytes());
        }
        catch (Exception exception) {
            System.out.println(exception);
            return false;
        }
        return true;
    }

    private void writeTableEntry(FileOutputStream fileOutputStream, String string, String string2) {
        this.writeLine(fileOutputStream, "<TR>");
        this.writeLine(fileOutputStream, "<TD align=left>" + string + "</A></TD>");
        this.writeLine(fileOutputStream, "<TD align=left>" + string2 + "</A></TD>");
    }
}

