/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.mod;

import com.ibm.xmi.mod.Id;
import com.ibm.xmi.mod.Listeners;
import com.ibm.xmi.mod.MetamodelManager;
import com.ibm.xmi.mod.ModelAPI;
import com.ibm.xmi.mod.ModelException;
import com.ibm.xmi.mod.ModelLink;
import com.ibm.xmi.mod.ModelProperty;
import com.ibm.xmi.mod.ModelType;
import com.ibm.xmi.mod.Session;
import com.ibm.xmi.mod.XMILoaderFactory;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.AttributeList;

public class XMILoader {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String VERSION = "xmi.version";
    private static final String TIMESTAMP = "timestamp";
    private static final String VERIFIED = "verified";
    private static final String NAME = "xmi.name";
    private static final String VALUE = "xmi.value";
    private static final String IDREF = "xmi.idref";
    private static final String UUIDREF = "xmi.uuidref";
    private static final String ID = "xmi.id";
    private static final String EXTENDER = "xmi.extender";
    private static final String EXTENDER_ID = "xmi.extenderID";
    private static final String XMI_UUID = "xmi.uuid";
    private static final String XMI_LABEL = "xmi.label";
    private static final String HREF = "href";
    private static final String XMI_NOTICE = "XMI.notice";
    private boolean debug;
    private int option;
    private long numConstructs;
    private long constructCount;
    private Vector header;
    private String lastHeader = "";
    protected String text;
    private MetamodelManager mm;
    private ModelAPI api;
    protected Stack constructs;
    protected Stack links;
    protected Stack mmConstructs;
    private Hashtable xToId;
    private Vector unresolvedLinks;

    public XMILoader(ModelAPI modelAPI, int n, Vector vector) {
        this.api = modelAPI;
        this.mm = modelAPI.getMetamodelManager();
        this.option = n;
        this.constructs = new Stack();
        this.mmConstructs = new Stack();
        this.links = new Stack();
        this.xToId = new Hashtable();
        this.unresolvedLinks = new Vector();
        this.text = null;
        this.debug = false;
        this.header = vector;
    }

    private void addHandling(ModelType modelType, AttributeList attributeList) {
        Id id;
        block11: {
            block10: {
                id = null;
                try {
                    id = this.api.getSession().add(modelType);
                    if (id != null) {
                        this.api.addToLoadIds(id);
                    }
                }
                catch (ModelException modelException) {
                    if (!this.debug) break block10;
                    System.out.println("INTERNAL ERROR IN ADDING CONSTRUCT!!!!!");
                }
            }
            if (modelType == ModelType.IXT_XMI) {
                try {
                    this.setXMIProperties(id, attributeList);
                    this.links.push(ModelLink.IXT_XMI_CONTENT);
                }
                catch (ModelException modelException) {
                    if (this.debug) {
                        System.out.println("INTERNAL ERROR IN SETTING XMI PROPERTY!!!");
                    }
                    break block11;
                }
            }
            if (this.option == 2) {
                Id id2 = (Id)this.constructs.peek();
                try {
                    id2.add(ModelLink.IXT_XMI_CONTENT, id);
                }
                catch (ModelException modelException) {
                    if (!this.debug) break block11;
                    System.out.println("INTERNAL ERROR IN ADDING LINK FOR FILE TRACKING!!!!");
                }
            }
        }
        this.constructs.push(id);
        this.mmConstructs.push(modelType);
        this.setIdProperties(id, attributeList);
    }

    protected void createConstruct(ModelType modelType, AttributeList attributeList) {
        if (this.option == 1 && this.isHeader(modelType)) {
            return;
        }
        if (this.isReference(attributeList)) {
            this.handleReference(attributeList);
            return;
        }
        if (attributeList.getValue(IDREF) == null && attributeList.getValue(UUIDREF) != null) {
            this.handleUUIDRefReference(modelType, attributeList);
            return;
        }
        if (this.proxyExists(attributeList)) {
            this.loadProxy(modelType, attributeList);
            return;
        }
        this.handleCreation(modelType, attributeList);
    }

    public void endDocument() {
        if (this.debug) {
            System.out.println("Second pass...");
        }
        for (int i = 0; i < this.unresolvedLinks.size() - 2; i += 3) {
            Id id = (Id)this.unresolvedLinks.elementAt(i);
            ModelLink modelLink = (ModelLink)this.unresolvedLinks.elementAt(i + 1);
            String string = (String)this.unresolvedLinks.elementAt(i + 2);
            Id id2 = (Id)this.xToId.get(string);
            try {
                if (id2 != null && id.isLoaded()) {
                    this.api.add(id, modelLink, id2);
                    continue;
                }
                if (!this.debug || !id.isLoaded()) continue;
                System.out.println("Unable to resolve XMI Id: " + string);
                continue;
            }
            catch (ModelException modelException) {
                if (!this.debug) continue;
                System.out.println("Error in resolving links on second pass!");
            }
        }
        this.unresolvedLinks = new Vector();
        this.xToId = new Hashtable();
    }

    public void endElement(String string) {
        if (!this.lastHeader.equals("") && this.header != null) {
            this.header.addElement(this.lastHeader);
            this.header.addElement(this.text);
        }
        if (this.option == 1 && this.constructs.empty()) {
            return;
        }
        Object e = this.mmConstructs.pop();
        if (e instanceof ModelType) {
            this.constructs.pop();
        } else if (e instanceof ModelLink) {
            this.links.pop();
        } else if (e instanceof ModelProperty) {
            this.setProperty((ModelProperty)e, this.text);
        }
    }

    public boolean getDebug() {
        return this.debug;
    }

    protected String getIdrefAttrib() {
        return IDREF;
    }

    protected Id getLastId() {
        if (this.constructs.isEmpty()) {
            return null;
        }
        return (Id)this.constructs.peek();
    }

    protected ModelType getLastType() {
        if (this.constructs.isEmpty()) {
            return null;
        }
        return ((Id)this.constructs.peek()).getType();
    }

    protected String getValueAttrib() {
        return VALUE;
    }

    protected String getXMIIdAttrib() {
        return ID;
    }

    protected void handleCreation(ModelType modelType, AttributeList attributeList) {
        block19: {
            Id id = null;
            if (modelType == ModelType.IXT_XMI) {
                this.addHandling(modelType, attributeList);
            } else if (this.lastConstructType() == ModelType.IXT_XMI_CONTENT || this.lastConstructType() == null) {
                this.addHandling(modelType, attributeList);
            } else if (modelType == ModelType.IXT_XMI_EXTENSION) {
                this.handleXMIExtension(attributeList);
            } else if (modelType == ModelType.IXT_EXTENSION) {
                this.handleExtension(attributeList);
            } else if (modelType == ModelType.IXT_EXT_SET) {
                this.handleExtSet(attributeList);
            } else if (modelType == ModelType.IXT_EXT_TV) {
                this.handleExtTV(attributeList);
            } else {
                try {
                    ++this.constructCount;
                    int n = this.numConstructs != 0L ? (int)(100L * this.constructCount / this.numConstructs) : (int)(100L * this.constructCount / (this.constructCount + 1L));
                    Listeners.fireProgress(1, n);
                    id = this.api.create(modelType);
                    Id id2 = (Id)this.constructs.peek();
                    this.constructs.push(id);
                    this.mmConstructs.push(modelType);
                    if (id2.getType() == ModelType.IXT_XMI_EXTENSION) {
                        id2.add(ModelLink.IXT_XMI_CONTENT, id);
                    } else if (id2.getType() == ModelType.IXT_EXTENSION) {
                        id2.add(ModelLink.IXT_EXTENSION_REFERENCE, id);
                    } else {
                        id2.add((ModelLink)this.links.peek(), id);
                    }
                    this.setIdProperties(id, attributeList);
                    if (modelType == ModelType.IXT_XMI_MODEL || modelType == ModelType.IXT_XMI_METAMODEL || modelType == ModelType.IXT_XMI_METAMETAMODEL || modelType == ModelType.IXT_XMI_EXTENSION) {
                        this.setXMIProperties(id, attributeList);
                    }
                }
                catch (ModelException modelException) {
                    if (!this.debug) break block19;
                    System.out.println("INTERNAL ERROR IN CREATING ID!!!!");
                }
            }
        }
    }

    private void handleExtension(AttributeList attributeList) {
        block12: {
            String string = attributeList.getValue(ModelProperty.IXT_EXTENSION_TYPE.getFullName());
            if (string == null) {
                string = attributeList.getValue("com.ibm.xmi.Data.type");
            }
            if (string != null && string.equals("XMITTaggedValueSet")) {
                String string2 = attributeList.getValue(ModelProperty.IXT_EXTENSION_NAME.getFullName());
                if (string2 == null) {
                    string2 = attributeList.getValue("com.ibm.xmi.Data.name");
                }
                this.mmConstructs.push(string2);
            } else if (string != null && string.equals("XMITTaggedValue")) {
                try {
                    String string3;
                    Id id = (Id)this.constructs.peek();
                    String string4 = (String)this.mmConstructs.peek();
                    String string5 = attributeList.getValue(ModelProperty.IXT_EXTENSION_NAME.getFullName());
                    if (string5 == null) {
                        string5 = attributeList.getValue("com.ibm.xmi.Data.name");
                    }
                    if ((string3 = attributeList.getValue(ModelProperty.IXT_EXTENSION_DATA.getFullName())) == null) {
                        string3 = attributeList.getValue("com.ibm.xmi.Data.data");
                    }
                    id.set(string4, string5, string3);
                    this.mmConstructs.push(string4);
                }
                catch (ModelException modelException) {}
            } else {
                try {
                    Id id = this.api.create(ModelType.IXT_EXTENSION);
                    Id id2 = (Id)this.constructs.peek();
                    this.constructs.push(id);
                    this.mmConstructs.push(ModelType.IXT_EXTENSION);
                    id2.add(ModelLink.IXT_XMI_CONTENT, id);
                    this.setIdProperties(id, attributeList);
                    this.setDataProperties(id, attributeList);
                }
                catch (ModelException modelException) {
                    if (!this.debug) break block12;
                    System.out.println("INTERNAL ERROR IN CREATING EXTENSION!!!!");
                }
            }
        }
    }

    private void handleExtSet(AttributeList attributeList) {
        String string = attributeList.getValue("s");
        this.mmConstructs.push(string);
    }

    private void handleExtTV(AttributeList attributeList) {
        try {
            Id id = (Id)this.constructs.peek();
            String string = (String)this.mmConstructs.peek();
            String string2 = attributeList.getValue("t");
            String string3 = attributeList.getValue("v");
            id.set(string, string2, string3);
            this.mmConstructs.push(string);
        }
        catch (ModelException modelException) {
            // empty catch block
        }
    }

    protected void handleLink(ModelLink modelLink) {
        this.links.push(modelLink);
        this.mmConstructs.push(modelLink);
    }

    protected void handleProperty(ModelProperty modelProperty, AttributeList attributeList) {
        if (this.constructs.empty()) {
            return;
        }
        String string = attributeList.getValue(this.getValueAttrib());
        if (string != null) {
            this.setProperty(modelProperty, string);
            this.mmConstructs.push("SET");
        } else {
            this.mmConstructs.push(modelProperty);
        }
    }

    protected void handleReference(AttributeList attributeList) {
        if (!this.constructs.isEmpty() && ((Id)this.constructs.peek()).getType() == ModelType.IXT_EXTENSION && (this.links.isEmpty() || (ModelLink)this.links.peek() != ModelLink.IXT_EXTENSION_REFERENCE)) {
            this.mmConstructs.push(ModelLink.IXT_EXTENSION_REFERENCE);
            this.links.push(ModelLink.IXT_EXTENSION_REFERENCE);
            this.setReference(ModelLink.IXT_EXTENSION_REFERENCE, attributeList);
            return;
        }
        if (this.links.isEmpty() || this.constructs.isEmpty()) {
            if (this.debug) {
                System.out.println("Error:  Must put references in links!!!");
            }
            return;
        }
        this.setReference((ModelLink)this.links.peek(), attributeList);
        this.mmConstructs.push((ModelLink)this.links.peek());
        this.links.push((ModelLink)this.links.peek());
    }

    protected void handleUUIDRefReference(ModelType modelType, AttributeList attributeList) {
        if (this.links.isEmpty() || this.constructs.isEmpty()) {
            if (this.debug) {
                System.out.println("Error:  Must put references in links!!!");
            }
            return;
        }
        try {
            Id id = this.api.create(modelType);
            id.setUUIDREF(attributeList.getValue(UUIDREF));
            this.api.add((Id)this.constructs.peek(), (ModelLink)this.links.peek(), id);
        }
        catch (ModelException modelException) {
            // empty catch block
        }
        this.mmConstructs.push((ModelLink)this.links.peek());
        this.links.push((ModelLink)this.links.peek());
    }

    private void handleXMIExtension(AttributeList attributeList) {
        block4: {
            String string = attributeList.getValue(EXTENDER);
            if (string != null && (string.equals("IXT") || string.equals("XMI Toolkit 2.0"))) {
                this.mmConstructs.push("IXT");
            } else {
                try {
                    Id id = this.api.create(ModelType.IXT_XMI_EXTENSION);
                    Id id2 = (Id)this.constructs.peek();
                    this.constructs.push(id);
                    this.mmConstructs.push(ModelType.IXT_XMI_EXTENSION);
                    id2.add(ModelLink.IXT_XMI_EXTENSION, id);
                    this.setIdProperties(id, attributeList);
                }
                catch (ModelException modelException) {
                    if (!this.debug) break block4;
                    System.out.println("INTERNAL ERROR IN CREATING EXTENSION!!!!");
                }
            }
        }
    }

    private boolean isHeader(ModelType modelType) {
        return modelType == ModelType.IXT_XMI || modelType == ModelType.IXT_XMI_HEADER || modelType == ModelType.IXT_XMI_DOCUMENTATION || modelType == ModelType.IXT_XMI_MODEL || modelType == ModelType.IXT_XMI_METAMODEL || modelType == ModelType.IXT_XMI_METAMETAMODEL || modelType == ModelType.IXT_XMI_CONTENT;
    }

    private boolean isReference(AttributeList attributeList) {
        return attributeList.getValue(IDREF) != null;
    }

    private ModelType lastConstructType() {
        if (this.constructs.empty()) {
            return null;
        }
        return ((Id)this.constructs.peek()).getType();
    }

    private void loadProxy(ModelType modelType, AttributeList attributeList) {
        block11: {
            try {
                String string = attributeList.getValue(XMI_UUID);
                Id id = this.api.getIds().getId(string);
                Id id2 = null;
                if (!this.constructs.empty()) {
                    id2 = (Id)this.constructs.peek();
                }
                this.constructs.push(id);
                this.mmConstructs.push(modelType);
                if (id2 != null) {
                    if (id2.getType() == ModelType.IXT_XMI_EXTENSION) {
                        id2.add(ModelLink.IXT_XMI_CONTENT, id);
                    } else if (id2.getType() == ModelType.IXT_EXTENSION) {
                        id2.add(ModelLink.IXT_EXTENSION_REFERENCE, id);
                    } else if (!this.links.empty()) {
                        id2.add((ModelLink)this.links.peek(), id);
                    }
                } else if (!((Session)this.api.getSession().getConstruct()).contains(id)) {
                    ((Session)this.api.getSession().getConstruct()).add(id);
                    this.api.addToLoadIds(id);
                }
                this.setProxyProperties(id, attributeList);
            }
            catch (ModelException modelException) {
                if (!this.debug) break block11;
                System.out.println("INTERNAL ERROR IN LOADING PROXY!!!!");
            }
        }
    }

    public static XMILoader makeXMILoader(ModelAPI modelAPI, int n, Vector vector) {
        XMILoaderFactory xMILoaderFactory = modelAPI.getXMILoaderFactory();
        return xMILoaderFactory.makeXMILoader(modelAPI, n, vector);
    }

    private boolean proxyExists(AttributeList attributeList) {
        String string = attributeList.getValue(XMI_UUID);
        if (string == null) {
            return false;
        }
        Id id = this.api.getIds().getId(string);
        if (id == null) {
            return false;
        }
        if (attributeList.getValue(HREF) != null) {
            return true;
        }
        return !id.isLoaded();
    }

    protected void pushConstruct(String string) {
        this.mmConstructs.push(string);
    }

    public void setConstructCount(long l) {
        this.constructCount = l;
    }

    public void setConstructs(long l) {
        this.numConstructs = l;
    }

    private void setDataProperties(Id id, AttributeList attributeList) {
        String string;
        String string2;
        String string3;
        String string4 = attributeList.getValue(ModelProperty.IXT_EXTENSION_NAME.getFullName());
        if (string4 == null) {
            string4 = attributeList.getValue("com.ibm.xmi.Data.name");
        }
        if ((string3 = attributeList.getValue(ModelProperty.IXT_EXTENSION_TYPE.getFullName())) == null) {
            string3 = attributeList.getValue("com.ibm.xmi.Data.type");
        }
        if ((string2 = attributeList.getValue(ModelProperty.IXT_EXTENSION_DELETE.getFullName())) == null) {
            string2 = attributeList.getValue("com.ibm.xmi.Data.delete");
        }
        if ((string = attributeList.getValue(ModelProperty.IXT_EXTENSION_DATA.getFullName())) == null) {
            string = attributeList.getValue("com.ibm.xmi.Data.data");
        }
        try {
            if (string4 != null) {
                id.set(ModelProperty.IXT_EXTENSION_NAME, string4);
            }
            if (string3 != null) {
                id.set(ModelProperty.IXT_EXTENSION_TYPE, string3);
            }
            if (string2 != null) {
                id.set(ModelProperty.IXT_EXTENSION_DELETE, string2);
            }
            if (string != null) {
                id.set(ModelProperty.IXT_EXTENSION_DATA, string);
            }
        }
        catch (ModelException modelException) {
            // empty catch block
        }
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
        this.api.setLog(bl);
    }

    protected void setIdProperties(Id id, AttributeList attributeList) {
        String string;
        block12: {
            string = attributeList.getValue(XMI_LABEL);
            if (string != null) {
                id.setLabel(string);
            }
            if ((string = attributeList.getValue(XMI_UUID)) != null) {
                try {
                    id.setUUID(string);
                }
                catch (ModelException modelException) {
                    if (!this.debug) break block12;
                    System.out.println("INTERNAL ERROR IN SETTING XMI_UUID!!!");
                }
            }
        }
        if ((string = attributeList.getValue(this.getXMIIdAttrib())) != null) {
            this.xToId.put(string, id);
        }
        if ((string = attributeList.getValue(HREF)) != null) {
            id.setHref(string);
            id.setLoaded(false);
        }
        if ((string = attributeList.getValue(EXTENDER)) != null) {
            try {
                id.set(ModelProperty.IXT_XMI_EXTENDER, string);
            }
            catch (ModelException modelException) {
                // empty catch block
            }
        }
        if ((string = attributeList.getValue(EXTENDER_ID)) != null) {
            try {
                id.set(ModelProperty.IXT_XMI_EXTENDER_ID, string);
            }
            catch (ModelException modelException) {
                // empty catch block
            }
        }
    }

    protected void setProperty(ModelProperty modelProperty, String string) {
        block3: {
            this.text = "";
            if (this.constructs.empty()) {
                return;
            }
            Id id = (Id)this.constructs.peek();
            try {
                id.set(modelProperty, string);
            }
            catch (ModelException modelException) {
                if (!this.debug) break block3;
                System.out.println("INTERNAL ERROR SETTING PROPERTY!!!!!");
            }
        }
    }

    private void setProxyProperties(Id id, AttributeList attributeList) {
        String string = attributeList.getValue(XMI_LABEL);
        if (string != null) {
            id.setLabel(string);
        }
        if ((string = attributeList.getValue(this.getXMIIdAttrib())) != null) {
            this.xToId.put(string, id);
        }
        if (!id.isLoaded() && attributeList.getValue(HREF) == null) {
            id.setLoaded(true);
        }
    }

    private void setReference(ModelLink modelLink, AttributeList attributeList) {
        block7: {
            String string = attributeList.getValue(this.getIdrefAttrib());
            Id id = null;
            if (string != null) {
                id = (Id)this.xToId.get(string);
            }
            if (id != null) {
                try {
                    if (((Id)this.constructs.peek()).isLoaded()) {
                        this.api.add((Id)this.constructs.peek(), modelLink, id);
                    }
                    break block7;
                }
                catch (ModelException modelException) {
                    if (this.debug) {
                        System.out.println("Error trying to add link to model!!!");
                    }
                    break block7;
                }
            }
            if (string != null) {
                this.unresolvedLinks.addElement(this.constructs.peek());
                this.unresolvedLinks.addElement(this.links.peek());
                this.unresolvedLinks.addElement(string);
            }
        }
    }

    private void setXMIProperties(Id id, AttributeList attributeList) throws ModelException {
        String string = attributeList.getValue(VERSION);
        if (string != null) {
            id.set(ModelProperty.IXT_XMI_VERSION, string);
        }
        if ((string = attributeList.getValue(TIMESTAMP)) != null) {
            id.set(ModelProperty.IXT_XMI_TIMESTAMP, string);
        }
        if ((string = attributeList.getValue(VERIFIED)) != null) {
            id.set(ModelProperty.IXT_XMI_VERIFIED, string);
        }
        if ((string = attributeList.getValue(NAME)) != null) {
            id.set(ModelProperty.IXT_XMI_NAME, string);
        }
        if ((string = attributeList.getValue(EXTENDER)) != null) {
            id.set(ModelProperty.IXT_XMI_EXTENDER, string);
        }
        if ((string = attributeList.getValue(EXTENDER_ID)) != null) {
            id.set(ModelProperty.IXT_XMI_EXTENDER_ID, string);
        }
    }

    public void startElement(String string, AttributeList attributeList) {
        this.text = "";
        this.lastHeader = "";
        Object object = this.mm.getMMConstruct(string);
        if (string.equals(XMI_NOTICE) && this.header != null) {
            this.lastHeader = XMI_NOTICE;
        } else if (object == null) {
            if (string.equals("XMI.reference") && this.getLastType() == ModelType.IXT_EXTENSION) {
                if (this.debug) {
                    System.out.println(string + " is a link.");
                }
                this.handleLink(ModelLink.IXT_EXTENSION_REFERENCE);
            } else {
                if (this.debug) {
                    System.out.println(string + " was not identified.");
                }
                this.mmConstructs.push(string);
            }
        } else if (object instanceof ModelType) {
            if (this.debug) {
                System.out.println(string + " is a construct.");
            }
            this.createConstruct((ModelType)object, attributeList);
        } else if (object instanceof ModelLink) {
            if (this.debug) {
                System.out.println(string + " is a link.");
            }
            this.handleLink((ModelLink)object);
        } else if (object instanceof ModelProperty && !((ModelProperty)object).isClass()) {
            if (this.debug) {
                System.out.println(string + " is a property.");
            }
            this.handleProperty((ModelProperty)object, attributeList);
        } else if (object instanceof ModelProperty && ((ModelProperty)object).isClass()) {
            if (this.debug) {
                System.out.println(string + " is a link.");
            }
            this.handleLink(((ModelProperty)object).getModelLink());
        }
    }

    public void text(String string) {
        this.text = this.text != null ? this.text + string : string;
    }
}

