/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.mod;

import com.ibm.xmi.mod.FileNotFoundException;
import com.ibm.xmi.mod.Listeners;
import com.ibm.xmi.mod.ModelAPI;
import com.ibm.xmi.mod.XMISAXHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.helpers.ParserFactory;

public class XMILoad {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final long CONSTRUCT_SIZE = 900L;
    private Parser parser;
    private String filename;
    private XMISAXHandler handler;
    private boolean validate;
    private ModelAPI api;
    private ZipFile inZip;

    public XMILoad(ModelAPI modelAPI, String string, Vector vector, int n, boolean bl, Vector vector2) {
        this.api = modelAPI;
        this.handler = new XMISAXHandler(modelAPI, vector, n, vector2);
        this.filename = string;
        this.validate = bl;
        try {
            this.parser = bl ? ParserFactory.makeParser("com.ibm.xml.parsers.ValidatingSAXParser") : ParserFactory.makeParser("com.ibm.xml.parsers.SAXParser");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void parse() throws Exception {
        this.parser.setDocumentHandler(this.handler);
        this.parser.setErrorHandler(this.handler);
        ZipFile zipFile = null;
        InputSource inputSource = this.searchForInputSource();
        if (inputSource != null) {
            this.parser.parse(inputSource);
            try {
                if (this.inZip != null) {
                    this.inZip.close();
                }
            }
            catch (Exception exception) {}
        } else {
            try {
                zipFile = new ZipFile(this.filename);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (zipFile == null) {
                File file = new File(this.filename);
                long l = (file.length() - 1100L) / 900L;
                this.handler.setConstructs(l);
                this.parser.parse(this.filename);
            } else {
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                long l = 0L;
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    long l2 = (zipEntry.getSize() - 11001L) / 900L;
                    if (l2 <= 0L) continue;
                    l += l2;
                }
                enumeration = zipFile.entries();
                long l3 = 0L;
                while (enumeration.hasMoreElements()) {
                    ZipEntry zipEntry = enumeration.nextElement();
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    InputSource inputSource2 = new InputSource(inputStream);
                    this.handler.setConstructs(l);
                    this.handler.setConstructCount(l3);
                    long l4 = (zipEntry.getSize() - 1100L) / 900L;
                    if (l4 > 0L) {
                        l3 += l4;
                    }
                    this.parser.parse(inputSource2);
                }
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        Listeners.fireProgress(1, 100);
    }

    private InputSource searchDirectory(String string) throws Exception {
        File file;
        if (string.equals(".")) {
            string = System.getProperty("user.dir");
        }
        if (!(file = new File(string + System.getProperty("file.separator") + this.filename.replace('/', File.separatorChar))).exists()) {
            return null;
        }
        long l = (file.length() - 1100L) / 900L;
        this.handler.setConstructs(l);
        return new InputSource(new FileInputStream(file));
    }

    private InputSource searchForInputSource() throws Exception {
        String string = this.api.getFilePath();
        if (string == null || string.equals("")) {
            return null;
        }
        File file = new File(this.filename);
        if (file.isAbsolute()) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            InputSource inputSource = null;
            if (zipFile != null) {
                inputSource = this.searchZipFile(zipFile);
                if (inputSource == null) {
                    try {
                        zipFile.close();
                        this.inZip = null;
                    }
                    catch (Exception exception) {}
                } else {
                    this.inZip = zipFile;
                }
            } else {
                inputSource = this.searchDirectory(string2);
                this.inZip = null;
            }
            if (inputSource == null) continue;
            return inputSource;
        }
        throw new FileNotFoundException(this.filename);
    }

    private InputSource searchZipFile(ZipFile zipFile) throws Exception {
        ZipEntry zipEntry = zipFile.getEntry(this.filename);
        if (zipEntry == null) {
            return null;
        }
        long l = (zipEntry.getSize() - 1100L) / 900L;
        this.handler.setConstructs(l);
        return new InputSource(zipFile.getInputStream(zipEntry));
    }
}

