/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.mod;

import com.ibm.xmi.mod.UHashtableEntry;
import com.ibm.xmi.mod.UHashtableEnumerator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;

public class UHashtable
extends Dictionary
implements Cloneable,
Serializable {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private transient UHashtableEntry[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    public UHashtable() {
        this(11, 1.0f);
    }

    public UHashtable(int n) {
        this(n, 1.0f);
    }

    public UHashtable(int n, float f) {
        if (n <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException();
        }
        this.loadFactor = f;
        this.table = new UHashtableEntry[n];
        this.threshold = (int)((float)n * f);
    }

    public void clear() {
        UHashtableEntry[] uHashtableEntryArray = this.table;
        int n = uHashtableEntryArray.length;
        while (--n >= 0) {
            uHashtableEntryArray[n] = null;
        }
        this.count = 0;
    }

    public Object clone() {
        try {
            UHashtable uHashtable = (UHashtable)super.clone();
            uHashtable.table = new UHashtableEntry[this.table.length];
            int n = this.table.length;
            while (n-- > 0) {
                uHashtable.table[n] = this.table[n] != null ? (UHashtableEntry)this.table[n].clone() : null;
            }
            return uHashtable;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean contains(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        UHashtableEntry[] uHashtableEntryArray = this.table;
        int n = uHashtableEntryArray.length;
        while (n-- > 0) {
            UHashtableEntry uHashtableEntry = uHashtableEntryArray[n];
            while (uHashtableEntry != null) {
                if (uHashtableEntry.value.equals(object)) {
                    return true;
                }
                uHashtableEntry = uHashtableEntry.next;
            }
        }
        return false;
    }

    public boolean containsKey(Object object) {
        UHashtableEntry[] uHashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % uHashtableEntryArray.length;
        UHashtableEntry uHashtableEntry = uHashtableEntryArray[n2];
        while (uHashtableEntry != null) {
            if (uHashtableEntry.hash == n && uHashtableEntry.key.equals(object)) {
                return true;
            }
            uHashtableEntry = uHashtableEntry.next;
        }
        return false;
    }

    public Enumeration elements() {
        return new UHashtableEnumerator(this.table, false);
    }

    public Object get(Object object) {
        UHashtableEntry[] uHashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % uHashtableEntryArray.length;
        UHashtableEntry uHashtableEntry = uHashtableEntryArray[n2];
        while (uHashtableEntry != null) {
            if (uHashtableEntry.hash == n && uHashtableEntry.key.equals(object)) {
                return uHashtableEntry.value;
            }
            uHashtableEntry = uHashtableEntry.next;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public Enumeration keys() {
        return new UHashtableEnumerator(this.table, true);
    }

    public Object put(Object object, Object object2) {
        if (object2 == null) {
            throw new NullPointerException();
        }
        UHashtableEntry[] uHashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % uHashtableEntryArray.length;
        UHashtableEntry uHashtableEntry = uHashtableEntryArray[n2];
        while (uHashtableEntry != null) {
            if (uHashtableEntry.hash == n && uHashtableEntry.key.equals(object)) {
                Object object3 = uHashtableEntry.value;
                uHashtableEntry.value = object2;
                return object3;
            }
            uHashtableEntry = uHashtableEntry.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            return this.put(object, object2);
        }
        uHashtableEntry = new UHashtableEntry();
        uHashtableEntry.hash = n;
        uHashtableEntry.key = object;
        uHashtableEntry.value = object2;
        uHashtableEntry.next = uHashtableEntryArray[n2];
        uHashtableEntryArray[n2] = uHashtableEntry;
        ++this.count;
        return null;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        int n3 = (int)((float)n2 * this.loadFactor) + n2 / 20 + 3;
        if (n3 > n2 && (n3 & 1) == 0) {
            --n3;
        }
        if (n > 0 && n3 > n) {
            n3 = n;
        }
        this.table = new UHashtableEntry[n3];
        this.count = 0;
        while (n2 > 0) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.put(object, object2);
            --n2;
        }
    }

    protected void rehash() {
        int n = this.table.length;
        UHashtableEntry[] uHashtableEntryArray = this.table;
        int n2 = 0;
        if (n < 1000) {
            n2 = n * 2 + 1;
        } else {
            n2 = (int)((float)n * 1.5f);
            if ((n2 & 1) == 0) {
                ++n2;
            }
        }
        UHashtableEntry[] uHashtableEntryArray2 = new UHashtableEntry[n2];
        this.threshold = (int)((float)n2 * this.loadFactor);
        this.table = uHashtableEntryArray2;
        int n3 = n;
        while (n3-- > 0) {
            UHashtableEntry uHashtableEntry = uHashtableEntryArray[n3];
            while (uHashtableEntry != null) {
                UHashtableEntry uHashtableEntry2 = uHashtableEntry;
                uHashtableEntry = uHashtableEntry.next;
                int n4 = (uHashtableEntry2.hash & Integer.MAX_VALUE) % n2;
                uHashtableEntry2.next = uHashtableEntryArray2[n4];
                uHashtableEntryArray2[n4] = uHashtableEntry2;
            }
        }
    }

    public Object remove(Object object) {
        UHashtableEntry[] uHashtableEntryArray = this.table;
        int n = object.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % uHashtableEntryArray.length;
        UHashtableEntry uHashtableEntry = uHashtableEntryArray[n2];
        UHashtableEntry uHashtableEntry2 = null;
        while (uHashtableEntry != null) {
            if (uHashtableEntry.hash == n && uHashtableEntry.key.equals(object)) {
                if (uHashtableEntry2 != null) {
                    uHashtableEntry2.next = uHashtableEntry.next;
                } else {
                    uHashtableEntryArray[n2] = uHashtableEntry.next;
                }
                --this.count;
                return uHashtableEntry.value;
            }
            uHashtableEntry2 = uHashtableEntry;
            uHashtableEntry = uHashtableEntry.next;
        }
        return null;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        int n = this.size() - 1;
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration enumeration = this.keys();
        Enumeration enumeration2 = this.elements();
        stringBuffer.append("{");
        for (int i = 0; i <= n; ++i) {
            String string = enumeration.nextElement().toString();
            String string2 = enumeration2.nextElement().toString();
            stringBuffer.append(string + "=" + string2);
            if (i >= n) continue;
            stringBuffer.append(", ");
            stringBuffer.append("\n");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.count);
        for (int i = this.table.length - 1; i >= 0; --i) {
            UHashtableEntry uHashtableEntry = this.table[i];
            while (uHashtableEntry != null) {
                objectOutputStream.writeObject(uHashtableEntry.key);
                objectOutputStream.writeObject(uHashtableEntry.value);
                uHashtableEntry = uHashtableEntry.next;
            }
        }
    }
}

