/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.mod;

import com.ibm.xmi.mod.Metamodel;
import com.ibm.xmi.mod.ModelType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class TestScript {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private Hashtable constructCounts = new Hashtable();
    private String description;
    private String testFile;
    private Vector contents;
    private FileOutputStream fos;
    final int DESCRIPTION_LENGTH = 45;
    private String className;
    private Metamodel metamodel;
    private ModelType type;
    private boolean mode;

    public TestScript(String string, Metamodel metamodel, ModelType modelType, boolean bl) {
        this.testFile = string;
        this.description = "";
        this.contents = new Vector();
        if (bl) {
            this.contents.addElement(new String("--> setSaveMemory true"));
            this.contents.addElement(new String("true"));
        }
        this.contents.addElement(new String("--> getSession"));
        this.contents.addElement(new String(""));
        this.contents.addElement(new String("--> setLabel s"));
        this.contents.addElement(new String("s"));
        this.className = "";
        this.metamodel = metamodel;
        this.type = modelType;
        this.mode = bl;
    }

    public void add(String string, String string2, String string3, String string4) {
        if (string3 != null) {
            this.contents.addElement("--> add " + string + " " + string2 + " " + string3);
        } else {
            this.contents.addElement("--> add " + string + " " + string2);
        }
        if (string4.equals("id")) {
            this.contents.addElement("com.ibm.xmi.mod.Id.xx");
        } else {
            this.contents.addElement(string4);
        }
        this.updateCount(string2);
    }

    private void addOutput(String string) {
        if (string.equals("")) {
            this.contents.addElement("");
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            this.contents.addElement(stringTokenizer.nextToken());
        }
    }

    private void closeFile(FileOutputStream fileOutputStream) {
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Error closing file.");
        }
    }

    public void create(String string, String string2) {
        this.contents.addElement("--> create " + string);
        if (string2.equals("id")) {
            this.contents.addElement("com.ibm.psh.xmi.Id.xx");
        } else {
            this.contents.addElement(string2);
        }
    }

    public void get(String string, String string2, String string3) {
        this.contents.addElement(new String("--> get " + string + " " + string2));
        this.addOutput(string3);
    }

    public void get(String string, String string2, String string3, String string4) {
        String string5 = "--> get " + string + " ";
        string5 = string2.equals("") ? string5 + "\"\" " : string5 + string2 + " ";
        string5 = string5 + string3;
        this.contents.addElement(string5);
        this.addOutput(string4);
    }

    public void get(String string, String string2, String string3, Vector vector) {
        String string4 = "--> get " + string + " ";
        string4 = string2.equals("") ? string4 + "\"\" " : string4 + string2 + " ";
        string4 = string4 + string3;
        this.contents.addElement(string4);
        for (int i = 0; i < vector.size(); ++i) {
            this.contents.addElement((String)vector.elementAt(i));
        }
    }

    public void get(String string, String string2, Vector vector, String string3, String string4) {
        String string5 = "--> get " + string + " " + string2 + " ";
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            string5 = string5 + enumeration.nextElement() + " ";
        }
        string5 = string5 + string3;
        this.contents.addElement(string5);
        this.addOutput(string4);
    }

    public String getClassName() {
        return this.className;
    }

    public int getCount(String string) {
        try {
            if (!this.constructCounts.containsKey(string)) {
                return 0;
            }
            Integer n = (Integer)this.constructCounts.get(string);
            return n;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return -1;
        }
    }

    public void getLinks(String string, String string2) {
        this.contents.addElement(new String("--> getLinks " + string));
        this.addOutput(string2);
    }

    private String getName() {
        int n = this.testFile.lastIndexOf("\\");
        if (n == -1) {
            return this.testFile;
        }
        return this.testFile.substring(n + 1);
    }

    public void getProperties(String string, String string2) {
        this.contents.addElement(new String("--> getProperties " + string));
        this.addOutput(string2);
    }

    public void getSets(String string, String string2) {
        this.contents.addElement(new String("--> getSets " + string));
        this.addOutput(string2);
    }

    public void getTags(String string, String string2, String string3) {
        this.contents.addElement(new String("--> getTags " + string + " " + string2));
        this.addOutput(string3);
    }

    public void getUUID() {
        this.contents.addElement(new String("--> getUUID"));
        this.addOutput("DCE");
    }

    protected String instance(String string, String string2, String string3, int n) {
        return "";
    }

    public void instance(String string, String string2, String string3, int n, String string4, String string5) {
        String string6 = "--> APIInstance " + string2 + " " + string + " ";
        int n2 = string3.indexOf(" ");
        string6 = n2 == -1 ? string6 + string3 : string6 + "\"" + string3 + "\"";
        this.contents.addElement(string6);
        String string7 = "(rc=0)   \"" + string4 + "\"(" + n + ",\"" + string5 + "\")";
        this.contents.addElement(string7);
    }

    protected String link(String string, String string2, String string3, ModelType modelType, String string4) {
        String string5 = string3 + "/";
        String string6 = "--> APILink " + string + " " + string2 + " " + modelType;
        if (string4.equals("")) {
            string5 = string5 + "$Link" + (this.getCount("Type.all") + 1);
        } else {
            int n = string4.indexOf(" ");
            string6 = n == -1 ? string6 + " " + string4 : string6 + " \"" + string4 + "\"";
            string5 = string5 + string4.trim();
        }
        this.contents.addElement(string6);
        this.contents.addElement(string5);
        this.updateCount("Type.all");
        return string5;
    }

    private FileOutputStream openFile(String string) {
        File file = new File(string);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (IOException iOException) {
            System.out.println("Exception: " + iOException);
            return null;
        }
        if (!file.canWrite()) {
            System.out.println("Cannot write to file " + file);
            return null;
        }
        return fileOutputStream;
    }

    public void save(Vector vector, String string, int n) {
        String string2 = "--> save ";
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                string2 = string2 + enumeration.nextElement() + " ";
            }
        }
        string2 = string2 + string + " " + n;
        this.contents.addElement(string2);
        this.contents.addElement("");
    }

    public void set(String string, Object object, String string2, int n, String string3, String string4) {
        String string5 = "--> APISet " + string + " " + object;
        int n2 = string2.indexOf(" ");
        string5 = n2 == -1 ? string5 + " " + string2 : string5 + " \"" + string2 + "\"";
        this.contents.addElement(string5);
        string5 = "(rc=0)   \"" + string3 + "\"(" + n + ",\"" + string4 + "\")";
        this.contents.addElement(string5);
    }

    public void set(String string, String string2, String string3, String string4) {
        String string5 = "--> set " + string + " ";
        string5 = string2.equals("") ? string5 + "\"\" " : string5 + string2 + " ";
        string5 = string5 + string3;
        this.contents.addElement(string5);
        this.contents.addElement(string4);
    }

    public void set(String string, String string2, String string3, String string4, String string5) {
        String string6 = "--> set " + string + " ";
        string6 = string2.equals("") ? string6 + "\"\" " : string6 + string2 + " ";
        string6 = string6 + string3 + " " + string4;
        this.contents.addElement(string6);
        this.contents.addElement(string5);
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setLabel(String string) {
        this.contents.addElement(new String("--> setLabel " + string));
        this.contents.addElement(new String(string));
    }

    private void updateCount(String string) {
        try {
            if (!this.constructCounts.containsKey(string)) {
                this.constructCounts.put(string, new Integer(1));
            } else {
                Integer n = (Integer)this.constructCounts.get(string);
                this.constructCounts.put(string, new Integer(n + 1));
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public boolean write() {
        this.fos = this.openFile(this.testFile);
        if (this.fos == null) {
            return false;
        }
        boolean bl = this.writeProlog();
        if (bl) {
            bl = this.writeContents();
        }
        this.closeFile(this.fos);
        return bl;
    }

    private boolean writeContents() {
        Enumeration enumeration = this.contents.elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (this.writeLine(string)) continue;
            return false;
        }
        return true;
    }

    private boolean writeLine(String string) {
        try {
            this.fos.write(string.getBytes());
            String string2 = "\n";
            this.fos.write(string2.getBytes());
        }
        catch (Exception exception) {
            System.out.println(exception);
            return false;
        }
        return true;
    }

    private boolean writeProlog() {
        String string = "////////////////////////////////////////////////////////////";
        if (!this.writeLine(string)) {
            return false;
        }
        String string2 = "// Test Case:  " + this.getName();
        if (!this.writeLine(string2)) {
            return false;
        }
        string2 = "// Programmer: Unit Test System Generated";
        if (!this.writeLine(string2)) {
            return false;
        }
        string2 = "// Date: " + new Date();
        if (!this.writeLine(string2)) {
            return false;
        }
        if (this.description.length() < 45 ? !this.writeLine(string2 = "// Description:  " + this.description) : !this.writeSplitDescription()) {
            return false;
        }
        return this.writeLine(string);
    }

    private boolean writeSplitDescription() {
        int n = this.description.lastIndexOf(" ", 44);
        String string = this.description.substring(n + 1);
        String string2 = this.description.substring(0, n);
        String string3 = "// Description:  " + string2;
        if (!this.writeLine(string3)) {
            return false;
        }
        while (string.length() > 45) {
            n = string.lastIndexOf(" ", 44);
            string2 = string.substring(0, n);
            string = string.substring(n + 1);
            string3 = "//               " + string2;
            if (this.writeLine(string3)) continue;
            return false;
        }
        string3 = "//               " + string;
        return this.writeLine(string3);
    }
}

