/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.mod;

import com.ibm.xmi.mod.Metamodel;
import com.ibm.xmi.mod.MetamodelManager;
import com.ibm.xmi.mod.ModelType;
import com.ibm.xmi.mod.TestBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class TestGenerator {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private MetamodelManager mm;
    private String directory;
    private Vector allTests;
    private Hashtable testCounts;
    public static final int ALL_TESTS = 1;
    public static final int ADD_TESTS = 2;
    public static final int SET_TESTS = 3;
    public static final int DEL_TESTS = 4;
    public static final int GET_TESTS = 5;
    public static final int LNK_TESTS = 6;
    public static final int CRT_TESTS = 7;
    public static final int LOAD_TESTS = 8;
    public static final int SAVE_TESTS = 9;
    public static final int XMI_TESTS = 10;
    public static final int UML_TESTS = 11;

    public TestGenerator(String string, MetamodelManager metamodelManager) {
        this.directory = string;
        this.allTests = new Vector();
        this.testCounts = new Hashtable();
        this.mm = metamodelManager;
    }

    private void addVector(Vector vector, Vector vector2) {
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
    }

    public int generate(String string, int n, ModelType modelType, boolean bl) {
        int n2 = 0;
        Metamodel metamodel = this.mm.getMetamodel(string);
        if (n == 2 || n == 1) {
            n2 = this.generateTests(2, metamodel, modelType, bl);
        }
        if (n2 == -1) {
            return -1;
        }
        if (n == 3 || n == 1) {
            n2 = this.generateTests(3, metamodel, modelType, bl);
        }
        if (n2 == -1) {
            return -1;
        }
        if (n == 5 || n == 1) {
            n2 = this.generateTests(5, metamodel, null, bl);
        }
        if (n2 == -1) {
            return -1;
        }
        if (n == 9 || n == 1) {
            n2 = this.generateTests(9, metamodel, modelType, bl);
        }
        if (n2 == -1) {
            return -1;
        }
        this.makeFile(1, this.getTypeAll(), null);
        return this.allTests.size();
    }

    private int generateTests(int n, Metamodel metamodel, ModelType modelType, boolean bl) {
        int n2 = 0;
        Vector vector = new Vector();
        Vector vector2 = this.getTypes(metamodel, modelType);
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            int n3;
            Vector vector3 = new Vector();
            ModelType modelType2 = (ModelType)enumeration.nextElement();
            TestBuilder testBuilder = this.makeTestBuilder(this.directory, n, metamodel, modelType2, (n3 = this.getCount(modelType2)) + 1, false, bl);
            int n4 = this.generateTests(testBuilder, vector3);
            if (n4 == -1) {
                return -1;
            }
            n2 += n4;
            this.updateCount(modelType2, n3 += n4);
            if (n != 9) {
                TestBuilder testBuilder2 = this.makeTestBuilder(this.directory, n, metamodel, modelType2, n3 + 1, true, bl);
                n4 = this.generateTests(testBuilder2, vector3);
                if (n4 == -1) {
                    return -1;
                }
                n2 += n4;
                this.updateCount(modelType2, n3 += n4);
            }
            if (n != 5) {
                this.makeFile(n, modelType2, vector3);
            }
            this.addVector(vector, vector3);
        }
        this.resetCounts();
        this.makeFile(n, this.getTypeAll(), vector);
        return n2;
    }

    private int generateTests(TestBuilder testBuilder, Vector vector) {
        Vector vector2 = testBuilder.build();
        if (vector2 == null) {
            return -1;
        }
        this.addVector(vector, vector2);
        this.addVector(this.allTests, vector2);
        return vector2.size();
    }

    public int getCount(ModelType modelType) {
        try {
            if (!this.testCounts.containsKey(modelType)) {
                return 0;
            }
            Integer n = (Integer)this.testCounts.get(modelType);
            return n;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return -1;
        }
    }

    protected ModelType getTypeAll() {
        return ModelType.IXT_ALL;
    }

    private Vector getTypes(Metamodel metamodel, ModelType modelType) {
        Vector vector = new Vector();
        if (modelType == this.getTypeAll()) {
            Vector vector2 = this.mm.getMetamodels();
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                Metamodel metamodel2 = (Metamodel)enumeration.nextElement();
                if (metamodel != null && metamodel != metamodel2) continue;
                Enumeration enumeration2 = metamodel2.getAllTypes();
                while (enumeration2.hasMoreElements()) {
                    vector.addElement(enumeration2.nextElement());
                }
            }
        } else if (modelType == null) {
            vector.addElement(this.getTypeAll());
        } else {
            vector.addElement(modelType);
        }
        return vector;
    }

    private void makeFile(int n, ModelType modelType, Vector vector) {
        if (vector != null && vector.size() == 0) {
            return;
        }
        String string = "alltests";
        if (n == 2) {
            string = "addtests";
        } else if (n == 3) {
            string = "settests";
        } else if (n == 5) {
            string = "gettests";
        }
        if (modelType != this.getTypeAll()) {
            string = modelType.toString().substring(0, 3) + string;
        }
        string = this.directory + System.getProperty("file.separator") + string;
        File file = new File(string);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (IOException iOException) {
            System.out.println("Exception: " + iOException);
            return;
        }
        if (!file.canWrite()) {
            System.out.println("Cannot write to file " + file);
            return;
        }
        Enumeration enumeration = vector == null ? this.allTests.elements() : vector.elements();
        while (enumeration.hasMoreElements()) {
            this.writeLine(fileOutputStream, (String)enumeration.nextElement());
        }
        try {
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            System.out.println("Error closing file.");
        }
    }

    protected TestBuilder makeTestBuilder(String string, int n, Metamodel metamodel, ModelType modelType, int n2, boolean bl, boolean bl2) {
        return TestBuilder.make(string, n, metamodel, modelType, n2, bl, bl2);
    }

    private void resetCounts() {
        this.testCounts.clear();
    }

    private void updateCount(ModelType modelType, int n) {
        try {
            this.testCounts.put(modelType, new Integer(n));
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private boolean writeLine(FileOutputStream fileOutputStream, String string) {
        try {
            fileOutputStream.write(string.getBytes());
            String string2 = "\n";
            fileOutputStream.write(string2.getBytes());
        }
        catch (Exception exception) {
            System.out.println(exception);
            return false;
        }
        return true;
    }
}

