/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.mod;

import com.ibm.xmi.mod.Metamodel;
import com.ibm.xmi.mod.ModelProperty;
import com.ibm.xmi.mod.ModelType;
import com.ibm.xmi.mod.TestBuilder;
import com.ibm.xmi.mod.TestScript;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;

public class SetTestBuilder
extends TestBuilder {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String DEFAULT = "value";

    protected SetTestBuilder(String string, Metamodel metamodel, ModelType modelType, int n, boolean bl, boolean bl2) {
        super(string, metamodel, modelType, n, bl, bl2);
    }

    public Vector build() {
        Vector vector = new Vector();
        int n = this.getFirstNum();
        if (!this.buildPropertyTests(vector, n)) {
            return null;
        }
        n = this.getFirstNum() + vector.size();
        if (!this.buildTagValueTests(vector, n)) {
            return null;
        }
        return vector;
    }

    private boolean buildPropertyTests(Vector vector, int n) {
        Vector vector2 = this.getProperties();
        if (vector2 == null) {
            return true;
        }
        int n2 = n;
        Enumeration enumeration = vector2.elements();
        while (enumeration.hasMoreElements()) {
            ModelProperty modelProperty = (ModelProperty)enumeration.nextElement();
            if (modelProperty.isClass()) continue;
            String string = modelProperty.getLegalValues();
            if (string.equals("")) {
                string = DEFAULT;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                Vector<Object> vector3 = new Vector<Object>();
                vector3.addElement(modelProperty);
                vector3.addElement(stringTokenizer.nextToken());
                if (this.buildTest(n2++, vector3, vector)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean buildTagValueTests(Vector vector, int n) {
        int n2 = n;
        Vector<String> vector2 = new Vector<String>();
        vector2.addElement("1default");
        vector2.addElement("tag1");
        vector2.addElement("value1");
        if (!this.buildTest(n2++, vector2, vector)) {
            return false;
        }
        vector2 = new Vector();
        vector2.addElement("2default");
        vector2.addElement("tag1");
        vector2.addElement("value1");
        vector2.addElement("tag2");
        vector2.addElement("value2");
        if (!this.buildTest(n2++, vector2, vector)) {
            return false;
        }
        vector2 = new Vector();
        vector2.addElement("1set");
        vector2.addElement("set1");
        vector2.addElement("tag1");
        vector2.addElement("value1");
        if (!this.buildTest(n2++, vector2, vector)) {
            return false;
        }
        vector2 = new Vector();
        vector2.addElement("2in1set");
        vector2.addElement("set1");
        vector2.addElement("tag1");
        vector2.addElement("value1");
        vector2.addElement("tag2");
        vector2.addElement("value2");
        if (!this.buildTest(n2++, vector2, vector)) {
            return false;
        }
        vector2 = new Vector();
        vector2.addElement("2in2set");
        vector2.addElement("set1");
        vector2.addElement("tag1");
        vector2.addElement("value1");
        vector2.addElement("set2");
        vector2.addElement("tag1");
        vector2.addElement("value2");
        if (!this.buildTest(n2++, vector2, vector)) {
            return false;
        }
        vector2 = new Vector();
        vector2.addElement("combo");
        vector2.addElement("tag1");
        vector2.addElement("value1");
        vector2.addElement("set1");
        vector2.addElement("tag2");
        vector2.addElement("value2");
        return this.buildTest(n2++, vector2, vector);
    }

    protected String getTestType() {
        return "ms";
    }

    protected boolean makeContent(TestScript testScript, Vector vector) {
        ModelType modelType = this.getType();
        String string = "construct";
        testScript.add("s", "Type." + this.getName(modelType), null, "id");
        testScript.setLabel(string);
        if (vector.firstElement() instanceof ModelProperty) {
            String string2 = (String)vector.elementAt(1);
            String string3 = "Property." + vector.firstElement();
            testScript.set(string, string3, string2, "");
            testScript.get(string, string3, "'" + string2 + "'");
            return true;
        }
        String string4 = (String)vector.firstElement();
        if (string4.equals("1set")) {
            String string5 = (String)vector.elementAt(1);
            String string6 = (String)vector.elementAt(2);
            String string7 = (String)vector.elementAt(3);
            testScript.set(string, string5, string6, string7, "");
            testScript.get(string, string5, string6, "'" + string7 + "'");
        } else if (string4.equals("2in1set")) {
            String string8 = (String)vector.elementAt(1);
            String string9 = (String)vector.elementAt(2);
            String string10 = (String)vector.elementAt(3);
            String string11 = (String)vector.elementAt(4);
            String string12 = (String)vector.elementAt(5);
            testScript.set(string, string8, string9, string10, "");
            testScript.set(string, string8, string11, string12, "");
            testScript.get(string, string8, string9, "'" + string10 + "'");
            testScript.get(string, string8, string11, "'" + string12 + "'");
        } else if (string4.equals("2in2set")) {
            String string13 = (String)vector.elementAt(1);
            String string14 = (String)vector.elementAt(2);
            String string15 = (String)vector.elementAt(3);
            String string16 = (String)vector.elementAt(4);
            String string17 = (String)vector.elementAt(5);
            String string18 = (String)vector.elementAt(6);
            testScript.set(string, string13, string14, string15, "");
            testScript.set(string, string16, string17, string18, "");
            testScript.get(string, string13, string14, "'" + string15 + "'");
            testScript.get(string, string16, string17, "'" + string18 + "'");
        } else if (string4.equals("1default")) {
            String string19 = (String)vector.elementAt(1);
            String string20 = (String)vector.elementAt(2);
            testScript.set(string, "", string19, string20, "");
            testScript.get(string, "", string19, "'" + string20 + "'");
        } else if (string4.equals("2default")) {
            String string21 = (String)vector.elementAt(1);
            String string22 = (String)vector.elementAt(2);
            String string23 = (String)vector.elementAt(3);
            String string24 = (String)vector.elementAt(4);
            testScript.set(string, "", string21, string22, "");
            testScript.set(string, "", string23, string24, "");
            testScript.get(string, "", string21, "'" + string22 + "'");
            testScript.get(string, "", string23, "'" + string24 + "'");
        } else if (string4.equals("combo")) {
            String string25 = (String)vector.elementAt(1);
            String string26 = (String)vector.elementAt(2);
            String string27 = (String)vector.elementAt(3);
            String string28 = (String)vector.elementAt(4);
            String string29 = (String)vector.elementAt(5);
            testScript.set(string, "", string25, string26, "");
            testScript.set(string, string27, string28, string29, "");
            testScript.get(string, "", string25, "'" + string26 + "'");
            testScript.get(string, string27, string28, "'" + string29 + "'");
        } else {
            return false;
        }
        return true;
    }

    protected boolean makeDescription(TestScript testScript, Vector vector) {
        String string = "Test if can set ";
        if (vector.firstElement() instanceof ModelProperty) {
            string = string + vector.firstElement() + " of " + this.getType() + " to ";
            string = string + vector.elementAt(1);
        } else {
            String string2 = (String)vector.firstElement();
            if (string2.equals("1default")) {
                string = string + "default tagged value pair for " + this.getType();
            } else if (string2.equals("2default")) {
                string = string + "two default tagged value pairs for " + this.getType();
            } else if (string2.equals("1set")) {
                string = string + "tagged value pair in a set for " + this.getType();
            } else if (string2.equals("2in1set")) {
                string = string + "two tagged value pairs in a set for " + this.getType();
            } else if (string2.equals("2in2set")) {
                string = string + "a tagged value pair in two sets for " + this.getType();
            } else if (string2.equals("combo")) {
                string = string + "a default tagged value pair and a ";
                string = string + "tagged value pair in a set for " + this.getType();
            }
        }
        string = string + this.getModeString();
        testScript.setDescription(string);
        return true;
    }
}

