/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.mod;

import com.ibm.xmi.mod.DuplicateException;
import com.ibm.xmi.mod.Id;
import com.ibm.xmi.mod.IntArray;
import com.ibm.xmi.mod.LargeHashtable;
import com.ibm.xmi.mod.ModelAPI;
import com.ibm.xmi.mod.ModelException;
import com.ibm.xmi.mod.ModelLink;
import com.ibm.xmi.mod.NoLinkException;
import com.ibm.xmi.mod.Relationships;
import com.ibm.xmi.mod.UHashtable;
import java.util.Enumeration;
import java.util.Vector;

class SMRelationships
extends Relationships {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String HASH_PREFIX = "rl";
    private UHashtable links = new UHashtable();

    SMRelationships(ModelAPI modelAPI) {
        super(modelAPI);
    }

    public void add(Id id, ModelLink modelLink, Id id2) throws ModelException {
        this.addToLinks(id, modelLink, id2);
        super.add(id, modelLink, id2);
    }

    private void addToLinks(Id id, ModelLink modelLink, Id id2) throws DuplicateException {
        Object object;
        LargeHashtable largeHashtable = (LargeHashtable)this.links.get(modelLink);
        if (largeHashtable == null) {
            object = this.api.getHashPrefix() + HASH_PREFIX + (this.links.size() + 1);
            largeHashtable = new LargeHashtable(1001, (String)object);
            this.links.put(modelLink, largeHashtable);
        }
        if ((object = (IntArray)largeHashtable.get(id.getInt())) == null) {
            object = new IntArray();
            largeHashtable.put(id.getInt(), object);
        }
        if (((IntArray)object).contains(id2.getInt())) {
            throw new DuplicateException();
        }
        ((IntArray)object).add(id2.getInt());
    }

    public void clear() {
        Enumeration enumeration = this.links.elements();
        while (enumeration.hasMoreElements()) {
            ((LargeHashtable)enumeration.nextElement()).clear();
        }
        this.links.clear();
    }

    protected Vector get(Id id, ModelLink modelLink) {
        LargeHashtable largeHashtable = (LargeHashtable)this.links.get(modelLink);
        if (largeHashtable == null) {
            return null;
        }
        IntArray intArray = (IntArray)largeHashtable.get(id.getInt());
        if (intArray == null || intArray.size() == 0) {
            return null;
        }
        int[] nArray = intArray.array();
        Vector<Id> vector = new Vector<Id>();
        for (int i = 0; i < intArray.size(); ++i) {
            Id id2 = this.api.getId(nArray[i]);
            if (id2 == null) continue;
            vector.addElement(id2);
        }
        return this.removeDeletedIds(vector);
    }

    protected Vector getAllLinks() {
        Vector vector = new Vector();
        Enumeration enumeration = this.links.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        return vector;
    }

    public Vector getIds() {
        Vector<Id> vector = new Vector<Id>();
        if (this.links == null) {
            return vector;
        }
        Enumeration enumeration = this.links.elements();
        while (enumeration.hasMoreElements()) {
            LargeHashtable largeHashtable = (LargeHashtable)enumeration.nextElement();
            Vector vector2 = largeHashtable.keys();
            Enumeration enumeration2 = vector2.elements();
            while (enumeration2.hasMoreElements()) {
                Id id = this.api.getIds().getId((Integer)enumeration2.nextElement());
                if (vector.contains(id) || id.isDeleted()) continue;
                vector.addElement(id);
            }
        }
        return vector;
    }

    public Vector getSources() {
        Vector<Id> vector = new Vector<Id>();
        if (this.links == null) {
            return vector;
        }
        Enumeration enumeration = this.links.elements();
        while (enumeration.hasMoreElements()) {
            LargeHashtable largeHashtable = (LargeHashtable)enumeration.nextElement();
            Vector vector2 = largeHashtable.keys();
            Enumeration enumeration2 = vector2.elements();
            while (enumeration2.hasMoreElements()) {
                Id id = this.api.getId((Integer)enumeration2.nextElement());
                if (vector.contains(id) || id.isDeleted()) continue;
                vector.addElement(id);
            }
        }
        return vector;
    }

    protected boolean hasSource(ModelLink modelLink, Id id) {
        LargeHashtable largeHashtable = (LargeHashtable)this.links.get(modelLink);
        if (largeHashtable == null) {
            return false;
        }
        return largeHashtable.containsKey(id.getInt());
    }

    public Vector remove(Id id) {
        Vector<Id> vector = null;
        Enumeration enumeration = this.links.elements();
        while (enumeration.hasMoreElements()) {
            LargeHashtable largeHashtable = (LargeHashtable)enumeration.nextElement();
            IntArray intArray = (IntArray)largeHashtable.get(id.getInt());
            if (intArray != null) {
                for (int i = 0; i < intArray.size(); ++i) {
                    int n = intArray.array()[i];
                    Id id2 = this.api.getId(n);
                    if (id2.isDeleted()) continue;
                    id2.setRefCount(id2.getRefCount() - 1);
                    if (id2.getRefCount() != 0) continue;
                    if (vector == null) {
                        vector = new Vector<Id>();
                    }
                    vector.addElement(id2);
                }
            }
            largeHashtable.remove(id.getInt());
        }
        return vector;
    }

    public void remove(Id id, ModelLink modelLink, Id id2) throws ModelException {
        this.removeFromLinks(id, modelLink, id2);
        super.remove(id, modelLink, id2);
    }

    public void removeFromLinks(Id id, ModelLink modelLink, Id id2) throws ModelException {
        LargeHashtable largeHashtable = (LargeHashtable)this.links.get(modelLink);
        if (largeHashtable == null) {
            throw new NoLinkException(id, modelLink, id2);
        }
        IntArray intArray = (IntArray)largeHashtable.get(id.getInt());
        if (intArray == null) {
            throw new NoLinkException(id, modelLink, id2);
        }
        if (!intArray.contains(id2.getInt())) {
            throw new NoLinkException(id, modelLink, id2);
        }
        intArray.remove(id2.getInt());
        if (intArray.size() == 0) {
            largeHashtable.remove(id.getInt());
        }
    }
}

