/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.mod;

import com.ibm.xmi.mod.Construct;
import com.ibm.xmi.mod.DuplicateException;
import com.ibm.xmi.mod.Id;
import com.ibm.xmi.mod.Ids;
import com.ibm.xmi.mod.LargeHashtable;
import com.ibm.xmi.mod.ModelAPI;
import com.ibm.xmi.mod.ModelException;
import com.ibm.xmi.mod.UHashtable;
import com.ibm.xmi.mod.UIntHashtable;
import java.util.Vector;

class SMIds
extends Ids {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String HREF_PREFIX = "ih";
    private static final String LABEL_PREFIX = "il";
    private static final String UUID_PREFIX = "iu";
    private static final String UUIDREF_PREFIX = "iur";
    private UHashtable uhLabelToId;
    private UHashtable uhUUIDToId;
    private UIntHashtable uihIntToId = new UIntHashtable(101, 1.0f);
    private LargeHashtable lhIntToLabel;
    private LargeHashtable lhIntToUUID;
    private LargeHashtable lhIntToHref;
    private LargeHashtable lhIntToUUIDRef;
    private int count = 0;

    SMIds(ModelAPI modelAPI) {
        super(modelAPI);
    }

    Id add(Construct construct) {
        SMId sMId = new SMId(construct);
        this.uihIntToId.put(sMId.getInt(), sMId);
        return sMId;
    }

    private void addToUHashtable(UHashtable uHashtable, String string, Id id) {
        if (string == null) {
            return;
        }
        Vector<Id> vector = (Vector<Id>)uHashtable.get(string);
        if (vector != null) {
            vector.addElement(id);
        } else {
            vector = new Vector<Id>(1);
            vector.addElement(id);
            uHashtable.put(string, vector);
        }
    }

    void clear() {
        if (this.uhLabelToId != null) {
            this.uhLabelToId.clear();
        }
        if (this.uhUUIDToId != null) {
            this.uhUUIDToId.clear();
        }
        if (this.uihIntToId != null) {
            this.uihIntToId.clear();
        }
        if (this.lhIntToLabel != null) {
            this.lhIntToLabel.clear();
        }
        if (this.lhIntToUUID != null) {
            this.lhIntToUUID.clear();
        }
        if (this.lhIntToUUIDRef != null) {
            this.lhIntToUUIDRef.clear();
        }
        if (this.lhIntToHref != null) {
            this.lhIntToHref.clear();
        }
        this.count = 0;
    }

    String getHref(SMId sMId) {
        if (this.lhIntToHref == null || sMId == null) {
            return null;
        }
        return (String)this.lhIntToHref.get(sMId.getInt());
    }

    Id getId(int n) {
        if (this.uihIntToId == null) {
            this.uihIntToId = new UIntHashtable(101, 1.0f);
        }
        return (Id)this.uihIntToId.get(n);
    }

    public Id getId(String string) {
        if (string == null) {
            return null;
        }
        if (this.uhUUIDToId == null) {
            return null;
        }
        return (Id)this.uhUUIDToId.get(string);
    }

    public Vector getIdsFromLabel(String string) {
        if (string == null) {
            return null;
        }
        if (this.uhLabelToId == null) {
            return null;
        }
        return (Vector)this.uhLabelToId.get(string);
    }

    String getLabel(SMId sMId) {
        if (this.lhIntToLabel == null || sMId == null) {
            return null;
        }
        return (String)this.lhIntToLabel.get(sMId.getInt());
    }

    String getUUID(SMId sMId) {
        if (this.lhIntToUUID == null || sMId == null) {
            return null;
        }
        return (String)this.lhIntToUUID.get(sMId.getInt());
    }

    public String getUUIDREF(SMId sMId) {
        if (this.lhIntToUUIDRef == null || sMId == null) {
            return null;
        }
        return (String)this.lhIntToUUIDRef.get(sMId.getInt());
    }

    void remove(Id id) {
        if (!(id instanceof SMId)) {
            return;
        }
        SMId sMId = (SMId)id;
        if (this.lhIntToLabel != null) {
            this.lhIntToLabel.remove(sMId.getInt());
        }
        if (this.lhIntToUUID != null) {
            this.lhIntToUUID.remove(sMId.getInt());
        }
        if (this.lhIntToHref != null) {
            this.lhIntToHref.remove(sMId.getInt());
        }
        if (this.lhIntToUUIDRef != null) {
            this.lhIntToUUIDRef.remove(sMId.getInt());
        }
        if (this.uihIntToId != null) {
            this.uihIntToId.remove(sMId.getInt());
        }
    }

    private void removeFromUHashtable(UHashtable uHashtable, String string, Id id) {
        if (uHashtable == null || string == null) {
            return;
        }
        Vector vector = (Vector)uHashtable.get(string);
        if (vector != null) {
            vector.removeElement(id);
            if (vector.size() == 0) {
                uHashtable.remove(string);
            }
        }
    }

    void setHref(SMId sMId, String string) {
        if (this.lhIntToHref != null) {
            this.lhIntToHref.remove(sMId.getInt());
        }
        if (string != null) {
            if (this.lhIntToHref == null) {
                this.lhIntToHref = new LargeHashtable(1001, this.api.getHashPrefix() + HREF_PREFIX);
            }
            this.lhIntToHref.put(sMId.getInt(), string);
        }
    }

    void setLabel(Id id, String string, String string2) {
        if (!(id instanceof SMId)) {
            return;
        }
        SMId sMId = (SMId)id;
        if (this.lhIntToLabel != null) {
            this.lhIntToLabel.remove(sMId.getInt());
        }
        this.removeFromUHashtable(this.uhLabelToId, string2, sMId);
        if (string != null) {
            if (this.lhIntToLabel == null) {
                this.lhIntToLabel = new LargeHashtable(1001, this.api.getHashPrefix() + LABEL_PREFIX);
            }
            this.lhIntToLabel.put(sMId.getInt(), string);
        }
        if (this.uhLabelToId == null) {
            this.uhLabelToId = new UHashtable(101, 1.0f);
        }
        this.addToUHashtable(this.uhLabelToId, string, id);
    }

    void setUUID(Id id, String string, String string2) {
        if (!(id instanceof SMId)) {
            return;
        }
        SMId sMId = (SMId)id;
        if (this.lhIntToUUID != null) {
            this.lhIntToUUID.remove(sMId.getInt());
        }
        if (string2 != null) {
            this.uhUUIDToId.remove(string2);
        }
        if (string != null) {
            if (this.lhIntToUUID == null) {
                this.lhIntToUUID = new LargeHashtable(1001, this.api.getHashPrefix() + UUID_PREFIX);
            }
            this.lhIntToUUID.put(sMId.getInt(), string);
        }
        if (this.uhUUIDToId == null) {
            this.uhUUIDToId = new UHashtable(101, 1.0f);
        }
        this.uhUUIDToId.put(string, id);
    }

    void setUUIDREF(SMId sMId, String string) {
        if (this.lhIntToUUIDRef != null) {
            this.lhIntToUUIDRef.remove(sMId.getInt());
        }
        if (string != null) {
            if (this.lhIntToUUIDRef == null) {
                this.lhIntToUUIDRef = new LargeHashtable(1001, this.api.getHashPrefix() + UUIDREF_PREFIX);
            }
            this.lhIntToUUIDRef.put(sMId.getInt(), string);
        }
    }

    private class SMId
    extends Id {
        private int number;

        SMId(Construct construct) {
            super(construct, SMIds.this.api);
            this.number = ++SMIds.this.count;
        }

        public String getHref() {
            return SMIds.this.getHref(this);
        }

        int getInt() {
            return this.number;
        }

        public String getLabel() {
            return SMIds.this.getLabel(this);
        }

        public String getUUID() {
            if (SMIds.this.getUUID(this) == null) {
                SMIds.this.setUUID(this, SMId.createUUID(), null);
            }
            return SMIds.this.getUUID(this);
        }

        public String getUUIDREF() {
            return SMIds.this.getUUIDREF(this);
        }

        void remove() {
            this.setDeleted(true);
            SMIds.this.remove(this);
        }

        public String retrieveUUID() {
            return SMIds.this.getUUID(this);
        }

        public void setHref(String string) {
            SMIds.this.setHref(this, string);
        }

        public void setLabel(String string) {
            SMIds.this.setLabel(this, string, this.getLabel());
        }

        public void setUUID(String string) throws ModelException {
            String string2 = SMIds.this.getUUID(this);
            if (string2 != null && string2.equals(string)) {
                return;
            }
            if (SMIds.this.uhUUIDToId != null && SMIds.this.uhUUIDToId.get(string) != null) {
                throw new DuplicateException();
            }
            SMIds.this.setUUID(this, string, this.retrieveUUID());
        }

        public void setUUIDREF(String string) {
            SMIds.this.setUUIDREF(this, string);
        }
    }
}

