/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.mod;

import com.ibm.xmi.mod.FastProperties;
import com.ibm.xmi.mod.Id;
import com.ibm.xmi.mod.ModelAPI;
import com.ibm.xmi.mod.ModelException;
import com.ibm.xmi.mod.ModelLink;
import com.ibm.xmi.mod.ModelProperty;
import com.ibm.xmi.mod.SMProperties;
import java.util.Vector;

public abstract class Properties {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    protected ModelAPI api;

    protected Properties(ModelAPI modelAPI) {
        this.api = modelAPI;
    }

    public abstract void clear();

    public Vector filterProperties(Vector vector, Vector vector2) {
        if (vector == null || vector2.size() == 0) {
            return vector;
        }
        Vector vector3 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            if (!this.hasProperties((Id)vector.elementAt(i), vector2)) continue;
            vector3.addElement(vector.elementAt(i));
        }
        if (vector3.size() == 0) {
            return null;
        }
        return vector3;
    }

    public Vector filterSets(Vector vector, Vector vector2) {
        if (vector == null || vector2.size() == 0) {
            return vector;
        }
        Vector vector3 = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            if (!this.hasTags((Id)vector.elementAt(i), vector2)) continue;
            vector3.addElement(vector.elementAt(i));
        }
        return vector3;
    }

    public abstract Vector getProperties(Id var1);

    public abstract String getProperty(Id var1, ModelProperty var2);

    public abstract Vector getSets(Id var1);

    public abstract String getTag(Id var1, String var2, String var3);

    public abstract Vector getTags(Id var1, String var2);

    private void handleExtensionDelete(Id id, String string) {
        Vector vector = null;
        try {
            vector = this.api.get(id, ModelLink.IXT_EXTENSION_REFERENCE, false);
        }
        catch (ModelException modelException) {
            // empty catch block
        }
        if (vector == null || vector.size() == 0) {
            return;
        }
        Id id2 = (Id)vector.firstElement();
        Vector vector2 = null;
        try {
            vector2 = this.api.get(id2, ModelLink.IXT_DATA, false);
        }
        catch (ModelException modelException) {
            // empty catch block
        }
        boolean bl = false;
        if (vector2 != null && vector2.contains(id)) {
            bl = true;
        }
        if ((string == null || string.equals("false")) && bl) {
            try {
                this.api.delete(id2, ModelLink.IXT_DATA, id);
            }
            catch (ModelException modelException) {}
        } else if (string.equals("true") && !bl) {
            try {
                this.api.add(id2, ModelLink.IXT_DATA, id);
            }
            catch (ModelException modelException) {
                // empty catch block
            }
        }
    }

    private boolean hasProperties(Id id, Vector vector) {
        for (int i = 0; i < vector.size() - 1; i += 2) {
            ModelProperty modelProperty = (ModelProperty)vector.elementAt(i);
            String string = (String)vector.elementAt(i + 1);
            String string2 = this.getProperty(id, modelProperty);
            if (string2 == null) {
                return false;
            }
            if (string2.equals(string)) continue;
            return false;
        }
        return true;
    }

    private boolean hasTags(Id id, Vector vector) {
        for (int i = 0; i < vector.size() - 2; i += 3) {
            String string = (String)vector.elementAt(i);
            String string2 = (String)vector.elementAt(i + 1);
            String string3 = (String)vector.elementAt(i + 2);
            String string4 = this.getTag(id, string, string2);
            if (string4 == null) {
                return false;
            }
            if (string4.equals(string3)) continue;
            return false;
        }
        return true;
    }

    public static Properties makeProperties(ModelAPI modelAPI, boolean bl) {
        if (bl) {
            return new SMProperties(modelAPI);
        }
        return new FastProperties(modelAPI);
    }

    public abstract void remove(Id var1);

    protected abstract void removeProperty(Id var1, ModelProperty var2) throws ModelException;

    protected abstract void removeTag(Id var1, String var2, String var3) throws ModelException;

    public void setProperty(Id id, ModelProperty modelProperty, String string) throws ModelException {
        if (string == null) {
            this.removeProperty(id, modelProperty);
        } else {
            this.updateProperty(id, modelProperty, string);
        }
        if (modelProperty == ModelProperty.IXT_EXTENSION_DELETE) {
            this.handleExtensionDelete(id, string);
        }
    }

    public void setTag(Id id, String string, String string2, String string3) throws ModelException {
        if (string == null) {
            string = "";
        }
        if (string3 == null) {
            this.removeTag(id, string, string2);
        } else {
            this.updateTag(id, string, string2, string3);
        }
    }

    protected abstract void updateProperty(Id var1, ModelProperty var2, String var3);

    protected abstract void updateTag(Id var1, String var2, String var3, String var4);
}

