/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.mod;

import com.ibm.xmi.mod.BadContainerException;
import com.ibm.xmi.mod.BadCriteriaException;
import com.ibm.xmi.mod.BadIdException;
import com.ibm.xmi.mod.BadLinkException;
import com.ibm.xmi.mod.BadLoadOptionException;
import com.ibm.xmi.mod.BadPropertyException;
import com.ibm.xmi.mod.BadSaveOptionException;
import com.ibm.xmi.mod.BadTypeException;
import com.ibm.xmi.mod.Construct;
import com.ibm.xmi.mod.Constructs;
import com.ibm.xmi.mod.Id;
import com.ibm.xmi.mod.Ids;
import com.ibm.xmi.mod.Listeners;
import com.ibm.xmi.mod.LoadException;
import com.ibm.xmi.mod.MetamodelManager;
import com.ibm.xmi.mod.ModelException;
import com.ibm.xmi.mod.ModelLink;
import com.ibm.xmi.mod.ModelProperty;
import com.ibm.xmi.mod.ModelType;
import com.ibm.xmi.mod.NullParameterException;
import com.ibm.xmi.mod.Properties;
import com.ibm.xmi.mod.Relationships;
import com.ibm.xmi.mod.SaveMemoryException;
import com.ibm.xmi.mod.Session;
import com.ibm.xmi.mod.StringAPI;
import com.ibm.xmi.mod.XMILoad;
import com.ibm.xmi.mod.XMILoaderFactory;
import com.ibm.xmi.mod.XMISave;
import com.ibm.xmi.mod.XMISaveFactory;
import java.io.File;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Vector;
import java.util.zip.ZipOutputStream;

public class ModelAPI {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int DEFAULT = 1;
    public static final int TRACK_FILES = 2;
    public static final int LOAD_HEADER = 3;
    public static final int NO_DTD = 4;
    private static final String HASH_PREFIX = "ixt";
    private static int number = 0;
    private static ModelAPI instance = null;
    static final float LOAD_FACTOR = 1.0f;
    static final int INITIAL_CAPACITY = 101;
    static final int LARGE_SIZE = 1001;
    private boolean log;
    private boolean saveMemory;
    private boolean started;
    private boolean demandLoad;
    private int count;
    private Vector loadIds;
    private String filePath;
    private Constructs constructs;
    private Id session;
    private Properties properties;
    private Relationships relationships;
    private Ids ids;
    private StringAPI stringAPI;
    private MetamodelManager mm;
    private XMISaveFactory xsf;
    private XMILoaderFactory xlf;
    private Construct sessionConstruct;

    public ModelAPI() {
        if (instance == null) {
            instance = this;
        }
        this.log = false;
        this.saveMemory = false;
        this.started = false;
        this.demandLoad = true;
        this.loadIds = null;
        this.filePath = null;
        this.count = ++number;
    }

    public void add(Id id, ModelLink modelLink, Id id2) throws ModelException {
        if (this.log) {
            System.out.println("");
            System.out.println("add function...");
            System.out.println("   construct:  " + id);
            System.out.println("   link:       " + modelLink);
            System.out.println("   associated: " + id2);
        }
        if (id == null || modelLink == null || id2 == null) {
            if (this.log) {
                System.out.println("Throwing NullParameterException...");
            }
            throw new NullParameterException();
        }
        if (id.isDeleted()) {
            if (this.log) {
                System.out.println("Throwing BadIdException...");
            }
            throw new BadIdException(id);
        }
        if (id2.isDeleted()) {
            if (this.log) {
                System.out.println("Throwing BadIdException...");
            }
            throw new BadIdException(id2);
        }
        if (modelLink == ModelLink.IXT_ALL) {
            if (this.log) {
                System.out.println("Throwing BadLinkException...");
            }
            throw new BadLinkException(modelLink);
        }
        if (!id.isLoaded() && this.demandLoad) {
            this.demandLoad(id);
        }
        this.getRelationships().add(id, modelLink, id2);
    }

    public Id add(Id id, ModelType modelType, String string) throws ModelException {
        return this.add(id, modelType, string, true);
    }

    public Id add(Id id, ModelType modelType, String string, boolean bl) throws ModelException {
        if (this.log) {
            System.out.println("");
            System.out.println("add method...");
            System.out.println("  construct:     " + id);
            System.out.println("  type:          " + modelType);
            System.out.println("  name:          " + string);
            System.out.println("  containerLink: " + bl);
        }
        if (id == null || modelType == null) {
            if (this.log) {
                System.out.println("Throwing NullParameterException...");
            }
            throw new NullParameterException();
        }
        if (modelType == ModelType.IXT_ALL) {
            if (this.log) {
                System.out.println("Throwing BadType Exception");
            }
            throw new BadTypeException(modelType);
        }
        if (id.isDeleted()) {
            if (this.log) {
                System.out.println("Throwing BadIdException...");
            }
            throw new BadIdException(id);
        }
        if (modelType == ModelType.IXT_EXTENSION && id.getConstruct().getType() != ModelType.IXT_EXTENSION && id.getConstruct().getType() != ModelType.IXT_XMI_EXTENSION) {
            if (this.log) {
                System.out.println("Throwing BadContainerException...");
            }
            throw new BadContainerException();
        }
        if (!id.isLoaded() && this.demandLoad) {
            this.demandLoad(id);
        }
        Id id2 = id.getConstruct().add(id, modelType, string, bl);
        if (this.log) {
            System.out.println("Returning...");
            System.out.println("id: " + id2);
        }
        return id2;
    }

    public void addListener(Id id, EventListener eventListener) throws ModelException {
        if (this.log) {
            System.out.println("");
            System.out.println("addListener method...");
            System.out.println("  construct:     " + id);
            System.out.println("  listener:      " + eventListener);
        }
        if (eventListener == null) {
            if (this.log) {
                System.out.println("Throwing NullParameterException...");
            }
            throw new NullParameterException();
        }
        Listeners.addListener(id, eventListener);
    }

    void addToLoadIds(Id id) {
        if (this.loadIds == null) {
            this.loadIds = new Vector();
        }
        this.loadIds.addElement(id);
    }

    public void check(Id id, boolean bl) throws ModelException {
    }

    void clear() {
        instance = null;
        this.log = false;
        this.saveMemory = false;
        this.started = false;
        if (this.relationships != null) {
            this.relationships.clear();
        }
        this.relationships = null;
        if (this.ids != null) {
            this.ids.clear();
        }
        this.ids = null;
        if (this.properties != null) {
            this.properties.clear();
        }
        this.properties = null;
    }

    public Id create(ModelType modelType) throws ModelException {
        if (this.log) {
            System.out.println("");
            System.out.println("Create function...");
            System.out.println("  type: " + modelType);
        }
        if (modelType == null) {
            if (this.log) {
                System.out.println("Throwing NullParameterException...");
            }
            throw new NullParameterException();
        }
        Construct construct = this.getConstructs().makeConstruct(this, modelType);
        if (construct == null) {
            if (this.log) {
                System.out.println("Throwing BadTypeException for type: " + modelType);
            }
            throw new BadTypeException(modelType);
        }
        Id id = this.getIds().add(construct);
        if (this.log) {
            System.out.println("Returning...");
            System.out.println("id: " + id);
        }
        return id;
    }

    public Vector delete(Id id) throws ModelException {
        if (this.log) {
            System.out.println("");
            System.out.println("delete function...");
            System.out.println("  construct: " + id);
        }
        if (id == null) {
            if (this.log) {
                System.out.println("Throwing NullParameterException...");
            }
            throw new NullParameterException();
        }
        if (id.isDeleted()) {
            if (this.log) {
                System.out.println("Throwing BadIdException...");
            }
            throw new BadIdException(id);
        }
        if (!id.isLoaded() && this.demandLoad) {
            this.demandLoad(id);
        }
        Vector vector = id.getConstruct().delete(id);
        if (this.log && vector != null) {
            System.out.println("Returning...");
            for (int i = 0; i < vector.size(); ++i) {
                System.out.println("id: " + vector.elementAt(i));
            }
        } else if (this.log && vector == null) {
            System.out.println("Returning...");
        }
        return vector;
    }

    public void delete(Id id, ModelLink modelLink, Id id2) throws ModelException {
        if (this.log) {
            System.out.println("");
            System.out.println("delete function...");
            System.out.println("   construct:  " + id);
            System.out.println("   link:       " + modelLink);
            System.out.println("   associated: " + id2);
        }
        if (id == null || modelLink == null || id2 == null) {
            if (this.log) {
                System.out.println("Throwing NullParameterException...");
            }
            throw new NullParameterException();
        }
        if (id.isDeleted()) {
            if (this.log) {
                System.out.println("Throwing BadIdException...");
            }
            throw new BadIdException(id);
        }
        if (id2.isDeleted()) {
            if (this.log) {
                System.out.println("Throwing BadIdException...");
            }
            throw new BadIdException(id2);
        }
        if (modelLink == ModelLink.IXT_ALL) {
            if (this.log) {
                System.out.println("Throwing BadLinkException...");
            }
            throw new BadLinkException(modelLink);
        }
        if (!id.isLoaded() && this.demandLoad) {
            this.demandLoad(id);
        }
        this.getRelationships().remove(id, modelLink, id2);
    }

    public void demandLoad(Id id) throws ModelException {
        String string = id.getHref();
        int n = string.indexOf("|");
        if (n == -1) {
            n = string.indexOf("#");
        }
        if (n != -1) {
            string = string.substring(0, n);
        }
        if (string.startsWith("/")) {
            string = string.substring(1);
        }
        Vector vector = this.loadIds;
        try {
            this.load(string, new Vector(), 1, false);
        }
        catch (Exception exception) {
            this.loadIds = vector;
            if (exception instanceof ModelException) {
                throw (ModelException)exception;
            }
            throw new LoadException(exception);
        }
    }

    public String execute(String string) {
        return this.getStringAPI().execute(string);
    }

    public Vector get(Id id, ModelLink modelLink, boolean bl) throws ModelException {
        if (this.log) {
            System.out.println("");
            System.out.println("Get function...");
            System.out.println("    construct: " + id);
            System.out.println("    link:      " + modelLink);
            System.out.println("    recursive: " + bl);
        }
        if (id == null || modelLink == null) {
            if (this.log) {
                System.out.println("Throwing NullParameterException...");
            }
            throw new NullParameterException();
        }
        if (id.isDeleted()) {
            if (this.log) {
                System.out.println("Throwing BadIdException...");
            }
            throw new BadIdException(id);
        }
        if (!id.isLoaded() && this.demandLoad) {
            this.demandLoad(id);
        }
        Vector vector = this.getRelationships().get(id, modelLink, bl);
        if (this.log) {
            if (vector == null) {
                System.out.println("Returning null...");
            } else {
                System.out.println("Returning...");
                for (int i = 0; i < vector.size(); ++i) {
                    System.out.println("id: " + vector.elementAt(i));
                }
            }
        }
        return vector;
    }

    public String get(Id id, ModelProperty modelProperty) throws ModelException {
        if (this.log) {
            System.out.println("");
            System.out.println("Get function...");
            System.out.println("    construct: " + id);
            System.out.println("    property: " + modelProperty);
        }
        if (id == null || modelProperty == null) {
            if (this.log) {
                System.out.println("Throwing NullParameterException...");
            }
            throw new NullParameterException();
        }
        if (id.isDeleted()) {
            if (this.log) {
                System.out.println("Throwing BadIdException...");
            }
            throw new BadIdException(id);
        }
        if (modelProperty.isClass()) {
            if (this.log) {
                System.out.println("Throwing BadPropertyException...");
            }
            throw new BadPropertyException(modelProperty);
        }
        if (!id.isLoaded() && this.demandLoad) {
            this.demandLoad(id);
        }
        String string = this.getProperties().getProperty(id, modelProperty);
        if (this.log) {
            if (string == null) {
                System.out.println("value: " + string);
            } else {
                System.out.println("value: '" + string + "'");
            }
        }
        return string;
    }

    public Vector get(Id id, ModelType modelType, Vector vector, boolean bl) throws ModelException {
        if (this.log) {
            System.out.println("");
            System.out.println("Get function...");
            System.out.println("    container: " + id);
            System.out.println("    type: " + modelType);
            System.out.println("    criteria: " + vector);
            System.out.println("    recursive: " + bl);
        }
        if (id == null || modelType == null) {
            if (this.log) {
                System.out.println("Throwing NullParameterException...");
            }
            throw new NullParameterException();
        }
        if (id.isDeleted()) {
            if (this.log) {
                System.out.println("Throwing BadIdException...");
            }
            throw new BadIdException(id);
        }
        if (!id.getConstruct().checkCriteria(vector)) {
            if (this.log) {
                System.out.println("Throwing BadCriteriaException...");
            }
            throw new BadCriteriaException();
        }
        if (!id.isLoaded() && this.demandLoad) {
            this.demandLoad(id);
        }
        Vector vector2 = id.getConstruct().getType(id, modelType, bl);
        vector2 = id.getConstruct().filterCriteria(vector2, vector);
        if (this.log) {
            if (vector2 == null) {
                System.out.println("Returning null...");
            } else {
                System.out.println("Returning...");
                for (int i = 0; i < vector2.size(); ++i) {
                    System.out.println("id: " + vector2.elementAt(i));
                }
            }
        }
        return vector2;
    }

    public Vector get(Id id, ModelType modelType, boolean bl) throws ModelException {
        if (this.log) {
            System.out.println("");
            System.out.println("Get function...");
            System.out.println("  construct: " + id);
            System.out.println("  type: " + modelType);
            System.out.println("  recursive: " + bl);
        }
        if (id == null || modelType == null) {
            if (this.log) {
                System.out.println("Throwing NullParameterException...");
            }
            throw new NullParameterException();
        }
        if (id.isDeleted()) {
            if (this.log) {
                System.out.println("Throwing BadIdException...");
            }
            throw new BadIdException(id);
        }
        if (!id.isLoaded() && this.demandLoad) {
            this.demandLoad(id);
        }
        Vector vector = id.getConstruct().getType(id, modelType, bl);
        if (this.log) {
            if (vector == null) {
                System.out.println("Returning null...");
            } else {
                System.out.println("Returning...");
                for (int i = 0; i < vector.size(); ++i) {
                    System.out.println("id: " + vector.elementAt(i));
                }
            }
        }
        return vector;
    }

    public String get(Id id, String string) throws ModelException {
        if (this.log) {
            System.out.println("");
            System.out.println("Get function...");
            System.out.println("  construct: " + id);
            System.out.println("  tag: " + string);
        }
        if (id == null || string == null) {
            if (this.log) {
                System.out.println("Throwing NullParameterException...");
            }
            throw new NullParameterException();
        }
        if (id.isDeleted()) {
            if (this.log) {
                System.out.println("Throwing BadIdException...");
            }
            throw new BadIdException(id);
        }
        if (!id.isLoaded() && this.demandLoad) {
            this.demandLoad(id);
        }
        String string2 = this.getProperties().getTag(id, "", string);
        if (this.log) {
            if (string2 == null) {
                System.out.println("value: null");
            } else {
                System.out.println("value: '" + string2 + "'");
            }
        }
        return string2;
    }

    public String get(Id id, String string, String string2) throws ModelException {
        if (this.log) {
            System.out.println("");
            System.out.println("Get function...");
            System.out.println("  construct: " + id);
            System.out.println("  set: " + string);
            System.out.println("  tag: " + string2);
        }
        if (id == null || string2 == null) {
            if (this.log) {
                System.out.println("Throwing NullParameterException...");
            }
            throw new NullParameterException();
        }
        if (id.isDeleted()) {
            if (this.log) {
                System.out.println("Throwing BadIdException...");
            }
            throw new BadIdException(id);
        }
        if (string == null) {
            string = "";
        }
        if (!id.isLoaded() && this.demandLoad) {
            this.demandLoad(id);
        }
        String string3 = this.getProperties().getTag(id, string, string2);
        if (this.log) {
            if (string3 == null) {
                System.out.println("value: " + string3);
            } else {
                System.out.println("value: '" + string3 + "'");
            }
        }
        return string3;
    }

    public Constructs getConstructs() {
        if (this.constructs == null) {
            this.constructs = new Constructs();
        }
        return this.constructs;
    }

    public boolean getDemandLoad() {
        return this.demandLoad;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String getHashPrefix() {
        return HASH_PREFIX + this.count;
    }

    public Id getId(int n) {
        return this.getIds().getId(n);
    }

    public Id getId(String string) {
        return this.getIds().getId(string);
    }

    public Ids getIds() {
        if (this.ids == null) {
            this.ids = Ids.makeIds(this, this.saveMemory);
        }
        return this.ids;
    }

    Vector getIdsFromLabel(String string) {
        return this.getIds().getIdsFromLabel(string);
    }

    public Vector getLinks(Id id) throws ModelException {
        if (this.log) {
            System.out.println("");
            System.out.println("Get links...");
            System.out.println("  construct: " + id);
        }
        if (id == null) {
            if (this.log) {
                System.out.println("Throwing NullParameterException...");
            }
            throw new NullParameterException();
        }
        if (id.isDeleted()) {
            if (this.log) {
                System.out.println("Throwing BadIdException...");
            }
            throw new BadIdException(id);
        }
        if (!id.isLoaded() && this.demandLoad) {
            this.demandLoad(id);
        }
        Vector vector = this.getRelationships().getLinks(id);
        if (this.log) {
            if (vector == null) {
                System.out.println("Returning null...");
            } else {
                System.out.println("Returning...");
                for (int i = 0; i < vector.size(); ++i) {
                    System.out.println("link: " + vector.elementAt(i));
                }
            }
        }
        return vector;
    }

    public Vector getLoadIds() {
        return this.loadIds;
    }

    public boolean getLog() {
        return this.log;
    }

    public MetamodelManager getMetamodelManager() {
        if (this.mm == null) {
            this.mm = new MetamodelManager();
        }
        return this.mm;
    }

    public Properties getProperties() {
        if (this.properties == null) {
            this.properties = Properties.makeProperties(this, this.saveMemory);
        }
        return this.properties;
    }

    public Vector getProperties(Id id) throws ModelException {
        if (this.log) {
            System.out.println("");
            System.out.println("Get properties...");
            System.out.println("  construct: " + id);
        }
        if (id == null) {
            if (this.log) {
                System.out.println("Throwing NullParameterException...");
            }
            throw new NullParameterException();
        }
        if (id.isDeleted()) {
            if (this.log) {
                System.out.println("Throwing BadIdException...");
            }
            throw new BadIdException(id);
        }
        if (!id.isLoaded() && this.demandLoad) {
            this.demandLoad(id);
        }
        Vector vector = this.getProperties().getProperties(id);
        if (this.log) {
            if (vector == null) {
                System.out.println("Returning null...");
            } else {
                System.out.println("Returning...");
                for (int i = 0; i < vector.size(); ++i) {
                    System.out.println("property: " + vector.elementAt(i));
                }
            }
        }
        return vector;
    }

    public Relationships getRelationships() {
        if (this.relationships == null) {
            this.relationships = Relationships.makeRelationships(this, this.saveMemory);
        }
        return this.relationships;
    }

    public Id getSession() {
        this.started = true;
        if (this.session == null) {
            this.session = this.sessionConstruct != null ? this.getIds().add(this.sessionConstruct) : this.getIds().add(new Session(this, null));
        }
        return this.session;
    }

    public Vector getSets(Id id) throws ModelException {
        if (this.log) {
            System.out.println("");
            System.out.println("Get sets...");
            System.out.println("  construct: " + id);
        }
        if (id == null) {
            if (this.log) {
                System.out.println("Throwing NullParameterException...");
            }
            throw new NullParameterException();
        }
        if (id.isDeleted()) {
            if (this.log) {
                System.out.println("Throwing BadIdException...");
            }
            throw new BadIdException(id);
        }
        if (!id.isLoaded() && this.demandLoad) {
            this.demandLoad(id);
        }
        Vector vector = this.getProperties().getSets(id);
        if (this.log) {
            if (vector == null) {
                System.out.println("Returning null...");
            } else {
                System.out.println("Returning...");
                for (int i = 0; i < vector.size(); ++i) {
                    System.out.println("set: '" + vector.elementAt(i) + "'");
                }
            }
        }
        return vector;
    }

    private StringAPI getStringAPI() {
        if (this.stringAPI == null) {
            this.stringAPI = new StringAPI(this);
        }
        return this.stringAPI;
    }

    public Vector getTags(Id id, String string) throws ModelException {
        if (this.log) {
            System.out.println("");
            System.out.println("Get tags...");
            System.out.println("  construct: " + id);
            System.out.println("  set:       '" + string + "'");
        }
        if (id == null) {
            if (this.log) {
                System.out.println("Throwing NullParameterException...");
            }
            throw new NullParameterException();
        }
        if (id.isDeleted()) {
            if (this.log) {
                System.out.println("Throwing BadIdException...");
            }
            throw new BadIdException(id);
        }
        if (!id.isLoaded() && this.demandLoad) {
            this.demandLoad(id);
        }
        Vector vector = this.getProperties().getTags(id, string);
        if (this.log) {
            if (vector == null) {
                System.out.println("Returning null...");
            } else {
                System.out.println("Returning...");
                for (int i = 0; i < vector.size(); ++i) {
                    System.out.println("tag: '" + vector.elementAt(i) + "'");
                }
            }
        }
        return vector;
    }

    public XMILoaderFactory getXMILoaderFactory() {
        if (this.xlf == null) {
            this.xlf = new XMILoaderFactory();
        }
        return this.xlf;
    }

    public XMISaveFactory getXMISaveFactory() {
        if (this.xsf == null) {
            this.xsf = new XMISaveFactory();
        }
        return this.xsf;
    }

    public static ModelAPI instance() {
        if (instance == null) {
            instance = new ModelAPI();
        }
        return instance;
    }

    public boolean isSaveMemory() {
        return this.saveMemory;
    }

    public Vector load(String string, Vector vector, int n, boolean bl) throws Exception {
        return this.load(string, vector, n, bl, null);
    }

    public Vector load(String string, Vector vector, int n, boolean bl, Vector vector2) throws Exception {
        if (this.log) {
            System.out.println("");
            System.out.println("Load function...");
            System.out.println("  filename: " + string);
            System.out.println("  warnings: " + vector);
            System.out.println("    option: " + n);
            System.out.println("  validate: " + bl);
            System.out.println("    header: " + vector2);
        }
        if (n != 1 && n != 2 && n != 3) {
            if (this.log) {
                System.out.println("Throwing bad load option exception: " + n);
            }
            throw new BadLoadOptionException(n);
        }
        this.loadIds = null;
        XMILoad xMILoad = new XMILoad(this, string, vector, n, bl, vector2);
        try {
            xMILoad.parse();
        }
        catch (Exception exception) {
            if (this.log) {
                System.out.println("Throwing exception: " + exception);
            }
            throw exception;
        }
        if (this.log) {
            if (this.loadIds == null) {
                System.out.println("Returning null...");
            } else {
                System.out.println("Returning...");
                for (int i = 0; i < this.loadIds.size(); ++i) {
                    System.out.println("id: '" + this.loadIds.elementAt(i) + "'");
                }
            }
        }
        return this.loadIds;
    }

    public void removeListener(Id id, EventListener eventListener) throws ModelException {
        if (this.log) {
            System.out.println("");
            System.out.println("removeListener method...");
            System.out.println("  construct:     " + id);
            System.out.println("  listener:      " + eventListener);
        }
        if (eventListener == null) {
            if (this.log) {
                System.out.println("Throwing NullParameterException...");
            }
            throw new NullParameterException();
        }
        Listeners.removeListener(id, eventListener);
    }

    public void save(Id id, String string, int n) throws Exception {
        Vector<Id> vector = new Vector<Id>(1);
        vector.addElement(id);
        this.save(vector, string, n, new Vector());
    }

    public void save(Id id, String string, int n, Vector vector) throws Exception {
        Vector<Id> vector2 = new Vector<Id>(1);
        vector2.addElement(id);
        this.save(vector2, string, n, vector);
    }

    public void save(Id id, ZipOutputStream zipOutputStream, int n, Vector vector) throws Exception {
        Vector<Id> vector2 = new Vector<Id>(1);
        vector2.addElement(id);
        this.save(vector2, zipOutputStream, n, vector);
    }

    public void save(Vector vector, String string, int n) throws Exception {
        this.save(vector, string, n, new Vector());
    }

    public void save(Vector vector, String string, int n, Vector vector2) throws Exception {
        this.save(vector, string, n, vector2, null);
    }

    public void save(Vector vector, String string, int n, Vector vector2, Vector vector3) throws Exception {
        Object object;
        if (this.log) {
            System.out.println("Save function...");
            System.out.println("          constructs: " + vector);
            System.out.println("     fileOrDirectory: " + string);
            System.out.println("              option: " + n);
        }
        if (string == null || vector == null) {
            if (this.log) {
                System.out.println("Throwing null parameter exception...");
            }
            throw new NullParameterException();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (Id)enumeration.nextElement();
            if (object != this.getSession() && !((Id)object).isDeleted()) continue;
            if (this.log) {
                System.out.println("Throwing bad id exception: " + object);
            }
            throw new BadIdException((Id)object);
        }
        if (n != 1 && n != 4) {
            if (this.log) {
                System.out.println("Throwing bad save option exception: " + n);
            }
            throw new BadSaveOptionException(n);
        }
        object = null;
        try {
            object = new File(string);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        if (vector2 == null) {
            vector2 = new Vector();
        }
        XMISave xMISave = XMISave.makeXMISave(this, vector, (File)object, null, n, "XMI Toolkit", "1.05", "", this.mm.getMetamodels(), vector2, vector3);
        xMISave.save();
    }

    public void save(Vector vector, ZipOutputStream zipOutputStream, int n, Vector vector2) throws Exception {
        this.save(vector, zipOutputStream, n, vector2, null);
    }

    public void save(Vector vector, ZipOutputStream zipOutputStream, int n, Vector vector2, Vector vector3) throws Exception {
        Object object;
        if (this.log) {
            System.out.println("Save function...");
            System.out.println("  constructs: " + vector);
            System.out.println("         zos: zos");
            System.out.println("      option: " + n);
        }
        if (zipOutputStream == null || vector == null) {
            if (this.log) {
                System.out.println("Throwing null parameter exception...");
            }
            throw new NullParameterException();
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object = (Id)enumeration.nextElement();
            if (object != this.getSession() && !((Id)object).isDeleted()) continue;
            if (this.log) {
                System.out.println("Throwing bad id exception: " + object);
            }
            throw new BadIdException((Id)object);
        }
        if (n != 1 && n != 4) {
            if (this.log) {
                System.out.println("Throwing bad save option exception: " + n);
            }
            throw new BadSaveOptionException(n);
        }
        if (vector2 == null) {
            vector2 = new Vector();
        }
        object = XMISave.makeXMISave(this, vector, null, zipOutputStream, n, "XMI Toolkit", "1.05", "", this.mm.getMetamodels(), vector2, vector3);
        ((XMISave)object).save();
    }

    public void set(Id id, ModelProperty modelProperty, String string) throws ModelException {
        if (this.log) {
            System.out.println("");
            System.out.println("Set function...");
            System.out.println("  construct: " + id);
            System.out.println("  property: " + modelProperty);
            System.out.println("  value: " + string);
        }
        if (id == null || modelProperty == null) {
            if (this.log) {
                System.out.println("Throwing NullParameterException...");
            }
            throw new NullParameterException();
        }
        if (id.isDeleted()) {
            if (this.log) {
                System.out.println("Throwing BadIdException...");
            }
            throw new BadIdException(id);
        }
        if (modelProperty.isClass()) {
            if (this.log) {
                System.out.println("Throwing BadPropertyException...");
            }
            throw new BadPropertyException(modelProperty);
        }
        if (!id.isLoaded() && this.demandLoad) {
            this.demandLoad(id);
        }
        this.getProperties().setProperty(id, modelProperty, string);
    }

    public void set(Id id, String string, String string2) throws ModelException {
        if (this.log) {
            System.out.println("");
            System.out.println("Set function...");
            System.out.println("  construct: " + id);
            System.out.println("  tag: " + string);
            System.out.println("  value: " + string2);
        }
        if (id == null || string == null) {
            if (this.log) {
                System.out.println("Throwing NullParameterException...");
            }
            throw new NullParameterException();
        }
        if (id.isDeleted()) {
            if (this.log) {
                System.out.println("Throwing BadIdException...");
            }
            throw new BadIdException(id);
        }
        if (!id.isLoaded() && this.demandLoad) {
            this.demandLoad(id);
        }
        this.getProperties().setTag(id, "", string, string2);
    }

    public void set(Id id, String string, String string2, String string3) throws ModelException {
        if (this.log) {
            System.out.println("");
            System.out.println("Set function...");
            System.out.println("  construct: " + id);
            System.out.println("  set: " + string);
            System.out.println("  tag: " + string2);
            System.out.println("  value: " + string3);
        }
        if (id == null || string2 == null) {
            if (this.log) {
                System.out.println("Throwing NullParameterException...");
            }
            throw new NullParameterException();
        }
        if (id.isDeleted()) {
            if (this.log) {
                System.out.println("Throwing BadIdException...");
            }
            throw new BadIdException(id);
        }
        if (string == null) {
            string = "";
        }
        if (!id.isLoaded() && this.demandLoad) {
            this.demandLoad(id);
        }
        this.getProperties().setTag(id, string, string2, string3);
    }

    public void setConstructs(Constructs constructs) {
        this.constructs = constructs;
    }

    public void setDemandLoad(boolean bl) {
        this.demandLoad = bl;
    }

    public void setFilePath(String string) {
        this.filePath = string;
    }

    public void setLog(boolean bl) {
        this.log = bl;
    }

    public void setSaveMemory(boolean bl) throws ModelException {
        if (this.log) {
            System.out.println("");
            System.out.println("setSaveMemory function...");
            System.out.println("   value: " + bl);
        }
        if (this.started) {
            if (this.log) {
                System.out.println("SaveMemory exception thrown...");
            }
            throw new SaveMemoryException();
        }
        this.saveMemory = bl;
    }

    public void setSession(Construct construct) {
        this.sessionConstruct = construct;
    }

    public void setXMILoaderFactory(XMILoaderFactory xMILoaderFactory) {
        this.xlf = xMILoaderFactory;
    }

    public void setXMISaveFactory(XMISaveFactory xMISaveFactory) {
        this.xsf = xMISaveFactory;
    }
}

