/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.mod;

import com.ibm.xmi.mod.BadListenerException;
import com.ibm.xmi.mod.Id;
import com.ibm.xmi.mod.ListenerNotFoundException;
import com.ibm.xmi.mod.ModelException;
import com.ibm.xmi.mod.ProgressEvent;
import com.ibm.xmi.mod.ProgressListener;
import java.util.EventListener;
import java.util.Vector;

class Listeners {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final int LOAD = 1;
    public static final int SAVE = 2;
    private static Listeners instance = null;
    private Vector progressListeners;
    private int loadPercent;
    private int savePercent;

    private Listeners() {
    }

    public static void addListener(Id id, EventListener eventListener) throws ModelException {
        if (instance == null) {
            instance = new Listeners();
        }
        if (!(eventListener instanceof ProgressListener)) {
            throw new BadListenerException(eventListener);
        }
        instance.addProgressListener((ProgressListener)eventListener);
    }

    private void addProgressListener(ProgressListener progressListener) {
        if (this.progressListeners == null) {
            this.progressListeners = new Vector(10);
        }
        this.progressListeners.addElement(progressListener);
    }

    public static void fireProgress(int n, int n2) {
        if (instance != null) {
            if (n2 > 100) {
                n2 = 100;
            }
            instance.fireProgressEvent(n, n2);
        }
    }

    private void fireProgressEvent(int n, int n2) {
        String string = null;
        if (n == 1 && this.loadPercent != n2) {
            string = "XMILoad";
            this.loadPercent = n2;
        } else if (n == 2 && this.savePercent != n2) {
            string = "XMISave";
            this.savePercent = n2;
        }
        if (string != null && this.progressListeners != null) {
            for (int i = 0; i < this.progressListeners.size(); ++i) {
                ProgressListener progressListener = (ProgressListener)this.progressListeners.elementAt(i);
                ProgressEvent progressEvent = new ProgressEvent(string, this.getReturnPercent(n2, progressListener));
                progressListener.progressUpdate(progressEvent);
            }
        }
    }

    private int getReturnPercent(int n, ProgressListener progressListener) {
        int n2 = progressListener.getLower();
        int n3 = progressListener.getUpper();
        if (n == 100) {
            return n3;
        }
        return n2 + (n3 - n2) * n / 100;
    }

    public static void removeListener(Id id, EventListener eventListener) throws ModelException {
        if (instance == null) {
            throw new ListenerNotFoundException(eventListener);
        }
        if (!(eventListener instanceof ProgressListener)) {
            throw new BadListenerException(eventListener);
        }
        instance.removeProgressListener((ProgressListener)eventListener);
    }

    private void removeProgressListener(ProgressListener progressListener) throws ModelException {
        if (!this.progressListeners.contains(progressListener)) {
            throw new ListenerNotFoundException(progressListener);
        }
        this.progressListeners.removeElement(progressListener);
    }
}

