/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.mod;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class IntArray
implements Serializable {
    private static final String copyright = "Licensed Materials-Property of IBM\n(C) Copyright IBM Corp. 1999, 2000-All Rights Reserved.\nUS Government Users Restricted Rights-Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";
    private transient int[] array = new int[5];
    private transient int count = 0;
    private final transient int increment = 5;

    public void add(int n) {
        if (this.count == this.array.length) {
            int[] nArray = new int[this.count + 5];
            System.arraycopy(this.array, 0, nArray, 0, this.array.length);
            this.array = nArray;
        }
        ++this.count;
        this.array[this.count - 1] = n;
    }

    public int[] array() {
        return this.array;
    }

    public void clear() {
        this.array = null;
        this.count = 0;
    }

    public boolean contains(int n) {
        for (int i = 0; i < this.count; ++i) {
            if (this.array[i] != n) continue;
            return true;
        }
        return false;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        int n = objectInputStream.readInt();
        this.count = objectInputStream.readInt();
        this.array = new int[n];
        for (int i = 0; i < this.count; ++i) {
            this.array[i] = objectInputStream.readInt();
        }
    }

    public void remove(int n) {
        int n2 = -1;
        for (int i = 0; i < this.array.length; ++i) {
            if (this.array[i] != n) continue;
            n2 = i;
        }
        if (n2 == -1) {
            return;
        }
        if (this.count - n2 - 1 > 0) {
            System.arraycopy(this.array, n2 + 1, this.array, n2, this.count - n2 - 1);
        }
        --this.count;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        for (int i = 0; i < this.count; ++i) {
            stringBuffer.append(this.array[i]);
            if (i >= this.count - 1) continue;
            stringBuffer.append(" ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.array.length);
        objectOutputStream.writeInt(this.count);
        for (int i = 0; i < this.count; ++i) {
            objectOutputStream.writeInt(this.array[i]);
        }
    }
}

