/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.AdapterFactoryRegister;
import com.ibm.xmi.framework.BaseLoader;
import com.ibm.xmi.framework.MatchBaseLoader;
import com.ibm.xmi.framework.MatchReaderAdapter;
import com.ibm.xmi.framework.ReaderAdapter;
import com.ibm.xmi.framework.XMIFile;
import com.ibm.xmi.framework.XMIFiles;
import org.xml.sax.AttributeList;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMIHandler
extends HandlerBase {
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private HandlerBase loader;
    private int option;

    public XMIHandler(XMIFile xMIFile, XMIFiles xMIFiles, int n) {
        this.option = n;
        xMIFile.setXMIFiles(xMIFiles);
        this.loader = null;
        if (xMIFiles == null || xMIFiles.getWorkspace() == null) {
            ReaderAdapter readerAdapter = AdapterFactoryRegister.getAdapterFactory().createReaderAdapter();
            this.loader = new BaseLoader(xMIFile, n, readerAdapter);
        } else {
            MatchReaderAdapter matchReaderAdapter = AdapterFactoryRegister.getAdapterFactory().createMatchReaderAdapter();
            this.loader = new MatchBaseLoader(xMIFile, n, matchReaderAdapter);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.loader != null) {
            this.loader.characters(cArray, n, n2);
        }
    }

    public void endDocument() throws SAXException {
        if (this.loader != null) {
            this.loader.endDocument();
        }
    }

    public void endElement(String string) throws SAXException {
        if (this.loader != null) {
            this.loader.endElement(string);
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        sAXParseException.printStackTrace();
        if (this.option == 1) {
            throw sAXParseException;
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (this.option == 1) {
            throw sAXParseException;
        }
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (this.loader != null) {
            this.loader.startElement(string, attributeList);
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        sAXParseException.printStackTrace();
    }
}

