/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.AdapterFactoryRegister;
import com.ibm.xmi.framework.ProxyNotResolvableException;
import com.ibm.xmi.framework.Workspace;
import com.ibm.xmi.framework.WriterWrapper;
import com.ibm.xmi.framework.XMIContainer;
import com.ibm.xmi.framework.XMIFile;
import com.ibm.xmi.framework.XMILoad;
import com.ibm.xmi.framework.XMIObject;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class XMIFiles {
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";
    public static final int DEFAULT = 1;
    public static final int OBJECTS_ONLY = 2;
    private Workspace workspace;
    private Vector files;
    private XMIContainer allData;
    private String filepath;
    private boolean demandLoad = true;
    private WriterWrapper wrapper = new WriterWrapper(AdapterFactoryRegister.getAdapterFactory().createWriterAdapter());

    void add(XMIFile xMIFile) {
        if (this.files == null) {
            this.files = new Vector();
        }
        this.files.addElement(xMIFile);
    }

    public XMIObject get(String string) {
        if (this.allData == null) {
            return null;
        }
        return this.allData.get(string);
    }

    public XMIContainer getContainer() {
        return this.allData;
    }

    public String getFilepath() {
        return this.filepath;
    }

    public Collection getFiles() {
        if (this.files == null) {
            return new Vector(1);
        }
        return Collections.unmodifiableCollection(this.files);
    }

    private Vector getProxies() {
        Vector<XMIObject> vector = new Vector<XMIObject>();
        if (this.allData == null) {
            return vector;
        }
        Iterator iterator = this.allData.getObjects().iterator();
        while (iterator.hasNext()) {
            XMIObject xMIObject = (XMIObject)iterator.next();
            if (!xMIObject.isXMIProxy()) continue;
            vector.add(xMIObject);
        }
        return vector;
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    private boolean isContained(XMIObject xMIObject, XMIObject xMIObject2) {
        if (xMIObject.isXMIProxy()) {
            return false;
        }
        Vector vector = this.wrapper.getContained(xMIObject);
        if (vector.contains(xMIObject2)) {
            return true;
        }
        for (int i = 0; i < vector.size(); ++i) {
            if (!this.isContained((XMIObject)vector.elementAt(i), xMIObject2)) continue;
            return true;
        }
        return false;
    }

    private boolean isContained(XMIObject xMIObject, Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            if (!this.isContained((XMIObject)vector.elementAt(i), xMIObject)) continue;
            return true;
        }
        return false;
    }

    public boolean isDemandLoad() {
        return this.demandLoad;
    }

    public XMIFile load(String string, int n, boolean bl) throws Exception {
        return this.load(string, null, n, bl);
    }

    public XMIFile load(String string, InputStream inputStream, int n, boolean bl) throws Exception {
        XMILoad xMILoad = new XMILoad(string, inputStream, n, bl, this);
        XMIFile xMIFile = xMILoad.load();
        if (this.allData == null) {
            this.allData = new XMIContainer(xMIFile.getObjects().iterator());
        } else {
            this.makeNewContainer(xMIFile.getObjects().iterator());
        }
        return xMIFile;
    }

    public void loadAll() {
        Vector vector = new Vector();
        HashSet<XMIObject> hashSet = new HashSet<XMIObject>();
        vector = this.getProxies();
        while (!vector.isEmpty()) {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                XMIObject xMIObject = (XMIObject)iterator.next();
                if (hashSet.contains(xMIObject)) {
                    throw new ProxyNotResolvableException(xMIObject);
                }
                hashSet.add(xMIObject);
                xMIObject.getXMILinks();
            }
            vector = this.getProxies();
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println("Specify a file name.");
            return;
        }
        XMIFiles xMIFiles = new XMIFiles();
        try {
            XMIFile xMIFile = xMIFiles.load(stringArray[0], 1, false);
            System.out.println("xmi version:     " + xMIFile.getXMIVersion());
            System.out.println("timestamp:       " + xMIFile.getTimestamp());
            System.out.println("exporter:        " + xMIFile.getExporter());
            System.out.println("exporterVersion: " + xMIFile.getExporterVersion());
            System.out.println("");
            XMIContainer xMIContainer = new XMIContainer(xMIFile.getObjects().iterator());
            System.out.println(xMIContainer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void makeNewContainer(Iterator iterator) {
        Vector vector = new Vector();
        Iterator iterator2 = this.allData.getTopObjects().iterator();
        while (iterator2.hasNext()) {
            vector.addElement(iterator2.next());
        }
        while (iterator.hasNext()) {
            XMIObject xMIObject = (XMIObject)iterator.next();
            if (xMIObject.getXMIUUID() != null && this.allData.get(xMIObject.getXMIUUID()) != null) continue;
            vector.addElement(xMIObject);
        }
        vector = this.removeContained(vector);
        this.allData = new XMIContainer(vector.iterator());
    }

    private Vector removeContained(Vector vector) {
        Vector<XMIObject> vector2 = new Vector<XMIObject>(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            XMIObject xMIObject = (XMIObject)vector.elementAt(i);
            if (this.isContained(xMIObject, vector)) continue;
            vector2.addElement(xMIObject);
        }
        return vector2;
    }

    public void setDemandLoad(boolean bl) {
        this.demandLoad = bl;
    }

    public void setFilepath(String string) {
        this.filepath = string;
    }

    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }
}

