/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.AdapterFactoryRegister;
import com.ibm.xmi.framework.Data;
import com.ibm.xmi.framework.Factory;
import com.ibm.xmi.framework.FactoryRegister;
import com.ibm.xmi.framework.FileWriter;
import com.ibm.xmi.framework.Link;
import com.ibm.xmi.framework.MIME2Java;
import com.ibm.xmi.framework.Namespace;
import com.ibm.xmi.framework.PrintXML;
import com.ibm.xmi.framework.Property;
import com.ibm.xmi.framework.WriterFactory;
import com.ibm.xmi.framework.WriterWrapper;
import com.ibm.xmi.framework.XMIFiles;
import com.ibm.xmi.framework.XMILoad;
import com.ibm.xmi.framework.XMIObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class XMIFile {
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";
    public static final int DEFAULT = 1;
    public static final int OBJECTS_ONLY = 2;
    public static final int PRESERVE_WHITESPACE = 3;
    private String encoding = "UTF-8";
    protected int indent = 2;
    String xmiVersion = "1.0";
    String timestamp;
    String exporter = "XMI Application Framework";
    String exporterVersion = "1.15";
    String owner;
    String contact;
    String longDescription;
    String shortDescription;
    String notice;
    private boolean verified;
    private Vector topObjects;
    private Vector unmatchedElements;
    private Vector header;
    private ZipOutputStream zos;
    private OutputStream outputStream;
    private String dtd;
    private String entry;
    private String filename;
    private Factory factory = FactoryRegister.getFactory();
    private XMIFiles files;
    private boolean printTimestamp = true;
    private WriterWrapper wrapper;
    private Vector assignedObjects;

    public XMIFile(OutputStream outputStream, String string) {
        this.outputStream = outputStream;
        this.filename = string;
    }

    public XMIFile(String string) {
        this.filename = string;
    }

    public XMIFile(ZipOutputStream zipOutputStream, String string) {
        this.zos = zipOutputStream;
        this.entry = string;
    }

    public void add(Namespace namespace) {
        if (this.header == null) {
            this.header = new Vector();
        }
        this.header.addElement(namespace);
    }

    public void add(Import import_) {
        if (this.header == null) {
            this.header = new Vector();
        }
        this.header.addElement(import_);
    }

    public void add(Metametamodel metametamodel) {
        if (this.header == null) {
            this.header = new Vector();
        }
        this.header.addElement(metametamodel);
    }

    public void add(Metamodel metamodel) {
        if (this.header == null) {
            this.header = new Vector();
        }
        this.header.addElement(metamodel);
    }

    public void add(Model model) {
        if (this.header == null) {
            this.header = new Vector();
        }
        this.header.addElement(model);
    }

    public void add(Object object) {
        if (this.topObjects == null) {
            this.topObjects = new Vector();
        }
        this.topObjects.addElement(object);
    }

    public void addUnmatchedElement(Data data) {
        if (this.unmatchedElements == null) {
            this.unmatchedElements = new Vector();
        }
        this.unmatchedElements.addElement(data);
    }

    public String getContact() {
        return this.contact;
    }

    public String getDTD() {
        return this.dtd;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public String getEntry() {
        return this.entry;
    }

    public String getExporter() {
        return this.exporter;
    }

    public String getExporterVersion() {
        return this.exporterVersion;
    }

    public String getFilename() {
        return this.filename;
    }

    public Collection getHeader() {
        if (this.header == null) {
            return new Vector(1);
        }
        return Collections.unmodifiableCollection(this.header);
    }

    public Collection getImports() {
        Vector vector = new Vector();
        if (this.header == null) {
            return vector;
        }
        for (int i = 0; i < this.header.size(); ++i) {
            if (!(this.header.elementAt(i) instanceof Import)) continue;
            vector.addElement(this.header.elementAt(i));
        }
        return vector;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public Collection getMetametamodels() {
        Vector vector = new Vector();
        if (this.header == null) {
            return vector;
        }
        for (int i = 0; i < this.header.size(); ++i) {
            if (!(this.header.elementAt(i) instanceof Metametamodel)) continue;
            vector.addElement(this.header.elementAt(i));
        }
        return vector;
    }

    public Collection getMetamodels() {
        Vector vector = new Vector();
        if (this.header == null) {
            return vector;
        }
        for (int i = 0; i < this.header.size(); ++i) {
            if (!(this.header.elementAt(i) instanceof Metamodel)) continue;
            vector.addElement(this.header.elementAt(i));
        }
        return vector;
    }

    public Collection getModels() {
        Vector vector = new Vector();
        if (this.header == null) {
            return vector;
        }
        for (int i = 0; i < this.header.size(); ++i) {
            if (!(this.header.elementAt(i) instanceof Model) || this.header.elementAt(i) instanceof Metamodel || this.header.elementAt(i) instanceof Metametamodel) continue;
            vector.addElement(this.header.elementAt(i));
        }
        return vector;
    }

    public Namespace getNamespace(String string) {
        if (this.header == null) {
            return null;
        }
        for (int i = 0; i < this.header.size(); ++i) {
            Namespace namespace;
            if (!(this.header.elementAt(i) instanceof Namespace) || (namespace = (Namespace)this.header.elementAt(i)).getName() == null || !namespace.getName().equals(string)) continue;
            return namespace;
        }
        return null;
    }

    public Collection getNamespaces() {
        Vector vector = new Vector();
        if (this.header == null) {
            return vector;
        }
        for (int i = 0; i < this.header.size(); ++i) {
            if (!(this.header.elementAt(i) instanceof Namespace)) continue;
            vector.addElement(this.header.elementAt(i));
        }
        return vector;
    }

    public String getNotice() {
        return this.notice;
    }

    public Collection getObjects() {
        if (this.topObjects == null) {
            return new Vector(1);
        }
        return Collections.unmodifiableCollection(this.topObjects);
    }

    public String getOwner() {
        return this.owner;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public Collection getUnmatchedElements() {
        if (this.unmatchedElements == null) {
            return new Vector(1);
        }
        return Collections.unmodifiableCollection(this.unmatchedElements);
    }

    public XMIFiles getXMIFiles() {
        return this.files;
    }

    public String getXMIVersion() {
        return this.xmiVersion;
    }

    public boolean isPrintTimestamp() {
        return this.printTimestamp;
    }

    public boolean isVerified() {
        return this.verified;
    }

    public static XMIFile load(String string, int n, boolean bl) throws Exception {
        return XMIFile.load(string, null, n, bl);
    }

    public static XMIFile load(String string, InputStream inputStream, int n, boolean bl) throws Exception {
        XMILoad xMILoad = new XMILoad(string, inputStream, n, bl, null);
        return xMILoad.load();
    }

    public static void main(String[] stringArray) {
        Factory factory = FactoryRegister.getFactory();
        if (stringArray.length != 0) {
            XMIFile xMIFile = new XMIFile(stringArray[0]);
            xMIFile.setDTD("my.dtd");
            try {
                Vector<XMIObject> vector = new Vector<XMIObject>(2);
                XMIObject xMIObject = factory.makeXMIObject("Dog");
                Property property = factory.makeBasicProperty((Object)xMIObject, "name", "Fido");
                property = factory.makeBasicProperty((Object)xMIObject, "neutered", "false");
                XMIObject xMIObject2 = factory.makeXMIObject("person2");
                property = factory.makeObjectProperty((Object)xMIObject, "ownerProperty", (Object)xMIObject2);
                XMIObject xMIObject3 = factory.makeXMIObject("Cat");
                property = factory.makeEnumProperty((Object)xMIObject3, "neutered", "true");
                Link link = factory.makeRefLink((Object)xMIObject, "friend", (Object)xMIObject3);
                link = factory.makeRefLink((Object)xMIObject, "friend", (Object)xMIObject3);
                XMIObject xMIObject4 = factory.makeXMIObject("person");
                link = factory.makeContainLink((Object)xMIObject, "owner", (Object)xMIObject4);
                vector.addElement(xMIObject);
                vector.addElement(xMIObject3);
                xMIFile.write(vector.iterator(), 1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            XMIFile xMIFile = new XMIFile("t.xml");
            try {
                xMIFile.write(null, 1);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setContact(String string) {
        this.contact = string;
    }

    public void setDTD(String string) {
        this.dtd = string;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setEntry(String string) {
        this.entry = string;
    }

    public void setExporter(String string) {
        this.exporter = string;
    }

    public void setExporterVersion(String string) {
        this.exporterVersion = string;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public void setIndent(int n) {
        this.indent = n;
    }

    public void setLongDescription(String string) {
        this.longDescription = string;
    }

    public void setNotice(String string) {
        this.notice = string;
    }

    public void setObjects(Iterator iterator) {
        this.topObjects = new Vector();
        while (iterator.hasNext()) {
            this.topObjects.addElement(iterator.next());
        }
    }

    public void setOutputStream(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    public void setOwner(String string) {
        this.owner = string;
    }

    public void setPrintTimestamp(boolean bl) {
        this.printTimestamp = bl;
    }

    public void setShortDescription(String string) {
        this.shortDescription = string;
    }

    public void setTimestamp(String string) {
        this.timestamp = string;
    }

    public void setVerified(boolean bl) {
        this.verified = bl;
    }

    public void setXMIFiles(XMIFiles xMIFiles) {
        this.files = xMIFiles;
    }

    public void setXMIVersion(String string) {
        this.xmiVersion = string;
    }

    public void setZipOutputStream(ZipOutputStream zipOutputStream) {
        this.zos = zipOutputStream;
    }

    public String toString() {
        return "filename: " + this.filename + "  entry: " + this.entry;
    }

    public void write(Iterator iterator, int n) throws Exception {
        Object object;
        this.topObjects = new Vector();
        if (iterator != null) {
            while (iterator.hasNext()) {
                this.topObjects.addElement(iterator.next());
            }
        }
        String string = MIME2Java.convert(this.encoding);
        PrintWriter printWriter = null;
        OutputStream outputStream = this.outputStream;
        if (this.zos != null) {
            printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)this.zos, string)));
            this.zos.putNextEntry(new ZipEntry(this.entry));
        } else {
            if (this.outputStream == null && this.filename != null) {
                object = new File(this.filename);
                String string2 = ((File)object).getParent();
                if (string2 != null) {
                    File file = new File(string2);
                    file.mkdirs();
                }
                object = new File(this.filename);
                outputStream = new FileOutputStream((File)object);
            }
            if (outputStream != null) {
                printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(outputStream, string)));
            }
        }
        PrintXML.setPrintWriter(printWriter);
        this.wrapper = new WriterWrapper(AdapterFactoryRegister.getAdapterFactory().createWriterAdapter());
        object = WriterFactory.makeFileWriter(this);
        ((FileWriter)object).setOption(n);
        ((FileWriter)object).setWriterWrapper(this.wrapper);
        ((FileWriter)object).write(0, this.indent);
        printWriter.flush();
        if (this.zos != null) {
            this.zos.closeEntry();
        } else if (outputStream != this.outputStream) {
            outputStream.close();
        }
    }

    public static class Import {
        private String name;
        private String version;
        private String href;

        public Import(String string, String string2, String string3) {
            this.name = string;
            this.version = string2;
            this.href = string3;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getHref() {
            return this.href;
        }
    }

    public static class Metametamodel
    extends Model {
        public Metametamodel(String string, String string2, String string3) {
            super(string, string2, string3);
        }
    }

    public static class Metamodel
    extends Model {
        public Metamodel(String string, String string2, String string3) {
            super(string, string2, string3);
        }
    }

    public static class Model {
        private String name;
        private String version;
        private String href;

        public Model(String string, String string2, String string3) {
            this.name = string;
            this.version = string2;
            this.href = string3;
        }

        public String getName() {
            return this.name;
        }

        public String getVersion() {
            return this.version;
        }

        public String getHref() {
            return this.href;
        }
    }
}

