/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.AdapterFactoryRegister;
import com.ibm.xmi.framework.Data;
import com.ibm.xmi.framework.Extension;
import com.ibm.xmi.framework.ObjectProperty;
import com.ibm.xmi.framework.Property;
import com.ibm.xmi.framework.WriterWrapper;
import com.ibm.xmi.framework.XMIObject;
import com.ibm.xmi.framework.XMLElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class XMIContainer {
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected ArrayList objects;
    protected ArrayList topObjects;
    protected HashMap nameToElement;
    protected HashMap uuidToData;
    protected HashSet objectsSet;
    protected HashSet uuidObjects;
    protected WriterWrapper wrapper = new WriterWrapper(AdapterFactoryRegister.getAdapterFactory().createWriterAdapter());

    public XMIContainer(Iterator iterator) {
        this.topObjects = new ArrayList();
        while (iterator.hasNext()) {
            this.topObjects.add(iterator.next());
        }
        this.objects = new ArrayList();
        this.objectsSet = new HashSet();
        this.uuidObjects = new HashSet();
    }

    public void add(Iterator iterator) {
        ArrayList arrayList = new ArrayList();
        if (iterator != null) {
            while (iterator.hasNext()) {
                Object e = iterator.next();
                this.topObjects.add(e);
                arrayList.add(e);
            }
        }
        if (this.nameToElement != null) {
            this.addObjectsToNameHash(arrayList);
        }
        if (this.uuidToData != null) {
            this.addObjectsToUUIDHash(arrayList);
        }
    }

    private void addObjectsToNameHash(ArrayList arrayList) {
        if (arrayList != null) {
            if (this.nameToElement == null) {
                this.nameToElement = new HashMap();
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.addObjectToNameHash((XMIObject)iterator.next());
            }
        }
    }

    private void addObjectsToUUIDHash(ArrayList arrayList) {
        if (arrayList != null) {
            if (this.uuidToData == null) {
                this.uuidToData = new HashMap();
            }
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                this.addObjectToUUIDHash((XMIObject)iterator.next());
            }
        }
    }

    private void addObjectToNameHash(XMIObject xMIObject) {
        Iterator iterator;
        if (this.objectsSet.contains(xMIObject)) {
            return;
        }
        this.objectsSet.add(xMIObject);
        this.objects.add(xMIObject);
        this.addToNameHashtable(xMIObject);
        Iterator iterator2 = Collections.EMPTY_LIST.iterator();
        if (!xMIObject.isXMIProxy()) {
            iterator2 = xMIObject.getXMIProperties().iterator();
        }
        while (iterator2.hasNext()) {
            iterator = (Property)iterator2.next();
            this.addToNameHashtable((Data)((Object)iterator));
            if (iterator.getXMIType() != 8 || iterator.getXMIGenericValue() == null) continue;
            this.addObjectToNameHash(((ObjectProperty)((Object)iterator)).getXMIValue());
        }
        iterator = Collections.EMPTY_LIST.iterator();
        if (!xMIObject.isXMIProxy()) {
            iterator = xMIObject.getXMILinks().iterator();
        }
        while (iterator.hasNext()) {
            this.addToNameHashtable((Data)iterator.next());
        }
        Vector vector = new Vector(1);
        if (!xMIObject.isXMIProxy()) {
            vector = this.wrapper.getContained(xMIObject);
        }
        for (int i = 0; i < vector.size(); ++i) {
            this.addObjectToNameHash((XMIObject)vector.elementAt(i));
        }
    }

    private void addObjectToUUIDHash(XMIObject xMIObject) {
        Object object;
        if (this.uuidObjects.contains(xMIObject)) {
            return;
        }
        this.uuidObjects.add(xMIObject);
        this.addToUUIDHashtable(xMIObject);
        Iterator iterator = Collections.EMPTY_LIST.iterator();
        if (!xMIObject.isXMIProxy()) {
            iterator = xMIObject.getXMIProperties().iterator();
        }
        while (iterator.hasNext()) {
            object = (Property)iterator.next();
            if (object.getXMIType() != 8 || object.getXMIGenericValue() == null) continue;
            this.addObjectToUUIDHash(((ObjectProperty)object).getXMIValue());
        }
        object = new Vector(1);
        if (!xMIObject.isXMIProxy()) {
            object = this.wrapper.getContained(xMIObject);
        }
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            this.addObjectToUUIDHash((XMIObject)((Vector)object).elementAt(i));
        }
    }

    private void addToNameHashtable(Data data) {
        String string = data.getXMIName();
        if (string != null) {
            ArrayList<Data> arrayList = (ArrayList<Data>)this.nameToElement.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<Data>();
                this.nameToElement.put(string, arrayList);
            }
            if (!arrayList.contains(data)) {
                arrayList.add(data);
            }
        }
    }

    private void addToUUIDHashtable(XMIObject xMIObject) {
        String string = xMIObject.getXMIUUID();
        if (string != null && this.uuidToData.get(string) == null) {
            this.uuidToData.put(string, xMIObject);
        }
    }

    public XMIObject get(String string) {
        if (string == null) {
            return null;
        }
        if (this.uuidToData == null && this.topObjects.size() == 0) {
            return null;
        }
        if (this.uuidToData == null && this.topObjects.size() > 0) {
            this.addObjectsToUUIDHash(this.topObjects);
        }
        return (XMIObject)this.uuidToData.get(string);
    }

    public Collection getData(String string) {
        ArrayList arrayList;
        if (string == null) {
            return Collections.EMPTY_LIST;
        }
        if (this.nameToElement == null && this.topObjects.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        if (this.nameToElement == null && this.topObjects.size() > 0) {
            this.addObjectsToNameHash(this.topObjects);
        }
        if ((arrayList = (ArrayList)this.nameToElement.get(string)) == null) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    public Collection getObjects() {
        if (this.nameToElement == null) {
            this.addObjectsToNameHash(this.topObjects);
        }
        if (this.objects == null || this.objects.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(this.objects);
    }

    public Collection getTopObjects() {
        if (this.topObjects == null || this.topObjects.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return Collections.unmodifiableCollection(this.topObjects);
    }

    private String printObject(XMIObject xMIObject, int n) {
        Object object;
        Iterator iterator;
        Iterator iterator2;
        String string = "";
        while (string.length() < n) {
            string = string + " ";
        }
        if (xMIObject == null) {
            return string + "null\n";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string);
        stringBuffer.append("Object: ");
        stringBuffer.append(xMIObject.getXMIName());
        stringBuffer.append(" id: ");
        stringBuffer.append(xMIObject.getXMIId());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("  label:   ");
        stringBuffer.append(xMIObject.getXMILabel());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("  uuid:    ");
        stringBuffer.append(xMIObject.getXMIUUID());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("  href:    ");
        stringBuffer.append(xMIObject.getXMIHref());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("  definer: ");
        stringBuffer.append(xMIObject.getXMIDefiner());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("  isProxy: ");
        stringBuffer.append(xMIObject.isXMIProxy());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("  file:    ");
        stringBuffer.append(xMIObject.getXMIFile());
        stringBuffer.append("\n");
        stringBuffer.append(string);
        stringBuffer.append("  namespace: ");
        stringBuffer.append(xMIObject.getXMINamespace());
        stringBuffer.append("\n");
        Iterator iterator3 = null;
        iterator3 = !xMIObject.isXMIProxy() ? xMIObject.getXMISets().iterator() : Collections.EMPTY_LIST.iterator();
        if (iterator3.hasNext()) {
            stringBuffer.append(string);
            stringBuffer.append("  Tag values:\n");
        }
        while (iterator3.hasNext()) {
            iterator2 = (Iterator)iterator3.next();
            iterator = xMIObject.getXMITags((String)((Object)iterator2)).iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                stringBuffer.append(string);
                stringBuffer.append("    set: '");
                stringBuffer.append(iterator2);
                stringBuffer.append("' tag: '");
                stringBuffer.append(object);
                stringBuffer.append("' value: '");
                stringBuffer.append(xMIObject.getXMITagValue((String)((Object)iterator2), (String)object));
                stringBuffer.append("'\n");
            }
        }
        iterator2 = null;
        iterator2 = !xMIObject.isXMIProxy() ? xMIObject.getXMIProperties().iterator() : Collections.EMPTY_LIST.iterator();
        if (iterator2.hasNext()) {
            stringBuffer.append(string);
            stringBuffer.append("  Properties:\n");
        }
        while (iterator2.hasNext()) {
            stringBuffer.append(string);
            stringBuffer.append("    ");
            stringBuffer.append(iterator2.next());
            stringBuffer.append("\n");
        }
        iterator = null;
        iterator = !xMIObject.isXMIProxy() ? xMIObject.getXMIExtensions().iterator() : Collections.EMPTY_LIST.iterator();
        if (iterator.hasNext()) {
            stringBuffer.append(string);
            stringBuffer.append("  Extensions:\n");
        }
        while (iterator.hasNext()) {
            object = (Extension)iterator.next();
            stringBuffer.append(string);
            stringBuffer.append("    extender: '");
            stringBuffer.append(object.getXMIExtender());
            stringBuffer.append("' extenderID: '");
            stringBuffer.append(object.getXMIExtenderID());
            stringBuffer.append("'\n");
            Iterator iterator4 = object.getXMIContents().iterator();
            if (!iterator4.hasNext()) continue;
            stringBuffer.append(string);
            stringBuffer.append("      contents:\n");
            while (iterator4.hasNext()) {
                Object e = iterator4.next();
                if (e instanceof XMIObject) {
                    stringBuffer.append(this.printObject((XMIObject)e, n + 8));
                    continue;
                }
                if (!(e instanceof XMLElement)) continue;
                stringBuffer.append(this.printXMLElement((XMLElement)e, n + 8));
            }
            stringBuffer.append(string);
            stringBuffer.append("      end contents:\n");
        }
        object = null;
        object = !xMIObject.isXMIProxy() ? xMIObject.getXMILinks().iterator() : Collections.EMPTY_LIST.iterator();
        if (object.hasNext()) {
            stringBuffer.append(string);
            stringBuffer.append("  Links:\n");
        }
        while (object.hasNext()) {
            stringBuffer.append(string);
            stringBuffer.append("    ");
            stringBuffer.append(object.next());
            stringBuffer.append("\n");
        }
        stringBuffer.append(string);
        stringBuffer.append("End object: ");
        stringBuffer.append(xMIObject.getXMIName());
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private String printXMLElement(XMLElement xMLElement, int n) {
        Object object;
        String string = "";
        while (string.length() < n) {
            string = string + " ";
        }
        String string2 = string + "XML element tag: " + xMLElement.getXMIName() + "\n";
        Iterator iterator = xMLElement.getXMIAttribs().iterator();
        if (!iterator.hasNext()) {
            string2 = string2 + string + "  attribs: []\n";
        } else {
            object = "";
            while (iterator.hasNext()) {
                if (!((String)object).equals("")) {
                    object = (String)object + " ";
                }
                object = (String)object + iterator.next() + "," + "\"" + iterator.next() + "\"";
            }
            string2 = string2 + string + "  attribs: [" + (String)object + "]\n";
        }
        object = xMLElement.getXMIContents().iterator();
        if (object.hasNext()) {
            string2 = string2 + string + "  contents:\n";
        } else {
            return string2;
        }
        while (object.hasNext()) {
            Object e = object.next();
            if (e instanceof XMLElement) {
                string2 = string2 + this.printXMLElement((XMLElement)e, n + 4);
                continue;
            }
            string2 = string2 + string + "    '" + e + "'\n";
        }
        string2 = string2 + string + "  end contents:\n";
        return string2;
    }

    public String toString() {
        if (this.topObjects == null) {
            return "empty";
        }
        String string = "--------------------------------\n";
        if (this.nameToElement == null) {
            this.addObjectsToNameHash(this.topObjects);
        }
        Iterator iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            string = string + this.printObject((XMIObject)iterator.next(), 0);
            string = string + "--------------------------------\n";
        }
        return string;
    }
}

