/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.BasicProperty;
import com.ibm.xmi.framework.ContainLink;
import com.ibm.xmi.framework.ContainerLink;
import com.ibm.xmi.framework.Data;
import com.ibm.xmi.framework.EnumProperty;
import com.ibm.xmi.framework.FeatureInfo;
import com.ibm.xmi.framework.Model;
import com.ibm.xmi.framework.Namespace;
import com.ibm.xmi.framework.ObjectInfo;
import com.ibm.xmi.framework.ObjectProperty;
import com.ibm.xmi.framework.RefLink;
import com.ibm.xmi.framework.XMIClass;
import com.ibm.xmi.framework.XMIFile;
import com.ibm.xmi.framework.XMIFiles;
import com.ibm.xmi.framework.XMIObject;
import com.ibm.xmi.framework.XMIObjectImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;

public class Workspace {
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private Vector models;
    private Vector xmiFiles;
    private boolean debug = false;

    public Workspace() {
    }

    public Workspace(Iterator iterator) {
        this.models = new Vector(10);
        while (iterator.hasNext()) {
            this.models.addElement(iterator.next());
        }
    }

    public Workspace(Iterator iterator, Iterator iterator2) {
        this(iterator);
        while (iterator2.hasNext()) {
            this.add((XMIFiles)iterator2.next());
        }
    }

    public void add(Model model) {
        if (this.models == null) {
            this.models = new Vector();
        }
        this.models.addElement(model);
    }

    public void add(XMIFiles xMIFiles) {
        if (this.xmiFiles == null) {
            this.xmiFiles = new Vector();
        }
        this.xmiFiles.addElement(xMIFiles);
        xMIFiles.setWorkspace(this);
    }

    private int convertToType(Data data) {
        if (data instanceof XMIObject) {
            return 11;
        }
        if (data instanceof EnumProperty) {
            return 6;
        }
        if (data instanceof BasicProperty) {
            return 7;
        }
        if (data instanceof ObjectProperty) {
            return 8;
        }
        if (data instanceof ContainerLink) {
            return 3;
        }
        if (data instanceof RefLink) {
            return 2;
        }
        if (data instanceof ContainLink) {
            return 4;
        }
        return -1;
    }

    public Data getDeclaration(FeatureInfo featureInfo, Data data, boolean bl) {
        Namespace namespace = featureInfo.getNamespace();
        if (namespace == null && featureInfo.getObject() != null && featureInfo.getObject() instanceof Data) {
            namespace = ((Data)featureInfo.getObject()).getXMINamespace();
        }
        return this.getDeclaration(featureInfo.getXMIName(), namespace, featureInfo.getModel(), this.stripNamespace(featureInfo.getClassName()), data, bl);
    }

    private Data getDeclaration(Model model, XMIClass xMIClass, String string, Data data, Namespace namespace, boolean bl) {
        if (model != null) {
            return model.getDeclaration(namespace, xMIClass, string, bl);
        }
        for (int i = 0; i < this.models.size(); ++i) {
            model = (Model)this.models.elementAt(i);
            Data data2 = model.getDeclaration(namespace, xMIClass, string, bl);
            if (!(data2 != null && data != null ? this.matchesType(data2, data) : data2 != null)) continue;
            return data2;
        }
        return null;
    }

    public Data getDeclaration(ObjectInfo objectInfo, XMIObject xMIObject, boolean bl) {
        if (this.debug) {
            System.out.println("object info:");
            System.out.println("   name: " + objectInfo.getXMIName());
            System.out.println("   namespace: " + objectInfo.getNamespace());
            System.out.println("Models:");
            Iterator iterator = this.models.iterator();
            while (iterator.hasNext()) {
                Model model = (Model)iterator.next();
                System.out.println(model);
                Iterator iterator2 = model.getNamespaces().iterator();
                while (iterator2.hasNext()) {
                    System.out.println("   namespace: " + iterator2.next());
                }
            }
        }
        return this.getDeclaration(objectInfo.getXMIName(), objectInfo.getNamespace(), objectInfo.getModel(), null, xMIObject, bl);
    }

    public Data getDeclaration(String string, Namespace namespace, XMIFile.Model model, String string2, Data data, boolean bl) {
        Model model2 = this.getModel(model, namespace);
        XMIClass xMIClass = null;
        if (string2 != null) {
            xMIClass = this.getXMIClass(model2, string2, namespace, bl);
        }
        if (xMIClass != null) {
            return this.getDeclaration(model2, xMIClass, string, data, namespace, bl);
        }
        if (model2 != null) {
            Data data2 = null;
            data2 = data != null ? model2.getDeclaration(namespace, this.convertToType(data), string, bl) : model2.getDeclaration(namespace, string, bl);
            return data2;
        }
        Iterator iterator = this.getDeclarations(string, data, namespace, bl).iterator();
        while (iterator.hasNext()) {
            Data data3 = (Data)iterator.next();
            if (data != null && !this.matchesType(data3, data)) continue;
            return data3;
        }
        return null;
    }

    public Collection getDeclarations(String string, Data data, Namespace namespace, boolean bl) {
        if (this.models == null) {
            return new Vector(1);
        }
        Vector<Data> vector = new Vector<Data>();
        for (int i = 0; i < this.models.size(); ++i) {
            Data data2 = null;
            data2 = data == null ? ((Model)this.models.elementAt(i)).getDeclaration(namespace, string, bl) : ((Model)this.models.elementAt(i)).getDeclaration(namespace, this.convertToType(data), string, bl);
            if (data2 == null) continue;
            vector.addElement(data2);
        }
        return vector;
    }

    private Model getModel(XMIFile.Model model, Namespace namespace) {
        Object object;
        Object object2;
        Object object3;
        if (this.models == null) {
            return null;
        }
        String string = null;
        if (namespace != null) {
            object3 = this.models.iterator();
            while (object3.hasNext()) {
                object2 = (Model)object3.next();
                object = ((Model)object2).getNamespaces();
                if (!object.contains(namespace)) continue;
                return object2;
            }
            string = namespace.getURI();
        }
        if (string != null) {
            object3 = this.models.iterator();
            while (object3.hasNext()) {
                object2 = (Model)object3.next();
                object = ((Model)object2).getURI();
                if (object == null || !((String)object).equals(string)) continue;
                return object2;
            }
        }
        object3 = null;
        if (model != null) {
            object3 = model.getName();
        }
        if (object3 == null && namespace != null) {
            object3 = namespace.getName();
        }
        if (object3 == null) {
            return null;
        }
        object2 = this.models.iterator();
        while (object2.hasNext()) {
            object = (Model)object2.next();
            String string2 = ((Model)object).getXMIName();
            if (string2 == null || !string2.equals(object3)) continue;
            return object;
        }
        return null;
    }

    public Collection getModels() {
        if (this.models == null) {
            return new Vector(1);
        }
        return Collections.unmodifiableCollection(this.models);
    }

    private XMIClass getXMIClass(Model model, String string, Namespace namespace, boolean bl) {
        if (model != null) {
            Data data = model.getDeclaration(namespace, 11, string, bl);
            if (data != null) {
                return (XMIClass)data;
            }
        } else {
            Iterator iterator = this.getDeclarations(string, new XMIObjectImpl("d"), namespace, bl).iterator();
            if (iterator.hasNext()) {
                return (XMIClass)iterator.next();
            }
        }
        return null;
    }

    public Collection getXMIFiles() {
        if (this.xmiFiles == null) {
            return new Vector(1);
        }
        return Collections.unmodifiableCollection(this.xmiFiles);
    }

    private boolean matchesType(Data data, Data data2) {
        if (data instanceof XMIClass && data2 instanceof XMIObject) {
            return true;
        }
        if (data instanceof ObjectProperty && data2 instanceof ObjectProperty) {
            return true;
        }
        if (data instanceof EnumProperty && data2 instanceof EnumProperty) {
            return true;
        }
        if (data instanceof BasicProperty && data2 instanceof BasicProperty) {
            return true;
        }
        if (data instanceof ContainerLink && data2 instanceof ContainerLink) {
            return true;
        }
        if (data instanceof RefLink && data2 instanceof RefLink) {
            return true;
        }
        return data instanceof ContainLink && data2 instanceof ContainLink;
    }

    private String stripNamespace(String string) {
        if (string == null) {
            return null;
        }
        int n = string.indexOf(":");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }
}

