/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.LibraryException;
import com.ibm.xmi.framework.XMLChar;
import java.io.IOException;
import java.io.Writer;
import java.util.Vector;

public class Util {
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";

    public static String backReference(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 12 / 10);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('<' == c) {
                stringBuffer.append("&lt;");
                continue;
            }
            if ('>' == c) {
                stringBuffer.append("&gt;");
                continue;
            }
            if ('&' == c) {
                stringBuffer.append("&amp;");
                continue;
            }
            if ('\ud800' <= c && c < '\udc00') {
                int n;
                if (i + 1 >= string.length()) {
                    throw new LibraryException("com.ibm.xml.parser.Util#backReference(): Invalid UTF-16 surrogate detected: " + Integer.toHexString(c) + " ?");
                }
                if (56320 > (n = string.charAt(++i)) || n >= 57344) {
                    throw new LibraryException("com.ibm.xml.parser.Util#backReference(): Invalid UTF-16 surrogate detected: " + Integer.toHexString(c) + " " + Integer.toHexString(n));
                }
                n = (c - 55296 << 10) + n - 56320 + 65536;
                stringBuffer.append("&#x");
                stringBuffer.append(Integer.toHexString(n));
                stringBuffer.append(";");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String backReference(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer(string.length() * 12 / 10);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            int n = string2.indexOf(c);
            if (n >= 0) {
                stringBuffer.append("&#");
                stringBuffer.append(Integer.toString(c));
                stringBuffer.append(";");
                continue;
            }
            if ('\ud800' <= c && c < '\udc00') {
                int n2;
                if (i + 1 >= string.length()) {
                    throw new LibraryException("com.ibm.xml.parser.Util#backReference(): Invalid UTF-16 surrogate detected: " + Integer.toHexString(c) + " ?");
                }
                if (56320 > (n2 = string.charAt(++i)) || n2 >= 57344) {
                    throw new LibraryException("com.ibm.xml.parser.Util#backReference(): Invalid UTF-16 surrogate detected: " + Integer.toHexString(c) + " " + Integer.toHexString(n2));
                }
                n2 = (c - 55296 << 10) + n2 - 56320 + 65536;
                stringBuffer.append("&#x");
                stringBuffer.append(Integer.toHexString(n2));
                stringBuffer.append(";");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String backReferenceForEntity(String string, String string2) {
        return Util.backReference(string, "&\"'%\r\n\t", string2);
    }

    public static boolean checkAllSpace(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (XMLChar.isSpace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean checkEncoding(String string) {
        if (1 > string.length()) {
            return false;
        }
        if (0 > "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".indexOf(string.charAt(0))) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (0 <= "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ._-".indexOf(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean checkLanguageID(String string) {
        int n = string.length();
        if (2 > n) {
            return false;
        }
        char c = string.charAt(0);
        char c2 = string.charAt(1);
        int n2 = 2;
        if (!(('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z') && ('a' <= c2 && c2 <= 'z' || 'A' <= c2 && c2 <= 'Z'))) {
            if ('-' == c2 && ('i' == c || 'I' == c || 'x' == c || 'X' == c) && 3 <= n) {
                if (!('a' <= (c = string.charAt(n2++)) && c <= 'z' || 'A' <= c && c <= 'Z')) {
                    return false;
                }
                while (n2 < n && ('a' <= (c = string.charAt(n2)) && c <= 'z' || 'A' <= c && c <= 'Z')) {
                    ++n2;
                }
            } else {
                return false;
            }
        }
        while (n2 < n) {
            if (n2 + 2 > n) {
                return false;
            }
            if ('-' != string.charAt(n2++)) {
                return false;
            }
            if (!('a' <= (c = string.charAt(n2++)) && c <= 'z' || 'A' <= c && c <= 'Z')) {
                return false;
            }
            while (n2 < n && ('a' <= (c = string.charAt(n2)) && c <= 'z' || 'A' <= c && c <= 'Z')) {
                ++n2;
            }
        }
        return true;
    }

    public static boolean checkName(String string) {
        if (1 > string.length()) {
            return false;
        }
        char c = string.charAt(0);
        if (!XMLChar.isLetter(c) && '_' != c && ':' != c) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            if (XMLChar.isNameChar(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean checkNCName(String string) {
        if (1 > string.length()) {
            return false;
        }
        char c = string.charAt(0);
        if (!XMLChar.isLetter(c) && '_' != c) {
            return false;
        }
        for (int i = 1; i < string.length(); ++i) {
            c = string.charAt(i);
            if (c != ':' && XMLChar.isNameChar(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean checkNmtoken(String string) {
        if (1 > string.length()) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (XMLChar.isNameChar(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean checkVersionNum(String string) {
        if (1 > string.length()) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || 0 <= "_.:-".indexOf(c)) continue;
            return false;
        }
        return true;
    }

    private static void fall(String[] stringArray, int n, int n2) {
        int n3 = 2 * n2 + 1;
        if (n3 < n) {
            if (n3 + 1 < n && 0 > stringArray[n3].compareTo(stringArray[n3 + 1])) {
                n3 = 2 * n2 + 2;
            }
            if (0 > stringArray[n2].compareTo(stringArray[n3])) {
                String string = stringArray[n2];
                stringArray[n2] = stringArray[n3];
                stringArray[n3] = string;
                Util.fall(stringArray, n, n3);
            }
        }
    }

    public static int getInvalidURIChar(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || 0 <= ";/?:@&=+$,-_.!~*'()%".indexOf(c)) continue;
            return i;
        }
        return -1;
    }

    public static void heapSort(String[] stringArray) {
        Util.heapSort(stringArray, stringArray.length);
    }

    public static void heapSort(String[] stringArray, int n) {
        int n2;
        for (n2 = n / 2; n2 >= 0; --n2) {
            Util.fall(stringArray, n, n2);
        }
        for (n2 = n - 1; n2 > 0; --n2) {
            String string = stringArray[0];
            stringArray[0] = stringArray[n2];
            stringArray[n2] = string;
            Util.fall(stringArray, n2, 0);
        }
    }

    public static void indent(Writer writer, int n) throws IOException {
        writer.write("\n");
        Util.printSpace(writer, n);
    }

    public static boolean isURN(String string) {
        return string.length() > 4 && string.substring(0, 4).equalsIgnoreCase("urn:");
    }

    public static String normalizeURN(String string) {
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('A' <= c && c <= 'Z') {
                bl = false;
            }
            if (i < 4 || c != ':') continue;
            return bl ? string : string.substring(0, i).toLowerCase() + string.substring(i);
        }
        return string;
    }

    public static void printSpace(Writer writer, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            writer.write(" ");
        }
    }

    public static Vector sortStringVector(Vector vector) {
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        Util.heapSort((String[])objectArray);
        vector.removeAllElements();
        vector.ensureCapacity(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            vector.addElement(objectArray[i]);
        }
        return vector;
    }
}

