/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.AdapterFactoryRegister;
import com.ibm.xmi.framework.DefinitionWriter;
import com.ibm.xmi.framework.PrintXML;
import com.ibm.xmi.framework.SchemaConstructWriter;
import com.ibm.xmi.framework.SchemaWriter;
import com.ibm.xmi.framework.WriterFactory;
import com.ibm.xmi.framework.WriterWrapper;
import com.ibm.xmi.framework.XMISchema;
import java.util.Iterator;

class Schema20Writer
extends SchemaWriter {
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private WriterWrapper wrapper = new WriterWrapper(AdapterFactoryRegister.getAdapterFactory().createWriterAdapter());

    public Schema20Writer(XMISchema xMISchema) {
        super(xMISchema);
    }

    public void write(int n, int n2) throws Exception {
        PrintXML.setEncoding(this.getSchema().getEncoding());
        this.writeHeader(n, n2);
        String[] stringArray = new String[8];
        int n3 = 0;
        stringArray[n3++] = "xmlns:xsd";
        stringArray[n3++] = "http://www.w3.org/1999/XMLSchema";
        stringArray[n3++] = "xmlns:xmi";
        stringArray[n3++] = "http://www.omg.org/2000/XMI";
        if (this.getSchema().getTargetNamespace() != null) {
            stringArray[n3++] = "xmlns";
            stringArray[n3++] = this.getSchema().getTargetNamespace().getURI();
            stringArray[n3++] = "targetNamespace";
            stringArray[n3++] = this.getSchema().getTargetNamespace().getURI();
        }
        PrintXML.printStartElement("xsd:schema", stringArray, false, n);
        this.writeContent(n, n2);
        PrintXML.printEndElement("xsd:schema", n);
        PrintXML.printEndDocument();
    }

    private void writeContent(int n, int n2) throws Exception {
        PrintXML.printBlankLine();
        String[] stringArray = new String[]{"namespace", "http://www.omg.org/2000/XMI"};
        PrintXML.printStartElement("xsd:import", stringArray, true, n);
        PrintXML.printBlankLine();
        Iterator iterator = this.getSchema().getDeclarations().iterator();
        while (iterator.hasNext()) {
            DefinitionWriter definitionWriter = WriterFactory.makeDeclWriter(iterator.next(), "2.0", "schema");
            if (definitionWriter instanceof SchemaConstructWriter) {
                ((SchemaConstructWriter)definitionWriter).setSchema(this.getSchema());
            }
            definitionWriter.setWrapper(this.wrapper);
            definitionWriter.write(n, n2);
        }
    }

    private void writeHeader(int n, int n2) throws Exception {
        PrintXML.printXMLPI("1.0");
    }
}

