/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.Factory;
import com.ibm.xmi.framework.FactoryRegister;
import com.ibm.xmi.framework.FeatureInfo;
import com.ibm.xmi.framework.Namespace;
import com.ibm.xmi.framework.ObjectInfo;
import com.ibm.xmi.framework.ObjectProperty;
import com.ibm.xmi.framework.Property;
import com.ibm.xmi.framework.ReaderAdapter;
import com.ibm.xmi.framework.TagValue2Handler;
import com.ibm.xmi.framework.TagValueHandler;
import com.ibm.xmi.framework.XMIFile;
import com.ibm.xmi.framework.XMIFiles;
import com.ibm.xmi.framework.XMIObject;
import java.util.Hashtable;
import org.xml.sax.DocumentHandler;

public class ReaderAdapterImpl
implements ReaderAdapter {
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected boolean debug = false;
    protected Factory factory = FactoryRegister.getFactory();
    protected Hashtable objectsToXMINames = new Hashtable();
    protected Hashtable uuidsToObjects = new Hashtable();
    protected XMIFile file;
    private XMIFiles files;

    public DocumentHandler createExtension(Object object, String string, String string2) {
        if (string.equals("IXAF TVS") && object instanceof XMIObject) {
            return new TagValueHandler((XMIObject)object);
        }
        if (string.equals("IXT") && object instanceof XMIObject) {
            return new TagValue2Handler((XMIObject)object);
        }
        return null;
    }

    public Object createObject(ObjectInfo objectInfo) {
        Object object;
        if (this.debug) {
            System.out.println("createObject: " + objectInfo);
            if (objectInfo.getModel() != null) {
                object = objectInfo.getModel();
                if (object instanceof XMIFile.Metametamodel) {
                    System.out.print("Metametamodel: ");
                } else if (object instanceof XMIFile.Metamodel) {
                    System.out.print("Metamodel: ");
                } else if (object instanceof XMIFile.Model) {
                    System.out.print("Model: ");
                }
                System.out.println("name: " + ((XMIFile.Model)object).getName() + " version: " + ((XMIFile.Model)object).getVersion() + " href: " + ((XMIFile.Model)object).getHref());
            }
        }
        if (objectInfo.getHref() != null && objectInfo.getUUID() != null) {
            object = (XMIObject)this.uuidsToObjects.get(objectInfo.getUUID());
            if (object == null && this.files != null) {
                object = this.files.get(objectInfo.getUUID());
            }
            if (object == null) {
                object = objectInfo.getNamespace() != null ? this.factory.makeXMIObject(objectInfo.getXMIName(), objectInfo.getNamespace()) : this.factory.makeXMIObject(objectInfo.getXMIName());
                object.setXMIProxy(true);
                object.setXMIId(objectInfo.getId());
                object.setXMIUUID(objectInfo.getUUID());
                this.uuidsToObjects.put(objectInfo.getUUID(), object);
                object.setXMILabel(objectInfo.getLabel());
                object.setXMIHref(objectInfo.getHref());
                object.setXMIFile(this.file);
                object.setXMINamespace(objectInfo.getNamespace());
                this.objectsToXMINames.put(object, objectInfo.getXMIName());
                if (this.debug) {
                    System.out.println("Made object: ");
                    System.out.println(object);
                }
            } else if (this.debug) {
                System.out.println("Returned object: ");
                System.out.println(object);
            }
            return object;
        }
        if (objectInfo.getIdref() == null) {
            boolean bl = false;
            if (objectInfo.getUUID() != null) {
                object = (XMIObject)this.uuidsToObjects.get(objectInfo.getUUID());
                if (object == null && this.files != null) {
                    object = this.files.get(objectInfo.getUUID());
                }
                if (object == null) {
                    object = objectInfo.getNamespace() != null ? this.factory.makeXMIObject(objectInfo.getXMIName(), objectInfo.getNamespace()) : this.factory.makeXMIObject(objectInfo.getXMIName());
                    object.setXMIUUID(objectInfo.getUUID());
                    bl = true;
                    if (objectInfo.getUUID() != null) {
                        this.uuidsToObjects.put(objectInfo.getUUID(), object);
                    }
                } else if (object.isXMIProxy()) {
                    object.setXMIProxy(false);
                } else if (this.debug) {
                    System.out.println("Duplicate object with uuid: " + objectInfo.getUUID());
                }
            } else {
                object = objectInfo.getNamespace() != null ? this.factory.makeXMIObject(objectInfo.getXMIName(), objectInfo.getNamespace()) : this.factory.makeXMIObject(objectInfo.getXMIName());
                bl = true;
            }
            object.setXMIId(objectInfo.getId());
            object.setXMILabel(objectInfo.getLabel());
            object.setXMINamespace(objectInfo.getNamespace());
            object.setXMIFile(this.file);
            this.objectsToXMINames.put(object, objectInfo.getXMIName());
            if (this.debug && bl) {
                System.out.println("Made object: ");
                System.out.println(object);
            } else if (this.debug) {
                System.out.println("Returned object: ");
                System.out.println(object);
            }
            return object;
        }
        return null;
    }

    public Object createProperty(FeatureInfo featureInfo) {
        if (this.debug) {
            System.out.println("createProperty...");
            System.out.println("xmiName: " + featureInfo.getXMIName());
            System.out.println("className: " + featureInfo.getClassName());
            System.out.println("namespace: " + featureInfo.getNamespace());
        }
        String string = featureInfo.getClassName() == null ? featureInfo.getXMIName() : (featureInfo.getClassName().equals(this.objectsToXMINames.get(featureInfo.getObject())) ? featureInfo.getXMIName() : featureInfo.getClassName() + "." + featureInfo.getXMIName());
        Object object = featureInfo.getValue() != null && featureInfo.getValue() instanceof String ? this.factory.makeBasicProperty(featureInfo.getObject(), string, (String)featureInfo.getValue()) : (featureInfo.getValue() == null ? new TempProperty(string, featureInfo.getNamespace()) : this.factory.makeObjectProperty(featureInfo.getObject(), string, featureInfo.getValue()));
        if (object instanceof Property) {
            ((Property)object).setXMINamespace(featureInfo.getNamespace());
        }
        if (this.debug) {
            System.out.println("Made property: ");
            System.out.println(object);
        }
        return object;
    }

    public void endFile() {
        if (this.debug) {
            System.out.println("End of file.");
        }
    }

    public int getType(FeatureInfo featureInfo) {
        return 7;
    }

    public void resolveValue(Object object, Object object2, Object object3) {
        ObjectProperty objectProperty = this.factory.makeObjectProperty(object, ((TempProperty)object2).getXMIName(), object3);
        if (this.debug) {
            System.out.println("Made property in resolveValue: ");
            System.out.println(objectProperty);
        }
        if (objectProperty instanceof Property) {
            ((Property)objectProperty).setXMINamespace(((TempProperty)object2).getXMINamespace());
        }
    }

    public void setXMIFile(XMIFile xMIFile) {
        this.file = xMIFile;
        if (xMIFile.getXMIFiles() != null) {
            this.files = xMIFile.getXMIFiles();
        }
    }

    protected class TempProperty {
        private String xmiName;
        private Namespace namespace;

        TempProperty(String string, Namespace namespace) {
            this.xmiName = string;
            this.namespace = namespace;
        }

        String getXMIName() {
            return this.xmiName;
        }

        Namespace getXMINamespace() {
            return this.namespace;
        }
    }
}

