/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.AdapterFactoryRegister;
import com.ibm.xmi.framework.Data;
import com.ibm.xmi.framework.Model;
import com.ibm.xmi.framework.Namespace;
import com.ibm.xmi.framework.Package;
import com.ibm.xmi.framework.WriterWrapper;
import com.ibm.xmi.framework.XMIClass;
import com.ibm.xmi.framework.XMIException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

class Namespaces {
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private Model m;
    private Vector list;
    private WriterWrapper wrapper = new WriterWrapper(AdapterFactoryRegister.getAdapterFactory().createWriterAdapter());

    public Namespaces(Vector vector, Collection collection) {
        try {
            this.m = new Model(null, collection.iterator());
        }
        catch (XMIException xMIException) {
            xMIException.printStackTrace();
        }
        this.list = vector;
    }

    private void assignAll(Namespace namespace) {
        Iterator iterator = this.m.getTopLevel().iterator();
        while (iterator.hasNext()) {
            this.assignNamespaces(namespace, (Data)iterator.next());
        }
    }

    private void assignNamespaces(Namespace namespace, Data data) {
        Object object;
        data.setXMINamespace(namespace);
        if (data instanceof XMIClass) {
            object = (XMIClass)data;
            Iterator iterator = object.getXMIProperties().iterator();
            while (iterator.hasNext()) {
                ((Data)iterator.next()).setXMINamespace(namespace);
            }
            Iterator iterator2 = object.getXMILinks().iterator();
            while (iterator2.hasNext()) {
                ((Data)iterator2.next()).setXMINamespace(namespace);
            }
        }
        if (data instanceof Package) {
            object = ((Package)data).getXMIContents().iterator();
            while (object.hasNext()) {
                this.assignNamespaces(namespace, (Data)object.next());
            }
        }
    }

    private void set() {
        for (int i = 0; i < this.list.size() - 1; i += 2) {
            String string = (String)this.list.get(i);
            Namespace namespace = (Namespace)this.list.get(i + 1);
            if (string != null && string.equals("")) {
                this.assignAll(namespace);
                return;
            }
            Data data = this.m.getDeclaration(string);
            if (data == null) continue;
            this.assignNamespaces(namespace, data);
        }
    }

    public void setNamespaces() {
        this.set();
    }
}

