/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.BaseLoader;
import com.ibm.xmi.framework.FeatureInfo;
import com.ibm.xmi.framework.MatchReaderAdapter;
import com.ibm.xmi.framework.ObjectInfo;
import com.ibm.xmi.framework.XMIFile;
import org.xml.sax.AttributeList;

class MatchBaseLoader
extends BaseLoader {
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private MatchReaderAdapter matchAdapter;
    private boolean debug = false;

    public MatchBaseLoader(XMIFile xMIFile, int n, MatchReaderAdapter matchReaderAdapter) {
        super(xMIFile, n, matchReaderAdapter);
        this.matchAdapter = matchReaderAdapter;
    }

    protected Object createFeatureFromAdapter(FeatureInfo featureInfo, int n) {
        if (this.debug) {
            System.out.println("MatchBaseLoader createFeatureFromAdapter:");
            System.out.println("info: " + featureInfo);
            System.out.println("type: " + n);
        }
        if (n == -1) {
            if (featureInfo.getValue() != null && featureInfo.getValue() instanceof String) {
                n = 7;
            } else if (featureInfo.getValue() == null || !(featureInfo.getValue() instanceof String)) {
                n = 8;
            }
        }
        if (n == 8) {
            return this.matchAdapter.createProperty(this.featureInfo);
        }
        if (n == 7) {
            return this.matchAdapter.createBasicProperty(this.featureInfo);
        }
        if (n == 6) {
            return this.matchAdapter.createEnumProperty(this.featureInfo);
        }
        if (n == 4) {
            return this.matchAdapter.createContainLink(this.featureInfo);
        }
        if (n == 3) {
            return this.matchAdapter.createContainerLink(this.featureInfo);
        }
        if (n == 2) {
            return this.matchAdapter.createReferenceLink(this.featureInfo);
        }
        return null;
    }

    protected boolean featureHasObjectValues(int n) {
        return n == 8 || n == 4 || n == 3 || n == 2;
    }

    protected int getPropertyType() {
        if (!this.types.isEmpty() && this.types.peek().equals("EnumProperty")) {
            return 6;
        }
        return 7;
    }

    protected int getTypeFromTypeStack() {
        if (this.types.isEmpty()) {
            return -1;
        }
        if (this.types.peek().equals("ObjectProperty") || this.types.peek().equals("Property")) {
            return 8;
        }
        if (this.types.peek().equals("ContainerLink")) {
            return 3;
        }
        if (this.types.peek().equals("ContainLink")) {
            return 4;
        }
        if (this.types.peek().equals("RefLink")) {
            return 2;
        }
        return -1;
    }

    protected boolean isBasicProperty() {
        return !this.types.isEmpty() && (this.types.peek().equals("BasicProperty") || this.types.peek().equals("EnumProperty") || this.types.peek().equals("Property"));
    }

    protected boolean isObject(String string, AttributeList attributeList) {
        if (super.isObject(string, attributeList)) {
            return true;
        }
        ObjectInfo objectInfo = new ObjectInfo();
        this.processAttribs(objectInfo, attributeList);
        int n = string.indexOf(":");
        if (n == -1) {
            objectInfo.setXMIName(string);
        } else {
            objectInfo.setXMIName(string.substring(n + 1));
        }
        objectInfo.setNamespace(this.getNamespace(string));
        objectInfo.setModel(this.getModel(this.getNamespace(string)));
        return this.matchAdapter.getType(objectInfo) == 10;
    }

    protected void pushFeature(String string) {
        this.featureInfo.clear();
        if (!this.objects.isEmpty()) {
            this.featureInfo.setObject(this.objects.peek());
        }
        this.featureInfo.setXMIName(this.getSimpleName(string));
        this.featureInfo.setClassName(this.getClassName(string));
        this.featureInfo.setNamespace(this.getNamespace(string));
        this.featureInfo.setModel(this.getModel(this.getNamespace(string)));
        int n = this.matchAdapter.getType(this.featureInfo);
        if (n == 3) {
            this.types.push("ContainerLink");
        } else if (n == 2) {
            this.types.push("RefLink");
        } else if (n == 4) {
            this.types.push("ContainLink");
        } else if (n == 8) {
            this.types.push("ObjectProperty");
        } else if (n == 6) {
            this.types.push("EnumProperty");
        } else if (n == 7) {
            this.types.push("BasicProperty");
        } else {
            super.pushFeature(string);
        }
    }
}

