/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.Namespace;
import com.ibm.xmi.framework.ObjectWriter;
import com.ibm.xmi.framework.PrintXML;
import com.ibm.xmi.framework.WriterWrapper;
import com.ibm.xmi.framework.XMIFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

class FileWriter {
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private static final int TOP_LEVEL = 1;
    private static final int CONTAINED = 2;
    private static final int PROPERTY_VALUE = 3;
    private static final int EXTENSION_OBJ = 4;
    private static final int REFERENCED = 5;
    protected XMIFile file;
    private String filename;
    protected HashMap objectsToFiles;
    protected HashMap objectToData;
    protected HashMap definerToFullName;
    protected HashMap definerToData;
    private HashSet refVector;
    private HashSet written;
    private ArrayList writing;
    private HashSet contained;
    private HashSet processedObjects;
    private ArrayList objectPropValues;
    private File xmiFile;
    private int option;
    protected WriterWrapper wrapper;

    public FileWriter(XMIFile xMIFile) {
        this.file = xMIFile;
        this.refVector = new HashSet();
        this.written = new HashSet();
        this.writing = new ArrayList();
        this.contained = new HashSet();
        this.objectPropValues = new ArrayList();
        this.objectToData = new HashMap();
    }

    private void computeRefVector() {
        Iterator iterator = this.file.getObjects().iterator();
        HashSet hashSet = new HashSet();
        while (iterator.hasNext()) {
            hashSet.add(iterator.next());
        }
        Iterator iterator2 = this.objectPropValues.iterator();
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            if (!this.contained.contains(e) && !hashSet.contains(e)) continue;
            this.refVector.add(e);
        }
    }

    private boolean equalsXMIFile(String string) {
        File file = new File(string);
        if (file.getName().equals(this.xmiFile.getName())) {
            return true;
        }
        file = new File(string.replace('/', File.separatorChar));
        return file.getName().equals(this.xmiFile.getName());
    }

    private boolean fileHasDocumentation() {
        return this.file.getExporter() != null || this.file.getExporterVersion() != null || this.file.getOwner() != null || this.file.getContact() != null || this.file.getLongDescription() != null || this.file.getShortDescription() != null || this.file.getNotice() != null;
    }

    private boolean fileHasHeader() {
        if (this.fileHasDocumentation()) {
            return true;
        }
        Collection collection = this.file.getModels();
        if (collection.size() > 0) {
            return true;
        }
        collection = this.file.getMetamodels();
        if (collection.size() > 0) {
            return true;
        }
        collection = this.file.getMetametamodels();
        if (collection.size() > 0) {
            return true;
        }
        collection = this.file.getImports();
        return collection.size() > 0;
    }

    public Collection getAllLinks(Object object) {
        Collection[] collectionArray;
        if (this.definerToData == null) {
            this.definerToData = new HashMap();
        }
        if ((collectionArray = (Collection[])this.definerToData.get(object)) == null) {
            collectionArray = new Collection[]{null, null};
            this.definerToData.put(object, collectionArray);
        }
        if (collectionArray[1] == null) {
            collectionArray[1] = this.wrapper.getAllLinksC(object);
        }
        return collectionArray[1];
    }

    public Collection getAllProperties(Object object) {
        Collection[] collectionArray;
        if (this.definerToData == null) {
            this.definerToData = new HashMap();
        }
        if ((collectionArray = (Collection[])this.definerToData.get(object)) == null) {
            collectionArray = new Collection[]{null, null};
            this.definerToData.put(object, collectionArray);
        }
        if (collectionArray[0] == null) {
            collectionArray[0] = this.wrapper.getAllPropertiesC(object);
        }
        return collectionArray[0];
    }

    public Object[] getData(Object object) {
        return (Object[])this.objectToData.get(object);
    }

    public XMIFile getFile() {
        return this.file;
    }

    public String getFullName(Object object) {
        String string;
        if (this.definerToFullName == null) {
            this.definerToFullName = new HashMap();
        }
        if ((string = (String)this.definerToFullName.get(object)) == null) {
            string = this.wrapper.getFullName(object, 500);
            this.definerToFullName.put(object, string);
        }
        return string;
    }

    protected String getName(Object object) {
        String string = this.wrapper.getXMIName(object);
        int n = string.indexOf(":");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    protected Namespace getNamespace(Object object) {
        return null;
    }

    public HashMap getObjectsToFiles() {
        return this.objectsToFiles;
    }

    public int getOption() {
        return this.option;
    }

    public HashSet getRefVector() {
        return this.refVector;
    }

    public ArrayList getWriting() {
        return this.writing;
    }

    public HashSet getWritten() {
        return this.written;
    }

    protected String[] getXMIAttribs() {
        String[] stringArray = new String[4];
        stringArray[0] = "xmi.version";
        stringArray[1] = this.file.getXMIVersion();
        if (this.file.isPrintTimestamp()) {
            stringArray[2] = "timestamp";
            stringArray[3] = this.file.getTimestamp() != null ? this.file.getTimestamp() : new Date().toString();
        }
        return stringArray;
    }

    private void initialize() {
        this.filename = this.file.getEntry() != null ? this.file.getEntry() : this.file.getFilename();
        this.xmiFile = new File(this.filename);
        this.objectsToFiles = new HashMap();
        Iterator iterator = this.file.getObjects().iterator();
        this.processedObjects = new HashSet();
        int n = 1;
        while (iterator.hasNext()) {
            this.processObject(iterator.next(), "_" + n++, this.filename, 1);
        }
        this.computeRefVector();
    }

    protected ObjectWriter makeObjectWriter(Object object) {
        ObjectWriter objectWriter = new ObjectWriter(object);
        objectWriter.setWrapper(this.wrapper);
        return objectWriter;
    }

    private void processContained(Object object, String string, String string2) {
        this.contained.add(object);
        this.processObject(object, string, string2, 2);
    }

    protected void processLink(Object object) {
    }

    protected void processObject(Object object, String string, String string2, int n) {
        Iterator iterator;
        Object object2;
        ArrayList<Object> arrayList;
        Object object3;
        Object object4;
        Object object5;
        Collection collection;
        String string3;
        if (n == 5) {
            return;
        }
        if (this.processedObjects.contains(object)) {
            return;
        }
        this.processedObjects.add(object);
        String string4 = this.wrapper.getXMIFile(object);
        if (string4 == null) {
            string4 = this.wrapper.getHref(object);
        }
        if (string4 != null) {
            string2 = string4;
        }
        if (this.objectsToFiles.get(object) == null && !this.equalsXMIFile(string2)) {
            this.objectsToFiles.put(object, string2);
        }
        if ((string3 = this.wrapper.getId(object)) == null) {
            string3 = string;
            this.wrapper.setId(object, string);
        }
        int n2 = 1;
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(13);
        Collection collection2 = this.wrapper.getProperties(object);
        ArrayList arrayList2 = new ArrayList(collection2.size());
        Iterator iterator2 = collection2.iterator();
        if (iterator2.hasNext()) {
            while (iterator2.hasNext()) {
                collection = iterator2.next();
                this.processProperty(collection);
                object5 = this.getName(collection);
                object4 = this.wrapper.getValue(collection);
                if (object4 != null) {
                    if (object4 instanceof Collection) {
                        object3 = new ArrayList();
                        ((ArrayList)object3).addAll((Collection)object4);
                        object4 = object3;
                    }
                    if ((object3 = hashMap.get(object5)) == null) {
                        hashMap.put(object5, object4);
                        arrayList2.add(collection);
                    } else if (object3 instanceof ArrayList) {
                        if (object4 instanceof ArrayList) {
                            ((ArrayList)object3).addAll((ArrayList)object4);
                        } else {
                            ((ArrayList)object3).add(object4);
                        }
                    } else {
                        arrayList = new ArrayList<Object>();
                        arrayList.add(object3);
                        arrayList.add(object4);
                        hashMap.put(object5, arrayList);
                    }
                }
                if (this.wrapper.getType(collection) != 8 || object4 == null) continue;
                if (!(object4 instanceof ArrayList)) {
                    this.processObject(object4, string + "." + n2++, string2, 3);
                    this.objectPropValues.add(object4);
                    continue;
                }
                object3 = ((ArrayList)object4).iterator();
                while (object3.hasNext()) {
                    arrayList = object3.next();
                    this.processObject(arrayList, string + "." + n2++, string2, 3);
                    this.objectPropValues.add(arrayList);
                }
            }
        }
        collection = this.wrapper.getLinks(object);
        object5 = new ArrayList(collection.size());
        object4 = collection.iterator();
        while (object4.hasNext()) {
            object3 = object4.next();
            this.processLink(object3);
            arrayList = this.wrapper.getObject(object3);
            object2 = this.getName(object3);
            if (arrayList != null) {
                if (arrayList instanceof Collection) {
                    iterator = new ArrayList();
                    ((ArrayList)((Object)iterator)).addAll(arrayList);
                    arrayList = iterator;
                }
                if ((iterator = hashMap.get(object2)) == null) {
                    hashMap.put(object2, arrayList);
                    ((ArrayList)object5).add(object3);
                } else if (iterator instanceof ArrayList) {
                    if (arrayList instanceof ArrayList) {
                        ((ArrayList)((Object)iterator)).addAll(arrayList);
                    } else {
                        ((ArrayList)((Object)iterator)).add(arrayList);
                    }
                } else {
                    ArrayList<Object> arrayList3 = new ArrayList<Object>();
                    arrayList3.add(iterator);
                    arrayList3.add(arrayList);
                    hashMap.put(object2, arrayList3);
                }
            }
            if (this.wrapper.getType(object3) != 4) {
                if (arrayList == null) continue;
                if (arrayList instanceof ArrayList) {
                    iterator = arrayList.iterator();
                    while (iterator.hasNext()) {
                        this.processReference(iterator.next(), string, string2);
                    }
                    continue;
                }
                this.processReference(arrayList, string, string2);
                continue;
            }
            if (arrayList == null) continue;
            if (arrayList instanceof ArrayList) {
                iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    this.processContained(iterator.next(), string + "." + n2++, string2);
                }
                continue;
            }
            this.processContained(arrayList, string + "." + n2++, string2);
        }
        object3 = this.wrapper.getExtensions(object);
        arrayList = object3.iterator();
        while (arrayList.hasNext()) {
            object2 = this.wrapper.getContents(arrayList.next()).iterator();
            while (object2.hasNext()) {
                iterator = object2.next();
                if (this.wrapper.getType(iterator) != 10) continue;
                this.processObject(iterator, string + "." + n2++, string2, 4);
            }
        }
        object2 = new Object[6];
        object2[0] = string3;
        object2[1] = this.getNamespace(object);
        if (collection2.size() > 0) {
            object2[2] = arrayList2;
        }
        if (collection.size() > 0) {
            object2[3] = object5;
        }
        if (object3.size() > 0) {
            object2[4] = object3;
        }
        object2[5] = hashMap;
        this.objectToData.put(object, object2);
    }

    protected void processProperty(Object object) {
    }

    private void processReference(Object object, String string, String string2) {
        this.processObject(object, string, string2, 5);
        String string3 = this.wrapper.getXMIFile(object);
        if (string3 != null && this.objectsToFiles.get(object) == null && !this.equalsXMIFile(string3)) {
            this.objectsToFiles.put(object, string3);
        }
    }

    public void setOption(int n) {
        this.option = n;
    }

    public void setWriterWrapper(WriterWrapper writerWrapper) {
        this.wrapper = writerWrapper;
    }

    public void write(int n, int n2) throws Exception {
        this.wrapper.setXMIFile(this.file);
        this.initialize();
        PrintXML.setEncoding(this.file.getEncoding());
        if (this.option != 2) {
            this.writeHeader(0, n2);
        }
        this.writeContent(n2, n2);
        PrintXML.printEndDocument();
    }

    private void writeContent(int n, int n2) throws Exception {
        Collection collection = this.file.getObjects();
        if (this.option != 2) {
            if (collection.size() == 0) {
                PrintXML.printStartElement("XMI.content", null, true, n);
            } else {
                PrintXML.printStartElement("XMI.content", null, false, n);
            }
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ObjectWriter objectWriter = this.makeObjectWriter(iterator.next());
            objectWriter.setFileWriter(this);
            objectWriter.write(n + n2, n2);
        }
        if (this.option != 2) {
            if (collection.size() != 0) {
                PrintXML.printEndElement("XMI.content", n);
            }
            PrintXML.printEndElement("XMI", 0);
        }
    }

    private void writeHeader(int n, int n2) throws Exception {
        PrintXML.printXMLPI("1.0");
        if (this.file.getDTD() != null) {
            PrintXML.printDoctype("XMI", this.file.getDTD());
        }
        String[] stringArray = this.getXMIAttribs();
        PrintXML.printStartElement("XMI", stringArray, false, 0);
        this.writeXMIHeader(n + n2, n2);
    }

    private void writeXMIDocumentation(int n, int n2) throws Exception {
        PrintXML.printStartElement("XMI.documentation", null, false, n);
        if (this.file.getExporter() != null) {
            PrintXML.printStartElement("XMI.exporter", null, false, n + n2);
            PrintXML.printText(this.file.getExporter());
            PrintXML.printEndElement("XMI.exporter", -1);
        }
        if (this.file.getExporterVersion() != null) {
            PrintXML.printStartElement("XMI.exporterVersion", null, false, n + n2);
            PrintXML.printText(this.file.getExporterVersion());
            PrintXML.printEndElement("XMI.exporterVersion", -1);
        }
        if (this.file.getOwner() != null) {
            PrintXML.printStartElement("XMI.owner", null, false, n + n2);
            PrintXML.printText(this.file.getOwner());
            PrintXML.printEndElement("XMI.owner", -1);
        }
        if (this.file.getContact() != null) {
            PrintXML.printStartElement("XMI.contact", null, false, n + n2);
            PrintXML.printText(this.file.getContact());
            PrintXML.printEndElement("XMI.contact", -1);
        }
        if (this.file.getLongDescription() != null) {
            PrintXML.printStartElement("XMI.longDescription", null, false, n + n2);
            PrintXML.printText(this.file.getLongDescription());
            PrintXML.printEndElement("XMI.longDescription", -1);
        }
        if (this.file.getShortDescription() != null) {
            PrintXML.printStartElement("XMI.shortDescription", null, false, n + n2);
            PrintXML.printText(this.file.getShortDescription());
            PrintXML.printEndElement("XMI.shortDescription", -1);
        }
        if (this.file.getNotice() != null) {
            PrintXML.printStartElement("XMI.notice", null, false, n + n2);
            PrintXML.printText(this.file.getNotice());
            PrintXML.printEndElement("XMI.notice", -1);
        }
        PrintXML.printEndElement("XMI.documentation", n);
    }

    private void writeXMIHeader(int n, int n2) throws Exception {
        if (this.fileHasHeader()) {
            PrintXML.printStartElement("XMI.header", null, false, n);
            if (this.fileHasDocumentation()) {
                this.writeXMIDocumentation(n + n2, n2);
            }
            Iterator iterator = this.file.getModels().iterator();
            while (iterator.hasNext()) {
                this.writeXMIHeaderElement(iterator.next(), n + n2);
            }
            iterator = this.file.getMetamodels().iterator();
            while (iterator.hasNext()) {
                this.writeXMIHeaderElement(iterator.next(), n + n2);
            }
            iterator = this.file.getMetametamodels().iterator();
            while (iterator.hasNext()) {
                this.writeXMIHeaderElement(iterator.next(), n + n2);
            }
            iterator = this.file.getImports().iterator();
            while (iterator.hasNext()) {
                this.writeXMIHeaderElement(iterator.next(), n + n2);
            }
            PrintXML.printEndElement("XMI.header", n);
        }
    }

    private void writeXMIHeaderElement(Object object, int n) throws Exception {
        String string = "";
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (object instanceof XMIFile.Metamodel) {
            string = "XMI.metamodel";
            string2 = ((XMIFile.Metamodel)object).getName();
            string3 = ((XMIFile.Metamodel)object).getVersion();
            string4 = ((XMIFile.Metamodel)object).getHref();
        } else if (object instanceof XMIFile.Metametamodel) {
            string = "XMI.metametamodel";
            string2 = ((XMIFile.Metametamodel)object).getName();
            string3 = ((XMIFile.Metametamodel)object).getVersion();
            string4 = ((XMIFile.Metametamodel)object).getHref();
        } else if (object instanceof XMIFile.Import) {
            string = "XMI.import";
            string2 = ((XMIFile.Import)object).getName();
            string3 = ((XMIFile.Import)object).getVersion();
            string4 = ((XMIFile.Import)object).getHref();
        } else if (object instanceof XMIFile.Model) {
            string = "XMI.model";
            string2 = ((XMIFile.Model)object).getName();
            string3 = ((XMIFile.Model)object).getVersion();
            string4 = ((XMIFile.Model)object).getHref();
        }
        String[] stringArray = new String[6];
        stringArray[0] = "xmi.name";
        stringArray[1] = string2;
        if (string3 != null) {
            stringArray[2] = "xmi.version";
            stringArray[3] = string3;
        }
        if (string4 != null) {
            stringArray[4] = "href";
            stringArray[5] = string4;
        }
        PrintXML.printStartElement(string, stringArray, true, n);
    }
}

