/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.BasicProperty;
import com.ibm.xmi.framework.Data;
import com.ibm.xmi.framework.MOFIOUtil;
import com.ibm.xmi.framework.ObjectProperty;
import com.ibm.xmi.framework.Property;
import com.ibm.xmi.framework.XMIContainer;
import com.ibm.xmi.framework.XMIFile;
import com.ibm.xmi.framework.XMIFiles;
import com.ibm.xmi.framework.XMIObject;
import com.ibm.xmi.framework.XMIObjectImpl;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class Codegen4Assolinks {
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private static final String UML_ASSOCIATION = "Foundation.Core.Association";
    private static final String UML_NAME = "Foundation.Core.ModelElement.name";
    private static final String UML_CONNECTION = "Foundation.Core.Association.connection";
    private static final String UML_END_TYPE = "Foundation.Core.AssociationEnd.type";
    private static final String UML_MULTIPLICITY = "multiplicity";
    private static final String REFEXTNPACKAGE = "com.ibm.mof.mof13.ref.extn";
    private static final String REFASSOCIATIONEXTN = "RefAssociationExtn";
    private static final String REFEXTNIMPLPACKAGE = "com.ibm.mof.mof13.ref.extn.impl";
    private static final String REFASSOCIATIONEXTNIMPL = "RefAssociationExtnImpl";
    private static final String JAVAUTILPACKAGE = "java.util";
    private static final String COLLECTION = "Collection";
    public boolean debug;
    public XMIContainer container;
    public String directory;
    private String interfaceAppend = "";
    private String implementationAppend = "";
    private String interfacePkg = "";
    private String implementationPkg = "";

    public Codegen4Assolinks(String string, String string2, String string3, String string4, String string5) {
        this.directory = string;
        this.interfacePkg = string2;
        this.implementationPkg = string3;
        this.interfaceAppend = string4;
        this.implementationAppend = string5;
    }

    private void createAddMethod(MOFIOUtil mOFIOUtil, XMIObject xMIObject, XMIObject xMIObject2, XMIObject xMIObject3, XMIObject xMIObject4, boolean bl) {
        String string = "void";
        String string2 = "add";
        String string3 = this.getName(xMIObject);
        String string4 = this.getName(xMIObject3);
        String string5 = this.shortOrFullName(this.getName(xMIObject2));
        String string6 = this.shortOrFullName(this.getName(xMIObject4));
        if (string3 == null || string3.equals("")) {
            string3 = "the" + string5.substring(0, 1).toUpperCase() + string5.substring(1);
        }
        if (string4 == null || string4.equals("")) {
            string4 = "the" + string6.substring(0, 1).toUpperCase() + string6.substring(1);
        }
        if (!bl) {
            mOFIOUtil.out("\tpublic " + string + " " + string2 + "(" + string5 + " _" + string3 + ", " + string6 + " _" + string4 + ");\n");
        } else {
            mOFIOUtil.out("\tpublic " + string + " " + string2 + "(" + string5 + " _" + string3 + ", " + string6 + " _" + string4 + ") {");
            mOFIOUtil.out("\t}\n");
        }
    }

    private void createAEMethods(MOFIOUtil mOFIOUtil, XMIObject xMIObject, XMIObject xMIObject2, XMIObject xMIObject3, XMIObject xMIObject4, boolean bl) {
        String string;
        String string2;
        String string3;
        String string4;
        boolean bl2;
        String string5 = this.getMultiplicity(xMIObject);
        String string6 = this.getMultiplicity(xMIObject3);
        if (string5 != null) {
            bl2 = true;
            if ((string5 = string5.trim()).length() == 1) {
                if (string5.equals("0") || string5.equals("1")) {
                    bl2 = false;
                }
            } else if (string5.startsWith("0") && string5.endsWith("0") || string5.startsWith("0") && string5.endsWith("1") || string5.startsWith("1") && string5.endsWith("1")) {
                bl2 = false;
            }
            string4 = bl2 ? COLLECTION : this.shortOrFullName(this.getName(xMIObject2));
            string3 = this.getName(xMIObject);
            if ((string3 = this.isJavaKeyword(string3)) == null || string3.equals("")) {
                string3 = "the" + this.getName(xMIObject2).substring(0, 1).toUpperCase() + this.getName(xMIObject2).substring(1);
            }
            string2 = this.shortOrFullName(this.getName(xMIObject4));
            string = this.getName(xMIObject3);
            if (string == null || string.equals("")) {
                string = "the" + string2.substring(0, 1).toUpperCase() + string2.substring(1);
            }
            if (!bl) {
                mOFIOUtil.out("\tpublic " + string4 + " " + string3 + "(" + string2 + " _" + string + ");\n");
            } else {
                mOFIOUtil.out("\tpublic " + string4 + " " + string3 + "(" + string2 + " _" + string + ") {");
                mOFIOUtil.out("\t\treturn null;");
                mOFIOUtil.out("\t}\n");
            }
        }
        if (string6 != null) {
            bl2 = true;
            if ((string6 = string6.trim()).length() == 1) {
                if (string6.equals("0") || string6.equals("1")) {
                    bl2 = false;
                }
            } else if (string6.startsWith("0") && string6.endsWith("0") || string6.startsWith("0") && string6.endsWith("1") || string6.startsWith("1") && string6.endsWith("1")) {
                bl2 = false;
            }
            string4 = bl2 ? COLLECTION : this.shortOrFullName(this.getName(xMIObject4));
            string3 = this.getName(xMIObject3);
            if ((string3 = this.isJavaKeyword(string3)) == null || string3.equals("")) {
                string3 = "the" + this.getName(xMIObject4).substring(0, 1).toUpperCase() + this.getName(xMIObject4).substring(1);
            }
            string2 = this.shortOrFullName(this.getName(xMIObject2));
            string = this.getName(xMIObject);
            if (string == null || string.equals("")) {
                string = "the" + string2.substring(0, 1).toUpperCase() + string2.substring(1);
            }
            if (!bl) {
                mOFIOUtil.out("\tpublic " + string4 + " " + string3 + "(" + string2 + " _" + string + ");\n");
            } else {
                mOFIOUtil.out("\tpublic " + string4 + " " + string3 + "(" + string2 + " _" + string + ") {");
                mOFIOUtil.out("\t\treturn null;");
                mOFIOUtil.out("\t}\n");
            }
        }
    }

    private void createAllLinksMethod(MOFIOUtil mOFIOUtil, String string, boolean bl) {
        String string2 = "all" + string + "Links";
        if (!bl) {
            mOFIOUtil.out("\tpublic Collection " + string2 + "();\n");
        } else {
            mOFIOUtil.out("\tpublic Collection " + string2 + "() {");
            mOFIOUtil.out("\t\treturn null;");
            mOFIOUtil.out("\t}\n");
        }
    }

    private void createExistsMethod(MOFIOUtil mOFIOUtil, XMIObject xMIObject, XMIObject xMIObject2, XMIObject xMIObject3, XMIObject xMIObject4, boolean bl) {
        String string = "boolean";
        String string2 = "exists";
        String string3 = this.getName(xMIObject);
        String string4 = this.getName(xMIObject3);
        String string5 = this.shortOrFullName(this.getName(xMIObject2));
        String string6 = this.shortOrFullName(this.getName(xMIObject4));
        if (string3 == null || string3.equals("")) {
            string3 = "the" + string5.substring(0, 1).toUpperCase() + string5.substring(1);
        }
        if (string4 == null || string4.equals("")) {
            string4 = "the" + string6.substring(0, 1).toUpperCase() + string6.substring(1);
        }
        if (!bl) {
            mOFIOUtil.out("\tpublic " + string + " " + string2 + "(" + string5 + " _" + string3 + ", " + string6 + " _" + string4 + ");\n");
        } else {
            mOFIOUtil.out("\tpublic " + string + " " + string2 + "(" + string5 + " _" + string3 + ", " + string6 + " _" + string4 + ") {");
            mOFIOUtil.out("\t\treturn false;");
            mOFIOUtil.out("\t}\n");
        }
    }

    private void createModifyAEMethods(MOFIOUtil mOFIOUtil, XMIObject xMIObject, XMIObject xMIObject2, XMIObject xMIObject3, XMIObject xMIObject4, boolean bl) {
        String string = "void";
        String string2 = this.shortOrFullName(this.getName(xMIObject2));
        String string3 = this.getName(xMIObject);
        String string4 = this.shortOrFullName(this.getName(xMIObject4));
        String string5 = this.getName(xMIObject3);
        if (string3 == null || string3.equals("")) {
            string3 = "the" + string2.substring(0, 1).toUpperCase() + string2.substring(1);
        }
        if (string5 == null || string5.equals("")) {
            string5 = "the" + string4.substring(0, 1).toUpperCase() + string4.substring(1);
        }
        String string6 = string3;
        String string7 = string5;
        String string8 = "modify" + string6.substring(0, 1).toUpperCase() + string6.substring(1);
        String string9 = string2;
        String string10 = "new" + string6.substring(0, 1).toUpperCase() + string6.substring(1);
        if (!bl) {
            mOFIOUtil.out("\tpublic " + string + " " + string8 + "(" + string2 + " _" + string3 + ", " + string4 + " _" + string5 + ", " + string9 + " _" + string10 + ");\n");
        } else {
            mOFIOUtil.out("\tpublic " + string + " " + string8 + "(" + string2 + " _" + string3 + ", " + string4 + " _" + string5 + ", " + string9 + " _" + string10 + ") {");
            mOFIOUtil.out("\t}\n");
        }
        string8 = "modify" + string7.substring(0, 1).toUpperCase() + string7.substring(1);
        string9 = string4;
        string10 = "new" + string7.substring(0, 1).toUpperCase() + string7.substring(1);
        if (!bl) {
            mOFIOUtil.out("\tpublic " + string + " " + string8 + "(" + string2 + " _" + string3 + ", " + string4 + " _" + string5 + ", " + string9 + " _" + string10 + ");\n");
        } else {
            mOFIOUtil.out("\tpublic " + string + " " + string8 + "(" + string2 + " _" + string3 + ", " + string4 + " _" + string5 + ", " + string9 + " _" + string10 + ") {");
            mOFIOUtil.out("\t}\n");
        }
    }

    private void createRemoveMethod(MOFIOUtil mOFIOUtil, XMIObject xMIObject, XMIObject xMIObject2, XMIObject xMIObject3, XMIObject xMIObject4, boolean bl) {
        String string = "void";
        String string2 = "remove";
        String string3 = this.getName(xMIObject);
        String string4 = this.getName(xMIObject3);
        String string5 = this.shortOrFullName(this.getName(xMIObject2));
        String string6 = this.shortOrFullName(this.getName(xMIObject4));
        if (string3 == null || string3.equals("")) {
            string3 = "the" + string5.substring(0, 1).toUpperCase() + string5.substring(1);
        }
        if (string4 == null || string4.equals("")) {
            string4 = "the" + string6.substring(0, 1).toUpperCase() + string6.substring(1);
        }
        if (!bl) {
            mOFIOUtil.out("\tpublic " + string + " " + string2 + "(" + string5 + " _" + string3 + ", " + string6 + " _" + string4 + ");\n");
        } else {
            mOFIOUtil.out("\tpublic " + string + " " + string2 + "(" + string5 + " _" + string3 + ", " + string6 + " _" + string4 + ") {");
            mOFIOUtil.out("\t}\n");
        }
    }

    public Vector getAssociationEnds(XMIObject xMIObject) {
        Collection collection = xMIObject.getXMIProperties();
        Iterator iterator = collection.iterator();
        Vector<Object> vector = new Vector<Object>();
        while (iterator.hasNext()) {
            Property property = (Property)iterator.next();
            if (!(property instanceof ObjectProperty) || !property.getXMIName().equals(UML_CONNECTION) || property.getXMIGenericValue() == null) continue;
            vector.addElement(property.getXMIGenericValue());
        }
        return vector;
    }

    private String getFullFileName(String string, String string2) {
        String string3;
        File file;
        File file2;
        String string4 = this.directory;
        if (string2 != null && !string2.equals("")) {
            string4 = string4 + File.separator + string2.replace('.', File.separatorChar);
        }
        if (!(file2 = new File(string4)).exists()) {
            file2.mkdirs();
        }
        try {
            string4 = file2.getCanonicalPath();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (this.debug && (file = new File(string3 = string4 + File.separator + string + ".java")).exists()) {
            System.out.println("!!! Warning: file exists: " + string3);
        }
        return string4 + File.separator + string + ".java";
    }

    public String getMultiplicity(XMIObject xMIObject) {
        Iterator iterator = xMIObject.getXMIProperties().iterator();
        Property property = null;
        while (iterator.hasNext()) {
            Property property2 = (Property)iterator.next();
            if (property2.getXMIName() == null || !property2.getXMIName().equals(UML_MULTIPLICITY)) continue;
            property = property2;
            break;
        }
        if (property == null || property instanceof ObjectProperty) {
            return null;
        }
        return ((BasicProperty)property).getXMIValue();
    }

    public String getName(XMIObject xMIObject) {
        Property property = ((XMIObjectImpl)xMIObject).getXMIProperty(UML_NAME);
        return ((BasicProperty)property).getXMIValue();
    }

    public XMIObject getSupplier(XMIObject xMIObject) {
        Property property = null;
        Iterator iterator = xMIObject.getXMIProperties().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            String string = ((Data)e).getXMIName();
            if (string == null || !string.equals(UML_END_TYPE)) continue;
            property = (Property)e;
        }
        if (property != null) {
            return (XMIObject)property.getXMIGenericValue();
        }
        return null;
    }

    private String isJavaKeyword(String string) {
        if (string == null) {
            return string;
        }
        if (string.equals("")) {
            return string;
        }
        if (string.equals("extends") || string.equals("implements") || string.equals("class") || string.equals("package") || string.equals("import") || string.equals("interface")) {
            return "_" + string;
        }
        return string;
    }

    public static void main(String[] stringArray) {
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        boolean bl = false;
        if (stringArray.length == 0) {
            System.out.println("Valid arguments are:");
            System.out.println("-xml\t\t-- UML xml file that contains model data");
            System.out.println("-dir\t\t-- directory contains the java source files");
            System.out.println("-intfP\t\t-- package name to contain interface files");
            System.out.println("-implP\t\t-- package name to contains class files");
            System.out.println("-intfA\t\t-- append name to interface file");
            System.out.println("-implA\t\t-- append name to class file");
            System.out.println("");
            System.out.println("-debug\t\t-- Turn debug mode on");
            System.out.println("");
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("-xml") && i + 1 < stringArray.length) {
                string = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-dir") && i + 1 < stringArray.length) {
                string2 = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-intfP") && i + 1 < stringArray.length) {
                string3 = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-implP") && i + 1 < stringArray.length) {
                string4 = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-intfA") && i + 1 < stringArray.length) {
                string5 = stringArray[i + 1];
                continue;
            }
            if (stringArray[i].equals("-implA") && i + 1 < stringArray.length) {
                string6 = stringArray[i + 1];
                continue;
            }
            if (!stringArray[i].equals("-debug")) continue;
            bl = true;
        }
        try {
            Codegen4Assolinks codegen4Assolinks = new Codegen4Assolinks(string2, string3, string4, string5, string6);
            if (bl) {
                codegen4Assolinks.setDebug(bl);
            }
            XMIFiles xMIFiles = new XMIFiles();
            XMIFile xMIFile = xMIFiles.load(string, 1, false);
            codegen4Assolinks.start(xMIFile.getObjects().iterator());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void makeImplementation(String string, XMIObject xMIObject, XMIObject xMIObject2, XMIObject xMIObject3, XMIObject xMIObject4) {
        MOFIOUtil mOFIOUtil = new MOFIOUtil();
        String string2 = string + this.implementationAppend;
        String string3 = this.getFullFileName(string2, this.implementationPkg);
        if (this.debug) {
            System.out.println("\tcreate class: " + string3);
        }
        mOFIOUtil.setFile(string3);
        if (this.implementationPkg != null && !this.implementationPkg.equals("")) {
            mOFIOUtil.out("package " + this.implementationPkg + ";\n");
        }
        mOFIOUtil.out("import com.ibm.mof.mof13.ref.extn.impl.RefAssociationExtnImpl;");
        String string4 = this.getMultiplicity(xMIObject);
        String string5 = this.getMultiplicity(xMIObject3);
        mOFIOUtil.out("import java.util.Collection;");
        if (this.interfacePkg != null && !this.interfacePkg.equals("")) {
            mOFIOUtil.out("import " + this.interfacePkg + ".*;");
        }
        String string6 = string + this.interfaceAppend;
        mOFIOUtil.out("public class " + string2 + " extends " + REFASSOCIATIONEXTNIMPL + " implements " + string6 + " {");
        mOFIOUtil.out("\tpublic " + string2 + "() {");
        mOFIOUtil.out("\t\tsuper();");
        mOFIOUtil.out("\t}\n");
        this.createAllLinksMethod(mOFIOUtil, string, true);
        this.createExistsMethod(mOFIOUtil, xMIObject, xMIObject2, xMIObject3, xMIObject4, true);
        this.createAEMethods(mOFIOUtil, xMIObject, xMIObject2, xMIObject3, xMIObject4, true);
        this.createAddMethod(mOFIOUtil, xMIObject, xMIObject2, xMIObject3, xMIObject4, true);
        this.createModifyAEMethods(mOFIOUtil, xMIObject, xMIObject2, xMIObject3, xMIObject4, true);
        this.createRemoveMethod(mOFIOUtil, xMIObject, xMIObject2, xMIObject3, xMIObject4, true);
        mOFIOUtil.out("} // " + string2);
        mOFIOUtil.endFile();
        if (this.debug) {
            System.out.println("\t---end std class");
        }
    }

    public void makeInterface(String string, XMIObject xMIObject, XMIObject xMIObject2, XMIObject xMIObject3, XMIObject xMIObject4) {
        MOFIOUtil mOFIOUtil = new MOFIOUtil();
        String string2 = string + this.interfaceAppend;
        String string3 = this.getFullFileName(string2, this.interfacePkg);
        if (this.debug) {
            System.out.println("\tcreate Interface: " + string3);
        }
        mOFIOUtil.setFile(string3);
        if (this.interfacePkg != null && !this.interfacePkg.equals("")) {
            mOFIOUtil.out("package " + this.interfacePkg + ";\n");
        }
        mOFIOUtil.out("import com.ibm.mof.mof13.ref.extn.RefAssociationExtn;");
        mOFIOUtil.out("import java.util.Collection;");
        mOFIOUtil.out("public interface " + string2 + " extends " + REFASSOCIATIONEXTN + " {");
        this.createAllLinksMethod(mOFIOUtil, string, false);
        this.createExistsMethod(mOFIOUtil, xMIObject, xMIObject2, xMIObject3, xMIObject4, false);
        this.createAEMethods(mOFIOUtil, xMIObject, xMIObject2, xMIObject3, xMIObject4, false);
        this.createAddMethod(mOFIOUtil, xMIObject, xMIObject2, xMIObject3, xMIObject4, false);
        this.createModifyAEMethods(mOFIOUtil, xMIObject, xMIObject2, xMIObject3, xMIObject4, false);
        this.createRemoveMethod(mOFIOUtil, xMIObject, xMIObject2, xMIObject3, xMIObject4, false);
        mOFIOUtil.out("} // " + string2);
        mOFIOUtil.endFile();
        if (this.debug) {
            System.out.println("\t---end create Interface");
        }
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    private String shortOrFullName(String string) {
        if (string == null) {
            return string;
        }
        if (string.equals("")) {
            return string;
        }
        if (string.equals("Class") || string.equals("Object") || string.equals("Package") || string.equals("Enumeration") || string.equals("Exception")) {
            if (!this.interfacePkg.equals("")) {
                return this.interfacePkg + "." + string;
            }
            return string;
        }
        return string;
    }

    public void start(Iterator iterator) {
        Vector vector = new Vector(10);
        while (iterator.hasNext()) {
            vector.addElement(iterator.next());
        }
        this.container = new XMIContainer(vector.iterator());
        Collection collection = this.container.getData(UML_ASSOCIATION);
        if (this.debug) {
            System.out.println("# of asso links: " + collection.size());
        }
        Iterator iterator2 = collection.iterator();
        while (iterator2.hasNext()) {
            XMIObject xMIObject = (XMIObject)iterator2.next();
            Vector vector2 = this.getAssociationEnds(xMIObject);
            XMIObject xMIObject2 = null;
            XMIObject xMIObject3 = null;
            XMIObject xMIObject4 = null;
            XMIObject xMIObject5 = null;
            if (vector2 == null || vector2.size() != 2) continue;
            xMIObject2 = (XMIObject)vector2.elementAt(0);
            xMIObject3 = (XMIObject)vector2.elementAt(1);
            xMIObject4 = this.getSupplier(xMIObject2);
            xMIObject5 = this.getSupplier(xMIObject3);
            if (this.debug) {
                System.out.println("asso link: " + this.getName(xMIObject));
                System.out.println("asso end: " + this.getName(xMIObject2) + " supplier: " + this.getName(xMIObject4));
                System.out.println("asso end: " + this.getName(xMIObject3) + " supplier: " + this.getName(xMIObject5));
            }
            if (xMIObject2 == null || xMIObject3 == null || xMIObject4 == null || xMIObject5 == null) continue;
            String string = this.getName(xMIObject2);
            String string2 = this.getName(xMIObject3);
            boolean bl = true;
            if (string.startsWith("/") && string2.startsWith("/")) {
                bl = false;
            }
            if (!bl) continue;
            String string3 = this.getName(xMIObject);
            if (string3 == null || string3.equals("")) {
                string3 = this.getName(xMIObject4) + "_" + this.getName(xMIObject5);
            }
            if (this.debug) {
                System.out.println("========== create java files for " + string3);
            }
            this.makeInterface(string3, xMIObject2, xMIObject4, xMIObject3, xMIObject5);
            this.makeImplementation(string3, xMIObject2, xMIObject4, xMIObject3, xMIObject5);
        }
    }
}

