/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xmi.framework;

import com.ibm.xmi.framework.Data;
import com.ibm.xmi.framework.Extension;
import com.ibm.xmi.framework.ExtensionImpl;
import com.ibm.xmi.framework.FeatureInfo;
import com.ibm.xmi.framework.Namespace;
import com.ibm.xmi.framework.ObjectInfo;
import com.ibm.xmi.framework.ReaderAdapter;
import com.ibm.xmi.framework.XMIFile;
import com.ibm.xmi.framework.XMIObject;
import com.ibm.xmi.framework.XMLElement;
import com.ibm.xmi.framework.XMLElementImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class BaseLoader
extends HandlerBase {
    public static final String copyright = "(c) Copyright IBM Corporation 2001.";
    protected XMIFile file;
    private int option;
    protected MyStack tagNames;
    protected MyStack types;
    protected MyStack objects;
    protected MyStack extensionInfos;
    protected MyStack xmlElements;
    protected boolean isContent = false;
    protected boolean debug = false;
    protected StringBuffer text = new StringBuffer("");
    protected HashMap idsToObjects = new HashMap();
    private HashMap namesToModels = new HashMap();
    protected ArrayList featuresToSet;
    private ReaderAdapter adapter;
    protected ObjectInfo objectInfo = new ObjectInfo();
    protected FeatureInfo featureInfo = new FeatureInfo();

    public BaseLoader(XMIFile xMIFile, int n, ReaderAdapter readerAdapter) {
        this.file = xMIFile;
        this.option = n;
        this.adapter = readerAdapter;
        this.tagNames = new MyStack();
        this.types = new MyStack();
        this.objects = new MyStack();
        this.extensionInfos = new MyStack();
        this.xmlElements = new MyStack();
        if (n == 2) {
            readerAdapter.setXMIFile(xMIFile);
            this.isContent = true;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (!this.extensionInfos.isEmpty() && ((ExtensionInfo)this.extensionInfos.peek()).getHandler() != null) {
            ((ExtensionInfo)this.extensionInfos.peek()).getHandler().characters(cArray, n, n2);
        } else {
            this.text.append(cArray, n, n2);
        }
    }

    private Object createFeature(FeatureInfo featureInfo, int n, String string) {
        if (this.debug) {
            System.out.println("BaseLoader createFeature:");
            System.out.println("info: " + featureInfo);
            System.out.println("type: " + n);
            System.out.println("idref: " + string);
        }
        if (featureInfo.getValue() == null && string != null) {
            featureInfo.setValue(this.idsToObjects.get(string));
        }
        featureInfo.setModel(this.getModel(featureInfo.getNamespace()));
        Object object = this.createFeatureFromAdapter(featureInfo, n);
        if (object != null && featureInfo.getValue() == null && string != null) {
            if (this.featuresToSet == null) {
                this.featuresToSet = new ArrayList();
            }
            this.featuresToSet.add(featureInfo.getObject());
            this.featuresToSet.add(object);
            this.featuresToSet.add(string);
        }
        return object;
    }

    protected Object createFeatureFromAdapter(FeatureInfo featureInfo, int n) {
        return this.adapter.createProperty(featureInfo);
    }

    protected Object createObject(ObjectInfo objectInfo) {
        objectInfo.setModel(this.getModel(objectInfo.getNamespace()));
        Object object = this.adapter.createObject(objectInfo);
        if (object != null) {
            if (!this.tagNames.isEmpty() && this.tagNames.peek().equals("XMI.content") && this.option != 2) {
                this.file.add(object);
            } else if (this.tagNames.isEmpty() && this.option == 2) {
                this.file.add(object);
            }
            if (objectInfo.getId() != null) {
                this.idsToObjects.put(objectInfo.getId(), object);
            }
        }
        return object;
    }

    protected void createObject(String string, AttributeList attributeList) {
        if (this.debug) {
            System.out.println("createObject " + string);
        }
        this.objectInfo.clear();
        String[] stringArray = this.processAttribs(this.objectInfo, attributeList);
        int n = string.indexOf(":");
        if (n == -1) {
            this.objectInfo.setXMIName(string);
        } else {
            this.objectInfo.setXMIName(string.substring(n + 1));
        }
        this.objectInfo.setNamespace(this.getNamespace(string));
        Object object = this.createObject(this.objectInfo);
        if (!this.objects.isEmpty() && !this.types.peek().equals("Extension")) {
            this.handleFeature(object, this.objectInfo.getIdref());
        }
        this.types.push("Object");
        if (object != null) {
            this.objects.push(object);
            this.processOtherAttribs(object, stringArray, string);
        } else {
            this.objects.push(new Object());
        }
    }

    private void createXMLElement(String string, AttributeList attributeList) {
        if (this.debug) {
            System.out.println("createXMLElement " + string);
        }
        XMLElementImpl xMLElementImpl = new XMLElementImpl(string);
        for (int i = 0; i < attributeList.getLength(); ++i) {
            String string2 = attributeList.getName(i);
            String string3 = attributeList.getValue(i);
            xMLElementImpl.add(string2, string3);
        }
        if (!this.types.isEmpty() && this.types.peek().equals("Extension") && !this.extensionInfos.isEmpty()) {
            ((ExtensionInfo)this.extensionInfos.peek()).getExtension().add(xMLElementImpl);
        } else if (!this.types.isEmpty() && this.types.peek().equals("XMLElement") && !this.xmlElements.isEmpty()) {
            ((XMLElement)this.xmlElements.peek()).add(xMLElementImpl);
        }
        this.xmlElements.push(xMLElementImpl);
        this.types.push("XMLElement");
    }

    public void endDocument() throws SAXException {
        if (this.debug) {
            System.out.println("endDocument");
        }
        if (this.featuresToSet != null) {
            for (int i = 0; i < this.featuresToSet.size() - 2; i += 3) {
                this.adapter.resolveValue(this.featuresToSet.get(i), this.featuresToSet.get(i + 1), this.idsToObjects.get(this.featuresToSet.get(i + 2)));
            }
        }
        this.featuresToSet = new ArrayList();
        this.idsToObjects = new HashMap();
        this.adapter.endFile();
    }

    public void endElement(String string) throws SAXException {
        Object object;
        if (this.debug) {
            System.out.println("endElement " + string);
        }
        if (!this.extensionInfos.isEmpty()) {
            object = (ExtensionInfo)this.extensionInfos.peek();
            if (((ExtensionInfo)object).getHandler() != null) {
                ((ExtensionInfo)object).getHandler().endElement(string);
            }
            if (string.equals("XMI.extension")) {
                this.types.pop();
                this.extensionInfos.pop();
                return;
            }
            if (((ExtensionInfo)object).getIgnore() || ((ExtensionInfo)object).getHandler() != null) {
                return;
            }
        }
        if (string.equals("XMI.content")) {
            this.isContent = false;
        }
        if (string.equals("XMI.exporter")) {
            this.file.setExporter(this.text.toString());
        } else if (string.equals("XMI.exporterVersion")) {
            this.file.setExporterVersion(this.text.toString());
        } else if (string.equals("XMI.owner")) {
            this.file.setOwner(this.text.toString());
        } else if (string.equals("XMI.contact")) {
            this.file.setContact(this.text.toString());
        } else if (string.equals("XMI.notice")) {
            this.file.setNotice(this.text.toString());
        } else if (string.equals("XMI.longDescription")) {
            this.file.setLongDescription(this.text.toString());
        } else if (string.equals("XMI.shortDescription")) {
            this.file.setShortDescription(this.text.toString());
        }
        if (this.isContent && !this.types.isEmpty() && this.types.peek().equals("Object")) {
            this.objects.pop();
        } else if (this.isContent && this.isBasicProperty()) {
            object = (String)this.tagNames.peek();
            this.featureInfo.clear();
            this.featureInfo.setObject(this.objects.peek());
            this.featureInfo.setClassName(this.getClassName((String)object));
            this.featureInfo.setXMIName(this.getSimpleName((String)object));
            this.featureInfo.setNamespace(this.getNamespace((String)object));
            this.featureInfo.setValue(this.text.toString());
            this.createFeature(this.featureInfo, this.getPropertyType(), null);
        } else if (this.isContent && !this.types.isEmpty() && this.types.peek().equals("XMLElement")) {
            if (!this.text.toString().equals("") && !this.xmlElements.isEmpty()) {
                ((XMLElement)this.xmlElements.peek()).add(this.text.toString());
            }
            if (!this.xmlElements.isEmpty()) {
                this.xmlElements.pop();
            }
        }
        this.tagNames.pop();
        if (!this.types.isEmpty()) {
            this.types.pop();
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        sAXParseException.printStackTrace();
        if (this.option == 1) {
            throw sAXParseException;
        }
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (this.option == 1) {
            throw sAXParseException;
        }
    }

    protected boolean featureHasObjectValues(int n) {
        return n != 7 && n != 6;
    }

    protected String getClassName(String string) {
        int n = string.indexOf(":");
        if (n != -1) {
            string = string.substring(n + 1);
        }
        if ((n = string.lastIndexOf(".")) == -1) {
            return null;
        }
        return string.substring(0, n);
    }

    protected String[] getIdrefs(String string) {
        ArrayList<String> arrayList = new ArrayList<String>(5);
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray(new String[0]);
    }

    protected XMIFile.Model getModel(Namespace namespace) {
        if (namespace == null || namespace.getName() == null) {
            return null;
        }
        return (XMIFile.Model)this.namesToModels.get(namespace.getName());
    }

    protected Namespace getNamespace(String string) {
        int n = string.indexOf(":");
        String string2 = "";
        if (n != -1) {
            string2 = string.substring(0, n);
        }
        return this.file.getNamespace(string2);
    }

    protected int getPropertyType() {
        return 7;
    }

    protected String getSimpleName(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    protected int getTypeFromTypeStack() {
        if (this.types.isEmpty()) {
            return -1;
        }
        if (this.types.peek().equals("ObjectProperty") || this.types.peek().equals("Property")) {
            return 8;
        }
        return -1;
    }

    private void handleContent(String string, AttributeList attributeList) {
        if (this.debug) {
            System.out.println("handleContent " + string);
        }
        if (this.objects.isEmpty() || this.getTypeFromTypeStack() != -1) {
            this.createObject(string, attributeList);
        } else if (!this.types.isEmpty() && this.types.peek().equals("XMLElement")) {
            this.createXMLElement(string, attributeList);
        } else if (!this.types.isEmpty() && this.types.peek().equals("Extension")) {
            if (this.isObject(string, attributeList)) {
                this.createObject(string, attributeList);
                if (!this.extensionInfos.isEmpty()) {
                    ((ExtensionInfo)this.extensionInfos.peek()).getExtension().add((Data)this.objects.peek());
                }
            } else {
                this.createXMLElement(string, attributeList);
            }
        } else {
            this.pushFeature(string);
            this.setText(attributeList);
        }
    }

    private void handleExtension(AttributeList attributeList) {
        String string = attributeList.getValue("xmi.extender");
        String string2 = attributeList.getValue("xmi.extenderID");
        ExtensionInfo extensionInfo = new ExtensionInfo();
        ExtensionInfo extensionInfo2 = null;
        if (!this.extensionInfos.isEmpty()) {
            extensionInfo2 = (ExtensionInfo)this.extensionInfos.peek();
        }
        if (extensionInfo2 != null && extensionInfo2.getHandler() != null) {
            extensionInfo.setHandler(extensionInfo2.getHandler());
        } else {
            extensionInfo.setHandler(this.adapter.createExtension(this.objects.peek(), string, string2));
        }
        if (extensionInfo.getHandler() == null) {
            if (extensionInfo2 != null && extensionInfo2.getIgnore() || !(this.objects.peek() instanceof XMIObject)) {
                extensionInfo.setIgnore(true);
            } else if (this.objects.peek() instanceof XMIObject) {
                ExtensionImpl extensionImpl = new ExtensionImpl(string, string2);
                ((XMIObject)this.objects.peek()).add(extensionImpl);
                extensionInfo.setExtension(extensionImpl);
            }
        }
        this.types.push("Extension");
        this.extensionInfos.push(extensionInfo);
    }

    protected void handleFeature(Object object, String string) {
        this.featureInfo.clear();
        this.featureInfo.setObject(this.objects.peek());
        this.featureInfo.setXMIName(this.stripNamespace((String)this.tagNames.peek()));
        this.featureInfo.setNamespace(this.getNamespace((String)this.tagNames.peek()));
        this.featureInfo.setValue(object);
        int n = this.getTypeFromTypeStack();
        this.createFeature(this.featureInfo, n, string);
        if (this.types.peek().equals("Property")) {
            this.types.pop();
            this.types.push("ObjectProperty");
        }
    }

    private void handleHeaderData(String string, AttributeList attributeList) {
        String string2 = attributeList.getValue("xmi.name");
        String string3 = attributeList.getValue("xmi.version");
        String string4 = attributeList.getValue("href");
        if (string.equals("XMI.import")) {
            this.file.add(new XMIFile.Import(string2, string3, string4));
        } else if (string.equals("XMI.model")) {
            XMIFile.Model model = new XMIFile.Model(string2, string3, string4);
            if (string2 != null) {
                this.namesToModels.put(string2, model);
            }
            this.file.add(model);
        } else if (string.equals("XMI.metamodel")) {
            XMIFile.Metamodel metamodel = new XMIFile.Metamodel(string2, string3, string4);
            if (string2 != null) {
                this.namesToModels.put(string2, metamodel);
            }
            this.file.add((XMIFile.Model)metamodel);
        } else if (string.equals("XMI.metametamodel")) {
            XMIFile.Metametamodel metametamodel = new XMIFile.Metametamodel(string2, string3, string4);
            if (string2 != null) {
                this.namesToModels.put(string2, metametamodel);
            }
            this.file.add((XMIFile.Model)metametamodel);
        }
    }

    private void handleXMIElement(AttributeList attributeList) {
        for (int i = 0; i < attributeList.getLength(); ++i) {
            String string = attributeList.getName(i);
            if (string.equals("xmi.version")) {
                this.file.setXMIVersion(attributeList.getValue(i));
                continue;
            }
            if (string.equals("timestamp")) {
                this.file.setTimestamp(attributeList.getValue(i));
                continue;
            }
            if (string.equals("verified")) {
                if (!attributeList.getValue(i).equals("true")) continue;
                this.file.setVerified(true);
                continue;
            }
            if (!string.startsWith("xmlns")) continue;
            int n = string.indexOf(":");
            String string2 = n == -1 ? "" : string.substring(n + 1);
            Namespace namespace = new Namespace(string2, attributeList.getValue(i));
            this.file.add(namespace);
        }
    }

    protected boolean isBasicProperty() {
        return !this.types.isEmpty() && this.types.peek().equals("Property");
    }

    protected boolean isObject(String string, AttributeList attributeList) {
        return attributeList.getValue("xmi.id") != null || attributeList.getValue("xmi.label") != null || attributeList.getValue("xmi.uuid") != null;
    }

    protected String[] processAttribs(ObjectInfo objectInfo, AttributeList attributeList) {
        String[] stringArray = new String[attributeList.getLength() * 2];
        int n = 0;
        for (int i = 0; i < attributeList.getLength(); ++i) {
            String string = attributeList.getName(i);
            if (string.equals("xmi.id")) {
                objectInfo.setId(attributeList.getValue(i));
                continue;
            }
            if (string.equals("xmi.uuid")) {
                objectInfo.setUUID(attributeList.getValue(i));
                continue;
            }
            if (string.equals("xmi.label")) {
                objectInfo.setLabel(attributeList.getValue(i));
                continue;
            }
            if (string.equals("xmi.idref")) {
                objectInfo.setIdref(attributeList.getValue(i));
                continue;
            }
            if (string.equals("href")) {
                objectInfo.setHref(attributeList.getValue(i));
                continue;
            }
            stringArray[n++] = string;
            stringArray[n++] = attributeList.getValue(i);
        }
        return stringArray;
    }

    protected void processOtherAttribs(Object object, String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length - 1; i += 2) {
            if (stringArray[i] == null) {
                return;
            }
            this.featureInfo.clear();
            this.featureInfo.setObject(object);
            this.featureInfo.setClassName(string);
            this.featureInfo.setXMIName(this.stripNamespace(stringArray[i]));
            this.featureInfo.setNamespace(this.getNamespace(stringArray[i]));
            int n = this.adapter.getType(this.featureInfo);
            if (this.featureHasObjectValues(n)) {
                String[] stringArray2 = this.getIdrefs(stringArray[i + 1]);
                for (int j = 0; j < stringArray2.length; ++j) {
                    ObjectInfo objectInfo = new ObjectInfo();
                    objectInfo.setIdref(stringArray2[j]);
                    Object object2 = this.createObject(objectInfo);
                    this.featureInfo.setValue(object2);
                    this.createFeature(this.featureInfo, n, stringArray2[j]);
                }
                continue;
            }
            this.featureInfo.setValue(stringArray[i + 1]);
            this.createFeature(this.featureInfo, n, null);
        }
    }

    protected void pushFeature(String string) {
        this.types.push("Property");
    }

    private void setText(AttributeList attributeList) {
        for (int i = 0; i < attributeList.getLength(); ++i) {
            if (!attributeList.getName(i).equals("xmi.value")) continue;
            this.text = new StringBuffer(attributeList.getValue(i));
        }
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        if (this.debug) {
            System.out.println("startElement " + string);
        }
        this.text = new StringBuffer("");
        if (!this.extensionInfos.isEmpty()) {
            ExtensionInfo extensionInfo = (ExtensionInfo)this.extensionInfos.peek();
            if (extensionInfo.getHandler() != null) {
                extensionInfo.getHandler().startElement(string, attributeList);
            }
            if (string.equals("XMI.extension")) {
                this.handleExtension(attributeList);
                return;
            }
            if (extensionInfo.getIgnore() || extensionInfo.getHandler() != null) {
                return;
            }
        }
        if (string.equals("XMI")) {
            this.handleXMIElement(attributeList);
        } else if (string.equals("XMI.import") || string.equals("XMI.model") || string.equals("XMI.metamodel") || string.equals("XMI.metametamodel")) {
            this.handleHeaderData(string, attributeList);
        } else if (string.equals("XMI.content")) {
            this.isContent = true;
            this.adapter.setXMIFile(this.file);
        } else {
            if (string.equals("XMI.extension")) {
                this.handleExtension(attributeList);
                return;
            }
            if (this.isContent) {
                this.handleContent(string, attributeList);
            }
        }
        this.tagNames.push(string);
    }

    protected String stripNamespace(String string) {
        int n = string.indexOf(":");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        sAXParseException.printStackTrace();
    }

    protected static class MyStack {
        private ArrayList list = new ArrayList();

        MyStack() {
        }

        boolean isEmpty() {
            return this.list.size() == 0;
        }

        Object peek() {
            if (this.list.size() == 0) {
                return null;
            }
            return this.list.get(this.list.size() - 1);
        }

        void push(Object object) {
            this.list.add(object);
        }

        Object pop() {
            if (this.list.size() == 0) {
                return null;
            }
            return this.list.remove(this.list.size() - 1);
        }
    }

    private static class ExtensionInfo {
        private DocumentHandler handler;
        private boolean ignore = false;
        private Extension extension;

        ExtensionInfo() {
        }

        void setHandler(DocumentHandler documentHandler) {
            this.handler = documentHandler;
        }

        void setIgnore(boolean bl) {
            this.ignore = bl;
        }

        void setExtension(Extension extension) {
            this.extension = extension;
        }

        DocumentHandler getHandler() {
            return this.handler;
        }

        boolean getIgnore() {
            return this.ignore;
        }

        Extension getExtension() {
            return this.extension;
        }
    }
}

