/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wtp.internal.encoders;

import com.ibm.wtp.internal.encoders.EncoderDecoder;
import com.ibm.wtp.internal.encoders.EncoderDecoderAdapter;

public class XMLValueEncoderDecoder
extends EncoderDecoderAdapter
implements EncoderDecoder {
    private static final String copyright = "(c) Copyright IBM Corporation 2001.";
    private int _lastPrintable = 126;
    protected static XMLValueEncoderDecoder _singleton;

    public String decode(String value) {
        return value;
    }

    public String encode(String value) {
        StringBuffer sbuf = new StringBuffer(value.length());
        String charRef = null;
        int i = 0;
        while (i < value.length()) {
            char ch = value.charAt(i);
            charRef = this.getEntityRef(ch);
            if (charRef != null) {
                sbuf.append('&');
                sbuf.append(charRef);
                sbuf.append(';');
            } else if (ch >= ' ' && ch <= this._lastPrintable && ch != '\u00f7' || ch == '\n' || ch == '\r' || ch == '\t') {
                sbuf.append(ch);
            } else {
                sbuf.append("&#");
                sbuf.append(Integer.toString(ch));
                sbuf.append(';');
            }
            ++i;
        }
        return sbuf.toString();
    }

    public static String escape(String value) {
        if (_singleton == null) {
            _singleton = new XMLValueEncoderDecoder();
        }
        return _singleton.encode(value);
    }

    protected String getEntityRef(char ch) {
        switch (ch) {
            case '<': {
                return "lt";
            }
            case '>': {
                return "gt";
            }
            case '\"': {
                return "quot";
            }
            case '\'': {
                return "apos";
            }
            case '&': {
                return "amp";
            }
        }
        return null;
    }
}

